/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBooleanLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.ExpressionVisitor;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.types.DynamicType;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f\"\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\b2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KTypeConstructor;", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "<init>", "(Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;)V", "visitedTypeParams", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lkotlin/collections/HashSet;", "callHelperFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "name", "", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "(Ljava/lang/String;[Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "createKType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "createDynamicType", "createSimpleKType", "Lorg/jetbrains/kotlin/types/SimpleType;", "createKTypeProjection", "tp", "Lorg/jetbrains/kotlin/types/TypeProjection;", "createKClassifier", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "createKTypeParameter", "typeParameter", "", "js.translator"})
@SourceDebugExtension(value={"SMAP\nTypeOfFIF.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeOfFIF.kt\norg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KTypeConstructor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n1557#2:164\n1628#2,3:165\n1557#2:168\n1628#2,3:169\n1557#2:172\n1628#2,3:173\n*S KotlinDebug\n*F\n+ 1 TypeOfFIF.kt\norg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/KTypeConstructor\n*L\n81#1:164\n81#1:165,3\n90#1:168\n90#1:169,3\n128#1:172\n128#1:173,3\n*E\n"})
final class KTypeConstructor {
    @NotNull
    private final TranslationContext context;
    @NotNull
    private final HashSet<TypeParameterDescriptor> visitedTypeParams;

    public KTypeConstructor(@NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.visitedTypeParams = new HashSet();
    }

    @NotNull
    public final JsInvocation callHelperFunction(@NotNull String name2, JsExpression ... arguments) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(arguments, "arguments");
        return new JsInvocation(this.context.getReferenceToIntrinsic(name2), Arrays.copyOf(arguments, arguments.length));
    }

    @NotNull
    public final JsExpression createKType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        UnwrappedType unwrappedType = type2.unwrap();
        if (unwrappedType instanceof SimpleType) {
            return this.createSimpleKType((SimpleType)unwrappedType);
        }
        if (unwrappedType instanceof DynamicType) {
            return this.createDynamicType();
        }
        throw new IllegalStateException(("Unexpected type " + type2).toString());
    }

    private final JsExpression createDynamicType() {
        return this.callHelperFunction("createDynamicKType", new JsExpression[0]);
    }

    /*
     * WARNING - void declaration
     */
    private final JsExpression createSimpleKType(SimpleType type2) {
        void $this$mapTo$iv$iv;
        Collection collection;
        JsExpression jsExpression;
        TypeConstructor typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor classifier = typeConstructor2.getDeclarationDescriptor();
        if (classifier instanceof TypeParameterDescriptor && ((TypeParameterDescriptor)classifier).isReified()) {
            JsName jsName = this.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkNotNullExpressionValue(jsName, "getNameForIntrinsic(...)");
            JsName kClassName = jsName;
            MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            JsExpression[] jsExpressionArray = new JsExpression[]{UtilsKt.getReferenceToJsClass(classifier, this.context)};
            JsInvocation reifiedTypeParameterType = new JsInvocation((JsExpression)kClassName.makeRef(), jsExpressionArray);
            if (type2.isMarkedNullable()) {
                jsExpressionArray = new JsExpression[]{reifiedTypeParameterType};
                return this.callHelperFunction("markKTypeNullable", jsExpressionArray);
            }
            return reifiedTypeParameterType;
        }
        if (classifier != null) {
            jsExpression = this.createKClassifier(classifier);
        } else if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            void $this$mapTo$iv$iv2;
            JsName jsName = this.context.getNameForIntrinsic("getKClassM");
            Intrinsics.checkNotNullExpressionValue(jsName, "getNameForIntrinsic(...)");
            JsName getKClassM = jsName;
            JsExpression[] $this$map$iv = (JsExpression[])((IntersectionTypeConstructor)typeConstructor2).getSupertypes();
            boolean $i$f$map2 = false;
            JsExpression[] jsExpressionArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (TypeProjection item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                KotlinType kotlinType = (KotlinType)((Object)item$iv$iv2);
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(UtilsKt.getReferenceToJsClass(it.getConstructor().getDeclarationDescriptor(), this.context));
            }
            List list = (List)destination$iv$iv;
            JsArrayLiteral args2 = new JsArrayLiteral(list);
            $this$map$iv = new JsExpression[]{args2};
            jsExpression = new JsInvocation((JsExpression)getKClassM.makeRef(), $this$map$iv);
        } else {
            throw new IllegalStateException(("Can't get KClass for " + type2).toString());
        }
        JsExpression kClassifier = jsExpression;
        Iterable $this$map$iv = type2.getArguments();
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection item$iv$iv2;
            item$iv$iv2 = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createKTypeProjection((TypeProjection)it));
        }
        List list = (List)destination$iv$iv;
        JsArrayLiteral arguments = new JsArrayLiteral(list);
        JsBooleanLiteral isMarkedNullable = new JsBooleanLiteral(type2.isMarkedNullable());
        JsExpression[] jsExpressionArray = new JsExpression[]{kClassifier, arguments, isMarkedNullable};
        return this.callHelperFunction("createKType", jsExpressionArray);
    }

    private final JsExpression createKTypeProjection(TypeProjection tp) {
        String string2;
        if (tp.isStarProjection()) {
            return this.callHelperFunction("getStarKTypeProjection", new JsExpression[0]);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[tp.getProjectionKind().ordinal()]) {
            case 1: {
                string2 = "createInvariantKTypeProjection";
                break;
            }
            case 2: {
                string2 = "createContravariantKTypeProjection";
                break;
            }
            case 3: {
                string2 = "createCovariantKTypeProjection";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String factoryName = string2;
        KotlinType kotlinType = tp.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        JsExpression kType = this.createKType(kotlinType);
        JsExpression[] jsExpressionArray = new JsExpression[]{kType};
        return this.callHelperFunction(factoryName, jsExpressionArray);
    }

    private final JsExpression createKClassifier(ClassifierDescriptor classifier) {
        JsExpression jsExpression;
        if (classifier instanceof TypeParameterDescriptor) {
            jsExpression = this.createKTypeParameter((TypeParameterDescriptor)classifier, (Set<TypeParameterDescriptor>)this.visitedTypeParams);
        } else {
            JsExpression jsExpression2 = ExpressionVisitor.getObjectKClass(this.context, classifier);
            jsExpression = jsExpression2;
            Intrinsics.checkNotNullExpressionValue(jsExpression2, "getObjectKClass(...)");
        }
        return jsExpression;
    }

    private final JsExpression createKTypeParameter(TypeParameterDescriptor typeParameter, Set<TypeParameterDescriptor> visitedTypeParams) {
        JsExpression jsExpression;
        if (visitedTypeParams.contains(typeParameter)) {
            JsInvocation jsInvocation;
            JsInvocation it = jsInvocation = this.callHelperFunction("getStarKTypeProjection", new JsExpression[0]);
            boolean bl = false;
            MetadataProperties.setKTypeWithRecursion(it, true);
            return jsInvocation;
        }
        visitedTypeParams.add(typeParameter);
        JsExpression it = jsExpression = KTypeConstructor.createKTypeParameter$createKTypeParameterImpl(typeParameter, this);
        boolean bl = false;
        visitedTypeParams.remove(typeParameter);
        return jsExpression;
    }

    /*
     * WARNING - void declaration
     */
    private static final JsExpression createKTypeParameter$createKTypeParameterImpl(TypeParameterDescriptor $typeParameter, KTypeConstructor this$0) {
        JsStringLiteral jsStringLiteral;
        void $this$mapTo$iv$iv;
        JsStringLiteral name2 = new JsStringLiteral($typeParameter.getName().asString());
        List<KotlinType> list = $typeParameter.getUpperBounds();
        Intrinsics.checkNotNullExpressionValue(list, "getUpperBounds(...)");
        JsExpression[] $this$map$iv = (JsExpression[])list;
        boolean $i$f$map = false;
        JsExpression[] jsExpressionArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            collection.add(this$0.createKType((KotlinType)it));
        }
        List list2 = (List)destination$iv$iv;
        JsArrayLiteral upperBounds = new JsArrayLiteral(list2);
        switch (WhenMappings.$EnumSwitchMapping$0[$typeParameter.getVariance().ordinal()]) {
            case 1: {
                jsStringLiteral = new JsStringLiteral("invariant");
                break;
            }
            case 2: {
                jsStringLiteral = new JsStringLiteral("in");
                break;
            }
            case 3: {
                jsStringLiteral = new JsStringLiteral("out");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        JsStringLiteral variance = jsStringLiteral;
        if ($typeParameter.isReified()) {
            JsName jsName = this$0.context.getNameForIntrinsic(SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE.getSuggestedName());
            Intrinsics.checkNotNullExpressionValue(jsName, "getNameForIntrinsic(...)");
            JsName kClassName = jsName;
            MetadataProperties.setSpecialFunction(kClassName, SpecialFunction.GET_REIFIED_TYPE_PARAMETER_KTYPE);
            jsExpressionArray = new JsExpression[]{UtilsKt.getReferenceToJsClass($typeParameter, this$0.context)};
            return new JsInvocation((JsExpression)kClassName.makeRef(), jsExpressionArray);
        }
        JsExpression[] jsExpressionArray2 = new JsExpression[]{name2, upperBounds, variance};
        return this$0.callHelperFunction("createKTypeParameter", jsExpressionArray2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Variance.values().length];
            try {
                nArray[Variance.INVARIANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

