/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.declaration;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.DataClassMethodGenerator;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsNullLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsStringLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsThisRef;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

abstract class JsEqualsHashcodeToStringGenerator
extends DataClassMethodGenerator {
    protected final TranslationContext context;

    protected JsEqualsHashcodeToStringGenerator(KtClassOrObject klass, TranslationContext context) {
        super(klass, context.bindingContext());
        this.context = context;
    }

    @Override
    public void generateToStringMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(0);
        }
        if (classProperties == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(1);
        }
        if (this.getDeclaration() instanceof KtObjectDeclaration) {
            this.generateJsMethod(function2).getBody().getStatements().add(new JsReturn(new JsStringLiteral(this.getDeclaration().getName())));
            return;
        }
        assert (!classProperties.isEmpty());
        JsFunction functionObj = this.generateJsMethod(function2);
        JsExpression result2 = null;
        for (int i2 = 0; i2 < classProperties.size(); ++i2) {
            String printName = classProperties.get(i2).getName().asString();
            JsName name2 = this.context.getNameForDescriptor(classProperties.get(i2));
            JsStringLiteral literal = new JsStringLiteral((i2 == 0 ? this.getClassDescriptor().getName() + "(" : ", ") + printName + "=");
            JsInvocation expr = new JsInvocation((JsExpression)this.context.namer().kotlin("toString"), new JsNameRef(name2, (JsExpression)new JsThisRef()));
            PsiElement source2 = PsiSourceElementKt.getPsi(classProperties.get(i2).getSource());
            JsExpression component = JsAstUtils.sum(literal, expr).source(source2);
            result2 = result2 == null ? component : JsAstUtils.sum(result2, component);
        }
        assert (result2 != null);
        result2 = JsAstUtils.sum(result2, new JsStringLiteral(")"));
        JsReturn returnStatement = new JsReturn(result2);
        returnStatement.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(returnStatement);
    }

    @Override
    public void generateHashCodeMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(2);
        }
        if (classProperties == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(3);
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        if (classProperties.isEmpty()) {
            FqName fqName = this.getDeclaration().getFqName();
            JsIntLiteral returnExpression = new JsIntLiteral(fqName != null ? fqName.hashCode() : 0);
            JsReturn returnStatement = new JsReturn(returnExpression);
            returnStatement.setSource(this.getDeclaration());
            functionObj.getBody().getStatements().add(returnStatement);
            return;
        }
        List<JsStatement> statements = functionObj.getBody().getStatements();
        JsName varName = functionObj.getScope().declareName("result");
        JsVars resultVar = new JsVars(new JsVars.JsVar(varName, new JsIntLiteral(0)));
        resultVar.setSource(this.getDeclaration());
        statements.add(resultVar);
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            JsInvocation component = new JsInvocation((JsExpression)this.context.namer().kotlin("hashCode"), new JsNameRef(name2, (JsExpression)new JsThisRef()));
            JsBinaryOperation newHashValue = JsAstUtils.sum(JsAstUtils.mul(new JsNameRef(varName), new JsIntLiteral(31)), component);
            JsBinaryOperation assignment = JsAstUtils.assignment(new JsNameRef(varName), new JsBinaryOperation(JsBinaryOperator.BIT_OR, newHashValue, new JsIntLiteral(0)));
            statements.add(assignment.source(PsiSourceElementKt.getPsi(propertyDescriptor.getSource())).makeStmt());
        }
        JsReturn returnStatement = new JsReturn(new JsNameRef(varName));
        returnStatement.setSource(this.getDeclaration());
        statements.add(returnStatement);
    }

    @Override
    public void generateEqualsMethod(@NotNull FunctionDescriptor function2, @NotNull List<? extends PropertyDescriptor> classProperties) {
        if (function2 == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(4);
        }
        if (classProperties == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(5);
        }
        JsFunction functionObj = this.generateJsMethod(function2);
        JsFunctionScope funScope = functionObj.getScope();
        JsName paramName = funScope.declareName("other");
        functionObj.getParameters().add(new JsParameter(paramName));
        JsBinaryOperation referenceEqual = JsAstUtils.equality(new JsThisRef(), new JsNameRef(paramName));
        JsBinaryOperation isNotNull = JsAstUtils.inequality(new JsNameRef(paramName), new JsNullLiteral());
        JsBinaryOperation otherIsObject = JsAstUtils.typeOfIs(paramName.makeRef(), new JsStringLiteral("object"));
        JsBinaryOperation prototypeEqual = JsAstUtils.equality(new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsThisRef()), new JsInvocation((JsExpression)new JsNameRef("getPrototypeOf", (JsExpression)new JsNameRef("Object")), new JsNameRef(paramName)));
        JsNode fieldChain = null;
        for (PropertyDescriptor propertyDescriptor : classProperties) {
            JsName name2 = this.context.getNameForDescriptor(propertyDescriptor);
            PsiElement source2 = PsiSourceElementKt.getPsi(propertyDescriptor.getSource());
            JsNode next = new JsInvocation((JsExpression)this.context.namer().kotlin("equals"), new JsNameRef(name2, (JsExpression)new JsThisRef()), new JsNameRef(name2, (JsExpression)new JsNameRef(paramName))).source(source2);
            if (fieldChain == null) {
                fieldChain = next;
                continue;
            }
            fieldChain = JsAstUtils.and((JsExpression)fieldChain, (JsExpression)next);
        }
        JsBinaryOperation returnExpression = JsAstUtils.or(referenceEqual, JsAstUtils.and(isNotNull, JsAstUtils.and(otherIsObject, fieldChain != null ? JsAstUtils.and(prototypeEqual, fieldChain) : prototypeEqual)));
        JsReturn jsReturn = new JsReturn(returnExpression);
        jsReturn.setSource(this.getDeclaration());
        functionObj.getBody().getStatements().add(jsReturn);
    }

    @Override
    protected void generateComponentFunction(@NotNull FunctionDescriptor function2, @NotNull ValueParameterDescriptor parameter) {
        if (function2 == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(6);
        }
        if (parameter == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(7);
        }
    }

    @Override
    protected void generateCopyFunction(@NotNull FunctionDescriptor function2, @NotNull List<? extends KtParameter> constructorParameters) {
        if (function2 == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(8);
        }
        if (constructorParameters == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(9);
        }
    }

    protected JsFunction generateJsMethod(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsEqualsHashcodeToStringGenerator.$$$reportNull$$$0(10);
        }
        JsFunction functionObject = this.context.createRootScopedFunction(functionDescriptor);
        functionObject.setSource(this.getDeclaration());
        ClassDescriptor containingClass = (ClassDescriptor)functionDescriptor.getContainingDeclaration();
        this.context.addDeclarationStatement(UtilsKt.addFunctionToPrototype(this.context, containingClass, functionDescriptor, functionObject));
        return functionObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classProperties";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorParameters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/declaration/JsEqualsHashcodeToStringGenerator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "generateToStringMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "generateHashCodeMethod";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateEqualsMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateComponentFunction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generateCopyFunction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generateJsMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

