/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Writer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B5\b\u0016\u0012*\u0010\u0002\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b0\u0007\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J\u001f\u0010\u0012\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonObject;", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/JsonNode;", "properties", "", "", "<init>", "(Ljava/util/Map;)V", "", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "getProperties", "()Ljava/util/Map;", "write", "", "writer", "Ljava/io/Writer;", "toString", "component1", "copy", "equals", "", "other", "", "hashCode", "", "js.parser"})
public final class JsonObject
extends JsonNode {
    @NotNull
    private final Map<String, JsonNode> properties;

    public JsonObject(@NotNull Map<String, JsonNode> properties2) {
        Intrinsics.checkNotNullParameter(properties2, "properties");
        super(null);
        this.properties = properties2;
    }

    @NotNull
    public final Map<String, JsonNode> getProperties() {
        return this.properties;
    }

    public JsonObject(Pair<String, ? extends JsonNode> ... properties2) {
        Intrinsics.checkNotNullParameter(properties2, "properties");
        this(MapsKt.toMutableMap(MapsKt.toMap(properties2)));
    }

    @Override
    public void write(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.append('{');
        boolean first2 = true;
        for (Map.Entry<String, JsonNode> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            JsonNode value2 = entry.getValue();
            if (!first2) {
                writer.append(',');
            }
            first2 = false;
            new JsonString(key).write(writer);
            writer.append(':');
            value2.write(writer);
        }
        writer.append('}');
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString();
    }

    @NotNull
    public final Map<String, JsonNode> component1() {
        return this.properties;
    }

    @NotNull
    public final JsonObject copy(@NotNull Map<String, JsonNode> properties2) {
        Intrinsics.checkNotNullParameter(properties2, "properties");
        return new JsonObject(properties2);
    }

    public static /* synthetic */ JsonObject copy$default(JsonObject jsonObject, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = jsonObject.properties;
        }
        return jsonObject.copy(map2);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JsonObject)) {
            return false;
        }
        JsonObject jsonObject = (JsonObject)other;
        return Intrinsics.areEqual(this.properties, jsonObject.properties);
    }
}

