/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.AbstractShortList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.shorts.ShortUnaryOperator;

public interface ShortList
extends ShortCollection,
Comparable<List<? extends Short>>,
List<Short> {
    @Override
    public ShortListIterator iterator();

    @Override
    default public ShortSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractShortList.IndexBasedSpliterator(this, 0);
        }
        return ShortSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public ShortListIterator listIterator();

    public ShortListIterator listIterator(int var1);

    public ShortList subList(int var1, int var2);

    public void getElements(int var1, short[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(short[] a2) {
        this.setElements(0, a2);
    }

    default public void setElements(int index, short[] a2) {
        this.setElements(index, a2, 0, a2.length);
    }

    default public void setElements(int index, short[] a2, int offset2, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        ShortArrays.ensureOffsetLength(a2, offset2, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        ShortListIterator iter = this.listIterator(index);
        int i2 = 0;
        while (i2 < length) {
            iter.nextShort();
            iter.set(a2[offset2 + i2++]);
        }
    }

    @Override
    public boolean add(short var1);

    @Override
    public void add(int var1, short var2);

    @Override
    @Deprecated
    default public void add(int index, Short key) {
        this.add(index, (short)key);
    }

    @Override
    public short set(int var1, short var2);

    default public void replaceAll(ShortUnaryOperator operator) {
        ShortListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(operator.apply(iter.nextShort()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Short> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof ShortUnaryOperator ? (ShortUnaryOperator)operator : operator::apply);
    }

    public short getShort(int var1);

    public int indexOf(short var1);

    public int lastIndexOf(short var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return ShortCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Short get(int index) {
        return this.getShort(index);
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf((Short)o);
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf((Short)o);
    }

    @Override
    @Deprecated
    default public boolean add(Short k) {
        return this.add((short)k);
    }

    public short removeShort(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return ShortCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Short remove(int index) {
        return this.removeShort(index);
    }

    @Override
    @Deprecated
    default public Short set(int index, Short k) {
        return this.set(index, (short)k);
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Short> comparator) {
        this.sort(ShortComparators.asShortComparator(comparator));
    }

    default public void sort(ShortComparator comparator) {
        if (comparator == null) {
            this.unstableSort(comparator);
        } else {
            short[] elements = this.toShortArray();
            ShortArrays.stableSort(elements, comparator);
            this.setElements(elements);
        }
    }

    default public void unstableSort(ShortComparator comparator) {
        short[] elements = this.toShortArray();
        if (comparator == null) {
            ShortArrays.unstableSort(elements);
        } else {
            ShortArrays.unstableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

