/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterators;

public abstract class AbstractLongCollection
extends AbstractCollection<Long>
implements LongCollection {
    protected AbstractLongCollection() {
    }

    @Override
    public abstract LongIterator iterator();

    @Override
    public boolean add(long k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(long k) {
        LongIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextLong()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(long k) {
        LongIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextLong()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Long key) {
        return LongCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return LongCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return LongCollection.super.remove(key);
    }

    public long[] toArray(long[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new long[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        LongIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public long[] toLongArray() {
        return this.toArray((long[])null);
    }

    public boolean addAll(LongCollection c) {
        boolean retVal = false;
        LongIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Long> c) {
        if (c instanceof LongCollection) {
            return this.addAll((LongCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(LongCollection c) {
        LongIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextLong())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.containsAll((LongCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(LongCollection c) {
        boolean retVal = false;
        LongIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextLong())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.removeAll((LongCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(LongCollection c) {
        boolean retVal = false;
        LongIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextLong())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof LongCollection) {
            return this.retainAll((LongCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        LongIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            long k = i2.nextLong();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

