/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.ints.IntComparator;

public final class IntArrays {
    public static final int[] EMPTY_ARRAY = new int[0];
    public static final int[] DEFAULT_EMPTY_ARRAY = new int[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<int[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static int[] forceCapacity(int[] array, int length, int preserve) {
        int[] t = new int[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(int[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    public static void swap(int[] x, int a2, int b2) {
        int t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    public static void swap(int[] x, int a2, int b2, int n) {
        int i2 = 0;
        while (i2 < n) {
            IntArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(int[] x, int a2, int b2, int c, IntComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c]);
        int bc = comp.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(int[] a2, int from2, int to, IntComparator comp) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (comp.compare(a2[j], a2[m]) >= 0) continue;
                m = j;
            }
            if (m == i2) continue;
            int u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    private static void insertionSort(int[] a2, int from2, int to, IntComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            int t = a2[i2];
            int j = i2;
            int u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void quickSort(int[] x, int from2, int to, IntComparator comp) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            IntArrays.selectionSort(x, from2, to, comp);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s, comp);
            m = IntArrays.med3(x, m - s, m, m + s, comp);
            n = IntArrays.med3(x, n - 2 * s, n - s, n, comp);
        }
        m = IntArrays.med3(x, l, m, n, comp);
        int v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = comp.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        IntArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSort(x, from2, from2 + s, comp);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to, comp);
        }
    }

    private static int med3(int[] x, int a2, int b2, int c) {
        int ab = Integer.compare(x[a2], x[b2]);
        int ac = Integer.compare(x[a2], x[c]);
        int bc = Integer.compare(x[b2], x[c]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c : a2)) : (bc > 0 ? b2 : (ac > 0 ? c : a2));
    }

    private static void selectionSort(int[] a2, int from2, int to) {
        for (int i2 = from2; i2 < to - 1; ++i2) {
            int m = i2;
            for (int j = i2 + 1; j < to; ++j) {
                if (a2[j] >= a2[m]) continue;
                m = j;
            }
            if (m == i2) continue;
            int u = a2[i2];
            a2[i2] = a2[m];
            a2[m] = u;
        }
    }

    public static void quickSort(int[] x, int from2, int to) {
        int c;
        int a2;
        int len = to - from2;
        if (len < 16) {
            IntArrays.selectionSort(x, from2, to);
            return;
        }
        int m = from2 + len / 2;
        int l = from2;
        int n = to - 1;
        if (len > 128) {
            int s = len / 8;
            l = IntArrays.med3(x, l, l + s, l + 2 * s);
            m = IntArrays.med3(x, m - s, m, m + s);
            n = IntArrays.med3(x, n - 2 * s, n - s, n);
        }
        m = IntArrays.med3(x, l, m, n);
        int v = x[m];
        int b2 = a2 = from2;
        int d = c = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c && (comparison = Integer.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c >= b2 && (comparison = Integer.compare(x[c], v)) >= 0) {
                if (comparison == 0) {
                    IntArrays.swap(x, c, d--);
                }
                --c;
            }
            if (b2 > c) break;
            IntArrays.swap(x, b2++, c--);
        }
        int s = Math.min(a2 - from2, b2 - a2);
        IntArrays.swap(x, from2, b2 - s, s);
        s = Math.min(d - c, to - d - 1);
        IntArrays.swap(x, b2, to - s, s);
        s = b2 - a2;
        if (s > 1) {
            IntArrays.quickSort(x, from2, from2 + s);
        }
        if ((s = d - c) > 1) {
            IntArrays.quickSort(x, to - s, to);
        }
    }

    public static void unstableSort(int[] a2, int from2, int to) {
        if (to - from2 >= 2000) {
            IntArrays.radixSort(a2, from2, to);
        } else {
            IntArrays.quickSort(a2, from2, to);
        }
    }

    public static void unstableSort(int[] a2) {
        IntArrays.unstableSort(a2, 0, a2.length);
    }

    public static void unstableSort(int[] a2, int from2, int to, IntComparator comp) {
        IntArrays.quickSort(a2, from2, to, comp);
    }

    public static void unstableSort(int[] a2, IntComparator comp) {
        IntArrays.unstableSort(a2, 0, a2.length, comp);
    }

    public static void mergeSort(int[] a2, int from2, int to, IntComparator comp, int[] supp) {
        int len = to - from2;
        if (len < 16) {
            IntArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        IntArrays.mergeSort(supp, from2, mid, comp, a2);
        IntArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(int[] a2, int from2, int to, IntComparator comp) {
        IntArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(int[] a2, int from2, int to) {
        IntArrays.unstableSort(a2, from2, to);
    }

    public static void stableSort(int[] a2, int from2, int to, IntComparator comp) {
        IntArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(int[] a2, IntComparator comp) {
        IntArrays.stableSort(a2, 0, a2.length, comp);
    }

    public static void radixSort(int[] a2, int from2, int to) {
        if (to - from2 < 1024) {
            IntArrays.quickSort(a2, from2, to);
            return;
        }
        int maxLevel = 3;
        int stackSize = 766;
        int stackPos = 0;
        int[] offsetStack = new int[766];
        int[] lengthStack = new int[766];
        int[] levelStack = new int[766];
        offsetStack[stackPos] = from2;
        lengthStack[stackPos] = to - from2;
        levelStack[stackPos++] = 0;
        int[] count2 = new int[256];
        int[] pos = new int[256];
        while (stackPos > 0) {
            int first2 = offsetStack[--stackPos];
            int length = lengthStack[stackPos];
            int level = levelStack[stackPos];
            int signMask = level % 4 == 0 ? 128 : 0;
            int shift = (3 - level % 4) * 8;
            int i2 = first2 + length;
            while (i2-- != first2) {
                int n = a2[i2] >>> shift & 0xFF ^ signMask;
                count2[n] = count2[n] + 1;
            }
            int lastUsed = -1;
            int p2 = first2;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count2[i3] != 0) {
                    lastUsed = i3;
                }
                pos[i3] = p2 += count2[i3];
            }
            int end = first2 + length - count2[lastUsed];
            int c = -1;
            for (int i4 = first2; i4 <= end; i4 += count2[c]) {
                int t = a2[i4];
                c = t >>> shift & 0xFF ^ signMask;
                if (i4 < end) {
                    while (true) {
                        int n = c;
                        int n2 = pos[n] - 1;
                        pos[n] = n2;
                        int d = n2;
                        if (n2 <= i4) break;
                        int z = t;
                        t = a2[d];
                        a2[d] = z;
                        c = t >>> shift & 0xFF ^ signMask;
                    }
                    a2[i4] = t;
                }
                if (level < 3 && count2[c] > 1) {
                    if (count2[c] < 1024) {
                        IntArrays.quickSort(a2, i4, i4 + count2[c]);
                    } else {
                        offsetStack[stackPos] = i4;
                        lengthStack[stackPos] = count2[c];
                        levelStack[stackPos++] = level + 1;
                    }
                }
                count2[c] = 0;
            }
        }
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<int[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(int[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(int[] a2, int[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

