/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Size64;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.AbstractFloatList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatArrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatComparators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatListIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatSpliterators;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.floats.FloatUnaryOperator;

public interface FloatList
extends FloatCollection,
Comparable<List<? extends Float>>,
List<Float> {
    @Override
    public FloatListIterator iterator();

    @Override
    default public FloatSpliterator spliterator() {
        if (this instanceof RandomAccess) {
            return new AbstractFloatList.IndexBasedSpliterator(this, 0);
        }
        return FloatSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 16720);
    }

    public FloatListIterator listIterator();

    public FloatListIterator listIterator(int var1);

    public FloatList subList(int var1, int var2);

    public void getElements(int var1, float[] var2, int var3, int var4);

    public void removeElements(int var1, int var2);

    default public void setElements(float[] a2) {
        this.setElements(0, a2);
    }

    default public void setElements(int index, float[] a2) {
        this.setElements(index, a2, 0, a2.length);
    }

    default public void setElements(int index, float[] a2, int offset2, int length) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is negative");
        }
        if (index > this.size()) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than list size (" + this.size() + ")");
        }
        FloatArrays.ensureOffsetLength(a2, offset2, length);
        if (index + length > this.size()) {
            throw new IndexOutOfBoundsException("End index (" + (index + length) + ") is greater than list size (" + this.size() + ")");
        }
        FloatListIterator iter = this.listIterator(index);
        int i2 = 0;
        while (i2 < length) {
            iter.nextFloat();
            iter.set(a2[offset2 + i2++]);
        }
    }

    @Override
    public boolean add(float var1);

    @Override
    public void add(int var1, float var2);

    @Override
    @Deprecated
    default public void add(int index, Float key) {
        this.add(index, key.floatValue());
    }

    @Override
    public float set(int var1, float var2);

    default public void replaceAll(FloatUnaryOperator operator) {
        FloatListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            iter.set(operator.apply(iter.nextFloat()));
        }
    }

    @Override
    @Deprecated
    default public void replaceAll(UnaryOperator<Float> operator) {
        Objects.requireNonNull(operator);
        this.replaceAll(operator instanceof FloatUnaryOperator ? (FloatUnaryOperator)operator : operator::apply);
    }

    public float getFloat(int var1);

    public int indexOf(float var1);

    public int lastIndexOf(float var1);

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        return FloatCollection.super.contains(key);
    }

    @Override
    @Deprecated
    default public Float get(int index) {
        return Float.valueOf(this.getFloat(index));
    }

    @Override
    @Deprecated
    default public int indexOf(Object o) {
        return this.indexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public int lastIndexOf(Object o) {
        return this.lastIndexOf(((Float)o).floatValue());
    }

    @Override
    @Deprecated
    default public boolean add(Float k) {
        return this.add(k.floatValue());
    }

    public float removeFloat(int var1);

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        return FloatCollection.super.remove(key);
    }

    @Override
    @Deprecated
    default public Float remove(int index) {
        return Float.valueOf(this.removeFloat(index));
    }

    @Override
    @Deprecated
    default public Float set(int index, Float k) {
        return Float.valueOf(this.set(index, k.floatValue()));
    }

    @Override
    @Deprecated
    default public void sort(Comparator<? super Float> comparator) {
        this.sort(FloatComparators.asFloatComparator(comparator));
    }

    default public void sort(FloatComparator comparator) {
        float[] elements = this.toFloatArray();
        if (comparator == null) {
            FloatArrays.stableSort(elements);
        } else {
            FloatArrays.stableSort(elements, comparator);
        }
        this.setElements(elements);
    }
}

