/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.io.Serializable;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Arrays;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleComparator;

public final class DoubleArrays {
    public static final double[] EMPTY_ARRAY = new double[0];
    public static final double[] DEFAULT_EMPTY_ARRAY = new double[0];
    protected static final Segment POISON_PILL = new Segment(-1, -1, -1);
    public static final Hash.Strategy<double[]> HASH_STRATEGY = new ArrayHashStrategy();

    public static double[] forceCapacity(double[] array, int length, int preserve) {
        double[] t = new double[length];
        System.arraycopy(array, 0, t, 0, preserve);
        return t;
    }

    public static void ensureOffsetLength(double[] a2, int offset2, int length) {
        Arrays.ensureOffsetLength(a2.length, offset2, length);
    }

    private static void insertionSort(double[] a2, int from2, int to, DoubleComparator comp) {
        int i2 = from2;
        while (++i2 < to) {
            double t = a2[i2];
            int j = i2;
            double u = a2[j - 1];
            while (comp.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    private static void insertionSort(double[] a2, int from2, int to) {
        int i2 = from2;
        while (++i2 < to) {
            double t = a2[i2];
            int j = i2;
            double u = a2[j - 1];
            while (Double.compare(t, u) < 0) {
                a2[j] = u;
                if (from2 == j - 1) {
                    --j;
                    break;
                }
                u = a2[--j - 1];
            }
            a2[j] = t;
        }
    }

    public static void mergeSort(double[] a2, int from2, int to, double[] supp) {
        int len = to - from2;
        if (len < 16) {
            DoubleArrays.insertionSort(a2, from2, to);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        DoubleArrays.mergeSort(supp, from2, mid, a2);
        DoubleArrays.mergeSort(supp, mid, to, a2);
        if (Double.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && Double.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from2, int to) {
        DoubleArrays.mergeSort(a2, from2, to, (double[])null);
    }

    public static void mergeSort(double[] a2, int from2, int to, DoubleComparator comp, double[] supp) {
        int len = to - from2;
        if (len < 16) {
            DoubleArrays.insertionSort(a2, from2, to, comp);
            return;
        }
        if (supp == null) {
            supp = java.util.Arrays.copyOf(a2, to);
        }
        int mid = from2 + to >>> 1;
        DoubleArrays.mergeSort(supp, from2, mid, comp, a2);
        DoubleArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from2, a2, from2, len);
            return;
        }
        int p2 = from2;
        int q2 = mid;
        for (int i2 = from2; i2 < to; ++i2) {
            a2[i2] = q2 >= to || p2 < mid && comp.compare(supp[p2], supp[q2]) <= 0 ? supp[p2++] : supp[q2++];
        }
    }

    public static void mergeSort(double[] a2, int from2, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, from2, to, comp, null);
    }

    public static void stableSort(double[] a2, int from2, int to) {
        DoubleArrays.mergeSort(a2, from2, to);
    }

    public static void stableSort(double[] a2) {
        DoubleArrays.stableSort(a2, 0, a2.length);
    }

    public static void stableSort(double[] a2, int from2, int to, DoubleComparator comp) {
        DoubleArrays.mergeSort(a2, from2, to, comp);
    }

    public static void stableSort(double[] a2, DoubleComparator comp) {
        DoubleArrays.stableSort(a2, 0, a2.length, comp);
    }

    protected static final class Segment {
        protected final int offset;
        protected final int length;
        protected final int level;

        protected Segment(int offset2, int length, int level) {
            this.offset = offset2;
            this.length = length;
            this.level = level;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", length=" + this.length + ", level=" + this.level + "]";
        }
    }

    private static final class ArrayHashStrategy
    implements Hash.Strategy<double[]>,
    Serializable {
        private static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(double[] o) {
            return java.util.Arrays.hashCode(o);
        }

        @Override
        public boolean equals(double[] a2, double[] b2) {
            return java.util.Arrays.equals(a2, b2);
        }
    }
}

