/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.doubles.DoubleIterators;

public abstract class AbstractDoubleCollection
extends AbstractCollection<Double>
implements DoubleCollection {
    protected AbstractDoubleCollection() {
    }

    @Override
    public abstract DoubleIterator iterator();

    @Override
    public boolean add(double k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(double k) {
        DoubleIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextDouble()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(double k) {
        DoubleIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextDouble()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Double key) {
        return DoubleCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return DoubleCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return DoubleCollection.super.remove(key);
    }

    public double[] toArray(double[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new double[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        DoubleIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public double[] toDoubleArray() {
        return this.toArray((double[])null);
    }

    public boolean addAll(DoubleCollection c) {
        boolean retVal = false;
        DoubleIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Double> c) {
        if (c instanceof DoubleCollection) {
            return this.addAll((DoubleCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(DoubleCollection c) {
        DoubleIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextDouble())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.containsAll((DoubleCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(DoubleCollection c) {
        boolean retVal = false;
        DoubleIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextDouble())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.removeAll((DoubleCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(DoubleCollection c) {
        boolean retVal = false;
        DoubleIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextDouble())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof DoubleCollection) {
            return this.retainAll((DoubleCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        DoubleIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            double k = i2.nextDouble();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

