/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars;

import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.chars.CharIterators;

public abstract class AbstractCharCollection
extends AbstractCollection<Character>
implements CharCollection {
    protected AbstractCharCollection() {
    }

    @Override
    public abstract CharIterator iterator();

    @Override
    public boolean add(char k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(char k) {
        CharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextChar()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean rem(char k) {
        CharIterator iterator2 = this.iterator();
        while (iterator2.hasNext()) {
            if (k != iterator2.nextChar()) continue;
            iterator2.remove();
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean add(Character key) {
        return CharCollection.super.add(key);
    }

    @Override
    @Deprecated
    public boolean contains(Object key) {
        return CharCollection.super.contains(key);
    }

    @Override
    @Deprecated
    public boolean remove(Object key) {
        return CharCollection.super.remove(key);
    }

    public char[] toArray(char[] a2) {
        int size = this.size();
        if (a2 == null) {
            a2 = new char[size];
        } else if (a2.length < size) {
            a2 = Arrays.copyOf(a2, size);
        }
        CharIterators.unwrap(this.iterator(), a2);
        return a2;
    }

    @Override
    public char[] toCharArray() {
        return this.toArray((char[])null);
    }

    public boolean addAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.add(i2.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends Character> c) {
        if (c instanceof CharCollection) {
            return this.addAll((CharCollection)c);
        }
        return super.addAll(c);
    }

    public boolean containsAll(CharCollection c) {
        CharIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (this.contains(i2.nextChar())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.containsAll((CharCollection)c);
        }
        return super.containsAll(c);
    }

    public boolean removeAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i2 = c.iterator();
        while (i2.hasNext()) {
            if (!this.rem(i2.nextChar())) continue;
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.removeAll((CharCollection)c);
        }
        return super.removeAll(c);
    }

    public boolean retainAll(CharCollection c) {
        boolean retVal = false;
        CharIterator i2 = this.iterator();
        while (i2.hasNext()) {
            if (c.contains(i2.nextChar())) continue;
            i2.remove();
            retVal = true;
        }
        return retVal;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (c instanceof CharCollection) {
            return this.retainAll((CharCollection)c);
        }
        return super.retainAll(c);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        CharIterator i2 = this.iterator();
        int n = this.size();
        boolean first2 = true;
        s.append("{");
        while (n-- != 0) {
            if (first2) {
                first2 = false;
            } else {
                s.append(", ");
            }
            char k = i2.nextChar();
            s.append(String.valueOf(k));
        }
        s.append("}");
        return s.toString();
    }
}

