/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.UnsignedType;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.CompoundInstruction;
import org.jetbrains.kotlin.ir.interpreter.CustomInstruction;
import org.jetbrains.kotlin.ir.interpreter.DefaultCallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.ExceptionUtilsKt;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterAssertionError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterError;
import org.jetbrains.kotlin.ir.interpreter.exceptions.InterpreterTimeOutError;
import org.jetbrains.kotlin.ir.interpreter.proxy.CommonProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.Proxy;
import org.jetbrains.kotlin.ir.interpreter.stack.CallStack;
import org.jetbrains.kotlin.ir.interpreter.state.Common;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.ExceptionState;
import org.jetbrains.kotlin.ir.interpreter.state.Primitive;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateKt;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00da\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tB'\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u001f*\u00020#H\u0002J\u001a\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J0\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+2\u0019\u0010,\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u00010\u00010-\u00a2\u0006\u0002\b.H\u0000\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020!H\u0002J\u0010\u0010$\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0002J\f\u00103\u001a\u00020\u001f*\u000204H\u0002J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010<\u001a\u00020\u001f2\u0006\u0010=\u001a\u00020>H\u0002J\u0010\u0010?\u001a\u00020\u001f2\u0006\u0010@\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020MH\u0002J\u0014\u0010N\u001a\u00020\u001f2\n\u0010&\u001a\u0006\u0012\u0002\b\u00030OH\u0002J\u0010\u0010P\u001a\u00020\u001f2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020TH\u0002J\u0010\u0010U\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020\u001f2\u0006\u0010]\u001a\u00020^H\u0002J\u0010\u0010_\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020aH\u0002J\u0010\u0010b\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020cH\u0002J\u0010\u0010d\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020gH\u0002J\u0010\u0010h\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020\u001f2\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020nH\u0002J\u0010\u0010o\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020\u001f2\u0006\u00101\u001a\u00020rH\u0002J\u0010\u0010s\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020tH\u0002J\u0010\u0010u\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020vH\u0002J\u0010\u0010w\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020xH\u0002J\u0010\u0010y\u001a\u00020\u001f2\u0006\u0010z\u001a\u00020{H\u0002J\u0010\u0010|\u001a\u00020\u001f2\u0006\u0010}\u001a\u00020~H\u0002J\u0012\u0010\u007f\u001a\u00020\u001f2\b\u0010\u0080\u0001\u001a\u00030\u0081\u0001H\u0002J\u0012\u0010\u0082\u0001\u001a\u00020\u001f2\u0007\u0010&\u001a\u00030\u0083\u0001H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0084\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreter;", "", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "bodyMap", "", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "<init>", "(Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;Ljava/util/Map;)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Map;)V", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "(Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;)V", "getEnvironment$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "getBodyMap$ir_interpreter", "()Ljava/util/Map;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "callStack", "Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "getCallStack", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "commandCount", "", "incrementAndCheckCommands", "", "getUnitState", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "handle", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "interpret", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "withNewCallStack", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "withNewCallStack$ir_interpreter", "extractResultAndAssertThatStackIsEmpty", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "tryResetFunctionBody", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "interpretFunction", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "interpretValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "interpretCall", "interpretField", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "interpretBody", "body", "interpretBlock", "block", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "interpretConstructor", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "interpretConstructorCall", "constructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "interpretDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "interpretEnumConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrEnumConstructorCall;", "interpretConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "interpretVariable", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "interpretSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "interpretReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "interpretWhile", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "interpretDoWhile", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "interpretWhen", "whenExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "interpretBranch", "branch", "Lorg/jetbrains/kotlin/ir/expressions/IrBranch;", "interpretSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "interpretGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "interpretGetObjectValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "interpretGetEnumValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetEnumValue;", "interpretEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "interpretTypeOperatorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "interpretVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "interpretTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "interpretThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "interpretStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "interpretFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "interpretFunctionReference", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "interpretPropertyReference", "propertyReference", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "interpretClassReference", "classReference", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "interpretGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIrInterpreter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ExceptionUtils.kt\norg/jetbrains/kotlin/ir/interpreter/exceptions/ExceptionUtilsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 7 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,652:1\n1#2:653\n1557#3:654\n1628#3,3:655\n1872#3,3:658\n1557#3:663\n1628#3,3:664\n1872#3,3:667\n808#3,11:672\n230#3,2:683\n1368#3:703\n1454#3,5:704\n808#3,11:709\n230#3,2:720\n1557#3:722\n1628#3,3:723\n808#3,11:726\n1863#3,2:737\n216#4,2:661\n20#5,2:670\n22#6,16:685\n38#6:702\n24#7:701\n*S KotlinDebug\n*F\n+ 1 IrInterpreter.kt\norg/jetbrains/kotlin/ir/interpreter/IrInterpreter\n*L\n165#1:654\n165#1:655,3\n187#1:658,3\n225#1:663\n225#1:664,3\n248#1:667,3\n490#1:672,11\n491#1:683,2\n525#1:703\n525#1:704,5\n543#1:709,11\n543#1:720,2\n544#1:722\n544#1:723,3\n429#1:726,11\n622#1:737,2\n192#1:661,2\n389#1:670,2\n496#1:685,16\n496#1:702\n496#1:701\n*E\n"})
public final class IrInterpreter {
    @NotNull
    private final IrInterpreterEnvironment environment;
    @NotNull
    private final Map<IdSignature, IrBody> bodyMap;
    @NotNull
    private final CallInterceptor callInterceptor;
    private int commandCount;

    public IrInterpreter(@NotNull IrInterpreterEnvironment environment, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter(environment, "environment");
        Intrinsics.checkNotNullParameter(bodyMap, "bodyMap");
        this.environment = environment;
        this.bodyMap = bodyMap;
        this.callInterceptor = new DefaultCallInterceptor(this);
    }

    public /* synthetic */ IrInterpreter(IrInterpreterEnvironment irInterpreterEnvironment, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(irInterpreterEnvironment, map2);
    }

    @NotNull
    public final IrInterpreterEnvironment getEnvironment$ir_interpreter() {
        return this.environment;
    }

    @NotNull
    public final Map<IdSignature, IrBody> getBodyMap$ir_interpreter() {
        return this.bodyMap;
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.environment.getIrBuiltIns();
    }

    private final CallStack getCallStack() {
        return this.environment.getCallStack$ir_interpreter();
    }

    public IrInterpreter(@NotNull IrBuiltIns irBuiltIns, @NotNull Map<IdSignature, ? extends IrBody> bodyMap) {
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(bodyMap, "bodyMap");
        this(new IrInterpreterEnvironment(irBuiltIns, null, 2, null), bodyMap);
    }

    public /* synthetic */ IrInterpreter(IrBuiltIns irBuiltIns, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(irBuiltIns, map2);
    }

    public IrInterpreter(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter(irModule, "irModule");
        this(new IrInterpreterEnvironment(irModule), MapsKt.emptyMap());
    }

    private final void incrementAndCheckCommands() {
        int n = this.commandCount;
        this.commandCount = n + 1;
        if (this.commandCount >= this.environment.getConfiguration().getMaxCommands()) {
            ExceptionUtilsKt.handleUserException(new InterpreterTimeOutError(), this.environment);
        }
    }

    private final State getUnitState() {
        Complex complex = this.environment.getMapOfObjects$ir_interpreter().get(this.getIrBuiltIns().getUnitClass());
        Intrinsics.checkNotNull(complex);
        return complex;
    }

    private final void handle(Instruction $this$handle) {
        Instruction instruction = $this$handle;
        if (instruction instanceof CompoundInstruction) {
            InstructionsUnfolderKt.unfoldInstruction(((CompoundInstruction)$this$handle).getElement(), this.environment);
        } else if (instruction instanceof SimpleInstruction) {
            Unit unit;
            this.interpret(((SimpleInstruction)$this$handle).getElement());
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            this.incrementAndCheckCommands();
        } else if (instruction instanceof CustomInstruction) {
            ((CustomInstruction)$this$handle).getEvaluate().invoke();
        }
    }

    @NotNull
    public final IrExpression interpret(@NotNull IrExpression expression2, @Nullable IrFile file2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.commandCount = 0;
        this.getCallStack().newFrame(expression2, file2);
        InstructionKt.pushCompoundInstruction(this.getCallStack(), expression2);
        while (!this.getCallStack().hasNoInstructions()) {
            this.handle(this.getCallStack().popInstruction());
        }
        return this.environment.stateToIrExpression$ir_interpreter(this.extractResultAndAssertThatStackIsEmpty(), expression2);
    }

    public static /* synthetic */ IrExpression interpret$default(IrInterpreter irInterpreter, IrExpression irExpression, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        return irInterpreter.interpret(irExpression, irFile);
    }

    @NotNull
    public final State withNewCallStack$ir_interpreter(@NotNull IrCall call2, @NotNull Function1<? super IrInterpreter, ? extends Object> init) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(init, "init");
        IrInterpreter $this$withNewCallStack_u24lambda_u241 = new IrInterpreter(this.environment.copyWithNewCallStack(), this.bodyMap);
        boolean bl = false;
        $this$withNewCallStack_u24lambda_u241.getCallStack().newFrame((IrFunction)call2.getSymbol().getOwner());
        init.invoke($this$withNewCallStack_u24lambda_u241);
        while (!$this$withNewCallStack_u24lambda_u241.getCallStack().hasNoInstructions()) {
            $this$withNewCallStack_u24lambda_u241.handle($this$withNewCallStack_u24lambda_u241.getCallStack().popInstruction());
        }
        return $this$withNewCallStack_u24lambda_u241.extractResultAndAssertThatStackIsEmpty();
    }

    private final State extractResultAndAssertThatStackIsEmpty() {
        boolean bl;
        State result2 = this.getCallStack().popState();
        boolean bl2 = bl = this.getCallStack().peekState() == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.getCallStack().dropFrame();
        return result2;
    }

    private final void interpret(IrElement element) {
        IrElement irElement = element;
        if (irElement instanceof IrSimpleFunction) {
            this.interpretFunction((IrSimpleFunction)element);
        } else if (irElement instanceof IrConstructor) {
            this.interpretConstructor((IrConstructor)element);
        } else if (irElement instanceof IrCall) {
            this.interpretCall((IrCall)element);
        } else if (irElement instanceof IrConstructorCall) {
            this.interpretConstructorCall((IrFunctionAccessExpression)element);
        } else if (irElement instanceof IrEnumConstructorCall) {
            this.interpretEnumConstructorCall((IrEnumConstructorCall)element);
        } else if (irElement instanceof IrDelegatingConstructorCall) {
            this.interpretDelegatingConstructorCall((IrDelegatingConstructorCall)element);
        } else if (irElement instanceof IrInstanceInitializerCall) {
            this.getCallStack().pushState(this.getUnitState());
        } else if (irElement instanceof IrValueParameter) {
            this.interpretValueParameter((IrValueParameter)element);
        } else if (irElement instanceof IrField) {
            this.interpretField((IrField)element);
        } else if (irElement instanceof IrBody) {
            this.interpretBody((IrBody)element);
        } else if (irElement instanceof IrBlock) {
            this.interpretBlock((IrBlock)element);
        } else if (irElement instanceof IrReturn) {
            this.interpretReturn((IrReturn)element);
        } else if (irElement instanceof IrSetField) {
            this.interpretSetField((IrSetField)element);
        } else if (irElement instanceof IrGetField) {
            this.interpretGetField((IrGetField)element);
        } else if (irElement instanceof IrGetObjectValue) {
            this.interpretGetObjectValue((IrGetObjectValue)element);
        } else if (irElement instanceof IrGetEnumValue) {
            this.interpretGetEnumValue((IrGetEnumValue)element);
        } else if (irElement instanceof IrEnumEntry) {
            this.interpretEnumEntry((IrEnumEntry)element);
        } else if (irElement instanceof IrConst) {
            this.interpretConst((IrConst)element);
        } else if (irElement instanceof IrVariable) {
            this.interpretVariable((IrVariable)element);
        } else if (irElement instanceof IrSetValue) {
            this.interpretSetValue((IrSetValue)element);
        } else if (irElement instanceof IrTypeOperatorCall) {
            this.interpretTypeOperatorCall((IrTypeOperatorCall)element);
        } else if (irElement instanceof IrBranch) {
            this.interpretBranch((IrBranch)element);
        } else if (irElement instanceof IrWhileLoop) {
            this.interpretWhile((IrWhileLoop)element);
        } else if (irElement instanceof IrDoWhileLoop) {
            this.interpretDoWhile((IrDoWhileLoop)element);
        } else if (irElement instanceof IrWhen) {
            this.interpretWhen((IrWhen)element);
        } else if (irElement instanceof IrVararg) {
            this.interpretVararg((IrVararg)element);
        } else if (irElement instanceof IrTry) {
            this.interpretTry((IrTry)element);
        } else if (irElement instanceof IrThrow) {
            this.interpretThrow((IrThrow)element);
        } else if (irElement instanceof IrStringConcatenation) {
            this.interpretStringConcatenation((IrStringConcatenation)element);
        } else if (irElement instanceof IrFunctionExpression) {
            this.interpretFunctionExpression((IrFunctionExpression)element);
        } else if (irElement instanceof IrFunctionReference) {
            this.interpretFunctionReference((IrFunctionReference)element);
        } else if (irElement instanceof IrPropertyReference) {
            this.interpretPropertyReference((IrPropertyReference)element);
        } else if (irElement instanceof IrClassReference) {
            this.interpretClassReference((IrClassReference)element);
        } else if (irElement instanceof IrGetClass) {
            this.interpretGetClass((IrGetClass)element);
        } else {
            String string2 = element.getClass() + " not supported for interpretation";
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
    }

    private final void tryResetFunctionBody(IrFunction $this$tryResetFunctionBody) {
        IdSignature idSignature = $this$tryResetFunctionBody.getSymbol().getSignature();
        if (idSignature == null) {
            return;
        }
        IdSignature signature = idSignature;
        if (this.bodyMap.get(signature) != null) {
            $this$tryResetFunctionBody.setBody(null);
        }
    }

    private final void interpretFunction(IrSimpleFunction function2) {
        this.tryResetFunctionBody(function2);
        if (UtilsKt.checkCast(function2, this.environment)) {
            this.getCallStack().dropFrameAndCopyResult();
        }
    }

    private final void interpretValueParameter(IrValueParameter valueParameter2) {
        IrDeclarationParent irDeclarationParent = valueParameter2.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
        IrFunction irFunction = (IrFunction)irDeclarationParent;
        State state = this.getCallStack().popState();
        if (StateKt.checkNullability(state, valueParameter2.getType(), this.environment, () -> IrInterpreter.interpretValueParameter$lambda$2(irFunction, valueParameter2)) == null) {
            return;
        }
        this.getCallStack().pushState(state);
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretCall(IrCall call2) {
        IrValueParameterSymbol it;
        State dispatchReceiver;
        Object object;
        State state;
        State state2;
        void $this$mapTo$iv$iv;
        IrSimpleFunction owner = (IrSimpleFunction)call2.getSymbol().getOwner();
        Iterable $this$map$iv = owner.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List valueArguments = CollectionsKt.reversed((List)destination$iv$iv);
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getExtensionReceiver(owner);
        if (irValueParameterSymbol != null) {
            IrValueParameterSymbol it2 = irValueParameterSymbol;
            boolean bl = false;
            state2 = this.getCallStack().popState();
        } else {
            state2 = null;
        }
        State extensionReceiver = state2;
        IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getDispatchReceiver(owner);
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it3 = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        if ((object = (dispatchReceiver = state)) == null || (object = object.getIrFunctionByIrCall(call2)) == null) {
            object = call2.getSymbol().getOwner();
        }
        Object irFunction = object;
        State[] it3 = new State[]{IrInterpreter.interpretCall$getThisOrSuperReceiver(dispatchReceiver, (IrFunction)irFunction), extensionReceiver};
        List args2 = CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(it3), (Iterable)valueArguments);
        Map<IrTypeParameterSymbol, KTypeState> reifiedTypeArguments = UtilsKt.loadReifiedTypeArguments(this.environment, call2);
        this.getCallStack().newFrame((IrFunction)irFunction);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), (IrElement)irFunction);
        if (dispatchReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)dispatchReceiver));
        }
        if (extensionReceiver instanceof StateWithClosure) {
            this.getCallStack().loadUpValues((StateWithClosure)((Object)extensionReceiver));
        }
        if (AdditionalIrUtilsKt.isLocal((IrDeclaration)irFunction)) {
            this.getCallStack().copyUpValuesFromPreviousFrame();
        }
        IrValueParameterSymbol irValueParameterSymbol3 = UtilsKt.getDispatchReceiver((IrFunction)irFunction);
        if (irValueParameterSymbol3 != null) {
            it = irValueParameterSymbol3;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, dispatchReceiver);
        }
        IrValueParameterSymbol irValueParameterSymbol4 = UtilsKt.getExtensionReceiver((IrFunction)irFunction);
        if (irValueParameterSymbol4 != null) {
            it = irValueParameterSymbol4;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, extensionReceiver);
        }
        Iterable $this$forEachIndexed$iv = ((IrFunction)irFunction).getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param2;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i2 = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param2.getSymbol(), (State)valueArguments.get(i2));
        }
        this.getCallStack().storeState((IrSymbol)((IrFunction)irFunction).getSymbol(), new KTypeState(call2.getType(), (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Map<IrTypeParameterSymbol, KTypeState> $this$forEach$iv = reifiedTypeArguments;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrTypeParameterSymbol, KTypeState>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<IrTypeParameterSymbol, KTypeState> element$iv;
            Map.Entry<IrTypeParameterSymbol, KTypeState> it4 = element$iv = iterator2.next();
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it4.getKey(), it4.getValue());
        }
        if (dispatchReceiver instanceof Complex) {
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)irFunction);
            boolean bl = irClass != null ? irClass.isInner() : false;
            if (bl) {
                Complex.loadOuterClassesInto$default((Complex)dispatchReceiver, this.getCallStack(), null, 2, null);
            }
        }
        this.callInterceptor.interceptCall(call2, (IrFunction)irFunction, args2, () -> IrInterpreter.interpretCall$lambda$10(this, (IrFunction)irFunction));
    }

    private final void interpretField(IrField field) {
        IrClass irClass = IrUtilsKt.getParentAsClass(field);
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        IrValueParameterSymbol receiver = irValueParameter.getSymbol();
        State receiverState = this.getCallStack().loadState(receiver);
        IrPropertySymbol irPropertySymbol = field.getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        receiverState.setField(irPropertySymbol, this.getCallStack().popState());
    }

    private final void interpretBody(IrBody body2) {
        if (IrUtilsKt.getStatements(body2).isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretBlock(IrBlock block) {
        this.getCallStack().dropSubFrame();
        if (block.getStatements().isEmpty()) {
            this.getCallStack().pushState(this.getUnitState());
        }
    }

    private final void interpretConstructor(IrConstructor constructor) {
        CallStack callStack = this.getCallStack();
        CallStack callStack2 = this.getCallStack();
        IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull(irValueParameter);
        callStack.pushState(callStack2.loadState(irValueParameter.getSymbol()));
        this.getCallStack().dropFrameAndCopyResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretConstructorCall(IrFunctionAccessExpression constructorCall) {
        IrValueSymbol superReceiver;
        IrValueSymbol irValueSymbol;
        IrStatement irStatement;
        State state;
        State objectState;
        State state2;
        IrValueParameterSymbol receiverSymbol;
        void $this$mapTo$iv$iv;
        IrFunction constructor = ((IrFunctionSymbol)constructorCall.getSymbol()).getOwner();
        Iterable $this$map$iv = constructor.getValueParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getCallStack().popState());
        }
        List valueArguments = CollectionsKt.reversed((List)destination$iv$iv);
        IrClass irClass = IrUtilsKt.getParentAsClass(constructor);
        IrValueParameter irValueParameter = constructor.getDispatchReceiverParameter();
        IrValueParameterSymbol irValueParameterSymbol = receiverSymbol = irValueParameter != null ? irValueParameter.getSymbol() : null;
        if (!(constructorCall instanceof IrConstructorCall)) {
            state2 = this.getCallStack().loadState(UtilsKt.getThisReceiver(constructorCall));
        } else {
            StateWithClosure $this$interpretConstructorCall_u24lambda_u2412 = $i$f$mapTo = UtilsKt.isSubclassOfThrowable(irClass) ? new ExceptionState(irClass, this.environment) : new Common(irClass);
            boolean bl = false;
            if (IrUtilsKt.isObject(irClass)) {
                this.environment.getMapOfObjects$ir_interpreter().put(irClass.getSymbol(), (Complex)((Object)$this$interpretConstructorCall_u24lambda_u2412));
            }
            state2 = objectState = (State)((Object)$i$f$mapTo);
        }
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.storeUpValues((StateWithClosure)((Object)objectState));
        }
        IrValueParameterSymbol irValueParameterSymbol2 = receiverSymbol;
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            state = this.getCallStack().popState();
        } else {
            state = null;
        }
        State outerClass = state;
        IrType returnType = UtilsKt.getTypeIfReified(constructorCall.getType(), this.getCallStack());
        this.getCallStack().newFrame(constructor);
        InstructionKt.pushSimpleInstruction(this.getCallStack(), constructor);
        if (AdditionalIrUtilsKt.isLocal(irClass)) {
            CallStack callStack = this.getCallStack();
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure");
            callStack.loadUpValues((StateWithClosure)((Object)objectState));
        }
        this.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(constructorCall), objectState);
        Iterable $this$forEachIndexed$iv = constructor.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void param2;
            int n;
            if ((n = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv;
            int i2 = n;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)param2.getSymbol(), (State)valueArguments.get(i2));
        }
        this.getCallStack().storeState((IrSymbol)constructor.getSymbol(), new KTypeState(returnType, (IrClass)this.environment.getKTypeClass$ir_interpreter().getOwner()));
        Object object = constructor.getBody();
        IrStatement irStatement2 = object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null ? (IrStatement)CollectionsKt.getOrNull(object, 0) : (irStatement = null);
        if (irStatement == null) {
            irValueSymbol = null;
        } else if (irStatement instanceof IrTypeOperatorCall) {
            IrExpression irExpression = ((IrTypeOperatorCall)irStatement).getArgument();
            Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irExpression);
        } else if (irStatement instanceof IrFunctionAccessExpression) {
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement);
        } else if (irStatement instanceof IrBlock) {
            IrStatement irStatement3 = CollectionsKt.last(((IrBlock)irStatement).getStatements());
            Intrinsics.checkNotNull(irStatement3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression");
            irValueSymbol = UtilsKt.getThisReceiver((IrFunctionAccessExpression)irStatement3);
        } else {
            String index$iv2 = irStatement.getClass() + " is not supported as first statement in constructor call";
            throw new NotImplementedError("An operation is not implemented: " + index$iv2);
        }
        IrValueSymbol irValueSymbol2 = superReceiver = irValueSymbol;
        if (irValueSymbol2 != null) {
            IrValueSymbol it = irValueSymbol2;
            boolean bl = false;
            this.getCallStack().storeState((IrSymbol)it, objectState);
        }
        if (outerClass != null) {
            IrValueParameter irValueParameter3 = IrUtilsKt.getParentAsClass(irClass).getThisReceiver();
            Intrinsics.checkNotNull(irValueParameter3);
            Pair<IrValueParameterSymbol, State> outerClassSymbolToState = TuplesKt.to(irValueParameter3.getSymbol(), outerClass);
            Intrinsics.checkNotNull(objectState, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Complex");
            ((Complex)objectState).setOuterClass(outerClassSymbolToState);
            Object object2 = superReceiver;
            if (!Intrinsics.areEqual(object2 != null && (object2 = object2.getOwner()) != null ? object2.getType() : null, ((IrValueParameter)receiverSymbol.getOwner()).getType())) {
                this.getCallStack().storeState((IrSymbol)receiverSymbol, outerClass);
                ((Complex)objectState).loadOuterClassesInto(this.getCallStack(), UtilsKt.getThisReceiver(constructorCall));
            }
        }
        this.callInterceptor.interceptConstructor(constructorCall, valueArguments, () -> IrInterpreter.interpretConstructorCall$lambda$16(this, constructor));
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretDelegatingConstructorCall(IrDelegatingConstructorCall constructorCall) {
        if (Intrinsics.areEqual(((IrConstructor)constructorCall.getSymbol().getOwner()).getParent(), this.getIrBuiltIns().getAnyClass().getOwner())) {
            return;
        }
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretEnumConstructorCall(IrEnumConstructorCall constructorCall) {
        this.interpretConstructorCall(constructorCall);
    }

    private final void interpretConst(IrConst<?> expression2) {
        IrType signedType = IrInterpreter.interpretConst$getSignedType(this, expression2.getType());
        if (signedType != null) {
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
            Intrinsics.checkNotNull(irClassSymbol);
            IrClassSymbol unsignedClass = irClassSymbol;
            IrConstructor constructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(unsignedClass)).getOwner();
            IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor.getReturnType(), constructor.getSymbol(), null, 4, null);
            constructorCall.putValueArgument(0, IrUtilsKt.toIrConst$default(expression2.getValue(), signedType, 0, 0, 6, null));
            InstructionKt.pushCompoundInstruction(this.getCallStack(), constructorCall);
            return;
        }
        this.getCallStack().pushState(UtilsKt.toPrimitive(expression2));
    }

    private final void interpretVariable(IrVariable variable) {
        this.getCallStack().storeState((IrSymbol)variable.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretSetValue(IrSetValue expression2) {
        this.getCallStack().rewriteState(expression2.getSymbol(), this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretReturn(IrReturn expression2) {
        this.getCallStack().returnFromFrameWithResult(expression2);
    }

    private final void interpretWhile(IrWhileLoop loop) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretDoWhile(IrDoWhileLoop loop) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        this.getCallStack().dropSubFrame();
        if (result2) {
            this.getCallStack().newSubFrame(loop);
            InstructionKt.pushSimpleInstruction(this.getCallStack(), loop);
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getCondition());
            InstructionKt.pushCompoundInstruction(this.getCallStack(), loop.getBody());
        }
    }

    private final void interpretWhen(IrWhen whenExpression) {
        this.getCallStack().dropSubFrame();
        this.getCallStack().pushState(this.getUnitState());
    }

    private final void interpretBranch(IrBranch branch) {
        boolean result2 = StateKt.asBoolean(this.getCallStack().popState());
        if (result2) {
            this.getCallStack().dropSubFrame();
            InstructionKt.pushCompoundInstruction(this.getCallStack(), branch.getResult());
        }
    }

    private final void interpretSetField(IrSetField expression2) {
        State state;
        IrExpression irExpression = expression2.getReceiver();
        Intrinsics.checkNotNull(irExpression, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrDeclarationReference");
        IrSymbol receiver = ((IrDeclarationReference)irExpression).getSymbol();
        IrPropertySymbol irPropertySymbol = ((IrField)expression2.getSymbol().getOwner()).getCorrespondingPropertySymbol();
        Intrinsics.checkNotNull(irPropertySymbol);
        IrPropertySymbol propertySymbol = irPropertySymbol;
        State $this$interpretSetField_u24lambda_u2417 = state = this.getCallStack().loadState(receiver);
        boolean bl = false;
        $this$interpretSetField_u24lambda_u2417.setField(propertySymbol, this.getCallStack().popState());
        this.getCallStack().pushState(this.getUnitState());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void interpretGetField(IrGetField expression) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        var4_2 = expression.getReceiver();
                        v0 = var4_2 instanceof IrDeclarationReference != false ? (IrDeclarationReference)var4_2 : null;
                        receiver = v0 != null ? v0.getSymbol() : null;
                        field = (IrField)expression.getSymbol().getOwner();
                        if (!Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.Companion.getIR_EXTERNAL_JAVA_DECLARATION_STUB()) || !field.isStatic()) break block5;
                        v1 = field.getInitializer();
                        v2 = initializerExpression = v1 != null ? v1.getExpression() : null;
                        if (initializerExpression instanceof IrConst) {
                            InstructionKt.pushSimpleInstruction(this.getCallStack(), initializerExpression);
                        } else {
                            this.callInterceptor.interceptJavaStaticField(expression);
                        }
                        break block6;
                    }
                    if (!Intrinsics.areEqual(field.getOrigin(), IrDeclarationOrigin.Companion.getPROPERTY_BACKING_FIELD()) || !UtilsKt.isConst(UtilsKt.getProperty(field))) break block7;
                    v3 = field.getInitializer();
                    InstructionKt.pushCompoundInstruction(this.getCallStack(), v3 != null ? v3.getExpression() : null);
                    break block6;
                }
                if (!UtilsKt.accessesTopLevelOrObjectField(expression)) break block8;
                propertyOwner = UtilsKt.getProperty(field);
                if (UtilsKt.isConst(propertyOwner) || ((v4 = propertyOwner) != null && (v4 = v4.getBackingField()) != null && (v4 = v4.getInitializer()) != null ? v4.getExpression() : null) instanceof IrConst) ** GOTO lbl-1000
                v5 /* !! */  = propertyOwner;
                v6 = v5 /* !! */  != null && (v5 /* !! */  = IrUtilsKt.getParentClassOrNull(v5 /* !! */ )) != null ? UtilsKt.hasAnnotation(v5 /* !! */ , UtilsKt.getCompileTimeAnnotation()) : false;
                if (v6) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                isConst = v7;
                $i$f$verify = false;
                if (!isConst) {
                    $i$a$-verify-IrInterpreter$interpretGetField$1 = false;
                    var8_8 = "Cannot interpret get method on top level non const properties".toString();
                    throw new InterpreterAssertionError(var8_8);
                }
                v8 = field.getInitializer();
                InstructionKt.pushCompoundInstruction(this.getCallStack(), v8 != null ? v8.getExpression() : null);
                break block6;
            }
            v9 = this.getCallStack();
            v10 = receiver;
            Intrinsics.checkNotNull(v10);
            v11 = v9.loadState(v10);
            v12 = field.getCorrespondingPropertySymbol();
            Intrinsics.checkNotNull(v12);
            result = v11.getField(v12);
            v13 = this.getCallStack();
            v14 = result;
            Intrinsics.checkNotNull(v14);
            v13.pushState(v14);
        }
    }

    private final void interpretGetObjectValue(IrGetObjectValue expression2) {
        this.callInterceptor.interceptGetObjectValue(expression2, () -> IrInterpreter.interpretGetObjectValue$lambda$19(expression2, this));
    }

    private final void interpretGetEnumValue(IrGetEnumValue expression2) {
        CallStack callStack = this.getCallStack();
        Complex complex = this.environment.getMapOfEnums$ir_interpreter().get(expression2.getSymbol());
        Intrinsics.checkNotNull(complex);
        callStack.pushState(complex);
    }

    private final void interpretEnumEntry(IrEnumEntry enumEntry) {
        this.callInterceptor.interceptEnumEntry(enumEntry, () -> IrInterpreter.interpretEnumEntry$lambda$20(enumEntry, this));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void interpretTypeOperatorCall(IrTypeOperatorCall expression2) {
        IrClassifierSymbol typeClassifier = IrTypesKt.getClassifierOrFail(expression2.getTypeOperand());
        IrSymbolOwner irSymbolOwner = typeClassifier.getOwner();
        IrTypeParameter irTypeParameter = irSymbolOwner instanceof IrTypeParameter ? (IrTypeParameter)irSymbolOwner : null;
        boolean isReified = irTypeParameter != null ? irTypeParameter.isReified() : false;
        boolean isErased = typeClassifier.getOwner() instanceof IrTypeParameter && !isReified;
        IrType typeOperand = UtilsKt.getTypeIfReified(expression2.getTypeOperand(), this.getCallStack());
        State state = this.getCallStack().popState();
        switch (WhenMappings.$EnumSwitchMapping$1[expression2.getOperator().ordinal()]) {
            case 1: {
                this.getCallStack().pushState(this.getUnitState());
                return;
            }
            case 2: 
            case 3: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    String castedClassName = UtilsKt.getFqName(state.getIrClass());
                    ExceptionUtilsKt.handleUserException(new ClassCastException(castedClassName + " cannot be cast to " + RenderIrElementKt.render$default(typeOperand, null, 1, null)), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 4: {
                if (!isErased && !StateKt.isSubtypeOf(state, typeOperand)) {
                    this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(null, this.getIrBuiltIns().getNothingNType()));
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 5: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 6: {
                boolean isInstance = isErased || StateKt.isSubtypeOf(state, typeOperand);
                this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(!isInstance, this.getIrBuiltIns().getBooleanType()));
                return;
            }
            case 7: {
                if (StateKt.isNull(state) && !IrTypeUtilsKt.isNullable(typeOperand)) {
                    ExceptionUtilsKt.handleUserException(new NullPointerException(), this.environment);
                    return;
                }
                this.getCallStack().pushState(state);
                return;
            }
            case 8: {
                State state2;
                if (StateKt.isNull(state)) {
                    state2 = state;
                } else if (state instanceof KFunctionState) {
                    State state3 = state;
                    KFunctionState $this$interpretTypeOperatorCall_u24lambda_u2421 = (KFunctionState)state3;
                    boolean bl = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2421.setFunInterface(typeOperand);
                    state2 = state3;
                } else {
                    Object element$iv;
                    IrFunction it;
                    void $this$first$iv;
                    Iterator $this$filterIsInstanceTo$iv$iv;
                    IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(typeOperand);
                    Intrinsics.checkNotNull(irClassSymbol);
                    IrClass samClass = (IrClass)irClassSymbol.getOwner();
                    IrFunction samFunction = UtilsKt.getSingleAbstractMethod(samClass);
                    Iterable $this$filterIsInstance$iv = state.getIrClass().getDeclarations();
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv$iv = iterator2.next();
                        if (!(element$iv$iv instanceof IrFunction)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$first = false;
                    $this$filterIsInstanceTo$iv$iv = $this$first$iv.iterator();
                    do {
                        if (!$this$filterIsInstanceTo$iv$iv.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                        element$iv = $this$filterIsInstanceTo$iv$iv.next();
                        it = (IrFunction)element$iv;
                        boolean bl = false;
                    } while (!(Intrinsics.areEqual(it.getName(), OperatorNameConventions.INVOKE) && it.getValueParameters().size() == samFunction.getValueParameters().size()));
                    IrFunction invokeFunction = (IrFunction)element$iv;
                    IrClass functionClass = IrUtilsKt.getParentAsClass(UtilsKt.getLastOverridden(invokeFunction));
                    IrValueParameter irValueParameter = invokeFunction.getDispatchReceiverParameter();
                    Intrinsics.checkNotNull(irValueParameter);
                    Pair<IrValueParameterSymbol, State> dispatchReceiver = TuplesKt.to(irValueParameter.getSymbol(), state);
                    IrElement $this$deepCopyWithSymbols_u24default$iv = invokeFunction;
                    boolean $i$f$deepCopyWithSymbols = false;
                    IrElement $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                    boolean $i$f$deepCopyImpl = false;
                    DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                    IrVisitorsKt.acceptVoid($this$deepCopyImpl$iv$iv, symbolRemapper$iv$iv);
                    DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                    boolean bl = false;
                    ReferencedSymbolRemapper p0 = deepCopySymbolRemapper;
                    TypeRemapper typeRemapper$iv$iv = new DeepCopyTypeRemapper(p0);
                    IrElement irElement = $this$deepCopyImpl$iv$iv.transform(new DeepCopyIrTreeWithSymbols(symbolRemapper$iv$iv, typeRemapper$iv$iv, null, 4, null), null);
                    if (irElement == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                    }
                    Object object = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrFunction)irElement), samClass);
                    IrFunction $this$interpretTypeOperatorCall_u24lambda_u2423 = (IrFunction)object;
                    boolean bl2 = false;
                    $this$interpretTypeOperatorCall_u24lambda_u2423.setDispatchReceiverParameter(null);
                    IrFunction newInvoke = (IrFunction)object;
                    object = new Pair[]{dispatchReceiver};
                    Object $this$interpretTypeOperatorCall_u24lambda_u2424 = object = new KFunctionState(newInvoke, functionClass, this.environment, MapsKt.mutableMapOf(object));
                    boolean bl3 = false;
                    ((KFunctionState)$this$interpretTypeOperatorCall_u24lambda_u2424).setFunInterface(typeOperand);
                    state2 = (State)object;
                }
                State newState = state2;
                this.getCallStack().pushState(newState);
                return;
            }
        }
        ExceptionUtilsKt.stop(() -> IrInterpreter.interpretTypeOperatorCall$lambda$25(expression2));
        throw null;
    }

    /*
     * WARNING - void declaration
     */
    private final void interpretVararg(IrVararg expression2) {
        State state;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = expression2.getElements();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list;
            IrVarargElement it = (IrVarargElement)element$iv$iv;
            boolean bl = false;
            State result2 = this.getCallStack().popState();
            if (result2 instanceof Wrapper) {
                list = CollectionsKt.listOf(((Wrapper)result2).getValue());
            } else if (result2 instanceof Primitive) {
                list = IrTypePredicatesKt.isArray(expression2.getVarargElementType()) || UtilsKt.isPrimitiveArray(expression2.getVarargElementType()) ? CollectionsKt.listOf(result2) : IrInterpreter.interpretVararg$arrayToList(((Primitive)result2).getValue());
            } else if (result2 instanceof Common) {
                if (UtilsKt.isUnsignedArray(IrUtilsKt.getDefaultType(((Common)result2).getIrClass()))) {
                    Object t = CollectionsKt.single((Iterable)((Common)result2).getFields().values());
                    Intrinsics.checkNotNull(t, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                    list = IrInterpreter.interpretVararg$arrayToList(((Primitive)t).getValue());
                } else {
                    list = CollectionsKt.listOf(CommonProxy.Companion.asProxy$ir_interpreter$default(CommonProxy.Companion, (Common)result2, this.callInterceptor, null, 2, null));
                }
            } else {
                list = CollectionsKt.listOf(result2);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List args2 = CollectionsKt.reversed((List)destination$iv$iv);
        if (UtilsKt.isUnsignedArray(expression2.getType())) {
            void $this$mapTo$iv$iv;
            Object element$iv2;
            Object object;
            IrClass owner;
            block16: {
                void $this$first$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
                Intrinsics.checkNotNull(irClassSymbol);
                owner = (IrClass)irClassSymbol.getOwner();
                Iterable $this$filterIsInstance$iv = owner.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                object = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator bl = $this$filterIsInstanceTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    Object element$iv$iv = bl.next();
                    if (!(element$iv$iv instanceof IrProperty)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv2;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    IrProperty it = (IrProperty)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName().asString(), "storage")) continue;
                    break block16;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrProperty storageProperty = (IrProperty)element$iv2;
            Iterable $this$map$iv = args2;
            boolean $i$f$map = false;
            element$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object t;
                void it;
                Object item$iv$iv;
                Object t2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv3;
                boolean bl = false;
                if (it instanceof Proxy) {
                    Object t3 = CollectionsKt.single((Iterable)((Proxy)it).getState().getFields().values());
                    Intrinsics.checkNotNull(t3, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.Primitive<*>");
                    t = ((Primitive)t3).getValue();
                } else {
                    t = it;
                }
                collection.add(t);
            }
            List primitiveArray = (List)destination$iv$iv3;
            IrField irField = storageProperty.getBackingField();
            Intrinsics.checkNotNull(irField);
            Primitive<?> unsignedArray = UtilsKt.toPrimitiveStateArray(primitiveArray, irField.getType());
            Object $this$interpretVararg_u24lambda_u2429 = object = new Common(owner);
            boolean bl = false;
            $this$interpretVararg_u24lambda_u2429.setField(storageProperty.getSymbol(), unsignedArray);
            state = (State)object;
        } else {
            state = UtilsKt.toPrimitiveStateArray(args2, expression2.getType());
        }
        State array = state;
        this.getCallStack().pushState(array);
    }

    private final void interpretTry(IrTry element) {
        block1: {
            State possibleException = this.getCallStack().peekState();
            this.getCallStack().dropSubFrame();
            if (possibleException instanceof ExceptionState) {
                Function0<Unit> checkUnhandledException = () -> IrInterpreter.interpretTry$lambda$30(this, possibleException);
                this.getCallStack().pushInstruction(new CustomInstruction(checkUnhandledException));
            }
            IrExpression irExpression = element.getFinallyExpression();
            if (irExpression == null) break block1;
            InstructionsUnfolderKt.handleAndDropResult(irExpression, this.getCallStack());
        }
    }

    private final void interpretThrow(IrThrow expression2) {
        this.getCallStack().dropFramesUntilTryCatch();
    }

    private final void interpretStringConcatenation(IrStringConcatenation expression2) {
        List result2 = new ArrayList();
        int n = expression2.getArguments().size();
        for (int j = 0; j < n; ++j) {
            int it = j;
            boolean bl = false;
            Collection collection = result2;
            State state = this.getCallStack().popState();
            String string2 = state instanceof Primitive ? String.valueOf(((Primitive)state).getValue()) : (state instanceof Wrapper ? ((Wrapper)state).getValue().toString() : state.toString());
            collection.add(string2);
        }
        this.getCallStack().pushState(this.environment.convertToState$ir_interpreter(CollectionsKt.joinToString$default(CollectionsKt.reversed(result2), "", null, null, 0, null, null, 62, null), expression2.getType()));
    }

    private final void interpretFunctionExpression(IrFunctionExpression expression2) {
        IrFunction irFunction = expression2.getFunction();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull(irClassSymbol);
        KFunctionState function2 = new KFunctionState(irFunction, (IrClass)irClassSymbol.getOwner(), this.environment, null, 8, null);
        if (AdditionalIrUtilsKt.isLocal(expression2.getFunction())) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretFunctionReference(IrFunctionReference reference2) {
        Pair<IrValueParameterSymbol, State> pair;
        Pair<IrValueParameterSymbol, State> pair2;
        Pair<IrValueParameterSymbol, State> pair3;
        IrFunctionReference irFunctionReference;
        IrInterpreterEnvironment irInterpreterEnvironment;
        State state;
        State state2;
        IrFunction irFunction = ((IrFunctionSymbol)reference2.getSymbol()).getOwner();
        IrValueParameterSymbol irValueParameterSymbol = UtilsKt.getDispatchReceiver(irFunction);
        if (irValueParameterSymbol != null) {
            IrValueParameterSymbol it = irValueParameterSymbol;
            boolean bl = false;
            IrExpression irExpression = reference2.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression it2 = irExpression;
                boolean bl2 = false;
                state2 = this.getCallStack().popState();
            } else {
                state2 = null;
            }
        } else {
            state2 = null;
        }
        State dispatchReceiver = state2;
        IrValueParameterSymbol irValueParameterSymbol2 = UtilsKt.getExtensionReceiver(irFunction);
        if (irValueParameterSymbol2 != null) {
            IrValueParameterSymbol it = irValueParameterSymbol2;
            boolean bl = false;
            IrExpression irExpression = reference2.getExtensionReceiver();
            if (irExpression != null) {
                IrExpression it3 = irExpression;
                boolean bl3 = false;
                state = this.getCallStack().popState();
            } else {
                state = null;
            }
        } else {
            state = null;
        }
        State extensionReceiver = state;
        IrFunctionReference irFunctionReference2 = reference2;
        IrInterpreterEnvironment irInterpreterEnvironment2 = this.environment;
        State state3 = dispatchReceiver;
        if (state3 != null) {
            State it = state3;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol3 = UtilsKt.getDispatchReceiver(irFunction);
            Intrinsics.checkNotNull(irValueParameterSymbol3);
            pair3 = new Pair<IrValueParameterSymbol, State>(irValueParameterSymbol3, it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair2 = pair3;
        } else {
            pair2 = null;
        }
        State state4 = extensionReceiver;
        if (state4 != null) {
            State it = state4;
            pair3 = pair2;
            irInterpreterEnvironment = irInterpreterEnvironment2;
            irFunctionReference = irFunctionReference2;
            boolean bl = false;
            IrValueParameterSymbol irValueParameterSymbol4 = UtilsKt.getExtensionReceiver(irFunction);
            Intrinsics.checkNotNull(irValueParameterSymbol4);
            Pair<IrValueParameterSymbol, State> pair4 = new Pair<IrValueParameterSymbol, State>(irValueParameterSymbol4, it);
            irFunctionReference2 = irFunctionReference;
            irInterpreterEnvironment2 = irInterpreterEnvironment;
            pair2 = pair3;
            pair = pair4;
        } else {
            pair = null;
        }
        Pair<IrValueParameterSymbol, State> pair5 = pair;
        Pair<IrValueParameterSymbol, State> pair6 = pair2;
        IrInterpreterEnvironment irInterpreterEnvironment3 = irInterpreterEnvironment2;
        IrFunctionReference irFunctionReference3 = irFunctionReference2;
        KFunctionState function2 = new KFunctionState(irFunctionReference3, irInterpreterEnvironment3, pair6, pair5);
        if (AdditionalIrUtilsKt.isLocal(irFunction)) {
            this.getCallStack().storeUpValues(function2);
        }
        this.getCallStack().pushState(function2);
    }

    private final void interpretPropertyReference(IrPropertyReference propertyReference) {
        List<IrTypeParameter> list;
        State state;
        State extensionReceiver;
        State state2;
        Object object;
        State dispatchReceiver;
        State state3;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = propertyReference.getGetter();
        IrSimpleFunction getter2 = irSimpleFunctionSymbol != null ? (IrSimpleFunction)irSimpleFunctionSymbol.getOwner() : null;
        Object object2 = getter2;
        if (object2 != null && (object2 = UtilsKt.getDispatchReceiver((IrFunction)object2)) != null) {
            Object it = object2;
            boolean bl = false;
            IrExpression irExpression = propertyReference.getDispatchReceiver();
            if (irExpression != null) {
                IrExpression it2 = irExpression;
                boolean bl2 = false;
                state3 = this.getCallStack().popState();
            } else {
                state3 = null;
            }
        } else {
            state3 = dispatchReceiver = null;
        }
        if ((object = getter2) != null && (object = UtilsKt.getExtensionReceiver((IrFunction)object)) != null) {
            Object it = object;
            boolean bl = false;
            IrExpression irExpression = propertyReference.getExtensionReceiver();
            if (irExpression != null) {
                IrExpression it3 = irExpression;
                boolean bl3 = false;
                state2 = this.getCallStack().popState();
            } else {
                state2 = null;
            }
        } else {
            state2 = extensionReceiver = null;
        }
        if ((state = dispatchReceiver) == null) {
            state = extensionReceiver;
        }
        State receiver = state;
        KPropertyState propertyState = new KPropertyState(propertyReference, receiver);
        Object object3 = propertyReference.getGetter();
        if (object3 != null && (object3 = (IrSimpleFunction)object3.getOwner()) != null && (object3 = object3.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(object3, propertyReference, this, propertyState);
        }
        if ((list = propertyReference.getSetter()) != null && (list = (IrSimpleFunction)list.getOwner()) != null && (list = list.getTypeParameters()) != null) {
            IrInterpreter.interpretPropertyReference$addToFields(list, propertyReference, this, propertyState);
        }
        this.getCallStack().pushState(propertyState);
    }

    private final void interpretClassReference(IrClassReference classReference) {
        if (classReference.getSymbol() instanceof IrTypeParameterSymbol) {
            State state = this.getCallStack().loadState(classReference.getSymbol());
            Intrinsics.checkNotNull(state, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kTypeState = (KTypeState)state;
            CallStack callStack = this.getCallStack();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kTypeState.getIrType());
            Intrinsics.checkNotNull(irClassSymbol);
            IrClass irClass = (IrClass)irClassSymbol.getOwner();
            IrClassSymbol irClassSymbol2 = IrTypesKt.getClassOrNull(classReference.getType());
            Intrinsics.checkNotNull(irClassSymbol2);
            callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol2.getOwner()));
        } else {
            this.getCallStack().pushState(new KClassState(classReference));
        }
    }

    private final void interpretGetClass(IrGetClass expression2) {
        IrClass irClass = this.getCallStack().popState().getIrClass();
        CallStack callStack = this.getCallStack();
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(expression2.getType());
        Intrinsics.checkNotNull(irClassSymbol);
        callStack.pushState(new KClassState(irClass, (IrClass)irClassSymbol.getOwner()));
    }

    private static final boolean interpretValueParameter$isReceiver(IrFunction irFunction, IrValueParameter $valueParameter) {
        return Intrinsics.areEqual(irFunction.getDispatchReceiverParameter(), $valueParameter) || Intrinsics.areEqual(irFunction.getExtensionReceiverParameter(), $valueParameter);
    }

    private static final Throwable interpretValueParameter$lambda$2(IrFunction $irFunction, IrValueParameter $valueParameter) {
        if (IrInterpreter.interpretValueParameter$isReceiver($irFunction, $valueParameter)) {
            return new NullPointerException();
        }
        String method = UtilsKt.getCapitalizedFileName($irFunction) + '.' + UtilsKt.getFqName($irFunction);
        Name parameter = $valueParameter.getName();
        return new IllegalArgumentException("Parameter specified as non-null is null: method " + method + ", parameter " + parameter);
    }

    private static final State interpretCall$getThisOrSuperReceiver(State $this$interpretCall_u24getThisOrSuperReceiver, IrFunction irFunction) {
        if (!($this$interpretCall_u24getThisOrSuperReceiver instanceof Common) || ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass() == null || !(irFunction.getParent() instanceof IrClass)) {
            return $this$interpretCall_u24getThisOrSuperReceiver;
        }
        Wrapper wrapper = ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        Intrinsics.checkNotNull(wrapper);
        if (IrUtilsKt.isSubclassOf(wrapper.getIrClass(), IrUtilsKt.getParentAsClass(irFunction))) {
            return ((Common)$this$interpretCall_u24getThisOrSuperReceiver).getSuperWrapperClass();
        }
        return $this$interpretCall_u24getThisOrSuperReceiver;
    }

    private static final Unit interpretCall$lambda$10(IrInterpreter this$0, IrFunction $irFunction) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $irFunction);
        return Unit.INSTANCE;
    }

    private static final Unit interpretConstructorCall$lambda$16(IrInterpreter this$0, IrFunction $constructor) {
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $constructor);
        return Unit.INSTANCE;
    }

    private static final IrType interpretConst$getSignedType(IrInterpreter this$0, IrType unsignedType) {
        IrType irType;
        UnsignedType unsignedType2 = IrTypePredicatesKt.getUnsignedType(unsignedType);
        switch (unsignedType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[unsignedType2.ordinal()]) {
            case 1: {
                irType = this$0.getIrBuiltIns().getByteType();
                break;
            }
            case 2: {
                irType = this$0.getIrBuiltIns().getShortType();
                break;
            }
            case 3: {
                irType = this$0.getIrBuiltIns().getIntType();
                break;
            }
            case 4: {
                irType = this$0.getIrBuiltIns().getLongType();
                break;
            }
            default: {
                irType = null;
            }
        }
        return irType;
    }

    private static final Unit interpretGetObjectValue$lambda$19(IrGetObjectValue $expression, IrInterpreter this$0) {
        boolean buildObject;
        IrClass objectClass = (IrClass)$expression.getSymbol().getOwner();
        boolean bl = buildObject = UtilsKt.hasAnnotation(objectClass, UtilsKt.getCompileTimeAnnotation()) || this$0.environment.getConfiguration().getCreateNonCompileTimeObjects();
        if (SequencesKt.none(IrUtilsKt.getConstructors(objectClass)) || !buildObject) {
            Common state = new Common(objectClass);
            this$0.environment.getMapOfObjects$ir_interpreter().put(objectClass.getSymbol(), state);
            this$0.getCallStack().pushState(state);
            return Unit.INSTANCE;
        }
        IrConstructor constructor = SequencesKt.first(IrUtilsKt.getConstructors(objectClass));
        IrConstructorCallImpl constructorCall = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, constructor.getReturnType(), constructor.getSymbol(), null, 4, null);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), constructorCall);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit interpretEnumEntry$lambda$20(IrEnumEntry $enumEntry, IrInterpreter this$0) {
        Common enumClassObject = UtilsKt.toState($enumEntry, this$0.getIrBuiltIns());
        this$0.environment.getMapOfEnums$ir_interpreter().put($enumEntry.getSymbol(), enumClassObject);
        IrElementBase irElementBase = $enumEntry.getInitializerExpression();
        if (irElementBase == null || (irElementBase = irElementBase.getExpression()) == null) {
            throw new InterpreterError("Initializer at enum entry " + UtilsKt.getFqName($enumEntry) + " is null");
        }
        IrElementBase enumInitializer = irElementBase;
        IrEnumConstructorCall irEnumConstructorCall = enumInitializer instanceof IrEnumConstructorCall ? (IrEnumConstructorCall)enumInitializer : null;
        if (irEnumConstructorCall == null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((IrBlock)enumInitializer).getStatements();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrEnumConstructorCall)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irEnumConstructorCall = (IrEnumConstructorCall)CollectionsKt.single((List)destination$iv$iv);
        }
        IrEnumConstructorCall enumConstructorCall = irEnumConstructorCall;
        this$0.getCallStack().newSubFrame($enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), $enumEntry);
        InstructionKt.pushCompoundInstruction(this$0.getCallStack(), enumInitializer);
        this$0.getCallStack().storeState((IrSymbol)UtilsKt.getThisReceiver(enumConstructorCall), enumClassObject);
        return Unit.INSTANCE;
    }

    private static final Object interpretTypeOperatorCall$lambda$25(IrTypeOperatorCall $expression) {
        return "Type operator " + (Object)((Object)$expression.getOperator()) + " is not supported for interpretation";
    }

    private static final List<Object> interpretVararg$arrayToList(Object value2) {
        Object object = value2;
        return CollectionsKt.reversed((Iterable)(object instanceof byte[] ? ArraysKt.toList((byte[])value2) : (object instanceof char[] ? ArraysKt.toList((char[])value2) : (object instanceof short[] ? ArraysKt.toList((short[])value2) : (object instanceof int[] ? ArraysKt.toList((int[])value2) : (object instanceof long[] ? ArraysKt.toList((long[])value2) : (object instanceof float[] ? ArraysKt.toList((float[])value2) : (object instanceof double[] ? ArraysKt.toList((double[])value2) : (object instanceof boolean[] ? ArraysKt.toList((boolean[])value2) : (object instanceof Object[] ? ArraysKt.toList((Object[])value2) : CollectionsKt.listOf(value2)))))))))));
    }

    private static final Unit interpretTry$lambda$30(IrInterpreter this$0, State possibleException) {
        this$0.getCallStack().pushState(possibleException);
        this$0.getCallStack().dropFramesUntilTryCatch();
        return Unit.INSTANCE;
    }

    private static final void interpretPropertyReference$addToFields(List<? extends IrTypeParameter> $this$interpretPropertyReference_u24addToFields, IrPropertyReference $propertyReference, IrInterpreter this$0, KPropertyState propertyState) {
        Iterable $this$forEach$iv = RangesKt.until(0, $propertyReference.getTypeArgumentsCount());
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            IrType typeArgument;
            int element$iv;
            int index = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if ($propertyReference.getTypeArgument(index) == null) continue;
            KTypeState kTypeState = new KTypeState(typeArgument, (IrClass)this$0.environment.getKTypeClass$ir_interpreter().getOwner());
            propertyState.setField($this$interpretPropertyReference_u24addToFields.get(index).getSymbol(), kTypeState);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[UnsignedType.values().length];
            try {
                nArray[UnsignedType.UBYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.USHORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.UINT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UnsignedType.ULONG.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAM_CONVERSION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

