/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005Ja\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2$\u0010\r\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u0002H\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\u0012\"\u0002H\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0014\u001a\u00020\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\u00072\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "lowerConst", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "C", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "carrierFactory", "Lkotlin/Function4;", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "args", "", "(Lorg/jetbrains/kotlin/ir/expressions/IrConst;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lkotlin/jvm/functions/Function4;[Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "createLong", "v", "", "visitConst", "backend.js"})
@SourceDebugExtension(value={"SMAP\nConstLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,105:1\n350#2,12:106\n*S KotlinDebug\n*F\n+ 1 ConstLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ConstTransformer\n*L\n34#1:106,12\n*E\n"})
public final class ConstTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final JsIrBackendContext context;

    public ConstTransformer(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
    }

    private final <C> IrExpression lowerConst(IrConst<?> expression2, IrClassSymbol irClass, Function4<? super Integer, ? super Integer, ? super IrType, ? super C, ? extends IrExpression> carrierFactory, C ... args2) {
        IrConstructorCallImpl irConstructorCallImpl;
        Sequence<IrConstructorSymbol> $this$single$iv = IrUtilsKt.getConstructors(irClass);
        boolean $i$f$single = false;
        IrConstructorSymbol single$iv = null;
        boolean found$iv = false;
        Iterator<IrConstructorSymbol> iterator2 = $this$single$iv.iterator();
        while (iterator2.hasNext()) {
            IrConstructorSymbol element$iv;
            IrConstructorSymbol it = element$iv = iterator2.next();
            boolean bl = false;
            if (!((IrConstructor)it.getOwner()).isPrimary()) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructorSymbol constructor = single$iv;
        IrType argType = CollectionsKt.first(((IrConstructor)constructor.getOwner()).getValueParameters()).getType();
        IrConstructorCallImpl $this$lowerConst_u24lambda_u241 = irConstructorCallImpl = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, expression2.getStartOffset(), expression2.getEndOffset(), IrTypesKt.getDefaultType(irClass), constructor, null, 16, null);
        boolean bl = false;
        int n = args2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            $this$lowerConst_u24lambda_u241.putValueArgument(i2, carrierFactory.invoke($this$lowerConst_u24lambda_u241.getStartOffset(), $this$lowerConst_u24lambda_u241.getEndOffset(), argType, args2[i2]));
        }
        return irConstructorCallImpl;
    }

    private final IrExpression createLong(IrConst<?> expression2, long v) {
        Integer[] integerArray = new Integer[]{(int)v, (int)(v >> 32)};
        return this.lowerConst(expression2, this.context.getIntrinsics().getLongClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

            public final IrConstImpl<Integer> invoke(int p0, int p1, IrType p2, int p3) {
                Intrinsics.checkNotNullParameter(p2, "p2");
                return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
            }

            public final String getSignature() {
                return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
            }

            public final String getName() {
                return "int";
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
            }
        }, integerArray);
    }

    @Override
    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        JsIntrinsics $this$visitConst_u24lambda_u243 = this.context.getIntrinsics();
        boolean bl = false;
        if (IrTypeUtilsKt.isUnsigned(expression2.getType()) && !Intrinsics.areEqual(expression2.getKind(), IrConstKind.Null.INSTANCE)) {
            IrExpression irExpression2;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(expression2.getType());
            if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUByteClassSymbol())) {
                Byte[] byteArray = new Byte[]{IrConstKind.Byte.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u243.getUByteClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Byte, IrConstImpl<Byte>>((Object)IrConstImpl.Companion){

                    public final IrConstImpl<Byte> invoke(int p0, int p1, IrType p2, byte p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).byte(p0, p1, p2, p3);
                    }

                    public final String getSignature() {
                        return "byte(IILorg/jetbrains/kotlin/ir/types/IrType;B)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    public final String getName() {
                        return "byte";
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, byteArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUShortClassSymbol())) {
                Short[] shortArray = new Short[]{IrConstKind.Short.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u243.getUShortClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Short, IrConstImpl<Short>>((Object)IrConstImpl.Companion){

                    public final IrConstImpl<Short> invoke(int p0, int p1, IrType p2, short p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).short(p0, p1, p2, p3);
                    }

                    public final String getSignature() {
                        return "short(IILorg/jetbrains/kotlin/ir/types/IrType;S)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    public final String getName() {
                        return "short";
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, shortArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getUIntClassSymbol())) {
                Integer[] integerArray = new Integer[]{IrConstKind.Int.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u243.getUIntClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

                    public final IrConstImpl<Integer> invoke(int p0, int p1, IrType p2, int p3) {
                        Intrinsics.checkNotNullParameter(p2, "p2");
                        return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                    }

                    public final String getSignature() {
                        return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                    }

                    public final String getName() {
                        return "int";
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                    }
                }, integerArray);
            } else if (Intrinsics.areEqual(irClassifierSymbol, $this$visitConst_u24lambda_u243.getULongClassSymbol())) {
                Long[] longArray = new Long[]{IrConstKind.Long.INSTANCE.valueOf(expression2)};
                irExpression2 = this.lowerConst(expression2, $this$visitConst_u24lambda_u243.getULongClassSymbol(), (arg_0, arg_1, arg_2, arg_3) -> ConstTransformer.visitConst$lambda$3$lambda$2(this, expression2, arg_0, arg_1, arg_2, arg_3), longArray);
            } else {
                CompilationExceptionKt.compilationException("Unknown unsigned type", expression2);
                throw null;
            }
            return irExpression2;
        }
        if (expression2.getKind() instanceof IrConstKind.Char) {
            Integer[] integerArray = new Integer[]{((Character)IrConstKind.Char.INSTANCE.valueOf(expression2)).charValue()};
            irExpression = this.lowerConst(expression2, $this$visitConst_u24lambda_u243.getCharClassSymbol(), (Function4)new Function4<Integer, Integer, IrType, Integer, IrConstImpl<Integer>>((Object)IrConstImpl.Companion){

                public final IrConstImpl<Integer> invoke(int p0, int p1, IrType p2, int p3) {
                    Intrinsics.checkNotNullParameter(p2, "p2");
                    return ((IrConstImpl.Companion)this.receiver).int(p0, p1, p2, p3);
                }

                public final String getSignature() {
                    return "int(IILorg/jetbrains/kotlin/ir/types/IrType;I)Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;";
                }

                public final String getName() {
                    return "int";
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(IrConstImpl.Companion.class);
                }
            }, integerArray);
        } else {
            irExpression = expression2.getKind() instanceof IrConstKind.Long ? this.createLong(expression2, ((Number)IrConstKind.Long.INSTANCE.valueOf(expression2)).longValue()) : super.visitConst(expression2);
        }
        return irExpression;
    }

    private static final IrExpression visitConst$lambda$3$lambda$2(ConstTransformer this$0, IrConst $expression, int n, int n2, IrType irType, long v) {
        Intrinsics.checkNotNullParameter(irType, "<unused var>");
        return this$0.createLong($expression, v);
    }
}

