/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.HmppCliModuleKt;
import org.jetbrains.kotlin.config.HmppCliModuleStructure;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a0\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a8\u0006\r"}, d2={"configureBaseRoots", "", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configureSourceRootsFromSources", "allSources", "", "Ljava/io/File;", "commonSources", "", "javaPackagePrefix", "", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nIncrementalFirJvmCompilerRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncrementalFirJvmCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalFirJvmCompilerRunnerKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,350:1\n13409#2:351\n12574#2,2:352\n13410#2:354\n1863#3,2:355\n*S KotlinDebug\n*F\n+ 1 IncrementalFirJvmCompilerRunner.kt\norg/jetbrains/kotlin/incremental/IncrementalFirJvmCompilerRunnerKt\n*L\n312#1:351\n317#1:352,2\n312#1:354\n323#1:355,2\n*E\n"})
public final class IncrementalFirJvmCompilerRunnerKt {
    public static final void configureBaseRoots(@NotNull CompilerConfiguration $this$configureBaseRoots, @NotNull K2JVMCompilerArguments args2) {
        block8: {
            String[] $i$f$forEach2;
            Object object;
            String element$iv;
            Intrinsics.checkNotNullParameter($this$configureBaseRoots, "<this>");
            Intrinsics.checkNotNullParameter(args2, "args");
            boolean isJava9Module = false;
            String[] stringArray = args2.getJavaSourceRoots();
            if (stringArray != null) {
                String[] $this$forEach$iv = stringArray;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv.length;
                for (int j = 0; j < n; ++j) {
                    String it = element$iv = $this$forEach$iv[j];
                    boolean bl = false;
                    File file2 = new File(it);
                    String packagePrefix = args2.getJavaPackagePrefix();
                    JvmContentRootsKt.addJavaSourceRoot($this$configureBaseRoots, file2, packagePrefix);
                    if (isJava9Module || packagePrefix != null) continue;
                    if (!Intrinsics.areEqual(file2.getName(), "module-info.java")) {
                        boolean bl2;
                        if (!file2.isDirectory()) continue;
                        if (file2.listFiles() != null) {
                            boolean bl3;
                            block7: {
                                File[] $this$any$iv;
                                boolean $i$f$any = false;
                                int n2 = $this$any$iv.length;
                                for (int k = 0; k < n2; ++k) {
                                    File element$iv2;
                                    File it2 = element$iv2 = $this$any$iv[k];
                                    boolean bl4 = false;
                                    if (!Intrinsics.areEqual(it2.getName(), "module-info.java")) continue;
                                    bl3 = true;
                                    break block7;
                                }
                                bl3 = false;
                            }
                            bl2 = bl3;
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                    }
                    isJava9Module = true;
                }
            }
            if ((object = args2.getClasspath()) == null || (object = StringsKt.split$default((CharSequence)object, $i$f$forEach2 = new String[]{File.pathSeparator}, false, 0, 6, null)) == null) break block8;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach3 = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                String classpathRoot = element$iv = iterator2.next();
                boolean bl = false;
                $this$configureBaseRoots.add(CLIConfigurationKeys.CONTENT_ROOTS, isJava9Module ? (JvmContentRoot)new JvmModulePathRoot(new File(classpathRoot)) : (JvmContentRoot)new JvmClasspathRoot(new File(classpathRoot)));
            }
        }
    }

    public static final void configureSourceRootsFromSources(@NotNull CompilerConfiguration $this$configureSourceRootsFromSources, @NotNull Collection<? extends File> allSources, @NotNull Set<? extends File> commonSources, @Nullable String javaPackagePrefix) {
        Intrinsics.checkNotNullParameter($this$configureSourceRootsFromSources, "<this>");
        Intrinsics.checkNotNullParameter(allSources, "allSources");
        Intrinsics.checkNotNullParameter(commonSources, "commonSources");
        HmppCliModuleStructure hmppCliModuleStructure = $this$configureSourceRootsFromSources.get(CommonConfigurationKeys.HMPP_MODULE_STRUCTURE);
        for (File file2 : allSources) {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            if (StringsKt.endsWith$default(string2, ".java", false, 2, null)) {
                JvmContentRootsKt.addJavaSourceRoot($this$configureSourceRootsFromSources, file2, javaPackagePrefix);
                continue;
            }
            String path = file2.getPath();
            Intrinsics.checkNotNull(path);
            HmppCliModuleStructure hmppCliModuleStructure2 = hmppCliModuleStructure;
            ContentRootsKt.addKotlinSourceRoot($this$configureSourceRootsFromSources, path, commonSources.contains(file2), hmppCliModuleStructure2 != null ? HmppCliModuleKt.getModuleNameForSource(hmppCliModuleStructure2, path) : null);
            if (!file2.isDirectory()) continue;
            JvmContentRootsKt.addJavaSourceRoot($this$configureSourceRootsFromSources, file2, javaPackagePrefix);
        }
    }
}

