/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J-\u0010\n\u001a\u00020\u00072\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000e2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lkotlin/Comparator;", "<init>", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)I", "compare", "a", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "b", "", "([Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)I", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "tree"})
public final class ConeKotlinTypeComparator
implements Comparator<ConeKotlinType> {
    @NotNull
    public static final ConeKotlinTypeComparator INSTANCE = new ConeKotlinTypeComparator();

    private ConeKotlinTypeComparator() {
    }

    private final int getPriority(ConeKotlinType $this$priority) {
        ConeKotlinType coneKotlinType = $this$priority;
        return coneKotlinType instanceof ConeErrorType ? 9 : (coneKotlinType instanceof ConeLookupTagBasedType ? 8 : (coneKotlinType instanceof ConeFlexibleType ? 7 : (coneKotlinType instanceof ConeCapturedType ? 6 : (coneKotlinType instanceof ConeDefinitelyNotNullType ? 5 : (coneKotlinType instanceof ConeIntersectionType ? 4 : (coneKotlinType instanceof ConeStubType ? 3 : (coneKotlinType instanceof ConeIntegerLiteralConstantType ? 2 : (coneKotlinType instanceof ConeIntegerConstantOperatorType ? 1 : 0))))))));
    }

    @Override
    private final int compare(ConeTypeProjection a2, ConeTypeProjection b2) {
        boolean bl;
        int kindDiff = a2.getKind().ordinal() - b2.getKind().ordinal();
        if (kindDiff != 0) {
            return kindDiff;
        }
        ConeTypeProjection coneTypeProjection = a2;
        if (coneTypeProjection instanceof ConeStarProjection) {
            return 0;
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            if (!(b2 instanceof ConeKotlinTypeProjectionIn)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$32 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$32 = "ordinal is inconsistent: " + a2 + " v.s. " + b2;
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$32.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionIn)a2).getType(), ((ConeKotlinTypeProjectionIn)b2).getType());
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            if (!(b2 instanceof ConeKotlinTypeProjectionOut)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$42 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$42 = "ordinal is inconsistent: " + a2 + " v.s. " + b2;
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$42.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionOut)a2).getType(), ((ConeKotlinTypeProjectionOut)b2).getType());
        }
        boolean bl2 = bl = a2 instanceof ConeKotlinType && b2 instanceof ConeKotlinType;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expect INVARIANT: " + a2 + " v.s. " + b2;
            throw new AssertionError((Object)string2);
        }
        Intrinsics.checkNotNull(a2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        ConeKotlinType coneKotlinType = (ConeKotlinType)a2;
        Intrinsics.checkNotNull(b2, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
        return this.compare(coneKotlinType, (ConeKotlinType)b2);
    }

    @Override
    private final int compare(ConeTypeProjection[] a2, ConeTypeProjection[] b2) {
        int sizeDiff = a2.length - b2.length;
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        for (Pair<ConeTypeProjection, ConeTypeProjection> pair : ArraysKt.zip(a2, b2)) {
            ConeTypeProjection bTypeProjection;
            ConeTypeProjection aTypeProjection = pair.component1();
            int typeProjectionDiff = this.compare(aTypeProjection, bTypeProjection = pair.component2());
            if (typeProjectionDiff == 0) continue;
            return typeProjectionDiff;
        }
        return 0;
    }

    @Override
    private final int compare(ConeNullability a2, ConeNullability b2) {
        return a2.ordinal() - b2.ordinal();
    }

    @Override
    public int compare(@NotNull ConeKotlinType a2, @NotNull ConeKotlinType b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        int priorityDiff = this.getPriority(a2) - this.getPriority(b2);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        ConeKotlinType coneKotlinType = a2;
        if (coneKotlinType instanceof ConeErrorType) {
            if (!(b2 instanceof ConeErrorType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$122 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$122 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$122.toString());
            }
            return ((ConeErrorType)a2).hashCode() - ((ConeErrorType)b2).hashCode();
        }
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            if (!(b2 instanceof ConeLookupTagBasedType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$132 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$132 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$132.toString());
            }
            int nameDiff = ((ConeLookupTagBasedType)a2).getLookupTag().getName().compareTo(((ConeLookupTagBasedType)b2).getLookupTag().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            int nullabilityDiff = this.compare(a2.getNullability(), b2.getNullability());
            if (nullabilityDiff != 0) {
                return nullabilityDiff;
            }
            return this.compare(a2.getTypeArguments(), b2.getTypeArguments());
        }
        if (coneKotlinType instanceof ConeFlexibleType) {
            if (!(b2 instanceof ConeFlexibleType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$142 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$142 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$142.toString());
            }
            int lowerBoundDiff = this.compare(((ConeFlexibleType)a2).getLowerBound(), ((ConeFlexibleType)b2).getLowerBound());
            if (lowerBoundDiff != 0) {
                return lowerBoundDiff;
            }
            return this.compare(((ConeFlexibleType)a2).getUpperBound(), ((ConeFlexibleType)b2).getUpperBound());
        }
        if (coneKotlinType instanceof ConeCapturedType) {
            int nullabilityDiff;
            int bHasLowerType;
            if (!(b2 instanceof ConeCapturedType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$152 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$152 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$152.toString());
            }
            int aHasLowerType = ((ConeCapturedType)a2).getLowerType() != null ? 1 : 0;
            int hasLowerTypeDiff = aHasLowerType - (bHasLowerType = ((ConeCapturedType)b2).getLowerType() != null ? 1 : 0);
            if (hasLowerTypeDiff != 0) {
                return hasLowerTypeDiff;
            }
            if (((ConeCapturedType)a2).getLowerType() != null && ((ConeCapturedType)b2).getLowerType() != null) {
                ConeKotlinType coneKotlinType2 = ((ConeCapturedType)a2).getLowerType();
                Intrinsics.checkNotNull(coneKotlinType2);
                ConeKotlinType coneKotlinType3 = ((ConeCapturedType)b2).getLowerType();
                Intrinsics.checkNotNull(coneKotlinType3);
                int lowerTypeDiff = this.compare(coneKotlinType2, coneKotlinType3);
                if (lowerTypeDiff != 0) {
                    return lowerTypeDiff;
                }
            }
            if ((nullabilityDiff = this.compare(((ConeCapturedType)a2).getNullability(), ((ConeCapturedType)b2).getNullability())) != 0) {
                return nullabilityDiff;
            }
            return ((ConeCapturedType)a2).getConstructor().hashCode() - ((ConeCapturedType)b2).getConstructor().hashCode();
        }
        if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            if (!(b2 instanceof ConeDefinitelyNotNullType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$162 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$162 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$162.toString());
            }
            return this.compare(((ConeDefinitelyNotNullType)a2).getOriginal(), ((ConeDefinitelyNotNullType)b2).getOriginal());
        }
        if (coneKotlinType instanceof ConeIntersectionType) {
            if (!(b2 instanceof ConeIntersectionType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$172 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$172 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$172.toString());
            }
            int sizeDiff = ((ConeIntersectionType)a2).getIntersectedTypes().size() - ((ConeIntersectionType)b2).getIntersectedTypes().size();
            if (sizeDiff != 0) {
                return sizeDiff;
            }
            return ((ConeIntersectionType)a2).hashCode() - ((ConeIntersectionType)b2).hashCode();
        }
        if (coneKotlinType instanceof ConeStubType) {
            if (!(b2 instanceof ConeStubType)) {
                boolean $i$a$-require-ConeKotlinTypeComparator$compare$182 = false;
                String $i$a$-require-ConeKotlinTypeComparator$compare$182 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException($i$a$-require-ConeKotlinTypeComparator$compare$182.toString());
            }
            int nameDiff = ((ConeStubType)a2).getConstructor().getVariable().getTypeConstructor().getName().compareTo(((ConeStubType)b2).getConstructor().getVariable().getTypeConstructor().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            return this.compare(((ConeStubType)a2).getNullability(), ((ConeStubType)b2).getNullability());
        }
        if (coneKotlinType instanceof ConeIntegerLiteralConstantType) {
            if (!(b2 instanceof ConeIntegerLiteralConstantType)) {
                boolean bl = false;
                String string2 = "priority is inconsistent: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2);
                throw new IllegalArgumentException(string2.toString());
            }
            long valueDiff = ((ConeIntegerLiteralConstantType)a2).getValue() - ((ConeIntegerLiteralConstantType)b2).getValue();
            if (valueDiff != 0L) {
                return (int)valueDiff;
            }
            int nullabilityDiff = this.compare(((ConeIntegerLiteralConstantType)a2).getNullability(), ((ConeIntegerLiteralConstantType)b2).getNullability());
            if (nullabilityDiff != 0) {
                return nullabilityDiff;
            }
            return ((ConeIntegerLiteralConstantType)a2).hashCode() - ((ConeIntegerLiteralConstantType)b2).hashCode();
        }
        if (coneKotlinType instanceof ConeIntegerConstantOperatorType) {
            return this.compare(((ConeIntegerConstantOperatorType)a2).getNullability(), b2.getNullability());
        }
        throw new IllegalStateException(("Unsupported type comparison: " + ConeTypeUtilsKt.renderForDebugging(a2) + " v.s. " + ConeTypeUtilsKt.renderForDebugging(b2)).toString());
    }
}

