/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeFlexibleTypeBoundsChecker;", "", "<init>", "()V", "areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability", "", "a", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "b", "getBaseBoundFqNameByMutability", "Lorg/jetbrains/kotlin/name/ClassId;", "providers"})
public final class ConeFlexibleTypeBoundsChecker {
    @NotNull
    public static final ConeFlexibleTypeBoundsChecker INSTANCE = new ConeFlexibleTypeBoundsChecker();

    private ConeFlexibleTypeBoundsChecker() {
    }

    public final boolean areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(@NotNull ConeKotlinType a2, @NotNull ConeKotlinType b2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        Intrinsics.checkNotNullParameter(b2, "b");
        ClassId classId = ConeTypeUtilsKt.getClassId(a2);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        ClassId classId3 = StandardClassIds.Collections.INSTANCE.getBaseCollectionToMutableEquivalent().get(classId2);
        if (classId3 == null && (classId3 = StandardClassIds.Collections.INSTANCE.getMutableCollectionToBaseCollection().get(classId2)) == null) {
            return false;
        }
        ClassId possiblePairBound = classId3;
        return Intrinsics.areEqual(possiblePairBound, ConeTypeUtilsKt.getClassId(b2));
    }

    @Nullable
    public final ClassId getBaseBoundFqNameByMutability(@NotNull ConeKotlinType a2) {
        Intrinsics.checkNotNullParameter(a2, "a");
        ClassId classId = ConeTypeUtilsKt.getClassId(a2);
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        if (StandardClassIds.Collections.INSTANCE.getBaseCollectionToMutableEquivalent().containsKey(classId2)) {
            return classId2;
        }
        return StandardClassIds.Collections.INSTANCE.getMutableCollectionToBaseCollection().get(classId2);
    }
}

