/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.mpp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirExpectActualMatchingContext;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.ExpectActualAttributesKt;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.mpp.ClassLikeSymbolMarker;
import org.jetbrains.kotlin.mpp.RegularClassSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.mpp.AbstractExpectActualMatcher;
import org.jetbrains.kotlin.resolve.multiplatform.ExpectActualMatchingCompatibility;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00070\u0005j\u0002`\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver;", "", "<init>", "()V", "findExpectForActual", "", "Lorg/jetbrains/kotlin/resolve/multiplatform/ExpectActualMatchingCompatibility;", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/ExpectForActualMatchingData;", "actualSymbol", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "context", "Lorg/jetbrains/kotlin/fir/FirExpectActualMatchingContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirExpectActualResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectActualResolver.kt\norg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,100:1\n774#2:101\n865#2,2:102\n1485#2:104\n1510#2,3:105\n1513#2,3:115\n381#3,7:108\n48#4:118\n*S KotlinDebug\n*F\n+ 1 FirExpectActualResolver.kt\norg/jetbrains/kotlin/fir/resolve/transformers/mpp/FirExpectActualResolver\n*L\n63#1:101\n63#1:102,2\n67#1:104\n67#1:105,3\n67#1:115,3\n67#1:108,7\n87#1:118\n*E\n"})
public final class FirExpectActualResolver {
    @NotNull
    public static final FirExpectActualResolver INSTANCE = new FirExpectActualResolver();

    private FirExpectActualResolver() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> findExpectForActual(@NotNull FirBasedSymbol<?> actualSymbol, @NotNull FirSession useSiteSession, @NotNull FirExpectActualMatchingContext context) {
        Object object;
        FirClassLikeSymbol<?> actualContainingClass;
        Intrinsics.checkNotNullParameter(actualSymbol, "actualSymbol");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(context, "context");
        FirExpectActualMatchingContext $this$findExpectForActual_u24lambda_u246 = context;
        boolean bl = false;
        FirBasedSymbol<?> firBasedSymbol = actualSymbol;
        if (firBasedSymbol instanceof FirCallableSymbol) {
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            void $this$filterTo$iv$iv;
            Collection collection;
            Object object2;
            CallableId callableId = ((FirCallableSymbol)actualSymbol).getCallableId();
            ClassId classId = callableId.getClassId();
            actualContainingClass = null;
            FirRegularClassSymbol expectContainingClass = null;
            if (callableId.isLocal()) {
                return MapsKt.emptyMap();
            }
            if (classId != null) {
                Collection collection2;
                List<FirBasedSymbol<?>> list;
                Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> map2;
                FirRegularClass firRegularClass;
                FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(useSiteSession).getClassLikeSymbolByClassId(classId);
                actualContainingClass = firClassLikeSymbol != null ? DeclarationUtilsKt.fullyExpandedClass(firClassLikeSymbol, useSiteSession) : null;
                object2 = actualContainingClass;
                firClassLikeSymbol = object2 != null && (firRegularClass = (FirRegularClass)((FirBasedSymbol)object2).getFir()) != null && (map2 = ExpectActualAttributesKt.getExpectForActual(firRegularClass)) != null && (list = map2.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE)) != null ? CollectionsKt.singleOrNull(list) : null;
                FirRegularClassSymbol firRegularClassSymbol = expectContainingClass = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
                if ((FirCallableSymbol)actualSymbol instanceof FirConstructorSymbol) {
                    FirRegularClassSymbol firRegularClassSymbol2 = expectContainingClass;
                    collection2 = firRegularClassSymbol2 != null ? FirExpectActualMatchingContext.getConstructors$default($this$findExpectForActual_u24lambda_u246, firRegularClassSymbol2, $this$findExpectForActual_u24lambda_u246.getExpectScopeSession(), null, 2, null) : null;
                } else {
                    FirRegularClassSymbol firRegularClassSymbol3 = expectContainingClass;
                    collection2 = collection = (Collection)(firRegularClassSymbol3 != null ? $this$findExpectForActual_u24lambda_u246.getMembersForExpectClass(firRegularClassSymbol3, ((FirCallableSymbol)actualSymbol).getName()) : null);
                }
                if (collection2 == null) {
                    collection = CollectionsKt.emptyList();
                }
            } else {
                FirPackageMemberScope scope2 = new FirPackageMemberScope(callableId.getPackageName(), useSiteSession, FirSymbolProviderKt.getDependenciesSymbolProvider(useSiteSession), null, 8, null);
                Object $this$findExpectForActual_u24lambda_u246_u24lambda_u242 = object2 = (List)new ArrayList();
                boolean bl2 = false;
                scope2.processFunctionsByName(callableId.getCallableName(), arg_0 -> FirExpectActualResolver.findExpectForActual$lambda$6$lambda$2$lambda$0((List)$this$findExpectForActual_u24lambda_u246_u24lambda_u242, arg_0));
                scope2.processPropertiesByName(callableId.getCallableName(), arg_0 -> FirExpectActualResolver.findExpectForActual$lambda$6$lambda$2$lambda$1((List)$this$findExpectForActual_u24lambda_u246_u24lambda_u242, arg_0));
                collection = (Collection)object2;
            }
            Collection candidates = collection;
            List<FirModuleData> transitiveDependsOn = ((FirCallableSymbol)actualSymbol).getModuleData().getAllDependsOnDependencies();
            Iterable $this$filter$iv = candidates;
            boolean $i$f$filter = false;
            Iterable bl2 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirCallableSymbol expectSymbol = (FirCallableSymbol)element$iv$iv;
                boolean bl3 = false;
                if (!(!Intrinsics.areEqual(actualSymbol, expectSymbol) && (expectContainingClass != null && !Intrinsics.areEqual($this$findExpectForActual_u24lambda_u246.getVisibility(expectSymbol), Visibilities.Private.INSTANCE) || $this$findExpectForActual_u24lambda_u246.isExpect(expectSymbol) && transitiveDependsOn.contains(expectSymbol.getModuleData())))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$filterTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object3;
                FirCallableSymbol expectDeclaration = (FirCallableSymbol)element$iv$iv;
                boolean bl4 = false;
                ExpectActualMatchingCompatibility key$iv$iv = AbstractExpectActualMatcher.INSTANCE.getCallablesMatchingCompatibility(expectDeclaration, (CallableSymbolMarker)((Object)actualSymbol), expectContainingClass, (RegularClassSymbolMarker)((Object)actualContainingClass), context);
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object3 = answer$iv$iv$iv;
                } else {
                    object3 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object3;
                list$iv$iv.add(element$iv$iv);
            }
            Object it = destination$iv$iv;
            boolean bl6 = false;
            List compatibleSymbols = (List)it.get(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE);
            object = compatibleSymbols == null ? it : MapsKt.mapOf(TuplesKt.to(ExpectActualMatchingCompatibility.MatchedSuccessfully.INSTANCE, compatibleSymbols));
        } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
            actualContainingClass = FirSymbolProviderKt.getDependenciesSymbolProvider(useSiteSession).getClassLikeSymbolByClassId(((FirClassLikeSymbol)actualSymbol).getClassId());
            FirRegularClassSymbol firRegularClassSymbol = actualContainingClass instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)actualContainingClass : null;
            if (firRegularClassSymbol == null) {
                return MapsKt.emptyMap();
            }
            FirRegularClassSymbol expectClassSymbol = firRegularClassSymbol;
            List<FirModuleData> transitiveDependsOn = ((FirClassLikeSymbol)actualSymbol).getModuleData().getAllDependsOnDependencies();
            FirClassLikeSymbol $this$isExpect$iv = expectClassSymbol;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getRawStatus().isExpect() && transitiveDependsOn.contains(expectClassSymbol.getModuleData())) {
                ExpectActualMatchingCompatibility compatibility = AbstractExpectActualMatcher.INSTANCE.matchClassifiers(expectClassSymbol, (ClassLikeSymbolMarker)((Object)actualSymbol), context);
                object = MapsKt.mapOf(TuplesKt.to(compatibility, CollectionsKt.listOf(expectClassSymbol)));
            } else {
                object = MapsKt.emptyMap();
            }
        } else {
            object = MapsKt.emptyMap();
        }
        Map<ExpectActualMatchingCompatibility, List<FirBasedSymbol<?>>> result2 = object;
        return result2;
    }

    private static final Unit findExpectForActual$lambda$6$lambda$2$lambda$0(List $this_apply, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $this_apply.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit findExpectForActual$lambda$6$lambda$2$lambda$1(List $this_apply, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $this_apply.add(it);
        return Unit.INSTANCE;
    }
}

