/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.lightTree.converter;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirCallBuilder;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtPsiUtil;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u0004\u0018\u00010\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0002*\u00020\u0005\u001a'\u0010\u0006\u001a\u0002H\u0007\"\b\b\u0000\u0010\u0007*\u00020\b*\u0002H\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\f\u001a/\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0019\u0010\u0010\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0011\u00a2\u0006\u0002\b\u0012H\u0086\b\u00f8\u0001\u0000\"\u0015\u0010\u0013\u001a\u00020\u000e*\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0016"}, d2={"nameAsSafeName", "Lorg/jetbrains/kotlin/name/Name;", "", "defaultName", "getAsStringWithoutBacktick", "Lorg/jetbrains/kotlin/com/intellij/lang/LighterASTNode;", "extractArgumentsFrom", "T", "Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "container", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;Ljava/util/List;)Lorg/jetbrains/kotlin/fir/expressions/builder/FirCallBuilder;", "isClassLocal", "", "classNode", "getParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "isUnderscored", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "(Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;)Z", "light-tree2fir"})
@SourceDebugExtension(value={"SMAP\nConverterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterUtil.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ConverterUtilKt\n+ 2 FirArgumentListBuilder.kt\norg/jetbrains/kotlin/fir/expressions/builder/FirArgumentListBuilderKt\n*L\n1#1,64:1\n36#2:65\n*S KotlinDebug\n*F\n+ 1 ConverterUtil.kt\norg/jetbrains/kotlin/fir/lightTree/converter/ConverterUtilKt\n*L\n31#1:65\n*E\n"})
public final class ConverterUtilKt {
    @NotNull
    public static final Name nameAsSafeName(@Nullable String $this$nameAsSafeName, @NotNull String defaultName) {
        Name name2;
        Intrinsics.checkNotNullParameter(defaultName, "defaultName");
        String string2 = $this$nameAsSafeName;
        if (string2 != null) {
            Name name3 = Name.identifier(KtPsiUtil.unquoteIdentifier(string2));
            name2 = name3;
            Intrinsics.checkNotNullExpressionValue(name3, "identifier(...)");
        } else if (((CharSequence)defaultName).length() > 0) {
            Name name4 = Name.identifier(defaultName);
            name2 = name4;
            Intrinsics.checkNotNullExpressionValue(name4, "identifier(...)");
        } else {
            name2 = SpecialNames.NO_NAME_PROVIDED;
        }
        return name2;
    }

    public static /* synthetic */ Name nameAsSafeName$default(String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string3 = "";
        }
        return ConverterUtilKt.nameAsSafeName(string2, string3);
    }

    @NotNull
    public static final String getAsStringWithoutBacktick(@NotNull LighterASTNode $this$getAsStringWithoutBacktick) {
        Intrinsics.checkNotNullParameter($this$getAsStringWithoutBacktick, "<this>");
        return StringsKt.replace$default($this$getAsStringWithoutBacktick.toString(), "`", "", false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T extends FirCallBuilder> T extractArgumentsFrom(@NotNull T $this$extractArgumentsFrom, @NotNull List<? extends FirExpression> container) {
        void $this$extractArgumentsFrom_u24lambda_u240;
        FirArgumentListBuilder firArgumentListBuilder;
        Intrinsics.checkNotNullParameter($this$extractArgumentsFrom, "<this>");
        Intrinsics.checkNotNullParameter(container, "container");
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        T t = $this$extractArgumentsFrom;
        boolean bl = false;
        CollectionsKt.addAll((Collection)$this$extractArgumentsFrom_u24lambda_u240.getArguments(), (Iterable)container);
        t.setArgumentList(firArgumentListBuilder.build());
        return $this$extractArgumentsFrom;
    }

    public static final boolean isClassLocal(@NotNull LighterASTNode classNode, @NotNull Function1<? super LighterASTNode, ? extends LighterASTNode> getParent) {
        Intrinsics.checkNotNullParameter(classNode, "classNode");
        Intrinsics.checkNotNullParameter(getParent, "getParent");
        boolean $i$f$isClassLocal = false;
        LighterASTNode currentNode = classNode;
        while (currentNode != null) {
            IElementType parentTokenType;
            LighterASTNode parent2;
            IElementType tokenType = currentNode.getTokenType();
            LighterASTNode lighterASTNode = parent2 = getParent.invoke(currentNode);
            IElementType iElementType = parentTokenType = lighterASTNode != null ? lighterASTNode.getTokenType() : null;
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.PROPERTY) || Intrinsics.areEqual(tokenType, KtNodeTypes.FUN)) {
                LighterASTNode lighterASTNode2 = parent2;
                LighterASTNode grandParent = lighterASTNode2 != null ? getParent.invoke(lighterASTNode2) : null;
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.KT_FILE)) {
                    return true;
                }
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.CLASS_BODY)) {
                    LighterASTNode lighterASTNode3;
                    LighterASTNode lighterASTNode4 = grandParent;
                    if (!Intrinsics.areEqual(lighterASTNode4 != null ? lighterASTNode4.getTokenType() : null, KtNodeTypes.OBJECT_DECLARATION) || !Intrinsics.areEqual((lighterASTNode3 = grandParent) != null && (lighterASTNode3 = getParent.invoke(lighterASTNode3)) != null ? lighterASTNode3.getTokenType() : null, KtNodeTypes.OBJECT_LITERAL)) {
                        return true;
                    }
                }
                if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.BLOCK)) {
                    LighterASTNode lighterASTNode5 = grandParent;
                    if (Intrinsics.areEqual(lighterASTNode5 != null ? lighterASTNode5.getTokenType() : null, KtNodeTypes.SCRIPT)) {
                        return true;
                    }
                }
            }
            if (Intrinsics.areEqual(parentTokenType, KtNodeTypes.ENUM_ENTRY)) {
                return true;
            }
            if (Intrinsics.areEqual(tokenType, KtNodeTypes.BLOCK)) {
                return true;
            }
            currentNode = parent2;
        }
        return false;
    }

    public static final boolean isUnderscored(@NotNull FirUserTypeRef $this$isUnderscored) {
        Intrinsics.checkNotNullParameter($this$isUnderscored, "<this>");
        Object object = CollectionsKt.lastOrNull($this$isUnderscored.getQualifier());
        return Intrinsics.areEqual(object != null && (object = object.getName()) != null ? ((Name)object).asString() : null, "_");
    }
}

