/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirDataClassCopyUsageWillBecomeInaccessibleCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeStubTypeForTypeVariableInSubtyping;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.types.EnrichedProjectionKind;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\f\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPrivateToThisAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isPrivateToThis", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "containingClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "contradictsWith", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "requiredVariance", "Lorg/jetbrains/kotlin/types/Variance;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPrivateToThisAccessChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPrivateToThisAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPrivateToThisAccessChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 4 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n18#2:153\n161#3:154\n118#3,4:155\n99#3:159\n87#3:160\n93#3:162\n122#3,2:163\n39#4:161\n1734#5,3:165\n1755#5,3:168\n*S KotlinDebug\n*F\n+ 1 FirPrivateToThisAccessChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirPrivateToThisAccessChecker\n*L\n45#1:153\n49#1:154\n49#1:155,4\n49#1:159\n49#1:160\n49#1:162\n49#1:163,2\n49#1:161\n75#1:165,3\n137#1:168,3\n*E\n"})
public final class FirPrivateToThisAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirPrivateToThisAccessChecker INSTANCE = new FirPrivateToThisAccessChecker();

    private FirPrivateToThisAccessChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        v0 = FirReferenceUtilsKt.getResolved(expression.getCalleeReference());
        if (v0 == null) {
            return;
        }
        reference = v0;
        if (reference instanceof FirResolvedErrorReference && ((FirResolvedErrorReference)reference).getDiagnostic() instanceof ConeVisibilityError) {
            return;
        }
        v1 = expression.getDispatchReceiver();
        if (v1 == null) {
            return;
        }
        dispatchReceiver = v1;
        v2 = FirReferenceUtilsKt.toResolvedCallableSymbol(reference, true);
        if (v2 == null) {
            return;
        }
        $this$visibility$iv = symbol = v2;
        $i$f$getVisibility = false;
        if (!Intrinsics.areEqual($this$visibility$iv.getResolvedStatus().getVisibility(), Visibilities.Private.INSTANCE)) {
            return;
        }
        session = context.getSession();
        v3 = ClassMembersKt.containingClassLookupTag(symbol);
        containingClassSymbol = v3 != null ? LookupTagUtilsKt.toClassSymbol(v3, session) : null;
        var9_10 = symbol;
        var21_12 = this;
        $i$f$unwrapFakeOverrides = false;
        $this$unwrapFakeOverrides$iv$iv = (FirCallableDeclaration)$this$unwrapFakeOverrides$iv.getFir();
        $i$f$unwrapFakeOverrides = false;
        current$iv$iv = $this$unwrapFakeOverrides$iv$iv;
        while (true) {
            $this$originalIfFakeOverride$iv$iv$iv = current$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v4 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v4 = v5 = null;
            }
            if (v4 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getBaseForIntersectionOverride = false;
                v5 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v5 == null) break;
            current$iv$iv = next$iv$iv = v5;
        }
        v6 = current$iv$iv.getSymbol();
        if (v6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
        }
        if (!var21_12.isPrivateToThis(v6, containingClassSymbol, session)) {
            return;
        }
        receiverReference = ReferenceUtilsKt.toReference(dispatchReceiver, session);
        v7 = receiverReference instanceof FirThisReference ? !Intrinsics.areEqual(((FirThisReference)receiverReference).getBoundSymbol(), containingClassSymbol) : (invisible = true);
        if (invisible) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression.getSource(), FirErrors.INSTANCE.getINVISIBLE_REFERENCE(), symbol, (Object)Visibilities.PrivateToThis.INSTANCE, (Object)symbol.getCallableId().getClassId(), (DiagnosticContext)context, null, 64, null);
        }
    }

    private final boolean isPrivateToThis(FirCallableSymbol<?> symbol, FirClassSymbol<?> containingClassSymbol, FirSession session2) {
        boolean bl;
        block11: {
            if (containingClassSymbol == null) {
                return false;
            }
            if (symbol instanceof FirConstructorSymbol) {
                return false;
            }
            Iterable $this$all$iv = containingClassSymbol.getTypeParameterSymbols();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (it.getVariance() == Variance.INVARIANT) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        if (bl) {
            return false;
        }
        if (FirDataClassCopyUsageWillBecomeInaccessibleCheckerKt.isDataClassCopy(symbol, containingClassSymbol, session2)) {
            return false;
        }
        Object object = symbol.getReceiverParameter();
        boolean bl3 = object != null && (object = ((FirReceiverParameter)object).getTypeRef()) != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? this.contradictsWith((ConeKotlinType)object, Variance.IN_VARIANCE, session2) : false;
        if (bl3) {
            return true;
        }
        if (this.contradictsWith(symbol.getResolvedReturnType(), symbol instanceof FirPropertySymbol && ((FirPropertySymbol)symbol).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE, session2)) {
            return true;
        }
        if (symbol instanceof FirFunctionSymbol) {
            for (FirValueParameterSymbol parameter : ((FirFunctionSymbol)symbol).getValueParameterSymbols()) {
                if (!this.contradictsWith(parameter.getResolvedReturnType(), Variance.IN_VARIANCE, session2)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean contradictsWith(ConeKotlinType $this$contradictsWith, Variance requiredVariance, FirSession session2) {
        ConeKotlinType coneKotlinType = $this$contradictsWith;
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            if ($this$contradictsWith instanceof ConeTypeParameterType) {
                return !((ConeTypeParameterType)$this$contradictsWith).getLookupTag().getTypeParameterSymbol().getVariance().allowsPosition(requiredVariance);
            }
            if ($this$contradictsWith instanceof ConeClassLikeType) {
                FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)$this$contradictsWith).getLookupTag(), session2);
                if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) {
                    return false;
                }
                FirClassLikeSymbol<?> classLike = firClassLikeSymbol;
                ConeTypeProjection[] coneTypeProjectionArray = $this$contradictsWith.getTypeArguments();
                int n = coneTypeProjectionArray.length;
                block6: for (int j = 0; j < n; ++j) {
                    ConeKotlinType argType;
                    Variance variance;
                    int index = j;
                    ConeTypeProjection argument = coneTypeProjectionArray[j];
                    FirTypeParameterRef typeParameterRef = CollectionsKt.getOrNull(((FirClassLikeDeclaration)((Object)classLike)).getTypeParameters(), index);
                    if (!(typeParameterRef instanceof FirTypeParameter)) continue;
                    switch (WhenMappings.$EnumSwitchMapping$0[EnrichedProjectionKind.Companion.getEffectiveProjectionKind(((FirTypeParameter)typeParameterRef).getVariance(), ConeTypeProjectionKt.getVariance(argument)).ordinal()]) {
                        case 1: {
                            variance = requiredVariance;
                            break;
                        }
                        case 2: {
                            variance = requiredVariance.opposite();
                            break;
                        }
                        case 3: {
                            variance = Variance.INVARIANT;
                            break;
                        }
                        case 4: {
                            continue block6;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    Variance requiredVarianceForArgument = variance;
                    if (ConeTypeProjectionKt.getType(argument) == null || !this.contradictsWith(argType, requiredVarianceForArgument, session2)) continue;
                    return true;
                }
            }
        } else {
            if (coneKotlinType instanceof ConeFlexibleType) {
                return this.contradictsWith(((ConeFlexibleType)$this$contradictsWith).getLowerBound(), requiredVariance, session2);
            }
            if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                return this.contradictsWith(((ConeDefinitelyNotNullType)$this$contradictsWith).getOriginal(), requiredVariance, session2);
            }
            if (coneKotlinType instanceof ConeIntersectionType) {
                boolean bl;
                block20: {
                    Iterable $this$any$iv = ((ConeIntersectionType)$this$contradictsWith).getIntersectedTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ConeKotlinType it = (ConeKotlinType)element$iv;
                            boolean bl2 = false;
                            if (!INSTANCE.contradictsWith(it, requiredVariance, session2)) continue;
                            bl = true;
                            break block20;
                        }
                        bl = false;
                    }
                }
                return bl;
            }
            if (coneKotlinType instanceof ConeCapturedType) {
                return false;
            }
            if (coneKotlinType instanceof ConeIntegerConstantOperatorType || coneKotlinType instanceof ConeIntegerLiteralConstantType || coneKotlinType instanceof ConeStubTypeForTypeVariableInSubtyping || coneKotlinType instanceof ConeTypeVariableType) {
                return false;
            }
            throw new NoWhenBranchMatchedException();
        }
        return false;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

