/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001:\u0001\u0015J \u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J&\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy;", "", "forEachClassLikeType", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "action", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "considerType", "type", "missingTypes", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reportMissingTypes", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "missingTypeOrigin", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "MissingTypeOrigin", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirMissingDependencyClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n1863#2,2:165\n*S KotlinDebug\n*F\n+ 1 FirMissingDependencyClassChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy\n*L\n91#1:165,2\n*E\n"})
public interface FirMissingDependencyClassProxy {
    default public void forEachClassLikeType(@NotNull ConeKotlinType $this$forEachClassLikeType, @NotNull Function1<? super ConeClassLikeType, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachClassLikeType, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        ConeKotlinType coneKotlinType = $this$forEachClassLikeType;
        if (coneKotlinType instanceof ConeFlexibleType) {
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getLowerBound(), action);
            this.forEachClassLikeType(((ConeFlexibleType)$this$forEachClassLikeType).getUpperBound(), action);
        } else if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            this.forEachClassLikeType(((ConeDefinitelyNotNullType)$this$forEachClassLikeType).getOriginal(), action);
        } else if (coneKotlinType instanceof ConeIntersectionType) {
            Iterable $this$forEach$iv = ((ConeIntersectionType)$this$forEachClassLikeType).getIntersectedTypes();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                this.forEachClassLikeType(it, action);
            }
        } else if (coneKotlinType instanceof ConeClassLikeType) {
            action.invoke((ConeClassLikeType)$this$forEachClassLikeType);
        }
    }

    default public void considerType(@NotNull ConeKotlinType type2, @NotNull Set<ConeKotlinType> missingTypes, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(missingTypes, "missingTypes");
        Intrinsics.checkNotNullParameter(context, "context");
        Ref.BooleanRef hasError = new Ref.BooleanRef();
        Ref.BooleanRef hasMissingClass = new Ref.BooleanRef();
        this.forEachClassLikeType(type2, arg_0 -> FirMissingDependencyClassProxy.considerType$lambda$1(hasError, this, missingTypes, context, hasMissingClass, arg_0));
        if (hasMissingClass.element && !hasError.element) {
            ConeKotlinType reportedType = TypeUtilsKt.withNullability$default(type2, ConeNullability.NOT_NULL, TypeComponentsKt.getTypeContext(context.getSession()), null, false, 12, null);
            missingTypes.add(reportedType);
        }
    }

    default public void reportMissingTypes(@Nullable KtSourceElement source2, @NotNull Set<ConeKotlinType> missingTypes, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull MissingTypeOrigin missingTypeOrigin) {
        Intrinsics.checkNotNullParameter(missingTypes, "missingTypes");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(missingTypeOrigin, "missingTypeOrigin");
        Set reported = new LinkedHashSet();
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context.getSession());
        for (ConeKotlinType missingType : missingTypes) {
            ConeKotlinType withoutArguments = TypeUtilsKt.withArguments(missingType, new ConeTypeProjection[0]);
            if (reported.contains(withoutArguments)) continue;
            if (missingTypeOrigin instanceof MissingTypeOrigin.LambdaParameter && missingType.getTypeArguments().length == 0 && !languageVersionSettings.supportsFeature(LanguageFeature.ForbidLambdaParameterWithMissingDependencyType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_LAMBDA_PARAMETER(), (Object)withoutArguments, (Object)((MissingTypeOrigin.LambdaParameter)missingTypeOrigin).getName(), (DiagnosticContext)context, null, 32, null);
            } else if (missingTypeOrigin instanceof MissingTypeOrigin.LambdaReceiver && missingType.getTypeArguments().length == 0 && !languageVersionSettings.supportsFeature(LanguageFeature.ForbidLambdaParameterWithMissingDependencyType)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_LAMBDA_RECEIVER(), (Object)withoutArguments, (DiagnosticContext)context, null, 16, null);
            } else if (missingTypeOrigin instanceof MissingTypeOrigin.Expression && !languageVersionSettings.supportsFeature(LanguageFeature.ForbidUsingExpressionTypesWithInaccessibleContent)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS_IN_EXPRESSION_TYPE(), (Object)withoutArguments, (DiagnosticContext)context, null, 16, null);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getMISSING_DEPENDENCY_CLASS(), (Object)withoutArguments, (DiagnosticContext)context, null, 16, null);
            }
            ((Collection)reported).add(withoutArguments);
        }
    }

    private static Unit considerType$lambda$1(Ref.BooleanRef $hasError, FirMissingDependencyClassProxy this$0, Set $missingTypes, CheckerContext $context, Ref.BooleanRef $hasMissingClass, ConeClassLikeType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it instanceof ConeErrorType) {
            ConeKotlinType delegatedType = ((ConeErrorType)it).getDelegatedType();
            if (delegatedType == null) {
                $hasError.element = true;
            } else {
                this$0.considerType(delegatedType, $missingTypes, $context);
            }
        } else {
            $hasMissingClass.element = $hasMissingClass.element || LookupTagUtilsKt.toSymbol(it.getLookupTag(), $context.getSession()) == null;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0004\u0005\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0004\b\t\n\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "", "<init>", "()V", "LambdaParameter", "LambdaReceiver", "Expression", "Other", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$Expression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$LambdaParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$LambdaReceiver;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$Other;", "checkers"})
    public static abstract class MissingTypeOrigin {
        private MissingTypeOrigin() {
        }

        public /* synthetic */ MissingTypeOrigin(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$Expression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "<init>", "()V", "checkers"})
        public static final class Expression
        extends MissingTypeOrigin {
            @NotNull
            public static final Expression INSTANCE = new Expression();

            private Expression() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$LambdaParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/name/Name;)V", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "checkers"})
        public static final class LambdaParameter
        extends MissingTypeOrigin {
            @NotNull
            private final Name name;

            public LambdaParameter(@NotNull Name name2) {
                Intrinsics.checkNotNullParameter(name2, "name");
                super(null);
                this.name = name2;
            }

            @NotNull
            public final Name getName() {
                return this.name;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$LambdaReceiver;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "<init>", "()V", "checkers"})
        public static final class LambdaReceiver
        extends MissingTypeOrigin {
            @NotNull
            public static final LambdaReceiver INSTANCE = new LambdaReceiver();

            private LambdaReceiver() {
                super(null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin$Other;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirMissingDependencyClassProxy$MissingTypeOrigin;", "<init>", "()V", "checkers"})
        public static final class Other
        extends MissingTypeOrigin {
            @NotNull
            public static final Other INSTANCE = new Other();

            private Other() {
                super(null);
            }
        }
    }
}

