/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponent;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInlineCheckerPlatformSpecificComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirInlineDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PublishedApiEffectiveVisibilityKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001e\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u0002H\u0002J&\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0018\u00010!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030'H\u0002\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkParameters", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "overriddenSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "checkParametersInNotInline", "checkNothingToInline", "checkCanBeInlined", "", "effectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isInlinableDefaultValue", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkCallableDeclaration", "isNonLocalReturnAllowed", "inlineFunction", "extractCallAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "anonymousFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "isArrayLambdaConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "InlineFunctionBodyContext", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 5 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,603:1\n43#2:604\n46#2:605\n46#2:606\n37#2,10:607\n28#2:623\n1755#3,3:617\n1755#3,3:620\n28#4:624\n57#5,4:625\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker\n*L\n44#1:604\n426#1:605\n430#1:606\n477#1:607,10\n520#1:623\n478#1:617,3\n480#1:620,3\n544#1:624\n557#1:625,4\n*E\n"})
public final class FirInlineDeclarationChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirInlineDeclarationChecker INSTANCE = new FirInlineDeclarationChecker();

    private FirInlineDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirMemberDeclaration $this$isInline$iv = declaration;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) {
            this.checkParametersInNotInline(declaration, context, reporter);
            return;
        }
        FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context.getSession());
        boolean bl = firInlineCheckerPlatformSpecificComponent != null ? !firInlineCheckerPlatformSpecificComponent.isGenerallyOk(declaration, context, reporter) : false;
        if (bl) {
            return;
        }
        if (!(declaration instanceof FirPropertyAccessor) && !(declaration instanceof FirSimpleFunction)) {
            return;
        }
        this.checkCallableDeclaration(declaration, context, reporter);
    }

    private final void checkParameters(FirSimpleFunction function2, List<? extends FirCallableSymbol<? extends FirCallableDeclaration>> overriddenSymbols, CheckerContext context, DiagnosticReporter reporter) {
        block9: {
            for (FirValueParameter firValueParameter : function2.getValueParameters()) {
                ConeKotlinType coneType = TypeExpansionUtilsKt.fullyExpandedType$default(FirTypeUtilsKt.getConeType(firValueParameter.getReturnTypeRef()), context.getSession(), null, 2, null);
                FunctionTypeKind functionKind = FunctionalTypeUtilsKt.functionTypeKind(coneType, context.getSession());
                boolean isFunctionalType = functionKind != null;
                FunctionTypeKind functionTypeKind = functionKind;
                boolean isSuspendFunctionType = functionTypeKind != null ? FunctionTypeKindKt.isSuspendOrKSuspendFunction(functionTypeKind) : false;
                FirExpression defaultValue = firValueParameter.getDefaultValue();
                if (!isFunctionalType && (firValueParameter.isNoinline() || firValueParameter.isCrossinline())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
                }
                if (firValueParameter.isNoinline()) continue;
                FirMemberDeclaration $this$isSuspend$iv = function2;
                boolean $i$f$isSuspend = false;
                if ($this$isSuspend$iv.getStatus().isSuspend() && defaultValue != null && isSuspendFunctionType) {
                    FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context.getSession());
                    if (firInlineCheckerPlatformSpecificComponent != null) {
                        firInlineCheckerPlatformSpecificComponent.checkSuspendFunctionalParameterWithDefaultValue(firValueParameter, context, reporter);
                    }
                }
                if (isSuspendFunctionType && !firValueParameter.isCrossinline()) {
                    $this$isSuspend$iv = function2;
                    $i$f$isSuspend = false;
                    if (!$this$isSuspend$iv.getStatus().isSuspend()) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getINLINE_SUSPEND_FUNCTION_TYPE_UNSUPPORTED(), (DiagnosticContext)context, null, 8, null);
                    }
                }
                if (ConeTypeUtilsKt.isNullable(coneType) && isFunctionalType) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firValueParameter.getSource(), FirErrors.INSTANCE.getNULLABLE_INLINE_PARAMETER(), (Object)firValueParameter.getSymbol(), (Object)function2.getSymbol(), (DiagnosticContext)context, null, 32, null);
                }
                if (!isFunctionalType || defaultValue == null || this.isInlinableDefaultValue(defaultValue)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)defaultValue.getSource(), FirErrors.INSTANCE.getINVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE(), (Object)firValueParameter.getSymbol(), (DiagnosticContext)context, null, 16, null);
            }
            if (!((Collection)overriddenSymbols).isEmpty()) {
                for (FirTypeParameter firTypeParameter : function2.getTypeParameters()) {
                    if (!firTypeParameter.isReified()) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)firTypeParameter.getSource(), FirErrors.INSTANCE.getREIFIED_TYPE_PARAMETER_IN_OVERRIDE(), (DiagnosticContext)context, null, 8, null);
                }
            }
            FirInlineCheckerPlatformSpecificComponent firInlineCheckerPlatformSpecificComponent = FirInlineCheckerPlatformSpecificComponentKt.getInlineCheckerExtension(context.getSession());
            if (firInlineCheckerPlatformSpecificComponent == null) break block9;
            firInlineCheckerPlatformSpecificComponent.checkFunctionalParametersWithInheritedDefaultValues(function2, context, reporter, overriddenSymbols);
        }
    }

    private final void checkParametersInNotInline(FirFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        for (FirValueParameter param2 : function2.getValueParameters()) {
            if (!param2.isNoinline() && !param2.isCrossinline()) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)param2.getSource(), FirErrors.INSTANCE.getILLEGAL_INLINE_PARAMETER_MODIFIER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final void checkNothingToInline(FirSimpleFunction function2, CheckerContext context, DiagnosticReporter reporter) {
        boolean hasInlinableParameters;
        FirSession session2;
        block15: {
            boolean bl;
            boolean bl2;
            block14: {
                block17: {
                    block16: {
                        FirMemberDeclaration $this$isExpect$iv = function2;
                        boolean $i$f$isExpect = false;
                        if ($this$isExpect$iv.getStatus().isExpect()) break block16;
                        FirMemberDeclaration $this$isSuspend$iv = function2;
                        boolean $i$f$isSuspend = false;
                        if (!$this$isSuspend$iv.getStatus().isSuspend()) break block17;
                    }
                    return;
                }
                Iterable $this$any$iv = function2.getTypeParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeParameter it = (FirTypeParameter)element$iv;
                        boolean bl3 = false;
                        if (!it.getSymbol().isReified()) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return;
            }
            session2 = context.getSession();
            Iterable $this$any$iv = function2.getValueParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv;
                    boolean bl4 = false;
                    if (!FirInlineDeclarationCheckerKt.access$isInlinable(it, context.getSession())) continue;
                    bl = true;
                    break block15;
                }
                bl = hasInlinableParameters = false;
            }
        }
        if (hasInlinableParameters) {
            return;
        }
        if (FirHelpersKt.isInlineOnly(function2, session2)) {
            return;
        }
        if (DeclarationUtilsKt.needsMultiFieldValueClassFlattening(function2.getReturnTypeRef(), session2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)function2.getSource(), FirErrors.INSTANCE.getNOTHING_TO_INLINE(), (DiagnosticContext)context, null, 8, null);
    }

    private final boolean checkCanBeInlined(FirCallableDeclaration declaration, EffectiveVisibility effectiveVisibility, CheckerContext context, DiagnosticReporter reporter) {
        if (ClassMembersKt.containingClassLookupTag(declaration) == null) {
            return true;
        }
        if (Intrinsics.areEqual(effectiveVisibility, EffectiveVisibility.PrivateInClass.INSTANCE)) {
            return true;
        }
        if (!DeclarationUtilsKt.isEffectivelyFinal(declaration, context)) {
            KtSourceElement ktSourceElement = declaration.getSource();
            if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtFakeSourceElementKind.PropertyFromParameter.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDECLARATION_CANT_BE_INLINED(), (DiagnosticContext)context, null, 8, null);
            }
            return false;
        }
        return true;
    }

    private final boolean isInlinableDefaultValue(FirExpression expression2) {
        return expression2 instanceof FirCallableReferenceAccess || expression2 instanceof FirFunctionCall || expression2 instanceof FirAnonymousFunctionExpression || expression2 instanceof FirLiteralExpression && ((FirLiteralExpression)expression2).getValue() == null;
    }

    public final void checkCallableDeclaration(@NotNull FirCallableDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        boolean canBeInlined;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (declaration instanceof FirPropertyAccessor) {
            return;
        }
        List<FirCallableSymbol<FirCallableDeclaration>> directOverriddenSymbols = FirHelpersKt.getDirectOverriddenSymbols(declaration, context);
        if (declaration instanceof FirSimpleFunction) {
            this.checkParameters((FirSimpleFunction)declaration, directOverriddenSymbols, context, reporter);
            this.checkNothingToInline((FirSimpleFunction)declaration, context, reporter);
        }
        FirMemberDeclaration $this$effectiveVisibility$iv = declaration;
        boolean $i$f$getEffectiveVisibility = false;
        FirDeclarationStatus firDeclarationStatus = $this$effectiveVisibility$iv.getStatus();
        Object object = firDeclarationStatus instanceof FirResolvedDeclarationStatus ? (FirResolvedDeclarationStatus)firDeclarationStatus : null;
        if (object == null || (object = object.getEffectiveVisibility()) == null) {
            object = EffectiveVisibility.Local.INSTANCE;
        }
        if ((canBeInlined = this.checkCanBeInlined(declaration, (EffectiveVisibility)object, context, reporter)) && !((Collection)directOverriddenSymbols).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getOVERRIDE_BY_INLINE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isNonLocalReturnAllowed(CheckerContext context, FirFunction inlineFunction2) {
        List<FirDeclaration> declarations2 = context.getContainingDeclarations();
        int inlineFunctionIndex = declarations2.indexOf(inlineFunction2);
        if (inlineFunctionIndex == -1) {
            return true;
        }
        int n = declarations2.size();
        for (int i2 = inlineFunctionIndex + 1; i2 < n; ++i2) {
            FirFunctionSymbol callable;
            Pair<FirFunctionCall, FirValueParameter> pair;
            FirDeclaration declaration = declarations2.get(i2);
            if (!(declaration instanceof FirFunction) && !(declaration instanceof FirClass)) continue;
            FirAnonymousFunction firAnonymousFunction = declaration instanceof FirAnonymousFunction ? (FirAnonymousFunction)declaration : null;
            if (firAnonymousFunction == null) {
                return false;
            }
            FirAnonymousFunction anonymousFunction = firAnonymousFunction;
            if (this.extractCallAndParameter(context, anonymousFunction) == null) {
                return false;
            }
            FirFunctionCall call2 = pair.component1();
            FirValueParameter parameter = pair.component2();
            FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(call2);
            if ((firCallableSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)firCallableSymbol : null) == null) {
                return false;
            }
            callable = callable;
            FirCallableSymbol $this$isInline$iv = callable;
            boolean $i$f$isInline = false;
            if (!$this$isInline$iv.getRawStatus().isInline() && !this.isArrayLambdaConstructor(callable)) {
                return false;
            }
            if (!parameter.isNoinline() && !parameter.isCrossinline()) continue;
            return false;
        }
        return true;
    }

    private final Pair<FirFunctionCall, FirValueParameter> extractCallAndParameter(CheckerContext context, FirAnonymousFunction anonymousFunction) {
        for (FirStatement call2 : context.getCallsOrAssignments()) {
            LinkedHashMap<FirExpression, FirValueParameter> mapping;
            if (!(call2 instanceof FirFunctionCall)) continue;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)call2;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            if ((argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null) == null) continue;
            mapping = mapping;
            for (Map.Entry entry : ((Map)mapping).entrySet()) {
                FirExpression argument = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                FirExpression firExpression = FirExpressionUtilKt.unwrapArgument(argument);
                FirAnonymousFunctionExpression firAnonymousFunctionExpression = firExpression instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)firExpression : null;
                if ((firAnonymousFunctionExpression != null ? firAnonymousFunctionExpression.getAnonymousFunction() : null) != anonymousFunction) continue;
                return TuplesKt.to(call2, parameter);
            }
        }
        return null;
    }

    private final boolean isArrayLambdaConstructor(FirFunctionSymbol<?> $this$isArrayLambdaConstructor) {
        return $this$isArrayLambdaConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isArrayLambdaConstructor).getValueParameterSymbols().size() == 2 && ArrayUtilsKt.isArrayOrPrimitiveArray(((FirConstructorSymbol)$this$isArrayLambdaConstructor).getResolvedReturnType());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001NB-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J$\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010$\u001a\u00020%H\u0002JA\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J@\u0010-\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030!\u0012\b\u0012\u0006\u0012\u0002\b\u00030!0.2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u001c\u0010/\u001a\u00020\u0014*\u00020\u00072\u0006\u00100\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0016\u00101\u001a\u0004\u0018\u000102*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0002J3\u00103\u001a\u00020\u00022\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b7J3\u00108\u001a\u00020\u00022\u0006\u00109\u001a\u00020:2\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b;J8\u0010<\u001a\u00020\u00022\u0006\u00104\u001a\u0002052\b\u0010=\u001a\u0004\u0018\u00010>2\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010?\u001a\u00020\u00142\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010!H\u0002J3\u0010@\u001a\u00020\u00022\u0006\u0010A\u001a\u00020\u001f2\f\u00106\u001a\b\u0012\u0002\b\u0003\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\bBJ\u0014\u0010C\u001a\u00020\u0014*\u00020\u001f2\u0006\u0010\"\u001a\u00020\u0003H\u0002J4\u0010D\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010E\u001a\u0006\u0012\u0002\b\u00030F2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J,\u0010G\u001a\u00020\u00022\n\u0010E\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J,\u0010H\u001a\u00020\u00022\n\u0010E\u001a\u0006\u0012\u0002\b\u00030F2\u0006\u0010I\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010J\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030KH\u0002J,\u0010L\u001a\u00020\u00022\n\u00106\u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010(\u001a\u00020)2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010M\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "inlineFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "inlinableParameters", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirFunction;Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;Ljava/util/List;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getInlineFunction", "()Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isEffectivelyPrivateApiFunction", "", "prohibitProtectedCallFromInline", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitSmartCastExpression", "smartCastExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirSmartCastExpression;", "accessedDeclarationEffectiveVisibility", "accessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "accessedSymbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "context", "shouldReportNonPublicCallFromPublicInline", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkAccessedDeclaration", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAccessedDeclaration$checkers", "getNonPublicCallFromPublicInlineFactory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory2;", "isReachableDueToLocalDispatchReceiver", "access", "localDispatchReceiver", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkReceiversOfQualifiedAccessExpression", "qualifiedAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "targetSymbol", "checkReceiversOfQualifiedAccessExpression$checkers", "checkArgumentsOfCall", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "checkArgumentsOfCall$checkers", "checkReceiver", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isInvokeOrInlineExtension", "checkQualifiedAccess", "qualifiedAccess", "checkQualifiedAccess$checkers", "partOfCall", "checkVisibilityAndAccess", "calledDeclaration", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "checkPrivateClassMemberAccess", "checkSuperCalls", "callExpression", "isDefinedInInlineFunction", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "checkRecursion", "isInsidePrivateClass", "AccessedDeclarationVisibilityData", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirInlineDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n+ 2 publishedApiEffectiveVisibility.kt\norg/jetbrains/kotlin/fir/resolve/transformers/PublishedApiEffectiveVisibilityKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,603:1\n45#2,2:604\n45#2,2:607\n19#3:606\n45#3:609\n19#3:610\n28#3:611\n45#3:612\n28#3:619\n18#3:630\n44#3:631\n44#3:632\n56#3:633\n57#4,4:613\n43#4:623\n295#5,2:617\n1755#5,3:620\n1755#5,3:624\n1755#5,3:627\n*S KotlinDebug\n*F\n+ 1 FirInlineDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext\n*L\n76#1:604,2\n77#1:607,2\n76#1:606\n77#1:609\n108#1:610\n146#1:611\n162#1:612\n197#1:619\n300#1:630\n393#1:631\n394#1:632\n400#1:633\n189#1:613,4\n279#1:623\n194#1:617,2\n264#1:620,3\n279#1:624,3\n292#1:627,3\n*E\n"})
    public static final class InlineFunctionBodyContext
    extends FirDefaultVisitor<Unit, CheckerContext> {
        @NotNull
        private final FirFunction inlineFunction;
        @NotNull
        private final EffectiveVisibility inlineFunEffectiveVisibility;
        @NotNull
        private final List<FirValueParameterSymbol> inlinableParameters;
        @NotNull
        private final FirSession session;
        private final boolean isEffectivelyPrivateApiFunction;
        private final boolean prohibitProtectedCallFromInline;

        public InlineFunctionBodyContext(@NotNull FirFunction inlineFunction2, @NotNull EffectiveVisibility inlineFunEffectiveVisibility, @NotNull List<FirValueParameterSymbol> inlinableParameters, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(inlineFunction2, "inlineFunction");
            Intrinsics.checkNotNullParameter(inlineFunEffectiveVisibility, "inlineFunEffectiveVisibility");
            Intrinsics.checkNotNullParameter(inlinableParameters, "inlinableParameters");
            Intrinsics.checkNotNullParameter(session2, "session");
            this.inlineFunction = inlineFunction2;
            this.inlineFunEffectiveVisibility = inlineFunEffectiveVisibility;
            this.inlinableParameters = inlinableParameters;
            this.session = session2;
            this.isEffectivelyPrivateApiFunction = this.inlineFunEffectiveVisibility.getPrivateApi();
            this.prohibitProtectedCallFromInline = FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.ProhibitProtectedCallFromInline);
        }

        @NotNull
        public final FirFunction getInlineFunction() {
            return this.inlineFunction;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter(element, "element");
            Intrinsics.checkNotNullParameter(data, "data");
        }

        @Override
        public void visitSmartCastExpression(@NotNull FirSmartCastExpression smartCastExpression, @NotNull CheckerContext data) {
            Intrinsics.checkNotNullParameter(smartCastExpression, "smartCastExpression");
            Intrinsics.checkNotNullParameter(data, "data");
        }

        private final EffectiveVisibility accessedDeclarationEffectiveVisibility(FirStatement accessExpression, FirBasedSymbol<?> accessedSymbol, CheckerContext context) {
            boolean $i$f$getEffectiveVisibility;
            FirBasedSymbol $this$effectiveVisibility$iv;
            EffectiveVisibility effectiveVisibility;
            boolean $i$f$getPublishedApiEffectiveVisibility;
            FirBasedSymbol<?> $this$publishedApiEffectiveVisibility$iv;
            FirBasedSymbol<?> firBasedSymbol = accessedSymbol;
            if (firBasedSymbol instanceof FirCallableSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirCallableSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirCallableSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else if (firBasedSymbol instanceof FirClassLikeSymbol) {
                $this$publishedApiEffectiveVisibility$iv = accessedSymbol;
                $i$f$getPublishedApiEffectiveVisibility = false;
                FirLazyDeclarationResolverKt.lazyResolveToPhase($this$publishedApiEffectiveVisibility$iv, FirResolvePhase.STATUS);
                effectiveVisibility = PublishedApiEffectiveVisibilityKt.getPublishedApiEffectiveVisibility($this$publishedApiEffectiveVisibility$iv.getFir());
                if (effectiveVisibility == null) {
                    $this$effectiveVisibility$iv = (FirClassLikeSymbol)accessedSymbol;
                    $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = ((FirClassLikeSymbol)$this$effectiveVisibility$iv).getResolvedStatus().getEffectiveVisibility();
                }
            } else {
                AddToStdlibKt.shouldNotBeCalled$default(null, 1, null);
                throw null;
            }
            EffectiveVisibility recordedEffectiveVisibility = effectiveVisibility;
            return this.isReachableDueToLocalDispatchReceiver(recordedEffectiveVisibility, accessExpression, context) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : (Intrinsics.areEqual(recordedEffectiveVisibility, EffectiveVisibility.Local.INSTANCE) ? (EffectiveVisibility)EffectiveVisibility.Public.INSTANCE : recordedEffectiveVisibility);
        }

        private final boolean shouldReportNonPublicCallFromPublicInline(EffectiveVisibility accessedDeclarationEffectiveVisibility, Visibility declarationVisibility) {
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationEffectiveVisibility.getPublicApi();
            boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
            return isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && declarationVisibility != Visibilities.Local.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AccessedDeclarationVisibilityData checkAccessedDeclaration$checkers(@NotNull KtSourceElement source2, @NotNull FirStatement accessExpression, @NotNull FirBasedSymbol<?> accessedSymbol, @NotNull Visibility declarationVisibility, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            EffectiveVisibility effectiveVisibility;
            Intrinsics.checkNotNullParameter(source2, "source");
            Intrinsics.checkNotNullParameter(accessExpression, "accessExpression");
            Intrinsics.checkNotNullParameter(accessedSymbol, "accessedSymbol");
            Intrinsics.checkNotNullParameter(declarationVisibility, "declarationVisibility");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            EffectiveVisibility accessedVisibility = this.accessedDeclarationEffectiveVisibility(accessExpression, accessedSymbol, context);
            FirCallableSymbol<?> firCallableSymbol = FirInlineDeclarationCheckerKt.unwrapDataClassCopyWithPrimaryConstructorOrNull(accessedSymbol, context.getSession());
            if (firCallableSymbol != null) {
                void $this$effectiveVisibility$iv;
                FirCallableSymbol<?> firCallableSymbol2 = firCallableSymbol;
                boolean $i$f$getEffectiveVisibility = false;
                effectiveVisibility = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
            } else {
                effectiveVisibility = null;
            }
            EffectiveVisibility accessedDataCopyVisibility = effectiveVisibility;
            if (this.shouldReportNonPublicCallFromPublicInline(accessedVisibility, declarationVisibility)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, this.getNonPublicCallFromPublicInlineFactory(accessExpression, accessedSymbol, source2, context), accessedSymbol, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            } else if (accessedDataCopyVisibility != null && this.shouldReportNonPublicCallFromPublicInline(accessedDataCopyVisibility, declarationVisibility)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getNON_PUBLIC_DATA_COPY_CALL_FROM_PUBLIC_INLINE(), this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 16, null);
            } else {
                this.checkPrivateClassMemberAccess(accessedSymbol, source2, context, reporter);
            }
            return new AccessedDeclarationVisibilityData(this.inlineFunEffectiveVisibility.getPublicApi(), accessedVisibility.getPublicApi(), accessedVisibility);
        }

        private final KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> getNonPublicCallFromPublicInlineFactory(FirStatement accessExpression, FirBasedSymbol<?> accessedSymbol, KtSourceElement source2, CheckerContext context) {
            if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitPrivateOperatorCallInInline)) {
                boolean isForLoopButNotIteratorCall;
                Object object;
                boolean isDelegatedPropertyAccessor = Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE);
                boolean bl = Intrinsics.areEqual(source2.getKind(), KtFakeSourceElementKind.DesugaredForLoop.INSTANCE) && !Intrinsics.areEqual((object = ReferenceUtilsKt.toReference(accessExpression, context.getSession())) != null && (object = FirReferenceUtilsKt.getSymbol((FirReference)object)) != null ? FirDeclarationUtilKt.getMemberDeclarationNameOrNull(object) : null, OperatorNameConventions.ITERATOR) ? true : (isForLoopButNotIteratorCall = false);
                if (isDelegatedPropertyAccessor || isForLoopButNotIteratorCall) {
                    return FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE_DEPRECATION();
                }
            }
            if (accessedSymbol instanceof FirCallableSymbol) {
                FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)accessedSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    return FirErrors.INSTANCE.getNON_PUBLIC_INLINE_CALL_FROM_PUBLIC_INLINE();
                }
            }
            return FirErrors.INSTANCE.getNON_PUBLIC_CALL_FROM_PUBLIC_INLINE();
        }

        private final boolean isReachableDueToLocalDispatchReceiver(EffectiveVisibility $this$isReachableDueToLocalDispatchReceiver, FirStatement access, CheckerContext context) {
            ConeKotlinType coneKotlinType = this.localDispatchReceiver(access, context);
            if (coneKotlinType == null) {
                return false;
            }
            ConeKotlinType receiverType = coneKotlinType;
            EffectiveVisibility.Protected receiverProtected = new EffectiveVisibility.Protected(TypeSystemContextHelpersKt.typeConstructor(receiverType, TypeComponentsKt.getTypeContext(context.getSession())));
            EffectiveVisibility.Permissiveness relation = receiverProtected.relation($this$isReachableDueToLocalDispatchReceiver, TypeComponentsKt.getTypeContext(context.getSession()));
            return relation == EffectiveVisibility.Permissiveness.SAME || relation == EffectiveVisibility.Permissiveness.LESS;
        }

        private final ConeKotlinType localDispatchReceiver(FirStatement $this$localDispatchReceiver, CheckerContext context) {
            Object object;
            Object object2 = $this$localDispatchReceiver instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$localDispatchReceiver : null;
            if (object2 != null && (object2 = ((FirQualifiedAccessExpression)object2).getDispatchReceiver()) != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null) {
                EffectiveVisibility effectiveVisibility;
                Object object3;
                Object it = object3 = object2;
                boolean bl = false;
                FirClassifierSymbol<?> firClassifierSymbol = TypeUtilsKt.toSymbol((ConeKotlinType)it, context.getSession());
                FirClassLikeSymbol firClassLikeSymbol = firClassifierSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firClassifierSymbol : null;
                if (firClassLikeSymbol != null) {
                    FirClassLikeSymbol $this$effectiveVisibility$iv = firClassLikeSymbol;
                    boolean $i$f$getEffectiveVisibility = false;
                    effectiveVisibility = $this$effectiveVisibility$iv.getResolvedStatus().getEffectiveVisibility();
                } else {
                    effectiveVisibility = null;
                }
                object = Intrinsics.areEqual(effectiveVisibility, EffectiveVisibility.Local.INSTANCE) ? object3 : null;
            } else {
                object = null;
            }
            return object;
        }

        public final void checkReceiversOfQualifiedAccessExpression$checkers(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getDispatchReceiver(), targetSymbol, context, reporter);
            this.checkReceiver(qualifiedAccessExpression, qualifiedAccessExpression.getExtensionReceiver(), targetSymbol, context, reporter);
        }

        public final void checkArgumentsOfCall$checkers(@NotNull FirFunctionCall functionCall, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(functionCall, "functionCall");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (context.isContractBody()) {
                return;
            }
            FirFunctionSymbol firFunctionSymbol = targetSymbol instanceof FirFunctionSymbol ? (FirFunctionSymbol)targetSymbol : null;
            if (firFunctionSymbol == null) {
                return;
            }
            FirFunctionSymbol calledFunctionSymbol = firFunctionSymbol;
            FirCall $this$resolvedArgumentMapping$iv = functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap<FirExpression, FirValueParameter> linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) {
                return;
            }
            LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2 = linkedHashMap;
            for (Map.Entry entry : ((Map)argumentMapping2).entrySet()) {
                KtDiagnosticFactory1<FirBasedSymbol<?>> ktDiagnosticFactory1;
                FirValueParameterSymbol valueParameterOfOriginalInlineFunction;
                Object v3;
                FirExpression argument;
                FirValueParameter valueParameter2;
                block9: {
                    FirVariableSymbol resolvedArgumentSymbol;
                    FirCallableSymbol<?> firCallableSymbol;
                    FirExpression wrappedArgument = (FirExpression)entry.getKey();
                    valueParameter2 = (FirValueParameter)entry.getValue();
                    FirExpression firExpression = FirExpressionUtilKt.unwrapErrorExpression(wrappedArgument);
                    if (firExpression == null || (firExpression = FirExpressionUtilKt.unwrapArgument(firExpression)) == null || ((firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(argument = firExpression, this.session)) instanceof FirVariableSymbol ? (FirVariableSymbol)firCallableSymbol : null) == null) continue;
                    resolvedArgumentSymbol = resolvedArgumentSymbol;
                    Iterable $this$firstOrNull$iv = this.inlinableParameters;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it, resolvedArgumentSymbol)) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                if ((valueParameterOfOriginalInlineFunction = (FirValueParameterSymbol)v3) == null) continue;
                FirCallableSymbol $this$isInline$iv = calledFunctionSymbol;
                boolean $i$f$isInline = false;
                if ($this$isInline$iv.getRawStatus().isInline()) {
                    if (!FirInlineDeclarationCheckerKt.access$isInlinable(valueParameter2, context.getSession())) {
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                    } else {
                        if (valueParameterOfOriginalInlineFunction.isCrossinline() || !valueParameter2.isCrossinline() && INSTANCE.isNonLocalReturnAllowed(context, this.inlineFunction)) continue;
                        ktDiagnosticFactory1 = FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED();
                    }
                } else {
                    ktDiagnosticFactory1 = FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE();
                }
                KtDiagnosticFactory1<FirBasedSymbol<?>> factory = ktDiagnosticFactory1;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)argument.getSource(), factory, (Object)valueParameterOfOriginalInlineFunction, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final void checkReceiver(FirQualifiedAccessExpression qualifiedAccessExpression, FirExpression receiverExpression, FirBasedSymbol<?> targetSymbol, CheckerContext context, DiagnosticReporter reporter) {
            if (receiverExpression == null) {
                return;
            }
            FirExpression firExpression = FirExpressionUtilKt.unwrapErrorExpression(receiverExpression);
            FirCallableSymbol<?> firCallableSymbol = firExpression != null ? ReferenceUtilsKt.toResolvedCallableSymbol(firExpression, this.session) : null;
            FirValueParameterSymbol firValueParameterSymbol = firCallableSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firCallableSymbol : null;
            if (firValueParameterSymbol == null) {
                return;
            }
            FirValueParameterSymbol receiverSymbol = firValueParameterSymbol;
            if (this.inlinableParameters.contains(receiverSymbol)) {
                if (!this.isInvokeOrInlineExtension(targetSymbol)) {
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), (Object)receiverSymbol, (DiagnosticContext)context, null, 16, null);
                } else if (!receiverSymbol.isCrossinline() && !INSTANCE.isNonLocalReturnAllowed(context, this.inlineFunction)) {
                    KtSourceElement ktSourceElement = receiverExpression.getSource();
                    if (ktSourceElement == null) {
                        ktSourceElement = qualifiedAccessExpression.getSource();
                    }
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)ktSourceElement, FirErrors.INSTANCE.getNON_LOCAL_RETURN_NOT_ALLOWED(), (Object)receiverSymbol, (DiagnosticContext)context, null, 16, null);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isInvokeOrInlineExtension(FirBasedSymbol<?> targetSymbol) {
            if (!(targetSymbol instanceof FirNamedFunctionSymbol)) {
                return false;
            }
            if (!Intrinsics.areEqual(((FirNamedFunctionSymbol)targetSymbol).getName(), OperatorNameConventions.INVOKE)) return false;
            ConeSimpleKotlinType coneSimpleKotlinType = ((FirNamedFunctionSymbol)targetSymbol).getDispatchReceiverType();
            if (coneSimpleKotlinType == null) return false;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(coneSimpleKotlinType, this.session)) return false;
            return true;
        }

        public final void checkQualifiedAccess$checkers(@NotNull FirStatement qualifiedAccess, @Nullable FirBasedSymbol<?> targetSymbol, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter(qualifiedAccess, "qualifiedAccess");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            KtSourceElement ktSourceElement = qualifiedAccess.getSource();
            if (ktSourceElement == null) {
                return;
            }
            KtSourceElement source2 = ktSourceElement;
            if (!(targetSymbol instanceof FirCallableSymbol)) {
                return;
            }
            if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetSymbol)) {
                boolean bl;
                block8: {
                    if (!this.partOfCall(qualifiedAccess, context)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getUSAGE_IS_NOT_INLINABLE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
                    }
                    Iterable $this$any$iv = context.getContainingDeclarations();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirDeclaration it = (FirDeclaration)element$iv;
                            boolean bl2 = false;
                            if (!CollectionsKt.contains((Iterable)this.inlinableParameters, it.getSymbol())) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getNOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE(), (Object)((FirValueParameterSymbol)targetSymbol), (DiagnosticContext)context, null, 16, null);
                }
            }
            this.checkVisibilityAndAccess(qualifiedAccess, (FirCallableSymbol)targetSymbol, source2, context, reporter);
            this.checkRecursion(targetSymbol, source2, context, reporter);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean partOfCall(FirStatement $this$partOfCall, CheckerContext context) {
            boolean bl;
            block7: {
                void $this$any$iv;
                if (!($this$partOfCall instanceof FirExpression)) {
                    return false;
                }
                FirStatement firStatement = CollectionsKt.getOrNull(context.getCallsOrAssignments(), context.getCallsOrAssignments().size() - 2);
                if (firStatement == null) {
                    return false;
                }
                FirStatement containingQualifiedAccess = firStatement;
                FirExpression firExpression = containingQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)containingQualifiedAccess : null;
                if (Intrinsics.areEqual($this$partOfCall, firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? FirExpressionUtilKt.unwrapErrorExpression(firExpression) : null)) {
                    return true;
                }
                FirCall firCall = containingQualifiedAccess instanceof FirCall ? (FirCall)containingQualifiedAccess : null;
                if (firCall == null) {
                    return false;
                }
                FirCall call2 = firCall;
                Object $this$arguments$iv = call2;
                boolean $i$f$getArguments = false;
                $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        FirExpression firExpression2 = FirExpressionUtilKt.unwrapErrorExpression(it);
                        if (!Intrinsics.areEqual(firExpression2 != null ? FirExpressionUtilKt.unwrapArgument(firExpression2) : null, $this$partOfCall)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final void checkVisibilityAndAccess(FirStatement accessExpression, FirCallableSymbol<?> calledDeclaration, KtSourceElement source2, CheckerContext context, DiagnosticReporter reporter) {
            block11: {
                block10: {
                    boolean bl;
                    block9: {
                        if (Intrinsics.areEqual(calledDeclaration.getCallableId().getCallableName(), StandardNames.BACKING_FIELD)) break block10;
                        Iterable $this$any$iv = context.getCallsOrAssignments();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                FirStatement it = (FirStatement)element$iv;
                                boolean bl2 = false;
                                if (!(it instanceof FirAnnotationCall)) continue;
                                bl = true;
                                break block9;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block11;
                }
                return;
            }
            FirCallableSymbol<?> $this$visibility$iv = calledDeclaration;
            boolean $i$f$getVisibility = false;
            AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = this.checkAccessedDeclaration$checkers(source2, accessExpression, (FirBasedSymbol)calledDeclaration, $this$visibility$iv.getResolvedStatus().getVisibility(), context, reporter);
            boolean isInlineFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component1();
            boolean isCalledFunPublicOrPublishedApi = accessedDeclarationVisibilityData.component2();
            EffectiveVisibility calledFunEffectiveVisibility = accessedDeclarationVisibilityData.component3();
            if (isInlineFunPublicOrPublishedApi && isCalledFunPublicOrPublishedApi) {
                this.checkSuperCalls(calledDeclaration, accessExpression, context, reporter);
            }
            boolean isConstructorCall = calledDeclaration instanceof FirConstructorSymbol;
            if (isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.Protected.INSTANCE && calledFunEffectiveVisibility.toVisibility() == Visibilities.Protected.INSTANCE) {
                KtDiagnosticFactory2<FirBasedSymbol<?>, FirBasedSymbol<?>> factory = isConstructorCall ? FirErrors.INSTANCE.getPROTECTED_CONSTRUCTOR_CALL_FROM_PUBLIC_INLINE() : (this.prohibitProtectedCallFromInline ? FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE_ERROR() : FirErrors.INSTANCE.getPROTECTED_CALL_FROM_PUBLIC_INLINE());
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, factory, this.inlineFunction.getSymbol(), calledDeclaration, (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkPrivateClassMemberAccess(FirBasedSymbol<?> calledDeclaration, KtSourceElement source2, CheckerContext context, DiagnosticReporter reporter) {
            if (!this.isEffectivelyPrivateApiFunction && this.isInsidePrivateClass(calledDeclaration)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getPRIVATE_CLASS_MEMBER_FROM_INLINE(), calledDeclaration, this.inlineFunction.getSymbol(), (DiagnosticContext)context, null, 32, null);
            }
        }

        private final void checkSuperCalls(FirCallableSymbol<?> calledDeclaration, FirStatement callExpression, CheckerContext context, DiagnosticReporter reporter) {
            FirStatement firStatement = callExpression;
            FirExpression firExpression = firStatement instanceof FirQualifiedAccessExpression ? ((FirQualifiedAccessExpression)callExpression).getDispatchReceiver() : (firStatement instanceof FirVariableAssignment ? FirExpressionUtilKt.getDispatchReceiver((FirVariableAssignment)callExpression) : null);
            FirQualifiedAccessExpression firQualifiedAccessExpression = firExpression instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression : null;
            if (firQualifiedAccessExpression == null) {
                return;
            }
            FirQualifiedAccessExpression receiver = firQualifiedAccessExpression;
            if (receiver.getCalleeReference() instanceof FirSuperReference) {
                FirExpression firExpression2 = receiver.getDispatchReceiver();
                ConeKotlinType dispatchReceiverType = firExpression2 != null ? FirTypeUtilsKt.getResolvedType(firExpression2) : null;
                Object object = dispatchReceiverType;
                if (object == null || (object = TypeUtilsKt.toSymbol((ConeKotlinType)object, this.session)) == null) {
                    return;
                }
                Object classSymbol = object;
                if (!this.isDefinedInInlineFunction((FirClassifierSymbol<?>)classSymbol)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)receiver.getSource(), FirErrors.INSTANCE.getSUPER_CALL_FROM_PUBLIC_INLINE(), calledDeclaration, (DiagnosticContext)context, null, 16, null);
                }
            }
        }

        private final boolean isDefinedInInlineFunction(FirClassifierSymbol<?> $this$isDefinedInInlineFunction) {
            boolean bl;
            FirClassifierSymbol<?> symbol = $this$isDefinedInInlineFunction;
            if (symbol instanceof FirAnonymousObjectSymbol) {
                bl = true;
            } else if (symbol instanceof FirRegularClassSymbol) {
                bl = ((FirRegularClassSymbol)symbol).getClassId().isLocal();
            } else {
                if (symbol instanceof FirTypeAliasSymbol || symbol instanceof FirTypeParameterSymbol) {
                    throw new IllegalStateException(("Unexpected classifier declaration type: " + symbol).toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            return bl;
        }

        private final void checkRecursion(FirBasedSymbol<?> targetSymbol, KtSourceElement source2, CheckerContext context, DiagnosticReporter reporter) {
            if (Intrinsics.areEqual(targetSymbol, this.inlineFunction.getSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source2, FirErrors.INSTANCE.getRECURSION_IN_INLINE(), targetSymbol, (DiagnosticContext)context, null, 16, null);
            }
        }

        private final boolean isInsidePrivateClass(FirBasedSymbol<?> $this$isInsidePrivateClass) {
            Visibility visibility;
            boolean $i$f$getVisibility;
            Object $this$visibility$iv;
            Object object = FirVisibilityCheckerKt.getOwnerLookupTag($this$isInsidePrivateClass);
            if (object == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, this.session)) == null) {
                return false;
            }
            Object containingClassSymbol = object;
            Object object2 = containingClassSymbol;
            if (object2 instanceof FirAnonymousObjectSymbol) {
                return false;
            }
            if (object2 instanceof FirRegularClassSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else if (object2 instanceof FirTypeAliasSymbol) {
                $this$visibility$iv = containingClassSymbol;
                $i$f$getVisibility = false;
                visibility = ((FirClassLikeSymbol)$this$visibility$iv).getResolvedStatus().getVisibility();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Visibility containingClassVisibility = visibility;
            if (Intrinsics.areEqual(containingClassVisibility, Visibilities.Private.INSTANCE) || Intrinsics.areEqual(containingClassVisibility, Visibilities.PrivateToThis.INSTANCE)) {
                return true;
            }
            if ($this$isInsidePrivateClass instanceof FirCallableSymbol && containingClassSymbol instanceof FirRegularClassSymbol) {
                Object $this$isCompanion$iv = containingClassSymbol;
                boolean $i$f$isCompanion = false;
                if (((FirClassLikeSymbol)$this$isCompanion$iv).getRawStatus().isCompanion()) {
                    return this.isInsidePrivateClass((FirBasedSymbol)containingClassSymbol);
                }
            }
            return false;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirInlineDeclarationChecker$InlineFunctionBodyContext$AccessedDeclarationVisibilityData;", "", "isInlineFunPublicOrPublishedApi", "", "isCalledFunPublicOrPublishedApi", "calledFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "<init>", "(ZZLorg/jetbrains/kotlin/descriptors/EffectiveVisibility;)V", "()Z", "getCalledFunEffectiveVisibility", "()Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "checkers"})
        public static final class AccessedDeclarationVisibilityData {
            private final boolean isInlineFunPublicOrPublishedApi;
            private final boolean isCalledFunPublicOrPublishedApi;
            @NotNull
            private final EffectiveVisibility calledFunEffectiveVisibility;

            public AccessedDeclarationVisibilityData(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter(calledFunEffectiveVisibility, "calledFunEffectiveVisibility");
                this.isInlineFunPublicOrPublishedApi = isInlineFunPublicOrPublishedApi;
                this.isCalledFunPublicOrPublishedApi = isCalledFunPublicOrPublishedApi;
                this.calledFunEffectiveVisibility = calledFunEffectiveVisibility;
            }

            public final boolean isInlineFunPublicOrPublishedApi() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean isCalledFunPublicOrPublishedApi() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility getCalledFunEffectiveVisibility() {
                return this.calledFunEffectiveVisibility;
            }

            public final boolean component1() {
                return this.isInlineFunPublicOrPublishedApi;
            }

            public final boolean component2() {
                return this.isCalledFunPublicOrPublishedApi;
            }

            @NotNull
            public final EffectiveVisibility component3() {
                return this.calledFunEffectiveVisibility;
            }

            @NotNull
            public final AccessedDeclarationVisibilityData copy(boolean isInlineFunPublicOrPublishedApi, boolean isCalledFunPublicOrPublishedApi, @NotNull EffectiveVisibility calledFunEffectiveVisibility) {
                Intrinsics.checkNotNullParameter(calledFunEffectiveVisibility, "calledFunEffectiveVisibility");
                return new AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi, isCalledFunPublicOrPublishedApi, calledFunEffectiveVisibility);
            }

            public static /* synthetic */ AccessedDeclarationVisibilityData copy$default(AccessedDeclarationVisibilityData accessedDeclarationVisibilityData, boolean bl, boolean bl2, EffectiveVisibility effectiveVisibility, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi;
                }
                if ((n & 2) != 0) {
                    bl2 = accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi;
                }
                if ((n & 4) != 0) {
                    effectiveVisibility = accessedDeclarationVisibilityData.calledFunEffectiveVisibility;
                }
                return accessedDeclarationVisibilityData.copy(bl, bl2, effectiveVisibility);
            }

            @NotNull
            public String toString() {
                return "AccessedDeclarationVisibilityData(isInlineFunPublicOrPublishedApi=" + this.isInlineFunPublicOrPublishedApi + ", isCalledFunPublicOrPublishedApi=" + this.isCalledFunPublicOrPublishedApi + ", calledFunEffectiveVisibility=" + this.calledFunEffectiveVisibility + ')';
            }

            public int hashCode() {
                int result2 = Boolean.hashCode(this.isInlineFunPublicOrPublishedApi);
                result2 = result2 * 31 + Boolean.hashCode(this.isCalledFunPublicOrPublishedApi);
                result2 = result2 * 31 + this.calledFunEffectiveVisibility.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AccessedDeclarationVisibilityData)) {
                    return false;
                }
                AccessedDeclarationVisibilityData accessedDeclarationVisibilityData = (AccessedDeclarationVisibilityData)other;
                if (this.isInlineFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isInlineFunPublicOrPublishedApi) {
                    return false;
                }
                if (this.isCalledFunPublicOrPublishedApi != accessedDeclarationVisibilityData.isCalledFunPublicOrPublishedApi) {
                    return false;
                }
                return Intrinsics.areEqual(this.calledFunEffectiveVisibility, accessedDeclarationVisibilityData.calledFunEffectiveVisibility);
            }
        }
    }
}

