/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.report;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.metrics.BuildAttribute;
import org.jetbrains.kotlin.build.report.metrics.BuildMetrics;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GcMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.build.report.metrics.RemoteBuildMetricsReporter;
import org.jetbrains.kotlin.daemon.common.CompilationResultCategory;
import org.jetbrains.kotlin.daemon.common.CompilationResults;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0004B+\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0011\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096\u0001J\u0019\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0019\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0017H\u0096\u0001J\u001d\u0010\u0018\u001a\u00020\r2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001aH\u0096\u0001J\u0011\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0003H\u0096\u0001J\u0019\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0017H\u0096\u0001J\u0019\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0017H\u0096\u0001J\u0019\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010#\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001J\u0015\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u001aH\u0096\u0001J\u0019\u0010%\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0001J\u0011\u0010&\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0002H\u0096\u0001R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/daemon/report/RemoteBuildMetricsReporterAdapter;", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildTime;", "Lorg/jetbrains/kotlin/build/report/metrics/GradleBuildPerformanceMetric;", "Lorg/jetbrains/kotlin/build/report/metrics/RemoteBuildMetricsReporter;", "delegate", "shouldReport", "", "compilationResults", "Lorg/jetbrains/kotlin/daemon/common/CompilationResults;", "<init>", "(Lorg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporter;ZLorg/jetbrains/kotlin/daemon/common/CompilationResults;)V", "flush", "", "addAttribute", "attribute", "Lorg/jetbrains/kotlin/build/report/metrics/BuildAttribute;", "addGcMetric", "metric", "", "value", "Lorg/jetbrains/kotlin/build/report/metrics/GcMetric;", "addMetric", "", "addMetrics", "metrics", "Lorg/jetbrains/kotlin/build/report/metrics/BuildMetrics;", "addTimeMetric", "addTimeMetricMs", "time", "durationMs", "addTimeMetricNs", "durationNs", "endGcMetric", "name", "endMeasure", "getMetrics", "startGcMetric", "startMeasure", "kotlin-daemon"})
public final class RemoteBuildMetricsReporterAdapter
implements BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric>,
RemoteBuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> {
    @NotNull
    private final BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> delegate;
    private final boolean shouldReport;
    @NotNull
    private final CompilationResults compilationResults;

    public RemoteBuildMetricsReporterAdapter(@NotNull BuildMetricsReporter<GradleBuildTime, GradleBuildPerformanceMetric> delegate2, boolean shouldReport, @NotNull CompilationResults compilationResults) {
        Intrinsics.checkNotNullParameter(delegate2, "delegate");
        Intrinsics.checkNotNullParameter(compilationResults, "compilationResults");
        this.delegate = delegate2;
        this.shouldReport = shouldReport;
        this.compilationResults = compilationResults;
    }

    @Override
    public void startMeasure(@NotNull GradleBuildTime time2) {
        Intrinsics.checkNotNullParameter(time2, "time");
        this.delegate.startMeasure((GradleBuildTime)((BuildTime)time2));
    }

    @Override
    public void endMeasure(@NotNull GradleBuildTime time2) {
        Intrinsics.checkNotNullParameter(time2, "time");
        this.delegate.endMeasure((GradleBuildTime)((BuildTime)time2));
    }

    @Override
    public void addTimeMetricNs(@NotNull GradleBuildTime time2, long durationNs) {
        Intrinsics.checkNotNullParameter(time2, "time");
        this.delegate.addTimeMetricNs((GradleBuildTime)((BuildTime)time2), durationNs);
    }

    @Override
    public void addTimeMetricMs(@NotNull GradleBuildTime time2, long durationMs) {
        Intrinsics.checkNotNullParameter(time2, "time");
        this.delegate.addTimeMetricMs((GradleBuildTime)((BuildTime)time2), durationMs);
    }

    @Override
    public void addMetric(@NotNull GradleBuildPerformanceMetric metric, long value2) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        this.delegate.addMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)metric), value2);
    }

    @Override
    public void addTimeMetric(@NotNull GradleBuildPerformanceMetric metric) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        this.delegate.addTimeMetric((GradleBuildPerformanceMetric)((BuildPerformanceMetric)metric));
    }

    @Override
    public void addGcMetric(@NotNull String metric, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(metric, "metric");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.delegate.addGcMetric(metric, value2);
    }

    @Override
    public void startGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.delegate.startGcMetric(name2, value2);
    }

    @Override
    public void endGcMetric(@NotNull String name2, @NotNull GcMetric value2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value2, "value");
        this.delegate.endGcMetric(name2, value2);
    }

    @Override
    public void addAttribute(@NotNull BuildAttribute attribute) {
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        this.delegate.addAttribute(attribute);
    }

    @Override
    @NotNull
    public BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public void addMetrics(@NotNull BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> metrics) {
        Intrinsics.checkNotNullParameter(metrics, "metrics");
        this.delegate.addMetrics(metrics);
    }

    @Override
    public void flush() {
        if (this.shouldReport) {
            BuildMetrics<GradleBuildTime, GradleBuildPerformanceMetric> metrics = this.delegate.getMetrics();
            this.compilationResults.add(CompilationResultCategory.BUILD_METRICS.getCode(), metrics);
        }
    }
}

