/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.xmlb;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.serialization.ClassUtil;
import org.jetbrains.kotlin.com.intellij.serialization.MutableAccessor;
import org.jetbrains.kotlin.com.intellij.util.ReflectionUtil;
import org.jetbrains.kotlin.com.intellij.util.xml.dom.XmlElement;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Binding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.MultiNodeBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.NestedBinding;
import org.jetbrains.kotlin.com.intellij.util.xmlb.Serializer;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializerImpl;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.MapAnnotation;
import org.jetbrains.kotlin.com.intellij.util.xmlb.annotations.XMap;

final class MapBinding
implements MultiNodeBinding,
NestedBinding {
    private static final Logger LOG = Logger.getInstance(MapBinding.class);
    private static final Comparator<Object> KEY_COMPARATOR = (o1, o2) -> {
        if (o1 instanceof Comparable && o2 instanceof Comparable) {
            Comparable c1 = (Comparable)o1;
            Comparable c2 = (Comparable)o2;
            return c1.compareTo(c2);
        }
        return 0;
    };
    private final MapAnnotation oldAnnotation;
    private final XMap annotation;
    @NotNull
    private final Class<? extends Map> mapClass;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Binding keyBinding;
    private Binding valueBinding;
    private final MutableAccessor accessor;

    MapBinding(@Nullable MutableAccessor accessor, @NotNull Class<? extends Map<?, ?>> mapClass) {
        if (mapClass == null) {
            MapBinding.$$$reportNull$$$0(0);
        }
        this.accessor = accessor;
        this.oldAnnotation = accessor == null ? null : accessor.getAnnotation(MapAnnotation.class);
        this.annotation = accessor == null ? null : accessor.getAnnotation(XMap.class);
        this.mapClass = mapClass;
    }

    @Override
    public void init(@NotNull Type originalType, @NotNull Serializer serializer2) {
        Object valueType;
        if (originalType == null) {
            MapBinding.$$$reportNull$$$0(2);
        }
        if (serializer2 == null) {
            MapBinding.$$$reportNull$$$0(3);
        }
        ParameterizedType type2 = (ParameterizedType)originalType;
        Type[] typeArguments = type2.getActualTypeArguments();
        this.keyClass = ClassUtil.typeToClass(typeArguments[0]);
        if (typeArguments.length == 1) {
            String typeName = type2.getRawType().getTypeName();
            if (!typeName.equals("org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntMap") && !typeName.equals("org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap")) {
                throw new UnsupportedOperationException("Value class is unknown for " + type2.getTypeName());
            }
            this.valueClass = Integer.class;
            valueType = Integer.class;
        } else {
            valueType = typeArguments[1];
            this.valueClass = ClassUtil.typeToClass((Type)valueType);
        }
        this.keyBinding = serializer2.getBinding(this.keyClass, typeArguments[0]);
        this.valueBinding = serializer2.getBinding(this.valueClass, (Type)valueType);
    }

    @Override
    public boolean isMulti() {
        return true;
    }

    private boolean isSurroundWithTag() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundWithTag();
    }

    @NotNull
    String getEntryElementName() {
        if (this.annotation != null) {
            String string2 = this.annotation.entryTagName();
            if (string2 == null) {
                MapBinding.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String string3 = this.oldAnnotation == null ? "entry" : this.oldAnnotation.entryTagName();
        if (string3 == null) {
            MapBinding.$$$reportNull$$$0(6);
        }
        return string3;
    }

    private String getKeyAttributeName() {
        if (this.annotation != null) {
            return this.annotation.keyAttributeName();
        }
        return this.oldAnnotation == null ? "key" : this.oldAnnotation.keyAttributeName();
    }

    private String getValueAttributeName() {
        if (this.annotation != null) {
            return this.annotation.valueAttributeName();
        }
        return this.oldAnnotation == null ? "value" : this.oldAnnotation.valueAttributeName();
    }

    @Override
    @Nullable
    public Object deserializeList2(@Nullable Object context, @NotNull List<XmlElement> elements) {
        List<XmlElement> childNodes;
        if (elements == null) {
            MapBinding.$$$reportNull$$$0(8);
        }
        if (this.isSurroundWithTag()) {
            assert (elements.size() == 1);
            childNodes = elements.get((int)0).children;
        } else {
            childNodes = elements;
        }
        return this.deserialize2(context, childNodes);
    }

    @Override
    public Object deserializeUnsafe(Object context, @NotNull XmlElement element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Nullable
    private Map<?, ?> deserialize2(@Nullable Object context, @NotNull List<XmlElement> childNodes) {
        Map<Object, Object> map2;
        if (childNodes == null) {
            MapBinding.$$$reportNull$$$0(13);
        }
        HashMap<Object, Object> hashMap = map2 = this.accessor == null ? null : (HashMap<Object, Object>)context;
        if (map2 != null) {
            if (ClassUtil.isMutableMap(map2)) {
                map2.clear();
            } else {
                map2 = null;
            }
        }
        for (XmlElement childNode : childNodes) {
            if (!childNode.name.equals(this.getEntryElementName())) {
                LOG.warn("unexpected entry for serialized Map will be skipped: " + childNode);
                continue;
            }
            if (map2 == null) {
                if (this.mapClass == Map.class) {
                    map2 = new HashMap<Object, Object>();
                } else {
                    try {
                        map2 = ReflectionUtil.newInstance(this.mapClass);
                    }
                    catch (Exception e) {
                        LOG.warn(e);
                        map2 = new HashMap();
                    }
                }
            }
            map2.put(this.deserializeKeyOrValue(childNode, this.getKeyAttributeName(), context, this.keyBinding, this.keyClass), this.deserializeKeyOrValue(childNode, this.getValueAttributeName(), context, this.valueBinding, this.valueClass));
        }
        return map2;
    }

    private Object deserializeKeyOrValue(@NotNull XmlElement entry, @NotNull String attributeName, Object context, @Nullable Binding binding, @NotNull Class<?> valueClass) {
        String attribute;
        if (entry == null) {
            MapBinding.$$$reportNull$$$0(19);
        }
        if (attributeName == null) {
            MapBinding.$$$reportNull$$$0(20);
        }
        if (valueClass == null) {
            MapBinding.$$$reportNull$$$0(21);
        }
        if ((attribute = entry.attributes.get(attributeName)) != null) {
            return XmlSerializerImpl.convert(attribute, valueClass);
        }
        if (!this.isSurroundKey()) {
            assert (binding != null);
            for (XmlElement element : entry.children) {
                if (!binding.isBoundTo(element)) continue;
                return binding.deserializeUnsafe(context, element);
            }
        } else {
            List<Object> children2;
            XmlElement entryChild = entry.getChild(attributeName);
            List<Object> list = children2 = entryChild == null ? Collections.emptyList() : entryChild.children;
            if (children2.isEmpty()) {
                return null;
            }
            assert (binding != null);
            return Binding.deserializeList2(binding, null, children2);
        }
        return null;
    }

    private boolean isSurroundKey() {
        if (this.annotation != null) {
            return false;
        }
        return this.oldAnnotation == null || this.oldAnnotation.surroundKeyWithTag();
    }

    boolean isBoundToWithoutProperty(@NotNull String elementName2) {
        if (elementName2 == null) {
            MapBinding.$$$reportNull$$$0(22);
        }
        if (this.annotation != null) {
            return elementName2.equals(this.annotation.entryTagName());
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return elementName2.equals(this.oldAnnotation.entryTagName());
        }
        return elementName2.equals("map");
    }

    @Override
    public boolean isBoundTo(@NotNull XmlElement element) {
        if (element == null) {
            MapBinding.$$$reportNull$$$0(24);
        }
        if (this.oldAnnotation != null && !this.oldAnnotation.surroundWithTag()) {
            return this.oldAnnotation.entryTagName().equals(element.name);
        }
        if (this.annotation != null) {
            return this.annotation.propertyElementName().equals(element.name);
        }
        return element.name.equals("map");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapClass";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNodes";
                break;
            }
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/xmlb/MapBinding";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "deserializeList2";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "deserializeUnsafe";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deserialize2";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "serializeKeyOrValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deserializeKeyOrValue";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isBoundToWithoutProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isBoundTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

