/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.io.keyStorage;

import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.io.ResizeableMappedFile;

@ApiStatus.Internal
public final class MappedFileInputStream
extends InputStream {
    private final ResizeableMappedFile raf;
    private final boolean checkAccess;
    private final long limit;
    private long position;

    /*
     * WARNING - void declaration
     */
    public MappedFileInputStream(@NotNull ResizeableMappedFile raf, long position, long limit, boolean bl) {
        void checkAccess;
        if (raf == null) {
            MappedFileInputStream.$$$reportNull$$$0(0);
        }
        long totalBytes = limit - position;
        if (totalBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("limit(=" + limit + ")-position(=" + position + ") = " + totalBytes + " > MAX_INT");
        }
        long fileLength = raf.length();
        if (limit > fileLength) {
            throw new IllegalArgumentException("limit(=" + limit + ") > file.length(=" + fileLength + ")");
        }
        this.raf = raf;
        this.position = (int)position;
        this.limit = limit;
        this.checkAccess = checkAccess;
    }

    @Override
    public int available() {
        return (int)(this.limit - this.position);
    }

    @Override
    public void close() {
    }

    @Override
    public int read() throws IOException {
        if (this.position < this.limit) {
            byte b2 = this.raf.get(this.position, this.checkAccess);
            ++this.position;
            return b2 & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte @NotNull [] buffer, int offset2, int length) throws IOException {
        if (buffer == null) {
            MappedFileInputStream.$$$reportNull$$$0(1);
        }
        if (length == 0) {
            return 0;
        }
        int bytesRemains = this.available();
        assert (bytesRemains >= 0) : "position(=" + this.position + ") > limit(=" + this.limit + ")";
        if (bytesRemains == 0) {
            return -1;
        }
        if (length > bytesRemains) {
            length = bytesRemains;
        }
        this.raf.get(this.position, buffer, offset2, length, this.checkAccess);
        this.position += (long)length;
        return length;
    }

    @Override
    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.position += amountSkipped;
        return amountSkipped;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "raf";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/io/keyStorage/MappedFileInputStream";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

