/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentList;

final class LockFreeCopyOnWriteArrayList<E>
extends AtomicReference<Object[]>
implements ConcurrentList<E>,
List<E>,
RandomAccess {
    LockFreeCopyOnWriteArrayList() {
        this.clear();
    }

    private boolean replaceArray(Object @NotNull [] oldArray, Object @NotNull [] newArray) {
        if (oldArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(2);
        }
        if (newArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(3);
        }
        return this.compareAndSet(oldArray, newArray);
    }

    @Override
    public int size() {
        return ((Object[])this.get()).length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOf(Object o, Object @NotNull [] elements, int index, int fence) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.indexOf(elements, o, index, fence);
    }

    private static int lastIndexOf(Object o, Object @NotNull [] elements, int index) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(5);
        }
        if (o == null) {
            for (int i2 = index; i2 >= 0; --i2) {
                if (elements[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = index; i3 >= 0; --i3) {
                if (!o.equals(elements[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = (Object[])this.get();
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] elements = (Object[])this.get();
        if (elements.length == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = Arrays.copyOf(elements, elements.length, Object[].class);
        if (objectArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a2) {
        Object[] elements;
        int len;
        if (a2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(8);
        }
        if (a2.length < (len = (elements = (Object[])this.get()).length)) {
            T[] TArray = Arrays.copyOf(elements, len, a2.getClass());
            if (TArray == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(9);
            }
            return TArray;
        }
        System.arraycopy(elements, 0, a2, 0, len);
        if (a2.length > len) {
            a2[len] = null;
        }
        if (a2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(10);
        }
        return a2;
    }

    private E get(Object @NotNull [] a2, int index) {
        if (a2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(11);
        }
        return (E)a2[index];
    }

    @Override
    public E get(int index) {
        return this.get((Object[])this.get(), index);
    }

    @Override
    public E set(int index, E element) throws IndexOutOfBoundsException {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = (Object[])this.get(), index)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index, element))) {
        }
        return oldValue;
    }

    private static Object @NotNull [] createArraySet(Object @NotNull [] elements, int index, Object element) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(12);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(13);
        }
        return newElements;
    }

    @Override
    public boolean add(E e) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayAdd(elements, e))) {
        }
        return true;
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, E e) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(14);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + 1);
        newElements[len] = e;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(15);
        }
        return newElements;
    }

    @Override
    public void add(int index, E element) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayAdd(elements, index, element))) {
        }
    }

    private static <E> Object @NotNull [] createArrayAdd(Object @NotNull [] elements, int index, E element) {
        int numMoved;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(16);
        }
        if (index > (len = elements.length) || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        Object[] newElements = new Object[len + 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index) != 0) {
            System.arraycopy(elements, index, newElements, index + 1, numMoved);
        }
        newElements[index] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(17);
        }
        return newElements;
    }

    @Override
    public E remove(int index) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index))) {
        }
        E oldValue = this.get(elements, index);
        return oldValue;
    }

    private static Object @NotNull [] createArrayRemove(Object @NotNull [] elements, int index) {
        int numMoved;
        int len;
        Object[] newElements;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(18);
        }
        Object[] objectArray = newElements = (len = elements.length) == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index != 0) {
            System.arraycopy(elements, 0, newElements, 0, index);
        }
        if ((numMoved = len - index - 1) != 0) {
            System.arraycopy(elements, index + 1, newElements, index, numMoved);
        }
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(19);
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements = (Object[])this.get(), o)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRemove(Object @NotNull [] elements, Object o) {
        int i2;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(20);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i2 = newLen; i2 != 0; --i2) {
            Object element = elements[i2];
            if (Objects.equals(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i2);
                break;
            }
            newElements[i2 - 1] = element;
        }
        if (i2 == 0 && !Objects.equals(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean addIfAbsent(E e) {
        Object[] newElements;
        Object[] elements;
        do {
            elements = (Object[])this.get();
            int len = elements.length;
            newElements = new Object[len + 1];
            for (int i2 = 0; i2 < len; ++i2) {
                if (Objects.equals(e, elements[i2])) {
                    return false;
                }
                newElements[i2] = elements[i2];
            }
            newElements[len] = e;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(21);
        }
        Object[] elements = (Object[])this.get();
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(22);
        }
        if (c.isEmpty()) {
            return false;
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements = (Object[])this.get(), c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRemoveAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(23);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(24);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(25);
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements = (Object[])this.get(), c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    private static Object @Nullable [] createArrayRetainAll(Object @NotNull [] elements, @NotNull Collection<?> c) {
        int len;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(26);
        }
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(27);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLength = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newLength++] = element;
        }
        if (newLength == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLength, Object[].class);
    }

    @Override
    public void clear() {
        this.set(ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(29);
        }
        if (c.isEmpty()) {
            return false;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, cs))) {
        }
        return true;
    }

    private static Object @NotNull [] createArrayAddAll(Object @NotNull [] elements, Object @NotNull [] cs) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(30);
        }
        if (cs == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(31);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(32);
        }
        return newElements;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        Object[] cs;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(33);
        }
        if ((cs = c.toArray()).length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = (Object[])this.get(), newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index, cs))) {
        }
        return true;
    }

    private static Object @NotNull [] createArrayAddAll(Object @NotNull [] elements, int index, Object @NotNull [] cs) {
        Object[] newElements;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(34);
        }
        if (cs == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(35);
        }
        if (index > (len = elements.length) || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + len);
        }
        int numMoved = len - index;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index);
            System.arraycopy(elements, index, newElements, index + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index, cs.length);
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(36);
        }
        return newElements;
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = Arrays.toString((Object[])this.get());
        if (string2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list = (List)o;
        Iterator it = list.iterator();
        for (Object element : (Object[])this.get()) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : (Object[])this.get()) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object[] elements = (Object[])this.get();
        return elements.length == 0 ? Collections.emptyIterator() : new COWIterator(elements, 0);
    }

    @Override
    public void forEach(@NotNull Consumer<? super E> action) {
        Object[] snapshot2;
        if (action == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(38);
        }
        for (Object element : snapshot2 = (Object[])this.get()) {
            action.accept(element);
        }
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator2 = this.listIterator(0);
        if (listIterator2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(39);
        }
        return listIterator2;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        Object[] elements = (Object[])this.get();
        int len = elements.length;
        if (index < 0 || index > len) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return elements.length == 0 ? Collections.emptyListIterator() : new COWIterator(elements, index);
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Arrays.spliterator((Object[])this.get());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 39: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArray";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createArraySet";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayAdd";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayRemove";
                break;
            }
            case 32: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayAddAll";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 39: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createArraySet";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAdd";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemove";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemoveAll";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRetainAll";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addAllAbsent";
                break;
            }
            case 29: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAddAll";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 39: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private final class COWIterator
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        private int lastRet;

        private COWIterator(Object[] elements, int initialCursor) {
            if (elements == null) {
                COWIterator.$$$reportNull$$$0(0);
            }
            this.lastRet = -1;
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastRet = --this.cursor;
            return this.snapshot[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new NoSuchElementException();
            }
            Object e = this.snapshot[this.lastRet];
            this.lastRet = -1;
            LockFreeCopyOnWriteArrayList.this.remove(e);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList$COWIterator", "<init>"));
        }
    }
}

