/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionGuard;
import org.jetbrains.kotlin.com.intellij.openapi.util.RecursionManager;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public abstract class ConcurrentFactoryMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<K, V> myMap = this.createMap();

    private ConcurrentFactoryMap() {
    }

    protected abstract V create(K var1);

    @Override
    public V get(Object key) {
        ConcurrentMap<K, V> map2 = this.myMap;
        Object k = ConcurrentFactoryMap.notNull(key);
        Object value2 = map2.get(k);
        if (value2 == null) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value2 = this.create(key);
            if (stamp.mayCacheNow()) {
                Object v = ConcurrentFactoryMap.notNull(value2);
                value2 = ConcurrencyUtil.cacheOrGet(map2, k, v);
            }
        }
        return ConcurrentFactoryMap.nullize(value2);
    }

    @Nullable
    private static <T> T nullize(T value2) {
        return value2 == ConcurrentFactoryMap.FAKE_NULL() ? null : (T)value2;
    }

    private static <T> T FAKE_NULL() {
        return (T)ObjectUtils.NULL;
    }

    private static <T> T notNull(Object key) {
        return (T)(key == null ? ConcurrentFactoryMap.FAKE_NULL() : key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.myMap.containsKey(ConcurrentFactoryMap.notNull(key));
    }

    @Override
    public V put(K key, V value2) {
        Object k = ConcurrentFactoryMap.notNull(key);
        Object v = ConcurrentFactoryMap.notNull(value2);
        v = this.myMap.put(k, v);
        return (V)ConcurrentFactoryMap.nullize(v);
    }

    @Override
    public V remove(Object key) {
        Object v = this.myMap.remove(ConcurrentFactoryMap.notNull(key));
        return ConcurrentFactoryMap.nullize(v);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new CollectionWrapper.CollectionWrapperSet(this.myMap.keySet());
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.myMap.containsValue(ConcurrentFactoryMap.notNull(value2));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(0);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new CollectionWrapper(this.myMap.values());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new CollectionWrapper.CollectionWrapperSet<Map.Entry<K, V>>(this.myMap.entrySet()){

            @Override
            public Object wrap(Object val) {
                return val instanceof CollectionWrapper.EntryWrapper ? ((CollectionWrapper.EntryWrapper)val).myEntry : val;
            }

            @Override
            public Map.Entry<K, V> unwrap(Map.Entry<K, V> val) {
                return val.getKey() == ConcurrentFactoryMap.FAKE_NULL() || val.getValue() == ConcurrentFactoryMap.FAKE_NULL() ? new CollectionWrapper.EntryWrapper(val) : val;
            }
        };
    }

    @NotNull
    protected ConcurrentMap<K, V> createMap() {
        return new ConcurrentHashMap();
    }

    @Override
    public V putIfAbsent(@NotNull K key, V value2) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(1);
        }
        return ConcurrentFactoryMap.nullize(this.myMap.putIfAbsent(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value2)));
    }

    @Override
    public boolean remove(@NotNull Object key, Object value2) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(2);
        }
        return this.myMap.remove(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value2));
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(3);
        }
        if (oldValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(4);
        }
        if (newValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(5);
        }
        return this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(oldValue), ConcurrentFactoryMap.notNull(newValue));
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value2) {
        if (key == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(6);
        }
        if (value2 == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(7);
        }
        return ConcurrentFactoryMap.nullize(this.myMap.replace(ConcurrentFactoryMap.notNull(key), ConcurrentFactoryMap.notNull(value2)));
    }

    public String toString() {
        return this.myMap.toString();
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createMap(final @NotNull Function<? super T, ? extends V> computeValue) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(8);
        }
        return new ConcurrentFactoryMap<T, V>(){

            @Override
            @Nullable
            protected V create(T key) {
                return computeValue.fun(key);
            }
        };
    }

    @NotNull
    public static <K, V> ConcurrentMap<K, V> create(final @NotNull Function<? super K, ? extends V> computeValue, final @NotNull Supplier<? extends ConcurrentMap<K, V>> mapCreator) {
        if (computeValue == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(9);
        }
        if (mapCreator == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(10);
        }
        return new ConcurrentFactoryMap<K, V>(){

            @Override
            @Nullable
            protected V create(K key) {
                return computeValue.fun(key);
            }

            @Override
            @NotNull
            protected ConcurrentMap<K, V> createMap() {
                ConcurrentMap concurrentMap = (ConcurrentMap)mapCreator.get();
                if (concurrentMap == null) {
                    3.$$$reportNull$$$0(0);
                }
                return concurrentMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap$3", "createMap"));
            }
        };
    }

    @NotNull
    public static <T, V> ConcurrentMap<T, V> createWeakMap(@NotNull Function<? super T, ? extends V> compute) {
        if (compute == null) {
            ConcurrentFactoryMap.$$$reportNull$$$0(11);
        }
        return ConcurrentFactoryMap.create(compute, CollectionFactory::createConcurrentWeakMap);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeValue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapCreator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "putAll";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "putIfAbsent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "createWeakMap";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CollectionWrapper<K>
    extends AbstractCollection<K> {
        private final Collection<K> myDelegate;

        CollectionWrapper(Collection<K> delegate2) {
            this.myDelegate = delegate2;
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                final Iterator<K> it;
                {
                    this.it = myDelegate.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public K next() {
                    return this.unwrap(this.it.next());
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public int size() {
            return this.myDelegate.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.myDelegate.contains(this.wrap(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.myDelegate.remove(this.wrap(o));
        }

        protected Object wrap(Object val) {
            return ConcurrentFactoryMap.notNull(val);
        }

        protected K unwrap(K val) {
            return (K)ConcurrentFactoryMap.nullize(val);
        }

        protected static final class EntryWrapper<K, V>
        implements Map.Entry<K, V> {
            final Map.Entry<? extends K, ? extends V> myEntry;

            private EntryWrapper(Map.Entry<? extends K, ? extends V> entry) {
                this.myEntry = entry;
            }

            @Override
            public K getKey() {
                return (K)ConcurrentFactoryMap.nullize(this.myEntry.getKey());
            }

            @Override
            public V getValue() {
                return (V)ConcurrentFactoryMap.nullize(this.myEntry.getValue());
            }

            @Override
            public V setValue(V value2) {
                return (V)this.myEntry.setValue(ConcurrentFactoryMap.notNull(value2));
            }

            @Override
            public int hashCode() {
                return this.myEntry.hashCode();
            }

            @Override
            public boolean equals(Object obj) {
                return this.myEntry.equals(obj instanceof EntryWrapper ? ((EntryWrapper)obj).myEntry : obj);
            }
        }

        private static class CollectionWrapperSet<K>
        extends CollectionWrapper<K>
        implements Set<K> {
            CollectionWrapperSet(@NotNull Collection<K> delegate2) {
                if (delegate2 == null) {
                    CollectionWrapperSet.$$$reportNull$$$0(0);
                }
                super(delegate2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/com/intellij/util/containers/ConcurrentFactoryMap$CollectionWrapper$CollectionWrapperSet", "<init>"));
            }
        }
    }
}

