/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ThreadLocalRandom;
import org.jetbrains.kotlin.com.intellij.util.containers.Unsafe;

final class ConcurrentLongObjectHashMap<V>
implements ConcurrentLongObjectMap<V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Node<V>[] table;
    private volatile transient Node<V>[] nextTable;
    private volatile transient long baseCount;
    private volatile transient int sizeCtl;
    private volatile transient int transferIndex;
    private volatile transient int cellsBusy;
    private volatile transient CounterCell[] counterCells;
    private static final long SIZECTL;
    private static final long TRANSFERINDEX;
    private static final long BASECOUNT;
    private static final long CELLSBUSY;
    private static final long CELLVALUE;
    private static final long ABASE;
    private static final int ASHIFT;

    static final int spread(long h) {
        h ^= h >>> 32;
        return (int)(h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    private static final int tableSizeFor(int c) {
        int n = -1 >>> Integer.numberOfLeadingZeros(c - 1);
        return n < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    static <V> Node<V> tabAt(Node<V>[] tab, int i2) {
        try {
            Object o = Unsafe.getObjectVolatile(tab, ((long)i2 << ASHIFT) + ABASE);
            return (Node)o;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> boolean casTabAt(Node<V>[] tab, int i2, Node<V> v) {
        try {
            return Unsafe.compareAndSwapObject(tab, ((long)i2 << ASHIFT) + ABASE, null, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static <V> void setTabAt(Node<V>[] tab, int i2, Node<V> v) {
        try {
            Unsafe.putObjectVolatile(tab, ((long)i2 << ASHIFT) + ABASE, v);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    ConcurrentLongObjectHashMap() {
    }

    public int size() {
        long n = this.sumCount();
        return n < 0L ? 0 : (n > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)n);
    }

    public boolean isEmpty() {
        return this.sumCount() <= 0L;
    }

    @Override
    public V get(long key) {
        Node<V> e;
        int n;
        int h = ConcurrentLongObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        if (this.table != null && (n = tab.length) > 0 && (e = ConcurrentLongObjectHashMap.tabAt(tab, n - 1 & h)) != null) {
            int eh = e.hash;
            if (eh == h) {
                if (e.key == key) {
                    return e.val;
                }
            } else if (eh < 0) {
                Node<V> p2 = e.find(h, key);
                return p2 != null ? (V)p2.val : null;
            }
            while ((e = e.next) != null) {
                if (e.hash != h || e.key != key) continue;
                return e.val;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(long key, @NotNull V v) {
        void value2;
        if (v == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(1);
        }
        return this.putVal(key, value2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V putVal(long key, V value2, boolean onlyIfAbsent) {
        int binCount;
        block21: {
            V oldVal;
            int i2;
            int hash = ConcurrentLongObjectHashMap.spread(key);
            binCount = 0;
            Node<V>[] tab = this.table;
            while (true) {
                Object fv;
                long fk;
                int n;
                if (tab == null || (n = tab.length) == 0) {
                    tab = this.initTable();
                    continue;
                }
                i2 = n - 1 & hash;
                Node<V> f = ConcurrentLongObjectHashMap.tabAt(tab, i2);
                if (f == null) {
                    if (!ConcurrentLongObjectHashMap.casTabAt(tab, i2, new Node<V>(hash, key, value2, null))) continue;
                    break block21;
                }
                int fh = f.hash;
                if (fh == -1) {
                    tab = this.helpTransfer(tab, f);
                    continue;
                }
                if (onlyIfAbsent && fh == hash && (fk = f.key) == key && (fv = f.val) != null) {
                    return fv;
                }
                oldVal = null;
                Node<V> node = f;
                synchronized (node) {
                    block22: {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f) {
                            if (fh >= 0) {
                                binCount = 1;
                                Node<V> e = f;
                                while (true) {
                                    long ek;
                                    if (e.hash == hash && (ek = e.key) == key) {
                                        oldVal = e.val;
                                        if (!onlyIfAbsent) {
                                            e.val = value2;
                                        }
                                        break block22;
                                    }
                                    Node<V> pred = e;
                                    e = e.next;
                                    if (e == null) {
                                        pred.next = new Node<V>(hash, key, value2, null);
                                        break block22;
                                    }
                                    ++binCount;
                                }
                            }
                            if (f instanceof TreeBin) {
                                binCount = 2;
                                TreeNode<V> p2 = ((TreeBin)f).putTreeVal(hash, key, value2);
                                if (p2 != null) {
                                    oldVal = p2.val;
                                    if (!onlyIfAbsent) {
                                        p2.val = value2;
                                    }
                                }
                            } else if (f instanceof ReservationNode) {
                                throw new IllegalStateException("Recursive update");
                            }
                        }
                    }
                }
                if (binCount != 0) break;
            }
            if (binCount >= 8) {
                this.treeifyBin(tab, i2);
            }
            if (oldVal != null) {
                return oldVal;
            }
        }
        this.addCount(1L, binCount);
        return null;
    }

    @Override
    public V remove(long key) {
        return this.replaceNode(key, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final V replaceNode(long key, V value2, Object cv) {
        int i2;
        Node<V> f;
        int n;
        int hash = ConcurrentLongObjectHashMap.spread(key);
        Node<V>[] tab = this.table;
        while (tab != null && (n = tab.length) != 0 && (f = ConcurrentLongObjectHashMap.tabAt(tab, i2 = n - 1 & hash)) != null) {
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                continue;
            }
            Object oldVal = null;
            boolean validated = false;
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f) {
                    if (fh >= 0) {
                        validated = true;
                        Node<V> e = f;
                        Node<V> pred = null;
                        do {
                            if (e.key == key) {
                                Object ev = e.val;
                                if (cv == null || cv == ev || ev != null && cv.equals(ev)) {
                                    oldVal = ev;
                                    if (value2 != null) {
                                        e.val = value2;
                                    } else if (pred != null) {
                                        pred.next = e.next;
                                    } else {
                                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, e.next);
                                    }
                                }
                                break;
                            }
                            pred = e;
                        } while ((e = e.next) != null);
                    } else if (f instanceof TreeBin) {
                        TreeNode p2;
                        validated = true;
                        TreeBin t = (TreeBin)f;
                        TreeNode r = t.root;
                        if (r != null && (p2 = r.findTreeNode(hash, key)) != null) {
                            Object pv = p2.val;
                            if (cv == null || cv == pv || pv != null && cv.equals(pv)) {
                                oldVal = pv;
                                if (value2 != null) {
                                    p2.val = value2;
                                } else if (t.removeTreeNode(p2)) {
                                    ConcurrentLongObjectHashMap.setTabAt(tab, i2, this.untreeify(t.first));
                                }
                            }
                        }
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
            if (!validated) continue;
            if (oldVal == null) break;
            if (value2 == null) {
                this.addCount(-1L, -1);
            }
            return (V)oldVal;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        long delta = 0L;
        int i2 = 0;
        Node<V>[] tab = this.table;
        while (tab != null && i2 < tab.length) {
            Node<V> f = ConcurrentLongObjectHashMap.tabAt(tab, i2);
            if (f == null) {
                ++i2;
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                tab = this.helpTransfer(tab, f);
                i2 = 0;
                continue;
            }
            Node<V> node = f;
            synchronized (node) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f) {
                    Node<V> p2;
                    Node<V> node2 = fh >= 0 ? f : (p2 = f instanceof TreeBin ? ((TreeBin)f).first : null);
                    while (p2 != null) {
                        --delta;
                        p2 = p2.next;
                    }
                    ConcurrentLongObjectHashMap.setTabAt(tab, i2++, null);
                }
            }
        }
        if (delta != 0L) {
            this.addCount(delta, -1);
        }
    }

    public int hashCode() {
        int h = 0;
        Node<V>[] t = this.table;
        if (this.table != null) {
            Node<V> p2;
            Traverser<V> it = new Traverser<V>(t, t.length, 0, t.length);
            while ((p2 = it.advance()) != null) {
                h += p2.hashCode();
            }
        }
        return h;
    }

    public String toString() {
        Node<V>[] t = this.table;
        int f = this.table == null ? 0 : t.length;
        Traverser<V> it = new Traverser<V>(t, f, 0, f);
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Node<V> p2 = it.advance();
        if (p2 != null) {
            while (true) {
                long k = p2.key;
                Object v = p2.val;
                sb.append(k);
                sb.append('=');
                sb.append((Object)(v == this ? "(this Map)" : v));
                p2 = it.advance();
                if (p2 == null) break;
                sb.append(',').append(' ');
            }
        }
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (o != this) {
            Node<V> p2;
            if (!(o instanceof ConcurrentLongObjectMap)) {
                return false;
            }
            ConcurrentLongObjectMap m = (ConcurrentLongObjectMap)o;
            Node<V>[] t = this.table;
            int f = this.table == null ? 0 : t.length;
            Traverser<V> it = new Traverser<V>(t, f, 0, f);
            while ((p2 = it.advance()) != null) {
                Object val = p2.val;
                Object v = m.get(p2.key);
                if (v != null && (v == val || v.equals(val))) continue;
                return false;
            }
            for (ConcurrentLongObjectMap.LongEntry e : m.entries()) {
                long mk = e.getKey();
                Object mv2 = e.getValue();
                V v = this.get(mk);
                if (v != null && (mv2 == v || mv2.equals(v))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(long key, @NotNull V v) {
        void value2;
        if (v == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(2);
        }
        return this.putVal(key, value2, true);
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(long key, @NotNull Object object) {
        void value2;
        if (object == null) {
            ConcurrentLongObjectHashMap.$$$reportNull$$$0(3);
        }
        return this.replaceNode(key, null, value2) != null;
    }

    public long mappingCount() {
        long n = this.sumCount();
        return n < 0L ? 0L : n;
    }

    static final int resizeStamp(int n) {
        return Integer.numberOfLeadingZeros(n) | 0x8000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Node<V>[] initTable() {
        Node<V>[] tab;
        block6: {
            int sc;
            while (true) {
                tab = this.table;
                if (this.table != null && tab.length != 0) break block6;
                sc = this.sizeCtl;
                if (sc < 0) {
                    Thread.yield();
                    continue;
                }
                if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, -1)) break;
            }
            try {
                tab = this.table;
                if (this.table == null || tab.length == 0) {
                    int n = sc > 0 ? sc : 16;
                    Node[] nt = new Node[n];
                    tab = nt;
                    this.table = nt;
                    sc = n - (n >>> 2);
                }
            }
            finally {
                this.sizeCtl = sc;
            }
        }
        return tab;
    }

    private final void addCount(long x, int check2) {
        long s;
        long b2;
        CounterCell[] as = this.counterCells;
        if (this.counterCells != null || !Unsafe.compareAndSwapLong(this, BASECOUNT, b2 = this.baseCount, s = b2 + x)) {
            long v;
            CounterCell a2;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a2 = as[ThreadLocalRandom.getProbe() & m]) == null || !(uncontended = Unsafe.compareAndSwapLong(a2, CELLVALUE, v = a2.value, v + x))) {
                this.fullAddCount(x, uncontended);
                return;
            }
            if (check2 <= 1) {
                return;
            }
            s = this.sumCount();
        }
        if (check2 >= 0) {
            int sc;
            while (s >= (long)(sc = this.sizeCtl)) {
                int n;
                Node<V>[] tab = this.table;
                if (this.table == null || (n = tab.length) >= 0x40000000) break;
                int rs = ConcurrentLongObjectHashMap.resizeStamp(n) << 16;
                if (sc < 0) {
                    if (sc == rs + 65535 || sc == rs + 1) break;
                    Node<V>[] nt = this.nextTable;
                    if (this.nextTable == null || this.transferIndex <= 0) break;
                    if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) {
                        this.transfer(tab, nt);
                    }
                } else if (Unsafe.compareAndSwapInt(this, SIZECTL, sc, rs + 2)) {
                    this.transfer(tab, null);
                }
                s = this.sumCount();
            }
        }
    }

    final Node<V>[] helpTransfer(Node<V>[] tab, Node<V> f) {
        if (tab != null && f instanceof ForwardingNode) {
            Node<V>[] nextTab = ((ForwardingNode)f).nextTable;
            if (((ForwardingNode)f).nextTable != null) {
                int sc;
                int rs = ConcurrentLongObjectHashMap.resizeStamp(tab.length) << 16;
                while (nextTab == this.nextTable && this.table == tab && (sc = this.sizeCtl) < 0 && sc != rs + 65535 && sc != rs + 1 && this.transferIndex > 0) {
                    if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc + 1)) continue;
                    this.transfer(tab, nextTab);
                    break;
                }
                return nextTab;
            }
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPresize(int size) {
        int sc;
        int c;
        int n = c = size >= 0x20000000 ? 0x40000000 : ConcurrentLongObjectHashMap.tableSizeFor(size + (size >>> 1) + 1);
        while ((sc = this.sizeCtl) >= 0) {
            int rs;
            int n2;
            Node<V>[] tab = this.table;
            if (tab == null || (n2 = tab.length) == 0) {
                int n3 = n2 = sc > c ? sc : c;
                if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, -1)) continue;
                try {
                    if (this.table != tab) continue;
                    Node[] nt = new Node[n2];
                    this.table = nt;
                    sc = n2 - (n2 >>> 2);
                    continue;
                }
                finally {
                    this.sizeCtl = sc;
                    continue;
                }
            }
            if (c <= sc || n2 >= 0x40000000) break;
            if (tab != this.table || !Unsafe.compareAndSwapInt(this, SIZECTL, sc, ((rs = ConcurrentLongObjectHashMap.resizeStamp(n2)) << 16) + 2)) continue;
            this.transfer(tab, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void transfer(Node<V>[] tab, Node<V>[] nextTab) {
        int n = tab.length;
        int stride = NCPU > 1 ? (n >>> 3) / NCPU : n;
        if (stride < 16) {
            stride = 16;
        }
        if (nextTab == null) {
            try {
                Node[] nt = new Node[n << 1];
                nextTab = nt;
            }
            catch (Throwable ex) {
                this.sizeCtl = Integer.MAX_VALUE;
                return;
            }
            this.nextTable = nextTab;
            this.transferIndex = n;
        }
        int nextn = nextTab.length;
        ForwardingNode<V> fwd = new ForwardingNode<V>(nextTab);
        boolean advance = true;
        boolean finishing = false;
        int i2 = 0;
        int bound = 0;
        while (true) {
            if (advance) {
                if (--i2 >= bound || finishing) {
                    advance = false;
                    continue;
                }
                int nextIndex = this.transferIndex;
                if (nextIndex <= 0) {
                    i2 = -1;
                    advance = false;
                    continue;
                }
                int nextBound = nextIndex > stride ? nextIndex - stride : 0;
                if (!Unsafe.compareAndSwapInt(this, TRANSFERINDEX, nextIndex, nextBound)) continue;
                bound = nextBound;
                i2 = nextIndex - 1;
                advance = false;
                continue;
            }
            if (i2 < 0 || i2 >= n || i2 + n >= nextn) {
                if (finishing) {
                    this.nextTable = null;
                    this.table = nextTab;
                    this.sizeCtl = (n << 1) - (n >>> 1);
                    return;
                }
                int sc = this.sizeCtl;
                if (!Unsafe.compareAndSwapInt(this, SIZECTL, sc, sc - 1)) continue;
                if (sc - 2 != ConcurrentLongObjectHashMap.resizeStamp(n) << 16) {
                    return;
                }
                advance = true;
                finishing = true;
                i2 = n;
                continue;
            }
            TreeBin f = ConcurrentLongObjectHashMap.tabAt(tab, i2);
            if (f == null) {
                advance = ConcurrentLongObjectHashMap.casTabAt(tab, i2, fwd);
                continue;
            }
            int fh = f.hash;
            if (fh == -1) {
                advance = true;
                continue;
            }
            TreeBin treeBin = f;
            synchronized (treeBin) {
                if (ConcurrentLongObjectHashMap.tabAt(tab, i2) == f) {
                    Node hn;
                    if (fh >= 0) {
                        Node ln;
                        int runBit = fh & n;
                        TreeBin lastRun = f;
                        Node p2 = f.next;
                        while (p2 != null) {
                            int b2 = p2.hash & n;
                            if (b2 != runBit) {
                                runBit = b2;
                                lastRun = p2;
                            }
                            p2 = p2.next;
                        }
                        if (runBit == 0) {
                            ln = lastRun;
                            hn = null;
                        } else {
                            hn = lastRun;
                            ln = null;
                        }
                        p2 = f;
                        while (p2 != lastRun) {
                            int ph = p2.hash;
                            long pk = p2.key;
                            Object pv = p2.val;
                            if ((ph & n) == 0) {
                                ln = new Node(ph, pk, pv, ln);
                            } else {
                                hn = new Node(ph, pk, pv, hn);
                            }
                            p2 = p2.next;
                        }
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f instanceof TreeBin) {
                        TreeBin ln;
                        TreeBin t = f;
                        TreeNode lo = null;
                        TreeNode loTail = null;
                        TreeNode hi = null;
                        TreeNode hiTail = null;
                        int lc = 0;
                        int hc = 0;
                        Node e = t.first;
                        while (e != null) {
                            int h = e.hash;
                            TreeNode p3 = new TreeNode(h, e.key, e.val, null, null);
                            if ((h & n) == 0) {
                                p3.prev = loTail;
                                if (p3.prev == null) {
                                    lo = p3;
                                } else {
                                    loTail.next = p3;
                                }
                                loTail = p3;
                                ++lc;
                            } else {
                                p3.prev = hiTail;
                                if (p3.prev == null) {
                                    hi = p3;
                                } else {
                                    hiTail.next = p3;
                                }
                                hiTail = p3;
                                ++hc;
                            }
                            e = e.next;
                        }
                        TreeBin treeBin2 = lc <= 6 ? this.untreeify(lo) : (ln = hc != 0 ? new TreeBin(lo) : t);
                        hn = hc <= 6 ? this.untreeify(hi) : (lc != 0 ? new TreeBin(hi) : t);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2, ln);
                        ConcurrentLongObjectHashMap.setTabAt(nextTab, i2 + n, hn);
                        ConcurrentLongObjectHashMap.setTabAt(tab, i2, fwd);
                        advance = true;
                    } else if (f instanceof ReservationNode) {
                        throw new IllegalStateException("Recursive update");
                    }
                }
            }
        }
    }

    final long sumCount() {
        CounterCell[] cs = this.counterCells;
        long sum = this.baseCount;
        if (cs != null) {
            for (CounterCell c : cs) {
                if (c == null) continue;
                sum += c.value;
            }
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void fullAddCount(long x, boolean wasUncontended) {
        int h = ThreadLocalRandom.getProbe();
        if (h == 0) {
            ThreadLocalRandom.localInit();
            h = ThreadLocalRandom.getProbe();
            wasUncontended = true;
        }
        boolean collide = false;
        while (true) {
            long v;
            int n;
            CounterCell[] cs = this.counterCells;
            if (this.counterCells != null && (n = cs.length) > 0) {
                CounterCell c = cs[n - 1 & h];
                if (c == null) {
                    if (this.cellsBusy == 0) {
                        CounterCell r = new CounterCell(x);
                        if (this.cellsBusy == 0 && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                            boolean created = false;
                            try {
                                int j;
                                int m;
                                CounterCell[] rs = this.counterCells;
                                if (this.counterCells != null && (m = rs.length) > 0 && rs[j = m - 1 & h] == null) {
                                    rs[j] = r;
                                    created = true;
                                }
                            }
                            finally {
                                this.cellsBusy = 0;
                            }
                            if (!created) continue;
                            return;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v = c.value;
                    if (Unsafe.compareAndSwapLong(c, CELLVALUE, v, v + x)) return;
                    if (this.counterCells != cs || n >= NCPU) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.cellsBusy == 0 && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                        try {
                            if (this.counterCells == cs) {
                                this.counterCells = Arrays.copyOf(cs, n << 1);
                            }
                        }
                        finally {
                            this.cellsBusy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h = ThreadLocalRandom.advanceProbe(h);
                continue;
            }
            if (this.cellsBusy == 0 && this.counterCells == cs && Unsafe.compareAndSwapInt(this, CELLSBUSY, 0, 1)) {
                boolean init = false;
                try {
                    if (this.counterCells == cs) {
                        CounterCell[] rs = new CounterCell[2];
                        rs[h & 1] = new CounterCell(x);
                        this.counterCells = rs;
                        init = true;
                    }
                }
                finally {
                    this.cellsBusy = 0;
                }
                if (!init) continue;
                return;
            }
            v = this.baseCount;
            if (Unsafe.compareAndSwapLong(this, BASECOUNT, v, v + x)) return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void treeifyBin(Node<V>[] tab, int index) {
        if (tab != null) {
            int n = tab.length;
            if (n < 64) {
                this.tryPresize(n << 1);
            } else {
                Node<V> b2 = ConcurrentLongObjectHashMap.tabAt(tab, index);
                if (b2 != null && b2.hash >= 0) {
                    Node<V> node = b2;
                    synchronized (node) {
                        if (ConcurrentLongObjectHashMap.tabAt(tab, index) == b2) {
                            TreeNode hd = null;
                            TreeNode tl = null;
                            Node<V> e = b2;
                            while (e != null) {
                                TreeNode p2 = new TreeNode(e.hash, e.key, e.val, null, null);
                                p2.prev = tl;
                                if (p2.prev == null) {
                                    hd = p2;
                                } else {
                                    tl.next = p2;
                                }
                                tl = p2;
                                e = e.next;
                            }
                            ConcurrentLongObjectHashMap.setTabAt(tab, index, new TreeBin(hd));
                        }
                    }
                }
            }
        }
    }

    Node<V> untreeify(Node<V> b2) {
        Node hd = null;
        Node tl = null;
        Node<V> q2 = b2;
        while (q2 != null) {
            Node p2 = new Node(q2.hash, q2.key, q2.val, null);
            if (tl == null) {
                hd = p2;
            } else {
                tl.next = p2;
            }
            tl = p2;
            q2 = q2.next;
        }
        return hd;
    }

    @Override
    @NotNull
    public Iterable<ConcurrentLongObjectMap.LongEntry<V>> entries() {
        return new EntrySetView(this);
    }

    static {
        try {
            Class<ConcurrentLongObjectHashMap> k = ConcurrentLongObjectHashMap.class;
            SIZECTL = Unsafe.objectFieldOffset(k.getDeclaredField("sizeCtl"));
            TRANSFERINDEX = Unsafe.objectFieldOffset(k.getDeclaredField("transferIndex"));
            BASECOUNT = Unsafe.objectFieldOffset(k.getDeclaredField("baseCount"));
            CELLSBUSY = Unsafe.objectFieldOffset(k.getDeclaredField("cellsBusy"));
            CELLVALUE = Unsafe.objectFieldOffset(CounterCell.class.getDeclaredField("value"));
            ABASE = Unsafe.arrayBaseOffset(Node[].class);
            int scale = Unsafe.arrayIndexScale(Node[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
        Class<LockSupport> ensureLoaded = LockSupport.class;
        Class<ReservationNode> clazz = ReservationNode.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ConcurrentLongObjectHashMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ConcurrentLongObjectHashMap";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keys";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheOrGet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "cacheOrGet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static class Node<V>
    implements ConcurrentLongObjectMap.LongEntry<V> {
        final int hash;
        final long key;
        volatile V val;
        volatile Node<V> next;

        Node(int hash, long key, V val, Node<V> next) {
            this.hash = hash;
            this.key = key;
            this.val = val;
            this.next = next;
        }

        @Override
        public final long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public final V getValue() {
            V v = this.val;
            if (v == null) {
                Node.$$$reportNull$$$0(0);
            }
            return v;
        }

        public final int hashCode() {
            return ConcurrentLongObjectHashMap.spread(this.key) ^ this.val.hashCode();
        }

        public final String toString() {
            return this.key + "=" + this.val;
        }

        public final boolean equals(Object o) {
            V u;
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            if (e.getKey() != this.key) {
                return false;
            }
            Object v = e.getValue();
            return v == (u = this.val) || v.equals(u);
        }

        Node<V> find(int h, long k) {
            Node<V> e = this;
            do {
                if (e.key != k) continue;
                return e;
            } while ((e = e.next) != null);
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/ConcurrentLongObjectHashMap$Node", "getValue"));
        }
    }

    static class Traverser<V> {
        Node<V>[] tab;
        Node<V> next;
        TableStack<V> stack;
        TableStack<V> spare;
        int index;
        int baseIndex;
        int baseLimit;
        final int baseSize;

        Traverser(Node<V>[] tab, int size, int index, int limit) {
            this.tab = tab;
            this.baseSize = size;
            this.baseIndex = this.index = index;
            this.baseLimit = limit;
            this.next = null;
        }

        final Node<V> advance() {
            Node<V> e = this.next;
            if (e != null) {
                e = e.next;
            }
            while (true) {
                int i2;
                int n;
                Node<V>[] t;
                block10: {
                    block9: {
                        if (e != null) {
                            this.next = e;
                            return this.next;
                        }
                        if (this.baseIndex >= this.baseLimit) break block9;
                        t = this.tab;
                        if (this.tab != null && (n = t.length) > (i2 = this.index) && i2 >= 0) break block10;
                    }
                    this.next = null;
                    return null;
                }
                e = ConcurrentLongObjectHashMap.tabAt(t, i2);
                if (e != null && e.hash < 0) {
                    if (e instanceof ForwardingNode) {
                        this.tab = ((ForwardingNode)e).nextTable;
                        e = null;
                        this.pushState(t, i2, n);
                        continue;
                    }
                    e = e instanceof TreeBin ? ((TreeBin)e).first : null;
                }
                if (this.stack != null) {
                    this.recoverState(n);
                    continue;
                }
                this.index = i2 + this.baseSize;
                if (this.index < n) continue;
                this.index = ++this.baseIndex;
            }
        }

        private void pushState(Node<V>[] t, int i2, int n) {
            TableStack<V> s = this.spare;
            if (s != null) {
                this.spare = s.next;
            } else {
                s = new TableStack();
            }
            s.tab = t;
            s.length = n;
            s.index = i2;
            s.next = this.stack;
            this.stack = s;
        }

        private void recoverState(int n) {
            int len;
            TableStack<V> s;
            while ((s = this.stack) != null && (this.index += (len = s.length)) >= n) {
                n = len;
                this.index = s.index;
                this.tab = s.tab;
                s.tab = null;
                TableStack next = s.next;
                s.next = this.spare;
                this.stack = next;
                this.spare = s;
            }
            if (s == null && (this.index += this.baseSize) >= n) {
                this.index = ++this.baseIndex;
            }
        }
    }

    static final class TreeBin<V>
    extends Node<V> {
        TreeNode<V> root;
        volatile TreeNode<V> first;
        volatile Thread waiter;
        volatile int lockState;
        private static final long LOCKSTATE;

        TreeBin(TreeNode<V> b2) {
            super(-2, 0L, null, null);
            this.first = b2;
            TreeNode r = null;
            TreeNode x = b2;
            while (x != null) {
                TreeNode next = (TreeNode)x.next;
                x.right = null;
                x.left = null;
                if (r == null) {
                    x.parent = null;
                    x.red = false;
                    r = x;
                } else {
                    TreeNode xp;
                    int dir2;
                    int h = x.hash;
                    TreeNode p2 = r;
                    do {
                        int ph;
                        dir2 = (ph = p2.hash) > h ? -1 : (ph < h ? 1 : 0);
                        xp = p2;
                    } while ((p2 = dir2 <= 0 ? p2.left : p2.right) != null);
                    x.parent = xp;
                    if (dir2 <= 0) {
                        xp.left = x;
                    } else {
                        xp.right = x;
                    }
                    r = TreeBin.balanceInsertion(r, x);
                }
                x = next;
            }
            this.root = r;
            assert (TreeBin.checkInvariants(this.root));
        }

        private final void lockRoot() {
            if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, 0, 1)) {
                this.contendedLock();
            }
        }

        private final void unlockRoot() {
            this.lockState = 0;
        }

        private final void contendedLock() {
            boolean waiting = false;
            while (true) {
                int s;
                if (((s = this.lockState) & 0xFFFFFFFD) == 0) {
                    if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, 1)) continue;
                    if (waiting) {
                        this.waiter = null;
                    }
                    return;
                }
                if ((s & 2) == 0) {
                    if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, s | 2)) continue;
                    waiting = true;
                    this.waiter = Thread.currentThread();
                    continue;
                }
                if (!waiting) continue;
                LockSupport.park(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        Node<V> find(int h, long k) {
            Node e = this.first;
            while (e != null) {
                TreeNode<V> p2;
                int s = this.lockState;
                if ((s & 3) != 0) {
                    if (e.key == k) {
                        return e;
                    }
                    e = e.next;
                    continue;
                }
                if (!Unsafe.compareAndSwapInt(this, LOCKSTATE, s, s + 4)) continue;
                try {
                    TreeNode<V> r = this.root;
                    p2 = r == null ? null : r.findTreeNode(h, k);
                }
                finally {
                    Thread w;
                    if (TreeBin.getAndAddInt(this, LOCKSTATE, -4) == 6 && (w = this.waiter) != null) {
                        LockSupport.unpark(w);
                    }
                }
                return p2;
            }
            return null;
        }

        private static int getAndAddInt(Object object, long offset2, int v) {
            try {
                return Unsafe.getAndAddInt(object, offset2, v);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        TreeNode<V> putTreeVal(int h, long k, V v) {
            block18: {
                TreeNode<V> xp;
                int dir2;
                boolean searched = false;
                TreeNode<V> p2 = this.root;
                do {
                    if (p2 == null) {
                        this.root = new TreeNode<V>(h, k, v, null, null);
                        this.first = this.root;
                        break block18;
                    }
                    int ph = p2.hash;
                    if (ph > h) {
                        dir2 = -1;
                    } else if (ph < h) {
                        dir2 = 1;
                    } else {
                        if (p2.key == k) {
                            return p2;
                        }
                        if (!searched) {
                            TreeNode q2;
                            searched = true;
                            TreeNode ch = p2.left;
                            if (ch != null && (q2 = ch.findTreeNode(h, k)) != null || (ch = p2.right) != null && (q2 = ch.findTreeNode(h, k)) != null) {
                                return q2;
                            }
                        }
                        dir2 = 0;
                    }
                    xp = p2;
                } while ((p2 = dir2 <= 0 ? p2.left : p2.right) != null);
                TreeNode<V> f = this.first;
                TreeNode<V> x = new TreeNode<V>(h, k, v, f, xp);
                this.first = x;
                if (f != null) {
                    f.prev = x;
                }
                if (dir2 <= 0) {
                    xp.left = x;
                } else {
                    xp.right = x;
                }
                if (!xp.red) {
                    x.red = true;
                } else {
                    this.lockRoot();
                    try {
                        this.root = TreeBin.balanceInsertion(this.root, x);
                    }
                    finally {
                        this.unlockRoot();
                    }
                }
            }
            assert (TreeBin.checkInvariants(this.root));
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean removeTreeNode(TreeNode<V> p2) {
            TreeNode rl;
            TreeNode next = (TreeNode)p2.next;
            TreeNode pred = p2.prev;
            if (pred == null) {
                this.first = next;
            } else {
                pred.next = next;
            }
            if (next != null) {
                next.prev = pred;
            }
            if (this.first == null) {
                this.root = null;
                return true;
            }
            TreeNode<V> r = this.root;
            if (r == null || r.right == null || (rl = r.left) == null || rl.left == null) {
                return true;
            }
            this.lockRoot();
            try {
                TreeNode pp;
                TreeNode replacement;
                TreeNode pl = p2.left;
                TreeNode pr = p2.right;
                if (pl != null && pr != null) {
                    TreeNode sl;
                    TreeNode s = pr;
                    while ((sl = s.left) != null) {
                        s = sl;
                    }
                    boolean c = s.red;
                    s.red = p2.red;
                    p2.red = c;
                    TreeNode sr = s.right;
                    TreeNode pp2 = p2.parent;
                    if (s == pr) {
                        p2.parent = s;
                        s.right = p2;
                    } else {
                        TreeNode sp = s.parent;
                        p2.parent = sp;
                        if (p2.parent != null) {
                            if (s == sp.left) {
                                sp.left = p2;
                            } else {
                                sp.right = p2;
                            }
                        }
                        if ((s.right = pr) != null) {
                            pr.parent = s;
                        }
                    }
                    p2.left = null;
                    p2.right = sr;
                    if (p2.right != null) {
                        sr.parent = p2;
                    }
                    if ((s.left = pl) != null) {
                        pl.parent = s;
                    }
                    if ((s.parent = pp2) == null) {
                        r = s;
                    } else if (p2 == pp2.left) {
                        pp2.left = s;
                    } else {
                        pp2.right = s;
                    }
                    replacement = sr != null ? sr : p2;
                } else {
                    replacement = pl != null ? pl : (pr != null ? pr : p2);
                }
                if (replacement != p2) {
                    replacement.parent = p2.parent;
                    pp = replacement.parent;
                    if (pp == null) {
                        r = replacement;
                    } else if (p2 == pp.left) {
                        pp.left = replacement;
                    } else {
                        pp.right = replacement;
                    }
                    p2.parent = null;
                    p2.right = null;
                    p2.left = null;
                }
                TreeNode<V> treeNode = this.root = p2.red ? r : TreeBin.balanceDeletion(r, replacement);
                if (p2 == replacement && (pp = p2.parent) != null) {
                    if (p2 == pp.left) {
                        pp.left = null;
                    } else if (p2 == pp.right) {
                        pp.right = null;
                    }
                    p2.parent = null;
                }
            }
            finally {
                this.unlockRoot();
            }
            assert (TreeBin.checkInvariants(this.root));
            return false;
        }

        static <V> TreeNode<V> rotateLeft(TreeNode<V> root, TreeNode<V> p2) {
            TreeNode r;
            if (p2 != null && (r = p2.right) != null) {
                p2.right = r.left;
                TreeNode rl = p2.right;
                if (p2.right != null) {
                    rl.parent = p2;
                }
                TreeNode pp = r.parent = p2.parent;
                if (r.parent == null) {
                    root = r;
                    r.red = false;
                } else if (pp.left == p2) {
                    pp.left = r;
                } else {
                    pp.right = r;
                }
                r.left = p2;
                p2.parent = r;
            }
            return root;
        }

        static <V> TreeNode<V> rotateRight(TreeNode<V> root, TreeNode<V> p2) {
            TreeNode l;
            if (p2 != null && (l = p2.left) != null) {
                p2.left = l.right;
                TreeNode lr = p2.left;
                if (p2.left != null) {
                    lr.parent = p2;
                }
                TreeNode pp = l.parent = p2.parent;
                if (l.parent == null) {
                    root = l;
                    l.red = false;
                } else if (pp.right == p2) {
                    pp.right = l;
                } else {
                    pp.left = l;
                }
                l.right = p2;
                p2.parent = l;
            }
            return root;
        }

        static <V> TreeNode<V> balanceInsertion(TreeNode<V> root, TreeNode<V> x) {
            x.red = true;
            while (true) {
                TreeNode xpp;
                TreeNode xp;
                if ((xp = x.parent) == null) {
                    x.red = false;
                    return x;
                }
                if (!xp.red || (xpp = xp.parent) == null) {
                    return root;
                }
                TreeNode xppl = xpp.left;
                if (xp == xppl) {
                    TreeNode xppr = xpp.right;
                    if (xppr != null && xppr.red) {
                        xppr.red = false;
                        xp.red = false;
                        xpp.red = true;
                        x = xpp;
                        continue;
                    }
                    if (x == xp.right) {
                        x = xp;
                        root = TreeBin.rotateLeft(root, x);
                        xp = x.parent;
                        TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                    }
                    if (xp == null) continue;
                    xp.red = false;
                    if (xpp == null) continue;
                    xpp.red = true;
                    root = TreeBin.rotateRight(root, xpp);
                    continue;
                }
                if (xppl != null && xppl.red) {
                    xppl.red = false;
                    xp.red = false;
                    xpp.red = true;
                    x = xpp;
                    continue;
                }
                if (x == xp.left) {
                    x = xp;
                    root = TreeBin.rotateRight(root, x);
                    xp = x.parent;
                    TreeNode treeNode = xpp = xp == null ? null : xp.parent;
                }
                if (xp == null) continue;
                xp.red = false;
                if (xpp == null) continue;
                xpp.red = true;
                root = TreeBin.rotateLeft(root, xpp);
            }
        }

        static <V> TreeNode<V> balanceDeletion(TreeNode<V> root, TreeNode<V> x) {
            while (x != null && x != root) {
                TreeNode sr;
                TreeNode sl;
                TreeNode xp = x.parent;
                if (xp == null) {
                    x.red = false;
                    return x;
                }
                if (x.red) {
                    x.red = false;
                    return root;
                }
                TreeNode xpl = xp.left;
                if (xpl == x) {
                    TreeNode xpr = xp.right;
                    if (xpr != null && xpr.red) {
                        xpr.red = false;
                        xp.red = true;
                        root = TreeBin.rotateLeft(root, xp);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr == null) {
                        x = xp;
                        continue;
                    }
                    sl = xpr.left;
                    sr = xpr.right;
                    if (!(sr != null && sr.red || sl != null && sl.red)) {
                        xpr.red = true;
                        x = xp;
                        continue;
                    }
                    if (sr == null || !sr.red) {
                        if (sl != null) {
                            sl.red = false;
                        }
                        xpr.red = true;
                        root = TreeBin.rotateRight(root, xpr);
                        xp = x.parent;
                        TreeNode treeNode = xpr = xp == null ? null : xp.right;
                    }
                    if (xpr != null) {
                        xpr.red = xp == null ? false : xp.red;
                        sr = xpr.right;
                        if (sr != null) {
                            sr.red = false;
                        }
                    }
                    if (xp != null) {
                        xp.red = false;
                        root = TreeBin.rotateLeft(root, xp);
                    }
                    x = root;
                    continue;
                }
                if (xpl != null && xpl.red) {
                    xpl.red = false;
                    xp.red = true;
                    root = TreeBin.rotateRight(root, xp);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl == null) {
                    x = xp;
                    continue;
                }
                sl = xpl.left;
                sr = xpl.right;
                if (!(sl != null && sl.red || sr != null && sr.red)) {
                    xpl.red = true;
                    x = xp;
                    continue;
                }
                if (sl == null || !sl.red) {
                    if (sr != null) {
                        sr.red = false;
                    }
                    xpl.red = true;
                    root = TreeBin.rotateLeft(root, xpl);
                    xp = x.parent;
                    TreeNode treeNode = xpl = xp == null ? null : xp.left;
                }
                if (xpl != null) {
                    xpl.red = xp == null ? false : xp.red;
                    sl = xpl.left;
                    if (sl != null) {
                        sl.red = false;
                    }
                }
                if (xp != null) {
                    xp.red = false;
                    root = TreeBin.rotateRight(root, xp);
                }
                x = root;
            }
            return root;
        }

        static <V> boolean checkInvariants(TreeNode<V> t) {
            TreeNode tp = t.parent;
            TreeNode tl = t.left;
            TreeNode tr2 = t.right;
            TreeNode tb = t.prev;
            TreeNode tn = (TreeNode)t.next;
            if (tb != null && tb.next != t) {
                return false;
            }
            if (tn != null && tn.prev != t) {
                return false;
            }
            if (tp != null && t != tp.left && t != tp.right) {
                return false;
            }
            if (tl != null && (tl.parent != t || tl.hash > t.hash)) {
                return false;
            }
            if (tr2 != null && (tr2.parent != t || tr2.hash < t.hash)) {
                return false;
            }
            if (t.red && tl != null && tl.red && tr2 != null && tr2.red) {
                return false;
            }
            if (tl != null && !TreeBin.checkInvariants(tl)) {
                return false;
            }
            return tr2 == null || TreeBin.checkInvariants(tr2);
        }

        static {
            try {
                Class<TreeBin> k = TreeBin.class;
                Field field = k.getDeclaredField("lockState");
                LOCKSTATE = Unsafe.objectFieldOffset(field);
            }
            catch (Throwable t) {
                throw new Error(t);
            }
        }
    }

    static final class TreeNode<V>
    extends Node<V> {
        TreeNode<V> parent;
        TreeNode<V> left;
        TreeNode<V> right;
        TreeNode<V> prev;
        boolean red;

        TreeNode(int hash, long key, V val, Node<V> next, TreeNode<V> parent2) {
            super(hash, key, val, next);
            this.parent = parent2;
        }

        @Override
        Node<V> find(int h, long k) {
            return this.findTreeNode(h, k);
        }

        final TreeNode<V> findTreeNode(int h, long k) {
            TreeNode<V> p2 = this;
            do {
                TreeNode<V> pl = p2.left;
                TreeNode<V> pr = p2.right;
                int ph = p2.hash;
                if (ph > h) {
                    p2 = pl;
                    continue;
                }
                if (ph < h) {
                    p2 = pr;
                    continue;
                }
                if (p2.key == k) {
                    return p2;
                }
                if (pl == null) {
                    p2 = pr;
                    continue;
                }
                if (pr == null) {
                    p2 = pl;
                    continue;
                }
                TreeNode<V> q2 = pr.findTreeNode(h, k);
                if (q2 != null) {
                    return q2;
                }
                p2 = pl;
            } while (p2 != null);
            return null;
        }
    }

    static final class ReservationNode<V>
    extends Node<V> {
        ReservationNode() {
            super(-3, 0L, null, null);
        }
    }

    static final class EntrySetView<V>
    extends CollectionView<V, ConcurrentLongObjectMap.LongEntry<V>>
    implements Set<ConcurrentLongObjectMap.LongEntry<V>> {
        EntrySetView(ConcurrentLongObjectHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            Object r = this.map.get(e.getKey());
            if (r == null) {
                return false;
            }
            Object v = e.getValue();
            return v == r || v.equals(r);
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof ConcurrentLongObjectMap.LongEntry)) {
                return false;
            }
            ConcurrentLongObjectMap.LongEntry e = (ConcurrentLongObjectMap.LongEntry)o;
            Object v = e.getValue();
            return this.map.remove(e.getKey(), v);
        }

        @Override
        @NotNull
        public Iterator<ConcurrentLongObjectMap.LongEntry<V>> iterator() {
            ConcurrentLongObjectHashMap m = this.map;
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntryIterator(t, f, 0, f, m);
        }

        @Override
        public boolean add(ConcurrentLongObjectMap.LongEntry<V> e) {
            return this.map.putVal(e.getKey(), e.getValue(), false) == null;
        }

        @Override
        public boolean addAll(Collection<? extends ConcurrentLongObjectMap.LongEntry<V>> c) {
            boolean added = false;
            for (ConcurrentLongObjectMap.LongEntry<V> e : c) {
                if (!this.add(e)) continue;
                added = true;
            }
            return added;
        }

        @Override
        public int hashCode() {
            int h = 0;
            Node<V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p2 = it.advance()) != null) {
                    h += p2.hashCode();
                }
            }
            return h;
        }

        @Override
        public final boolean equals(Object o) {
            Set c;
            return o instanceof Set && ((c = (Set)o) == this || this.containsAll(c) && c.containsAll(this));
        }

        @Override
        public Spliterator<ConcurrentLongObjectMap.LongEntry<V>> spliterator() {
            ConcurrentLongObjectHashMap m = this.map;
            long n = m.sumCount();
            Node<V>[] t = m.table;
            int f = m.table == null ? 0 : t.length;
            return new EntrySpliterator(t, f, 0, f, n < 0L ? 0L : n, m);
        }

        @Override
        public void forEach(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node<V>[] t = this.map.table;
            if (this.map.table != null) {
                Node p2;
                Traverser it = new Traverser(t, t.length, 0, t.length);
                while ((p2 = it.advance()) != null) {
                    action.accept(new SimpleLongEntry(p2.key, p2.val));
                }
            }
        }
    }

    static final class CounterCell {
        volatile long value;

        CounterCell(long x) {
            this.value = x;
        }
    }

    static final class ForwardingNode<V>
    extends Node<V> {
        final Node<V>[] nextTable;

        ForwardingNode(Node<V>[] tab) {
            super(-1, 0L, null, null);
            this.nextTable = tab;
        }

        @Override
        Node<V> find(int h, long k) {
            Node<V>[] tab = this.nextTable;
            block0: while (true) {
                Node<V> e;
                int n;
                if (tab == null || (n = tab.length) == 0 || (e = ConcurrentLongObjectHashMap.tabAt(tab, n - 1 & h)) == null) {
                    return null;
                }
                do {
                    if (e.key == k) {
                        return e;
                    }
                    if (e.hash >= 0) continue;
                    if (e instanceof ForwardingNode) {
                        tab = ((ForwardingNode)e).nextTable;
                        continue block0;
                    }
                    return e.find(h, k);
                } while ((e = e.next) != null);
                break;
            }
            return null;
        }
    }

    private static class SimpleLongEntry<V>
    implements ConcurrentLongObjectMap.LongEntry<V> {
        private final long key;
        private final V value;

        /*
         * WARNING - void declaration
         */
        private SimpleLongEntry(long key, @NotNull V v) {
            void value2;
            if (v == null) {
                SimpleLongEntry.$$$reportNull$$$0(0);
            }
            this.key = key;
            this.value = value2;
        }

        @Override
        public long getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public V getValue() {
            V v = this.value;
            if (v == null) {
                SimpleLongEntry.$$$reportNull$$$0(1);
            }
            return v;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ConcurrentLongObjectHashMap$SimpleLongEntry";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ConcurrentLongObjectHashMap$SimpleLongEntry";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static abstract class CollectionView<V, E>
    implements Collection<E> {
        final ConcurrentLongObjectHashMap<V> map;

        CollectionView(ConcurrentLongObjectHashMap<V> map2) {
            this.map = map2;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public abstract Iterator<E> iterator();

        @Override
        public abstract boolean contains(Object var1);

        @Override
        public abstract boolean remove(Object var1);

        @Override
        public final Object[] toArray() {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError("Required array size too large");
            }
            int n = (int)sz;
            Object[] r = new Object[n];
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        @Override
        public final <T> T[] toArray(T[] a2) {
            long sz = this.map.mappingCount();
            if (sz > 0x7FFFFFF7L) {
                throw new OutOfMemoryError("Required array size too large");
            }
            int m = (int)sz;
            T[] r = a2.length >= m ? a2 : (Object[])Array.newInstance(a2.getClass().getComponentType(), m);
            int n = r.length;
            int i2 = 0;
            for (E e : this) {
                if (i2 == n) {
                    if (n >= 0x7FFFFFF7) {
                        throw new OutOfMemoryError("Required array size too large");
                    }
                    n = n >= 0x3FFFFFFB ? 0x7FFFFFF7 : (n += (n >>> 1) + 1);
                    r = Arrays.copyOf(r, n);
                }
                r[i2++] = e;
            }
            if (a2 == r && i2 < n) {
                r[i2] = null;
                return r;
            }
            return i2 == n ? r : Arrays.copyOf(r, i2);
        }

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            Iterator<E> it = this.iterator();
            if (it.hasNext()) {
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                    if (!it.hasNext()) break;
                    sb.append(',').append(' ');
                }
            }
            return sb.append(']').toString();
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            if (c != this) {
                for (Object e : c) {
                    if (e != null && this.contains(e)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Node<V>[] t = this.map.table;
            if (this.map.table == null) {
                return false;
            }
            if (c instanceof Set && c.size() > t.length) {
                Iterator<E> it = this.iterator();
                while (it.hasNext()) {
                    if (!c.contains(it.next())) continue;
                    it.remove();
                    modified = true;
                }
            } else {
                for (Object e : c) {
                    modified |= this.remove(e);
                }
            }
            return modified;
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            boolean modified = false;
            Iterator<E> it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }
    }

    static final class EntrySpliterator<V>
    extends Traverser<V>
    implements Spliterator<ConcurrentLongObjectMap.LongEntry<V>> {
        final ConcurrentLongObjectHashMap<V> map;
        long est;

        EntrySpliterator(Node<V>[] tab, int size, int index, int limit, long est, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.est = est;
        }

        @Override
        public EntrySpliterator<V> trySplit() {
            EntrySpliterator<V> entrySpliterator;
            int i2 = this.baseIndex;
            int f = this.baseLimit;
            int h = i2 + f >>> 1;
            if (h <= i2) {
                entrySpliterator = null;
            } else {
                this.baseLimit = h;
                EntrySpliterator<V> entrySpliterator2 = new EntrySpliterator<V>(this.tab, this.baseSize, this.baseLimit, f, this.est >>>= 1, this.map);
                entrySpliterator = entrySpliterator2;
            }
            return entrySpliterator;
        }

        @Override
        public void forEachRemaining(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action) {
            Node p2;
            if (action == null) {
                throw new NullPointerException();
            }
            while ((p2 = this.advance()) != null) {
                action.accept(new SimpleLongEntry(p2.key, p2.val));
            }
        }

        @Override
        public boolean tryAdvance(Consumer<? super ConcurrentLongObjectMap.LongEntry<V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            Node p2 = this.advance();
            if (p2 == null) {
                return false;
            }
            action.accept(new SimpleLongEntry(p2.key, p2.val));
            return true;
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 4353;
        }
    }

    static final class EntryIterator<V>
    extends BaseIterator<V>
    implements Iterator<ConcurrentLongObjectMap.LongEntry<V>> {
        EntryIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index, limit, map2);
        }

        @Override
        public final ConcurrentLongObjectMap.LongEntry<V> next() {
            Node p2 = this.next;
            if (p2 == null) {
                throw new NoSuchElementException();
            }
            long k = p2.key;
            Object v = p2.val;
            this.lastReturned = p2;
            this.advance();
            return new SimpleLongEntry(k, v);
        }
    }

    static class BaseIterator<V>
    extends Traverser<V> {
        final ConcurrentLongObjectHashMap<V> map;
        Node<V> lastReturned;

        BaseIterator(Node<V>[] tab, int size, int index, int limit, ConcurrentLongObjectHashMap<V> map2) {
            super(tab, size, index, limit);
            this.map = map2;
            this.advance();
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        public final boolean hasMoreElements() {
            return this.next != null;
        }

        public final void remove() {
            Node<V> p2 = this.lastReturned;
            if (p2 == null) {
                throw new IllegalStateException();
            }
            this.lastReturned = null;
            this.map.replaceNode(p2.key, null, null);
        }
    }

    static final class TableStack<V> {
        int length;
        int index;
        Node<V>[] tab;
        TableStack<V> next;

        TableStack() {
        }
    }
}

