/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.util.CommonProcessors;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.Query;
import org.jetbrains.kotlin.com.intellij.util.UnmodifiableIterator;

public abstract class AbstractQuery<Result>
implements Query<Result> {
    private final ThreadLocal<Boolean> myIsProcessing = new ThreadLocal();
    private static final boolean RANDOMIZE = ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isInternal();
    private static final Comparator<Object> CRAZY_ORDER = (o1, o2) -> -Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));

    @Override
    @NotNull
    public Collection<Result> findAll() {
        this.assertNotProcessing();
        ArrayList<Object> result2 = new ArrayList<Object>();
        Processor processor = Processors.cancelableCollectProcessor(result2);
        this.forEach(processor);
        if (RANDOMIZE && result2.size() > 1) {
            result2.sort(CRAZY_ORDER);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            AbstractQuery.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Iterator<Result> iterator() {
        this.assertNotProcessing();
        return new UnmodifiableIterator(Query.super.iterator());
    }

    @Override
    @Nullable
    public Result findFirst() {
        this.assertNotProcessing();
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        this.forEach(processor);
        return (Result)processor.getFoundValue();
    }

    private void assertNotProcessing() {
        assert (this.myIsProcessing.get() == null) : "Operation is not allowed while query is being processed";
    }

    @NotNull
    private Processor<Result> threadSafeProcessor(@NotNull Processor<? super Result> consumer2) {
        if (consumer2 == null) {
            AbstractQuery.$$$reportNull$$$0(1);
        }
        Object lock2 = ObjectUtils.sentinel("AbstractQuery lock");
        Processor<Object> processor = e -> {
            Object object = lock2;
            synchronized (object) {
                return consumer2.process((Object)e);
            }
        };
        if (processor == null) {
            AbstractQuery.$$$reportNull$$$0(2);
        }
        return processor;
    }

    @Override
    public boolean forEach(@NotNull Processor<? super Result> consumer2) {
        if (consumer2 == null) {
            AbstractQuery.$$$reportNull$$$0(3);
        }
        return this.doProcessResults(this.threadSafeProcessor(consumer2));
    }

    private boolean doProcessResults(@NotNull Processor<? super Result> consumer2) {
        if (consumer2 == null) {
            AbstractQuery.$$$reportNull$$$0(4);
        }
        this.assertNotProcessing();
        this.myIsProcessing.set(true);
        try {
            boolean bl = this.processResults(consumer2);
            return bl;
        }
        finally {
            this.myIsProcessing.remove();
        }
    }

    protected abstract boolean processResults(@NotNull Processor<? super Result> var1);

    protected static <T> boolean delegateProcessResults(@NotNull Query<T> query, @NotNull Processor<? super T> consumer2) {
        if (query == null) {
            AbstractQuery.$$$reportNull$$$0(5);
        }
        if (consumer2 == null) {
            AbstractQuery.$$$reportNull$$$0(6);
        }
        if (query instanceof AbstractQuery) {
            return ((AbstractQuery)query).doProcessResults(consumer2);
        }
        return query.forEach(consumer2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/AbstractQuery";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/AbstractQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "threadSafeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "threadSafeProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doProcessResults";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "delegateProcessResults";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapInReadAction";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

