/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class TokenSet {
    public static final TokenSet EMPTY = new TokenSet(Short.MAX_VALUE, 0, null);
    public static final TokenSet ANY = TokenSet.forAllMatching(IElementType.TRUE);
    public static final TokenSet WHITE_SPACE = TokenSet.doCreate(TokenType.WHITE_SPACE);
    private final short myShift;
    private final short myMax;
    private final long[] myWords;
    @Nullable
    private final IElementType.Predicate myOrCondition;
    private volatile IElementType[] myTypes;

    private TokenSet(short shift, short max, @Nullable IElementType.Predicate orCondition) {
        this.myShift = shift;
        this.myMax = max;
        int size = (max >> 6) + 1 - shift;
        this.myWords = size > 0 ? new long[size] : ArrayUtil.EMPTY_LONG_ARRAY;
        this.myOrCondition = orCondition;
    }

    private boolean get(int index) {
        int wordIndex = (index >> 6) - this.myShift;
        return wordIndex >= 0 && wordIndex < this.myWords.length && (this.myWords[wordIndex] & 1L << index) != 0L;
    }

    @Contract(value="null -> false")
    public boolean contains(@Nullable IElementType t) {
        if (t == null) {
            return false;
        }
        short i2 = t.getIndex();
        return 0 <= i2 && i2 <= this.myMax && this.get(i2) || this.myOrCondition != null && this.myOrCondition.matches(t);
    }

    public IElementType @NotNull [] getTypes() {
        if (this.myOrCondition != null) {
            IElementType[] iElementTypeArray = IElementType.enumerate(this::contains);
            if (iElementTypeArray == null) {
                TokenSet.$$$reportNull$$$0(0);
            }
            return iElementTypeArray;
        }
        IElementType[] types2 = this.myTypes;
        if (types2 == null) {
            if (this.myWords.length == 0) {
                types2 = IElementType.EMPTY_ARRAY;
            } else {
                ArrayList<IElementType> list = new ArrayList<IElementType>();
                for (short i2 = (short)Math.max(1, this.myShift << 6); i2 <= this.myMax; i2 = (short)(i2 + 1)) {
                    IElementType type2;
                    if (!this.get(i2) || (type2 = IElementType.find(i2)) == null) continue;
                    list.add(type2);
                }
                types2 = list.toArray(IElementType.EMPTY_ARRAY);
            }
            this.myTypes = types2;
        }
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(1);
        }
        return types2;
    }

    public String toString() {
        return Arrays.toString(this.getTypes());
    }

    @NotNull
    public static TokenSet create(IElementType ... types2) {
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(2);
        }
        if (types2.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(3);
            }
            return tokenSet;
        }
        if (types2.length == 1 && types2[0] == TokenType.WHITE_SPACE) {
            TokenSet tokenSet = WHITE_SPACE;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(4);
            }
            return tokenSet;
        }
        return TokenSet.doCreate(types2);
    }

    @NotNull
    private static TokenSet doCreate(IElementType ... types2) {
        if (types2 == null) {
            TokenSet.$$$reportNull$$$0(5);
        }
        short min = Short.MAX_VALUE;
        short max = 0;
        for (IElementType type2 : types2) {
            if (type2 == null) continue;
            short index = type2.getIndex();
            assert (index >= 0) : "Unregistered elements are not allowed here: " + ObjectUtils.objectInfo(type2);
            if (min > index) {
                min = index;
            }
            if (max >= index) continue;
            max = index;
        }
        short shift = (short)(min >> 6);
        TokenSet set = new TokenSet(shift, max, null);
        for (IElementType type3 : types2) {
            int wordIndex;
            if (type3 == null) continue;
            short index = type3.getIndex();
            int n = wordIndex = (index >> 6) - shift;
            set.myWords[n] = set.myWords[n] | 1L << index;
        }
        TokenSet tokenSet = set;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(6);
        }
        return tokenSet;
    }

    public static TokenSet forAllMatching(@NotNull IElementType.Predicate condition) {
        if (condition == null) {
            TokenSet.$$$reportNull$$$0(7);
        }
        return new TokenSet(Short.MAX_VALUE, 0, condition);
    }

    @NotNull
    public static TokenSet orSet(TokenSet ... sets) {
        if (sets == null) {
            TokenSet.$$$reportNull$$$0(8);
        }
        if (sets.length == 0) {
            TokenSet tokenSet = EMPTY;
            if (tokenSet == null) {
                TokenSet.$$$reportNull$$$0(9);
            }
            return tokenSet;
        }
        ArrayList<IElementType.Predicate> orConditions = new ArrayList<IElementType.Predicate>();
        ContainerUtil.addIfNotNull(orConditions, sets[0].myOrCondition);
        short shift = sets[0].myShift;
        short max = sets[0].myMax;
        for (int i2 = 1; i2 < sets.length; ++i2) {
            if (shift > sets[i2].myShift) {
                shift = sets[i2].myShift;
            }
            if (max < sets[i2].myMax) {
                max = sets[i2].myMax;
            }
            ContainerUtil.addIfNotNull(orConditions, sets[i2].myOrCondition);
        }
        OrPredicate disjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : new OrPredicate(orConditions));
        TokenSet newSet = new TokenSet(shift, max, disjunction);
        for (TokenSet set : sets) {
            int shiftDiff = set.myShift - newSet.myShift;
            for (int i3 = 0; i3 < set.myWords.length; ++i3) {
                int n = i3 + shiftDiff;
                newSet.myWords[n] = newSet.myWords[n] | set.myWords[i3];
            }
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(10);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andSet(@NotNull TokenSet a2, @NotNull TokenSet b2) {
        if (a2 == null) {
            TokenSet.$$$reportNull$$$0(11);
        }
        if (b2 == null) {
            TokenSet.$$$reportNull$$$0(12);
        }
        ArrayList orConditions = new ArrayList();
        ContainerUtil.addIfNotNull(orConditions, a2.myOrCondition);
        ContainerUtil.addIfNotNull(orConditions, b2.myOrCondition);
        IElementType.Predicate conjunction = orConditions.isEmpty() ? null : (orConditions.size() == 1 ? (IElementType.Predicate)orConditions.get(0) : t -> Objects.requireNonNull(a2.myOrCondition).matches(t) && Objects.requireNonNull(b2.myOrCondition).matches(t));
        TokenSet newSet = new TokenSet((short)Math.min(a2.myShift, b2.myShift), (short)Math.max(a2.myMax, b2.myMax), conjunction);
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai = newSet.myShift - a2.myShift + i2;
            int bi = newSet.myShift - b2.myShift + i2;
            newSet.myWords[i2] = (0 <= ai && ai < a2.myWords.length ? a2.myWords[ai] : 0L) & (0 <= bi && bi < b2.myWords.length ? b2.myWords[bi] : 0L);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(13);
        }
        return tokenSet;
    }

    @NotNull
    public static TokenSet andNot(@NotNull TokenSet a2, @NotNull TokenSet b2) {
        if (a2 == null) {
            TokenSet.$$$reportNull$$$0(14);
        }
        if (b2 == null) {
            TokenSet.$$$reportNull$$$0(15);
        }
        IElementType.Predicate difference2 = a2.myOrCondition == null ? null : e -> !b2.contains(e) && a2.myOrCondition.matches(e);
        TokenSet newSet = new TokenSet((short)Math.min(a2.myShift, b2.myShift), (short)Math.max(a2.myMax, b2.myMax), difference2);
        for (int i2 = 0; i2 < newSet.myWords.length; ++i2) {
            int ai = newSet.myShift - a2.myShift + i2;
            int bi = newSet.myShift - b2.myShift + i2;
            newSet.myWords[i2] = (0 <= ai && ai < a2.myWords.length ? a2.myWords[ai] : 0L) & ((0 <= bi && bi < b2.myWords.length ? b2.myWords[bi] : 0L) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        TokenSet tokenSet = newSet;
        if (tokenSet == null) {
            TokenSet.$$$reportNull$$$0(16);
        }
        return tokenSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/tree/TokenSet";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/tree/TokenSet";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "orSet";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "andSet";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "andNot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forAllMatching";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orSet";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "andSet";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "andNot";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OrPredicate
    implements IElementType.Predicate {
        private final IElementType.Predicate[] myComponents;

        OrPredicate(List<IElementType.Predicate> components) {
            this.myComponents = (IElementType.Predicate[])components.stream().flatMap(p2 -> p2 instanceof OrPredicate ? Arrays.stream(((OrPredicate)p2).myComponents) : Stream.of(p2)).distinct().toArray(IElementType.Predicate[]::new);
        }

        @Override
        public boolean matches(@NotNull IElementType t) {
            if (t == null) {
                OrPredicate.$$$reportNull$$$0(0);
            }
            for (IElementType.Predicate component : this.myComponents) {
                if (!component.matches(t)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "org/jetbrains/kotlin/com/intellij/psi/tree/TokenSet$OrPredicate", "matches"));
        }
    }
}

