/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.LoadingState;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IFileElementType;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class IElementType {
    public static final IElementType[] EMPTY_ARRAY = new IElementType[0];
    public static final ArrayFactory<IElementType> ARRAY_FACTORY = count2 -> count2 == 0 ? EMPTY_ARRAY : new IElementType[count2];
    public static final Predicate TRUE = type2 -> true;
    public static final short FIRST_TOKEN_INDEX = 1;
    private static short size;
    private static volatile IElementType @NotNull [] ourRegistry;
    @NonNls
    private static final Object lock;
    private final short myIndex;
    @NonNls
    @NotNull
    private final String myDebugName;
    @NotNull
    private final Language myLanguage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static IElementType @NotNull [] push(IElementType @NotNull [] types2) {
        if (types2 == null) {
            IElementType.$$$reportNull$$$0(0);
        }
        Object object = lock;
        // MONITORENTER : object
        IElementType[] oldRegistry = ourRegistry;
        ourRegistry = types2;
        size = (short)ContainerUtil.skipNulls(Arrays.asList(ourRegistry)).size();
        // MONITOREXIT : object
        if (oldRegistry != null) return oldRegistry;
        IElementType.$$$reportNull$$$0(1);
        return oldRegistry;
    }

    public static void unregisterElementTypes(@NotNull ClassLoader loader, @NotNull PluginDescriptor pluginDescriptor) {
        if (loader == null) {
            IElementType.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            IElementType.$$$reportNull$$$0(3);
        }
        for (int i2 = 0; i2 < ourRegistry.length; ++i2) {
            IElementType type2 = ourRegistry[i2];
            if (type2 == null || type2.getClass().getClassLoader() != loader) continue;
            IElementType.ourRegistry[i2] = TombstoneElementType.create(type2, pluginDescriptor);
        }
    }

    public static void unregisterElementTypes(@NotNull Language language2, @NotNull PluginDescriptor pluginDescriptor) {
        if (language2 == null) {
            IElementType.$$$reportNull$$$0(4);
        }
        if (pluginDescriptor == null) {
            IElementType.$$$reportNull$$$0(5);
        }
        if (language2 == Language.ANY) {
            throw new IllegalArgumentException("Trying to unregister Language.ANY");
        }
        for (int i2 = 0; i2 < ourRegistry.length; ++i2) {
            IElementType type2 = ourRegistry[i2];
            if (type2 == null || !type2.getLanguage().equals(language2)) continue;
            IElementType.ourRegistry[i2] = TombstoneElementType.create(type2, pluginDescriptor);
        }
    }

    public IElementType(@NonNls @NotNull String debugName, @Nullable Language language2) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(6);
        }
        this(debugName, language2, true);
        if (!(this instanceof IFileElementType)) {
            LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IElementType(@NonNls @NotNull String debugName, @Nullable Language language2, boolean register) {
        if (debugName == null) {
            IElementType.$$$reportNull$$$0(7);
        }
        this.myDebugName = debugName;
        Language language3 = this.myLanguage = language2 == null ? Language.ANY : language2;
        if (register) {
            Object object = lock;
            synchronized (object) {
                short s = size;
                size = (short)(s + 1);
                this.myIndex = s;
                if (this.myIndex >= 15000) {
                    Map<Language, List<IElementType>> byLang = Stream.of(ourRegistry).filter(Objects::nonNull).collect(Collectors.groupingBy(ie -> ie.myLanguage));
                    Map.Entry max = Collections.max(byLang.entrySet(), Comparator.comparingInt(e -> ((List)e.getValue()).size()));
                    List types2 = (List)max.getValue();
                    Logger.getInstance(IElementType.class).error("Too many element types registered. Out of (short) range. Most of element types (" + types2.size() + ") were registered for '" + max.getKey() + "': " + StringUtil.first(StringUtil.join(types2, ", "), 300, true));
                }
                IElementType[] newRegistry = this.myIndex >= ourRegistry.length ? ArrayUtil.realloc(ourRegistry, ourRegistry.length * 3 / 2 + 1, ARRAY_FACTORY) : ourRegistry;
                newRegistry[this.myIndex] = this;
                ourRegistry = newRegistry;
            }
        } else {
            this.myIndex = (short)-1;
        }
    }

    @NotNull
    public Language getLanguage() {
        Language language2 = this.myLanguage;
        if (language2 == null) {
            IElementType.$$$reportNull$$$0(8);
        }
        return language2;
    }

    public final short getIndex() {
        return this.myIndex;
    }

    public int hashCode() {
        return this.myIndex >= 0 ? this.myIndex : super.hashCode();
    }

    public String toString() {
        return this.getDebugName();
    }

    @ApiStatus.Internal
    @NonNls
    @NotNull
    public String getDebugName() {
        String string2 = this.myDebugName;
        if (string2 == null) {
            IElementType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    public boolean isLeftBound() {
        return false;
    }

    public static IElementType find(short idx) {
        IElementType type2 = ourRegistry[idx];
        if (type2 instanceof TombstoneElementType) {
            throw new IllegalArgumentException("Trying to access element type from unloaded plugin: " + type2);
        }
        return type2;
    }

    public static IElementType @NotNull [] enumerate(@NotNull Predicate p2) {
        if (p2 == null) {
            IElementType.$$$reportNull$$$0(10);
        }
        ArrayList<IElementType> matches = new ArrayList<IElementType>();
        for (IElementType value2 : ourRegistry) {
            if (value2 == null || !p2.matches(value2)) continue;
            matches.add(value2);
        }
        IElementType[] iElementTypeArray = matches.toArray(new IElementType[0]);
        if (iElementTypeArray == null) {
            IElementType.$$$reportNull$$$0(11);
        }
        return iElementTypeArray;
    }

    static {
        ourRegistry = EMPTY_ARRAY;
        lock = new String("registry lock");
        IElementType[] init = new IElementType[137];
        init[0] = new IElementType("NULL", Language.ANY, false);
        IElementType.push(init);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/tree/IElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/tree/IElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "push";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterElementTypes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TombstoneElementType
    extends IElementType {
        private TombstoneElementType(@NotNull @NonNls String debugName) {
            if (debugName == null) {
                TombstoneElementType.$$$reportNull$$$0(0);
            }
            super(debugName, Language.ANY);
        }

        private static TombstoneElementType create(@NotNull IElementType type2, @NotNull PluginDescriptor pluginDescriptor) {
            if (type2 == null) {
                TombstoneElementType.$$$reportNull$$$0(1);
            }
            if (pluginDescriptor == null) {
                TombstoneElementType.$$$reportNull$$$0(2);
            }
            return new TombstoneElementType("tombstone of " + type2 + " (" + type2.getClass() + ") belonged to unloaded " + pluginDescriptor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/tree/IElementType$TombstoneElementType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean matches(@NotNull IElementType var1);
    }
}

