/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.search;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.LanguageMatcher;
import org.jetbrains.kotlin.com.intellij.notebook.editor.BackedVirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.search.FileLanguageGlobalScope;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.LocalSearchScope;
import org.jetbrains.kotlin.com.intellij.psi.search.SearchScope;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;

public final class PsiSearchScopeUtil {
    public static final Key<SearchScope> USE_SCOPE_KEY = Key.create("search.use.scope");

    @Nullable
    public static SearchScope union(@Nullable SearchScope a2, @Nullable SearchScope b2) {
        return a2 == null ? b2 : (b2 == null ? a2 : a2.union(b2));
    }

    public static boolean isInScope(@NotNull SearchScope scope2, @NotNull PsiElement element) {
        if (scope2 == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(1);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope local = (LocalSearchScope)scope2;
            return PsiSearchScopeUtil.isInScope(local, element);
        }
        GlobalSearchScope globalScope = (GlobalSearchScope)scope2;
        return PsiSearchScopeUtil.isInScope(globalScope, element);
    }

    public static boolean isInScope(@NotNull GlobalSearchScope globalScope, @NotNull PsiElement element) {
        PsiFile file2;
        if (globalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(3);
        }
        if ((file2 = element.getContainingFile()) == null) {
            return true;
        }
        while (file2 != null) {
            if (globalScope.contains(BackedVirtualFile.getOriginFileIfBacked(file2.getOriginalFile().getViewProvider().getVirtualFile()))) {
                return true;
            }
            PsiElement context = file2.getContext();
            file2 = context == null ? null : context.getContainingFile();
        }
        return false;
    }

    public static boolean isInScope(@NotNull LocalSearchScope local, @NotNull PsiElement element) {
        PsiElement[] scopeElements;
        if (local == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement scopeElement : scopeElements = local.getScope()) {
            if (!PsiTreeUtil.isAncestor(scopeElement, element, false)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static SearchScope restrictScopeTo(@NotNull SearchScope originalScope, FileType ... fileTypes) {
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(6);
        }
        if (fileTypes == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(7);
        }
        if (originalScope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)originalScope, fileTypes);
            if (globalSearchScope == null) {
                PsiSearchScopeUtil.$$$reportNull$$$0(8);
            }
            return globalSearchScope;
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileTypes((LocalSearchScope)originalScope, fileTypes);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(9);
        }
        return localSearchScope;
    }

    @ApiStatus.Experimental
    @Contract(pure=true)
    @NotNull
    public static SearchScope restrictScopeToFileLanguage(@NotNull Project project, @NotNull SearchScope originalScope, @NotNull LanguageMatcher matcher) {
        if (project == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(10);
        }
        if (originalScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(11);
        }
        if (matcher == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(12);
        }
        if (originalScope instanceof GlobalSearchScope) {
            return new FileLanguageGlobalScope(project, (GlobalSearchScope)originalScope, matcher);
        }
        LocalSearchScope localSearchScope = LocalSearchScope.getScopeRestrictedByFileLanguage((LocalSearchScope)originalScope, matcher);
        if (localSearchScope == null) {
            PsiSearchScopeUtil.$$$reportNull$$$0(13);
        }
        return localSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalScope";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/search/PsiSearchScopeUtil";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeTo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "restrictScopeToFileLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeTo";
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restrictScopeToFileLanguage";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 8: 
            case 9: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

