/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.PsiKeyword;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.TreeElement;

public class ModifierListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(ModifierListElement.class);
    private static final HashMap<String, Integer> ourModifierToOrderMap = new HashMap();

    public ModifierListElement() {
        super(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor, Boolean before) {
        if (before == null && first2 == last2 && ElementType.KEYWORD_BIT_SET.contains(first2.getElementType())) {
            anchor = ModifierListElement.getDefaultAnchor((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(this), (PsiKeyword)SourceTreeToPsiMap.treeElementToPsi(first2));
            before = Boolean.TRUE;
        }
        return super.addInternal(first2, last2, anchor, before);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            ModifierListElement.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        if (child.getElementType() == JavaElementType.ANNOTATION) {
            return 250;
        }
        return 0;
    }

    @Nullable
    private static ASTNode getDefaultAnchor(PsiModifierList modifierList2, PsiKeyword modifier) {
        Integer order = ourModifierToOrderMap.get(modifier.getText());
        if (order == null) {
            return null;
        }
        boolean hasKeyword = false;
        for (ASTNode child = SourceTreeToPsiMap.psiToTreeNotNull(modifierList2).getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (ElementType.KEYWORD_BIT_SET.contains(child.getElementType())) {
                hasKeyword = true;
                Integer order1 = ourModifierToOrderMap.get(child.getText());
                if (order1 == null || order1 <= order) continue;
                return child;
            }
            if (child.getElementType() != JavaElementType.ANNOTATION || !hasKeyword) continue;
            return child;
        }
        return null;
    }

    static {
        ourModifierToOrderMap.put("public", 1);
        ourModifierToOrderMap.put("private", 1);
        ourModifierToOrderMap.put("protected", 1);
        ourModifierToOrderMap.put("static", 2);
        ourModifierToOrderMap.put("abstract", 2);
        ourModifierToOrderMap.put("final", 3);
        ourModifierToOrderMap.put("synchronized", 4);
        ourModifierToOrderMap.put("transient", 4);
        ourModifierToOrderMap.put("volatile", 4);
        ourModifierToOrderMap.put("native", 5);
        ourModifierToOrderMap.put("strictfp", 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/ModifierListElement", "getChildRole"));
    }
}

