/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.ChildRole;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaDocElementType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class EnumConstantElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance(EnumConstantElement.class);

    public EnumConstantElement() {
        super(ENUM_CONSTANT);
    }

    @Override
    public int getTextOffset() {
        return this.findChildByRole(9).getStartOffset();
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 7: {
                return PsiImplUtil.findDocComment(this);
            }
            case 9: {
                return this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 73: {
                return this.findChildByType(EXPRESSION_LIST);
            }
            case 70: {
                return this.findChildByType(ENUM_CONSTANT_INITIALIZER);
            }
            case 8: 
        }
        return this.findChildByType(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            EnumConstantElement.$$$reportNull$$$0(0);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i2 = child.getElementType();
        if (i2 == JavaDocElementType.DOC_COMMENT) {
            return this.getChildRole(child, 7);
        }
        if (i2 == JavaTokenType.C_STYLE_COMMENT || i2 == JavaTokenType.END_OF_LINE_COMMENT) {
            return 0;
        }
        if (i2 == JavaTokenType.IDENTIFIER) {
            return this.getChildRole(child, 9);
        }
        if (i2 == ENUM_CONSTANT_INITIALIZER) {
            return 70;
        }
        if (i2 == EXPRESSION_LIST) {
            return 73;
        }
        if (i2 == MODIFIER_LIST) {
            return 8;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/java/EnumConstantElement", "getChildRole"));
    }
}

