/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.ConstraintType;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpressionList;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.scope.MethodProcessorSetupFailedException;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.util.PsiScopesUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;

public class ProcessCandidateParameterTypeInferencePolicy
extends DefaultParameterTypeInferencePolicy {
    public static final ProcessCandidateParameterTypeInferencePolicy INSTANCE = new ProcessCandidateParameterTypeInferencePolicy();

    @Override
    public Pair<PsiType, ConstraintType> inferTypeConstraintFromCallContext(PsiExpression innerMethodCall, PsiExpressionList expressionList, @NotNull PsiCallExpression contextCall, PsiTypeParameter typeParameter) {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(0);
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        PsiElement parent2 = innerMethodCall;
        while (parent2.getParent() instanceof PsiParenthesizedExpression) {
            parent2 = parent2.getParent();
        }
        int i2 = ArrayUtilRt.find(expressions, parent2);
        if (i2 < 0) {
            return null;
        }
        PsiMethod owner = (PsiMethod)typeParameter.getOwner();
        if (owner == null) {
            return null;
        }
        try {
            JavaResolveResult[] results = this.getResults(contextCall, i2);
            PsiType innerReturnType = owner.getReturnType();
            for (JavaResolveResult result2 : results) {
                PsiSubstitutor substitutor2;
                Pair<PsiType, ConstraintType> constraint;
                if (result2 == null || (constraint = ProcessCandidateParameterTypeInferencePolicy.inferConstraint(typeParameter, innerMethodCall, i2, innerReturnType, result2, substitutor2 = this.getSubstitutor(contextCall, expressions, i2, result2))) == null) continue;
                return constraint;
            }
        }
        catch (MethodProcessorSetupFailedException ev) {
            return null;
        }
        return null;
    }

    protected PsiSubstitutor getSubstitutor(PsiCallExpression contextCall, PsiExpression[] expressions, int i2, JavaResolveResult result2) {
        if (result2 instanceof MethodCandidateInfo) {
            List<PsiExpression> leftArgs = this.getExpressions(expressions, i2);
            return ((MethodCandidateInfo)result2).inferSubstitutorFromArgs(this, leftArgs.toArray(PsiExpression.EMPTY_ARRAY));
        }
        return result2.getSubstitutor();
    }

    protected List<PsiExpression> getExpressions(PsiExpression[] expressions, int i2) {
        return Arrays.asList(expressions).subList(0, i2);
    }

    protected static Pair<PsiType, ConstraintType> inferConstraint(PsiTypeParameter typeParameter, PsiExpression innerMethodCall, int parameterIdx, PsiType innerReturnType, JavaResolveResult result2, PsiSubstitutor substitutor2) {
        PsiElement element = result2.getElement();
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter parameter = null;
            if (parameters.length > parameterIdx) {
                parameter = parameters[parameterIdx];
            } else if (method.isVarArgs()) {
                parameter = parameters[parameters.length - 1];
            }
            if (parameter != null) {
                PsiParameter finalParameter = parameter;
                PsiType type2 = PsiResolveHelper.ourGuard.doPreventingRecursion(innerMethodCall, true, () -> substitutor2.substitute(finalParameter.getType()));
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel(finalParameter);
                Pair<PsiType, ConstraintType> constraint = new PsiOldInferenceHelper(element.getManager()).getSubstitutionForTypeParameterConstraint(typeParameter, innerReturnType, type2, false, languageLevel);
                if (constraint != null) {
                    return constraint;
                }
            }
        }
        return null;
    }

    protected JavaResolveResult @NotNull [] getResults(@NotNull PsiCallExpression contextCall, int exprIdx) throws MethodProcessorSetupFailedException {
        if (contextCall == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(1);
        }
        PsiFile containingFile = contextCall.getContainingFile();
        MethodCandidatesProcessor processor = new MethodCandidatesProcessor(contextCall, containingFile);
        PsiScopesUtil.setupAndRunProcessor(processor, contextCall, false);
        JavaResolveResult[] javaResolveResultArray = processor.getResult();
        if (javaResolveResultArray == null) {
            ProcessCandidateParameterTypeInferencePolicy.$$$reportNull$$$0(2);
        }
        return javaResolveResultArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextCall";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/ProcessCandidateParameterTypeInferencePolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeConstraintFromCallContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getResults";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

