/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.java.JavaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.application.ModalityState;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyKey;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.FileViewProvider;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaResolveResult;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportList;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiImportStaticStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaCodeReferenceElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaModule;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNamedElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackageStatement;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;
import org.jetbrains.kotlin.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaPsiImplementationHelper;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiFileEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.Constants;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiFileImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.SourceTreeToPsiMap;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.SymbolCollectingProcessor;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.scope.DelegatingScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.ElementClassHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.JavaScopeProcessorEvent;
import org.jetbrains.kotlin.com.intellij.psi.scope.NameHint;
import org.jetbrains.kotlin.com.intellij.psi.scope.PsiScopeProcessor;
import org.jetbrains.kotlin.com.intellij.psi.scope.processor.MethodsProcessor;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.FileContentUtilCore;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.JBIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.MostlySingularMultiMap;
import org.jetbrains.kotlin.com.intellij.util.containers.MultiMap;
import org.jetbrains.kotlin.com.intellij.util.execution.ParametersListUtil;

public abstract class PsiJavaFileBaseImpl
extends PsiFileImpl
implements PsiJavaFile {
    private static final Logger LOG = Logger.getInstance(PsiJavaFileBaseImpl.class);
    private static final String[] IMPLICIT_IMPORTS = new String[]{"java.lang"};
    private final CachedValue<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> myResolveCache;
    private volatile String myPackageName;
    private static final NotNullLazyKey<LanguageLevel, PsiJavaFileBaseImpl> LANGUAGE_LEVEL_KEY = NotNullLazyKey.createLazyKey("LANGUAGE_LEVEL", file2 -> file2.getLanguageLevelInner());
    private static final Key<String> SHEBANG_SOURCE_LEVEL = Key.create("SHEBANG_SOURCE_LEVEL");

    protected PsiJavaFileBaseImpl(@NotNull IElementType elementType, @NotNull IElementType contentElementType, @NotNull FileViewProvider viewProvider) {
        if (elementType == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(0);
        }
        if (contentElementType == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(1);
        }
        if (viewProvider == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(2);
        }
        super(elementType, contentElementType, viewProvider);
        this.myResolveCache = CachedValuesManager.getManager(this.myManager.getProject()).createCachedValue(new MyCacheBuilder(this), false);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myPackageName = null;
    }

    @Override
    public PsiClass @NotNull [] getClasses() {
        StubElement<?> stub = this.getGreenStub();
        if (stub != null) {
            PsiClass[] psiClassArray = (PsiClass[])stub.getChildrenByType(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
            if (psiClassArray == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(3);
            }
            return psiClassArray;
        }
        PsiClass[] psiClassArray = (PsiClass[])this.calcTreeElement().getChildrenAsPsiElements(Constants.CLASS_BIT_SET, PsiClass.ARRAY_FACTORY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(4);
        }
        return psiClassArray;
    }

    @Override
    public PsiPackageStatement getPackageStatement() {
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.PACKAGE_STATEMENT);
        return node != null ? (PsiPackageStatement)node.getPsi() : null;
    }

    @Override
    @NotNull
    public String getPackageName() {
        PsiJavaFileStub stub = (PsiJavaFileStub)this.getGreenStub();
        if (stub != null) {
            String string2 = stub.getPackageName();
            if (string2 == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(5);
            }
            return string2;
        }
        String name2 = this.myPackageName;
        if (name2 == null) {
            PsiPackageStatement statement = this.getPackageStatement();
            name2 = statement == null ? "" : statement.getPackageName();
            this.myPackageName = name2;
        }
        String string3 = name2;
        if (string3 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(6);
        }
        return string3;
    }

    @Override
    public void setPackageName(@NotNull String packageName2) throws IncorrectOperationException {
        if (packageName2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(7);
        }
        if (PsiUtil.isModuleFile(this)) {
            throw new IncorrectOperationException("Cannot set package name for module declarations");
        }
        PsiPackageStatement packageStatement = this.getPackageStatement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
        if (packageStatement != null) {
            if (!packageName2.isEmpty()) {
                PsiJavaCodeReferenceElement reference2 = packageStatement.getPackageReference();
                reference2.replace(factory.createPackageStatement(packageName2).getPackageReference());
            } else {
                packageStatement.delete();
            }
        } else if (!packageName2.isEmpty()) {
            this.cleanupBrokenPackageKeyword();
            PsiElement anchor = this.getFirstChild();
            if ("package-info.java".equals(this.getName())) {
                String text;
                anchor = this.getImportList();
                assert (anchor != null);
                PsiElement prev = anchor.getPrevSibling();
                if (prev instanceof PsiComment && (text = prev.getText().trim()).startsWith("/*") && !text.endsWith("*/")) {
                    prev.replace(factory.createCommentFromText(text + (StringUtil.containsLineBreak(text) ? "\n*/" : " */"), prev));
                }
            }
            this.addBefore(factory.createPackageStatement(packageName2), anchor);
        }
    }

    private void cleanupBrokenPackageKeyword() {
        PsiElement child = this.getFirstChild();
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment || child instanceof PsiErrorElement) {
            if (child instanceof PsiErrorElement && child.getFirstChild() != null && child.getFirstChild().textMatches("package")) {
                child.delete();
                break;
            }
            child = child.getNextSibling();
        }
    }

    @Override
    public PsiImportList getImportList() {
        StubElement<?> stub = this.getGreenStub();
        if (stub != null) {
            PsiImportList[] nodes = (PsiImportList[])stub.getChildrenByType(JavaStubElementTypes.IMPORT_LIST, PsiImportList.ARRAY_FACTORY);
            if (nodes.length == 1) {
                return nodes[0];
            }
            assert (nodes.length == 0);
            return null;
        }
        ASTNode node = this.calcTreeElement().findChildByType(JavaElementType.IMPORT_LIST);
        return (PsiImportList)SourceTreeToPsiMap.treeElementToPsi(node);
    }

    @Override
    public PsiElement @NotNull [] getOnDemandImports(boolean includeImplicit, boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(8);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiElement> array = new ArrayList<PsiElement>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            array.add(resolved);
        }
        if (includeImplicit) {
            PsiJavaCodeReferenceElement[] implicitRefs;
            for (PsiJavaCodeReferenceElement implicitRef : implicitRefs = this.getImplicitlyImportedPackageReferences()) {
                PsiElement resolved = implicitRef.resolve();
                if (resolved == null) continue;
                array.add(resolved);
            }
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(array);
        if (psiElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @Override
    public PsiClass @NotNull [] getSingleClassImports(boolean checkIncludes) {
        PsiImportStatement[] statements;
        PsiImportList importList = this.getImportList();
        if (importList == null) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(10);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> array = new ArrayList<PsiClass>();
        for (PsiImportStatement statement : statements = importList.getImportStatements()) {
            PsiElement ref;
            if (statement.isOnDemand() || !((ref = statement.resolve()) instanceof PsiClass)) continue;
            array.add((PsiClass)ref);
        }
        PsiClass[] psiClassArray = array.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(11);
        }
        return psiClassArray;
    }

    @Override
    public PsiJavaCodeReferenceElement findImportReferenceTo(@NotNull PsiClass aClass) {
        PsiImportList importList;
        if (aClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(12);
        }
        if ((importList = this.getImportList()) != null) {
            PsiImportStatement[] statements;
            for (PsiImportStatement statement : statements = importList.getImportStatements()) {
                PsiElement ref;
                if (statement.isOnDemand() || (ref = statement.resolve()) == null || !this.getManager().areElementsEquivalent(ref, aClass)) continue;
                return statement.getImportReference();
            }
        }
        return null;
    }

    @Override
    public String @NotNull [] getImplicitlyImportedPackages() {
        if (IMPLICIT_IMPORTS == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(13);
        }
        return IMPLICIT_IMPORTS;
    }

    @Override
    public PsiJavaCodeReferenceElement @NotNull [] getImplicitlyImportedPackageReferences() {
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = PsiImplUtil.namesToPackageReferences(this.myManager, IMPLICIT_IMPORTS);
        if (psiJavaCodeReferenceElementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(14);
        }
        return psiJavaCodeReferenceElementArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        Iterable<SymbolCollectingProcessor.ResultWithContext> iterable;
        NameHint nameHint;
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(16);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(17);
        }
        String name2 = (nameHint = processor.getHint(NameHint.KEY)) != null ? nameHint.getName(state) : null;
        Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated = this.getEnumeratedDeclarations();
        Iterable<SymbolCollectingProcessor.ResultWithContext> iterable2 = iterable = name2 != null ? explicitlyEnumerated.get(name2) : ContainerUtil.concat(explicitlyEnumerated.values().toArray(new Iterable[0]));
        if (iterable != null && !ContainerUtil.process(iterable, new MyResolveCacheProcessor(state, processor))) {
            return false;
        }
        if (processor instanceof ClassResolverProcessor && (this.getUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING) == Boolean.TRUE || this.myResolveCache.hasUpToDateValue()) && !PsiUtil.isInsideJavadocComment(place)) {
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> cache2 = this.myResolveCache.getValue();
            MyResolveCacheProcessor cacheProcessor = new MyResolveCacheProcessor(state, processor);
            return name2 != null ? cache2.processForKey(name2, cacheProcessor) : cache2.processAllValues(cacheProcessor);
        }
        return this.processOnDemandPackages(state, place, processor);
    }

    @NotNull
    private Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> getEnumeratedDeclarations() {
        Map map2 = (Map)CachedValuesManager.getCachedValue(this, () -> {
            JavaPsiFacade psiFacade;
            PsiClass aClass;
            MultiMap<String, PsiClass> ownClasses = MultiMap.create();
            MultiMap<String, PsiElement> typeImports = MultiMap.create();
            MultiMap<String, PsiElement> staticImports = MultiMap.create();
            for (PsiClass psiClass : this.getClasses()) {
                String name2 = psiClass.getName();
                if (name2 == null) continue;
                ownClasses.putValue(name2, psiClass);
            }
            for (PsiElement psiElement : this.getImportStatements()) {
                String qName;
                if (psiElement.isOnDemand() || (qName = psiElement.getQualifiedName()) == null) continue;
                typeImports.putValue(StringUtil.getShortName(qName), psiElement);
            }
            for (PsiElement psiElement : this.getImportStaticStatements()) {
                String name2 = psiElement.getReferenceName();
                if (name2 == null) continue;
                staticImports.putValue(name2, psiElement);
            }
            if (PsiUtil.getLanguageLevel(this).isAtLeast(LanguageLevel.JDK_21_PREVIEW) && (aClass = (psiFacade = JavaPsiFacade.getInstance(this.getProject())).findClass("java.lang.StringTemplate", this.getResolveScope())) != null) {
                PsiImportStaticStatement importStaticStatement = psiFacade.getElementFactory().createImportStaticStatement(aClass, "STR");
                staticImports.putValue("STR", importStaticStatement);
            }
            LinkedHashMap result2 = new LinkedHashMap();
            for (String name3 : ContainerUtil.newLinkedHashSet(ContainerUtil.concat(ownClasses.keySet(), typeImports.keySet(), staticImports.keySet()))) {
                NotNullLazyValue<Iterable> notNullLazyValue = NotNullLazyValue.volatileLazy(() -> PsiJavaFileBaseImpl.findExplicitDeclarations(name3, ownClasses, typeImports, staticImports));
                result2.put(name3, () -> ((Iterable)lazy.getValue()).iterator());
            }
            return CachedValueProvider.Result.create(result2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (map2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @NotNull
    private static Iterable<SymbolCollectingProcessor.ResultWithContext> findExplicitDeclarations(@NotNull String name2, @NotNull MultiMap<String, PsiClass> ownClasses, @NotNull MultiMap<String, PsiImportStatement> typeImports, @NotNull MultiMap<String, PsiImportStaticStatement> staticImports) {
        if (name2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(19);
        }
        if (ownClasses == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(20);
        }
        if (typeImports == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(21);
        }
        if (staticImports == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(22);
        }
        ArrayList<SymbolCollectingProcessor.ResultWithContext> result2 = new ArrayList<SymbolCollectingProcessor.ResultWithContext>();
        for (PsiClass psiClass : ownClasses.get(name2)) {
            result2.add(new SymbolCollectingProcessor.ResultWithContext(psiClass, null));
        }
        for (PsiImportStatement psiImportStatement : typeImports.get(name2)) {
            PsiElement target = psiImportStatement.resolve();
            if (!(target instanceof PsiClass)) continue;
            result2.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)target, psiImportStatement));
        }
        for (PsiImportStaticStatement psiImportStaticStatement : staticImports.get(name2)) {
            PsiJavaCodeReferenceElement reference2 = psiImportStaticStatement.getImportReference();
            if (reference2 == null) continue;
            for (JavaResolveResult result1 : reference2.multiResolve(false)) {
                PsiElement element = result1.getElement();
                if (!(element instanceof PsiNamedElement)) continue;
                result2.add(new SymbolCollectingProcessor.ResultWithContext((PsiNamedElement)element, psiImportStaticStatement));
            }
        }
        JBIterable<SymbolCollectingProcessor.ResultWithContext> jBIterable = JBIterable.from(result2).unique(SymbolCollectingProcessor.ResultWithContext::getElement);
        if (jBIterable == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(23);
        }
        return jBIterable;
    }

    private boolean processOnDemandPackages(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        ElementClassHint classHint;
        boolean shouldProcessClasses;
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(24);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(25);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(26);
        }
        boolean bl = shouldProcessClasses = (classHint = processor.getHint(ElementClassHint.KEY)) == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS);
        if (shouldProcessClasses && !this.processCurrentPackage(state, place, processor)) {
            return false;
        }
        if (!this.processOnDemandStaticImports(state, new StaticImportFilteringProcessor(this.getEnumeratedDeclarations(), processor))) {
            return false;
        }
        if (shouldProcessClasses && !this.processOnDemandTypeImports(state, place, processor)) {
            return false;
        }
        return !shouldProcessClasses || this.processImplicitImports(state, place, processor);
    }

    private PsiImportStaticStatement @NotNull [] getImportStaticStatements() {
        PsiImportStaticStatement[] psiImportStaticStatementArray = this.getImportList() != null ? this.getImportList().getImportStaticStatements() : PsiImportStaticStatement.EMPTY_ARRAY;
        if (psiImportStaticStatementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(27);
        }
        return psiImportStaticStatementArray;
    }

    private PsiImportStatement @NotNull [] getImportStatements() {
        PsiImportStatement[] psiImportStatementArray = this.getImportList() != null ? this.getImportList().getImportStatements() : PsiImportStatement.EMPTY_ARRAY;
        if (psiImportStatementArray == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(28);
        }
        return psiImportStatementArray;
    }

    private boolean processCurrentPackage(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(29);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(30);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(31);
        }
        processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        PsiPackage aPackage = JavaPsiFacade.getInstance(this.myManager.getProject()).findPackage(this.getPackageName());
        return aPackage == null || PsiJavaFileBaseImpl.processPackageDeclarations(state, place, aPackage, processor);
    }

    private boolean processOnDemandTypeImports(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(32);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(34);
        }
        for (PsiImportStatement statement : this.getImportStatements()) {
            PsiElement resolved;
            if (!statement.isOnDemand() || (resolved = statement.resolve()) == null) continue;
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, statement);
            if (PsiJavaFileBaseImpl.processOnDemandTarget(resolved, state, place, processor)) continue;
            return false;
        }
        return true;
    }

    private boolean processOnDemandStaticImports(@NotNull ResolveState state, @NotNull StaticImportFilteringProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(36);
        }
        for (PsiImportStaticStatement importStaticStatement : this.getImportStaticStatements()) {
            PsiClass targetElement;
            if (!importStaticStatement.isOnDemand() || (targetElement = importStaticStatement.resolveTargetClass()) == null) continue;
            processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, importStaticStatement);
            if (PsiClassImplUtil.processAllMembersWithoutSubstitutors(targetElement, processor, state)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitImports(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(37);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(39);
        }
        processor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, null);
        for (PsiJavaCodeReferenceElement aImplicitlyImported : this.getImplicitlyImportedPackageReferences()) {
            PsiElement resolved = aImplicitlyImported.resolve();
            if (resolved == null || PsiJavaFileBaseImpl.processOnDemandTarget(resolved, state, place, processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean processPackageDeclarations(@NotNull ResolveState state, @NotNull PsiElement place, @NotNull PsiPackage aPackage, @NotNull PsiScopeProcessor processor) {
        if (state == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(40);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(41);
        }
        if (aPackage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(42);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(43);
        }
        if (!aPackage.getQualifiedName().isEmpty()) {
            processor = new DelegatingScopeProcessor(processor){

                @Override
                @Nullable
                public <T> T getHint(@NotNull Key<T> hintKey) {
                    if (hintKey == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hintKey == ElementClassHint.KEY) {
                        return (T)((ElementClassHint)kind -> kind == ElementClassHint.DeclarationKind.CLASS);
                    }
                    return super.getHint(hintKey);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$1", "getHint"));
                }
            };
        }
        return aPackage.processDeclarations(processor, state, null, place);
    }

    @NotNull
    private static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass containingClass) {
        if (containingClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(44);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(containingClass.getProject()).createRawSubstitutor(containingClass);
        if (psiSubstitutor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(45);
        }
        return psiSubstitutor;
    }

    private static boolean processOnDemandTarget(@NotNull PsiElement target, @NotNull ResolveState substitutor2, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (target == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(46);
        }
        if (substitutor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(47);
        }
        if (place == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(48);
        }
        if (processor == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(49);
        }
        if (target instanceof PsiPackage) {
            return PsiJavaFileBaseImpl.processPackageDeclarations(substitutor2, place, (PsiPackage)target, processor);
        }
        if (target instanceof PsiClass) {
            PsiClass[] inners = ((PsiClass)target).getInnerClasses();
            if (((PsiClass)target).hasTypeParameters()) {
                substitutor2 = substitutor2.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor((PsiClass)target));
            }
            for (PsiClass inner : inners) {
                if (processor.execute(inner, substitutor2)) continue;
                return false;
            }
        } else {
            LOG.error("Unexpected target type: " + target);
        }
        return true;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(50);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitJavaFile(this);
        } else {
            visitor2.visitFile(this);
        }
    }

    @Override
    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(51);
        }
        return javaLanguage;
    }

    @Override
    public boolean importClass(@NotNull PsiClass aClass) {
        if (aClass == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(52);
        }
        return JavaCodeStyleManager.getInstance(this.getProject()).addImport(this, aClass);
    }

    @Override
    @NotNull
    public LanguageLevel getLanguageLevel() {
        LanguageLevel languageLevel = LANGUAGE_LEVEL_KEY.getValue(this);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(53);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public PsiJavaModule getModuleDeclaration() {
        return null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.putUserData(LANGUAGE_LEVEL_KEY, null);
    }

    @Override
    public void setOriginalFile(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(54);
        }
        super.setOriginalFile(originalFile);
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private LanguageLevel getLanguageLevelInner() {
        VirtualFile virtualFile;
        block13: {
            LanguageLevel languageLevel;
            if (this.myOriginalFile instanceof PsiJavaFile) {
                LanguageLevel languageLevel2 = ((PsiJavaFile)this.myOriginalFile).getLanguageLevel();
                if (languageLevel2 == null) {
                    PsiJavaFileBaseImpl.$$$reportNull$$$0(55);
                }
                return languageLevel2;
            }
            LanguageLevel forcedLanguageLevel = this.getUserData(PsiUtil.FILE_LANGUAGE_LEVEL_KEY);
            if (forcedLanguageLevel != null) {
                LanguageLevel languageLevel3 = forcedLanguageLevel;
                if (languageLevel3 == null) {
                    PsiJavaFileBaseImpl.$$$reportNull$$$0(56);
                }
                return languageLevel3;
            }
            virtualFile = this.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = this.getViewProvider().getVirtualFile();
            }
            String sourceLevel = null;
            try {
                LanguageLevel sheBangLevel;
                List<String> params;
                int srcIdx;
                CharSequence line;
                CharSequence contents = this.getViewProvider().getContents();
                int lineBound = Strings.indexOf(contents, "\n");
                CharSequence charSequence = line = lineBound > 0 ? contents.subSequence(0, lineBound) : contents;
                if (!Strings.startsWith(line, 0, "#!") || (srcIdx = (params = ParametersListUtil.parse(line.toString())).indexOf("--source")) <= 0 || srcIdx + 1 >= params.size() || (sheBangLevel = LanguageLevel.parse(sourceLevel = params.get(srcIdx + 1))) == null) break block13;
                LanguageLevel languageLevel4 = sheBangLevel;
                languageLevel = languageLevel4;
            }
            catch (Throwable file2) {
                break block13;
            }
            finally {
                if (!Objects.equals(sourceLevel, virtualFile.getUserData(SHEBANG_SOURCE_LEVEL)) && virtualFile.isInLocalFileSystem()) {
                    virtualFile.putUserData(SHEBANG_SOURCE_LEVEL, sourceLevel);
                    VirtualFile file3 = virtualFile;
                    ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles(file3), ModalityState.nonModal(), ApplicationManager.getApplication().getDisposed());
                }
            }
            if (languageLevel == null) {
                PsiJavaFileBaseImpl.$$$reportNull$$$0(57);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = JavaPsiImplementationHelper.getInstance(this.getProject()).getEffectiveLanguageLevel(virtualFile);
        if (languageLevel == null) {
            PsiJavaFileBaseImpl.$$$reportNull$$$0(58);
        }
        return languageLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 45: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 45: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentElementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 45: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 12: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: 
            case 26: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 43: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 24: 
            case 29: 
            case 32: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 17: 
            case 25: 
            case 30: 
            case 33: 
            case 38: 
            case 41: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownClasses";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeImports";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticImports";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPackage";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnDemandImports";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleClassImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitlyImportedPackageReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnumeratedDeclarations";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "findExplicitDeclarations";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStaticStatements";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportStatements";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevel";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 45: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setPackageName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findImportReferenceTo";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findExplicitDeclarations";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandPackages";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processCurrentPackage";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandTypeImports";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandStaticImports";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitImports";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDeclarations";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processOnDemandTarget";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "importClass";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setOriginalFile";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 27: 
            case 28: 
            case 45: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCacheBuilder
    implements CachedValueProvider<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> {
        @NotNull
        private final PsiJavaFileBaseImpl myFile;

        MyCacheBuilder(@NotNull PsiJavaFileBaseImpl file2) {
            if (file2 == null) {
                MyCacheBuilder.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        @Override
        @NotNull
        public CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> compute() {
            SymbolCollectingProcessor p2 = new SymbolCollectingProcessor();
            this.myFile.processOnDemandPackages(ResolveState.initial(), this.myFile, p2);
            MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext> results = p2.getResults();
            CachedValueProvider.Result<MostlySingularMultiMap<String, SymbolCollectingProcessor.ResultWithContext>> result2 = CachedValueProvider.Result.create(results, PsiModificationTracker.MODIFICATION_COUNT, this.myFile);
            if (result2 == null) {
                MyCacheBuilder.$$$reportNull$$$0(1);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyCacheBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyCacheBuilder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyResolveCacheProcessor
    implements Processor<SymbolCollectingProcessor.ResultWithContext> {
        private final PsiScopeProcessor myProcessor;
        private final ResolveState myState;

        MyResolveCacheProcessor(@NotNull ResolveState state, @NotNull PsiScopeProcessor processor) {
            if (state == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(0);
            }
            if (processor == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(1);
            }
            this.myProcessor = processor;
            this.myState = state;
        }

        @Override
        public boolean process(@NotNull SymbolCollectingProcessor.ResultWithContext result2) {
            PsiClass containingClass;
            if (result2 == null) {
                MyResolveCacheProcessor.$$$reportNull$$$0(2);
            }
            PsiElement context = result2.getFileContext();
            this.myProcessor.handleEvent(JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT, context);
            PsiNamedElement element = result2.getElement();
            if (element instanceof PsiClass && context instanceof PsiImportStatement && (containingClass = ((PsiClass)element).getContainingClass()) != null && containingClass.hasTypeParameters()) {
                return this.myProcessor.execute(element, this.myState.put(PsiSubstitutor.KEY, PsiJavaFileBaseImpl.createRawSubstitutor(containingClass)));
            }
            return this.myProcessor.execute(element, this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$MyResolveCacheProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StaticImportFilteringProcessor
    extends DelegatingScopeProcessor {
        private final Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> myExplicitlyEnumerated;
        private final Collection<PsiElement> myCollectedElements;

        StaticImportFilteringProcessor(@NotNull Map<String, Iterable<SymbolCollectingProcessor.ResultWithContext>> explicitlyEnumerated, @NotNull PsiScopeProcessor delegate2) {
            if (explicitlyEnumerated == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(0);
            }
            if (delegate2 == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(1);
            }
            super(delegate2);
            this.myCollectedElements = new HashSet<PsiElement>();
            this.myExplicitlyEnumerated = explicitlyEnumerated;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                StaticImportFilteringProcessor.$$$reportNull$$$0(3);
            }
            if (element instanceof PsiModifierListOwner && ((PsiModifierListOwner)element).hasModifierProperty("static")) {
                PsiScopeProcessor delegate2 = this.getDelegate();
                if (element instanceof PsiNamedElement) {
                    PsiElement currentFileContext;
                    PsiClass containingClass;
                    String name2 = ((PsiNamedElement)element).getName();
                    Iterable<SymbolCollectingProcessor.ResultWithContext> shadowing = this.myExplicitlyEnumerated.get(name2);
                    if (shadowing != null && ContainerUtil.exists(shadowing, rwc -> StaticImportFilteringProcessor.hasSameDeclarationKind(element, rwc.getElement()))) {
                        return true;
                    }
                    if (delegate2 instanceof MethodsProcessor && element instanceof PsiMethod && (containingClass = ((PsiMethod)element).getContainingClass()) != null && containingClass.isInterface() && (currentFileContext = ((MethodsProcessor)delegate2).getCurrentFileContext()) instanceof PsiImportStaticStatement && ((PsiImportStaticStatement)currentFileContext).isOnDemand() && !containingClass.isEquivalentTo(((PsiImportStaticStatement)currentFileContext).resolveTargetClass())) {
                        return true;
                    }
                }
                if (this.myCollectedElements.add(element)) {
                    return delegate2.execute(element, state);
                }
            }
            return true;
        }

        private static boolean hasSameDeclarationKind(PsiElement e1, PsiElement e2) {
            return e1 instanceof PsiClass ? e2 instanceof PsiClass : (e1 instanceof PsiMethod ? e2 instanceof PsiMethod : e2 instanceof PsiField);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "explicitlyEnumerated";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/PsiJavaFileBaseImpl$StaticImportFilteringProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

