/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.JavaElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayType;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassObjectAccessExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiEnumConstant;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodCallExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPackage;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeCastExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiVariableEx;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiClassReferenceType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.ClassUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.ConstantEvaluationOverflowException;
import org.jetbrains.kotlin.com.intellij.psi.util.ConstantExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.Interner;

final class ConstantExpressionVisitor
extends JavaElementVisitor
implements PsiConstantEvaluationHelper.AuxEvaluator {
    private final Interner<String> myInterner = Interner.createStringInterner();
    private Set<PsiVariable> myVisitedVars;
    private final Map<PsiElement, Object> myCachedValues = new HashMap<PsiElement, Object>();
    private final boolean myThrowExceptionOnOverflow;
    private Object myResult;
    private final PsiConstantEvaluationHelper.AuxEvaluator myAuxEvaluator;

    ConstantExpressionVisitor(Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        this.myVisitedVars = visitedVars;
        this.myThrowExceptionOnOverflow = throwExceptionOnOverflow;
        this.myAuxEvaluator = auxEvaluator;
    }

    Object handle(PsiElement element) {
        this.myResult = null;
        element.accept(this);
        this.store(element, this.myResult);
        return this.myResult;
    }

    private Object getStoredValue(PsiElement element) {
        return this.myCachedValues.remove(element);
    }

    void store(PsiElement element, Object value2) {
        this.myCachedValues.put(element, value2);
    }

    @Override
    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
        Object value2;
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.myResult = (value2 = expression2.getValue()) instanceof String ? this.myInterner.intern((String)value2) : value2;
    }

    @Override
    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(1);
        }
        PsiTypeElement castTypeElement = expression2.getCastType();
        PsiExpression operand = expression2.getOperand();
        Object opValue = this.getStoredValue(operand);
        if (castTypeElement == null || opValue == null) {
            this.myResult = null;
            return;
        }
        PsiType castType = castTypeElement.getType();
        if (!(castType instanceof PsiPrimitiveType) && !castType.equalsToText("java.lang.String")) {
            this.myResult = null;
            return;
        }
        this.myResult = ConstantExpressionUtil.computeCastTo(opValue, castType);
    }

    @Override
    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(2);
        }
        Object then = this.getStoredValue(expression2.getThenExpression());
        Object els = this.getStoredValue(expression2.getElseExpression());
        Object condition = this.getStoredValue(expression2.getCondition());
        if (then == null || els == null) {
            this.myResult = null;
            return;
        }
        Object value2 = null;
        if (condition instanceof Boolean) {
            value2 = (Boolean)condition != false ? then : els;
        }
        this.myResult = value2;
    }

    @Override
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
        PsiExpression[] operands;
        Object lValue;
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(3);
        }
        if ((lValue = this.getStoredValue((operands = expression2.getOperands())[0])) == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        for (int i2 = 1; i2 < operands.length; ++i2) {
            PsiExpression operand = operands[i2];
            Object rValue = this.getStoredValue(operand);
            if (rValue == null) {
                this.myResult = null;
                break;
            }
            this.myResult = this.compute(lValue, rValue, tokenType, expression2);
            if (this.myResult == null) break;
            lValue = this.myResult;
        }
        if (this.myResult instanceof String) {
            this.myResult = this.myInterner.intern((String)this.myResult);
        }
    }

    private Object compute(Object lOperandValue, Object rOperandValue, IElementType tokenType, PsiPolyadicExpression expression2) {
        Object value2 = null;
        if (tokenType == JavaTokenType.PLUS) {
            if (lOperandValue instanceof String || rOperandValue instanceof String) {
                String l = ConstantExpressionVisitor.computeValueToString(lOperandValue);
                String r = ConstantExpressionVisitor.computeValueToString(rOperandValue);
                value2 = l + r;
            } else {
                if (lOperandValue instanceof Character) {
                    lOperandValue = (int)((Character)lOperandValue).charValue();
                }
                if (rOperandValue instanceof Character) {
                    rOperandValue = (int)((Character)rOperandValue).charValue();
                }
                if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                    if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                        value2 = ((Number)lOperandValue).doubleValue() + ((Number)rOperandValue).doubleValue();
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                    } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                        value2 = Float.valueOf(((Number)lOperandValue).floatValue() + ((Number)rOperandValue).floatValue());
                        this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                    } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                        long r;
                        long l = ((Number)lOperandValue).longValue();
                        value2 = l + (r = ((Number)rOperandValue).longValue());
                        this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r >= 0L, expression2);
                    } else {
                        int r;
                        int l = ((Number)lOperandValue).intValue();
                        value2 = l + (r = ((Number)rOperandValue).intValue());
                        this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r >= 0, expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.MINUS) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = ((Number)lOperandValue).doubleValue() - ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = Float.valueOf(((Number)lOperandValue).floatValue() - ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r;
                    long l = ((Number)lOperandValue).longValue();
                    value2 = l - (r = ((Number)rOperandValue).longValue());
                    this.checkAdditionOverflow((Long)value2 >= 0L, l >= 0L, r < 0L, expression2);
                } else {
                    int r;
                    int l = ((Number)lOperandValue).intValue();
                    value2 = l - (r = ((Number)rOperandValue).intValue());
                    this.checkAdditionOverflow((Integer)value2 >= 0, l >= 0, r < 0, expression2);
                }
            }
        } else if (tokenType == JavaTokenType.ANDAND) {
            if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            } else if (lOperandValue instanceof Boolean && !((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && !((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.FALSE;
            }
        } else if (tokenType == JavaTokenType.OROR) {
            if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            } else if (lOperandValue instanceof Boolean && ((Boolean)lOperandValue).booleanValue() || rOperandValue instanceof Boolean && ((Boolean)rOperandValue).booleanValue()) {
                value2 = Boolean.TRUE;
            }
        } else if (tokenType == JavaTokenType.LT || tokenType == JavaTokenType.LE || tokenType == JavaTokenType.GT || tokenType == JavaTokenType.GE) {
            value2 = ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.EQEQ || tokenType == JavaTokenType.NE) {
            value2 = ConstantExpressionVisitor.handleEqualityComparison(lOperandValue, rOperandValue, tokenType);
        } else if (tokenType == JavaTokenType.ASTERISK) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = ((Number)lOperandValue).doubleValue() * ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = Float.valueOf(((Number)lOperandValue).floatValue() * ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow((Long)value2, l, r, expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l * r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, r, expression2);
                }
            }
        } else if (tokenType == JavaTokenType.DIV) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = ((Number)lOperandValue).doubleValue() / ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = Float.valueOf(((Number)lOperandValue).floatValue() / ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long r = ((Number)rOperandValue).longValue();
                    long l = ((Number)lOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression2);
                    value2 = r == 0L ? null : Long.valueOf(l / r);
                } else {
                    int r = ((Number)rOperandValue).intValue();
                    int l = ((Number)lOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l / r);
                }
            }
        } else if (tokenType == JavaTokenType.PERC) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (lOperandValue instanceof Number && rOperandValue instanceof Number) {
                double rVal = ((Number)rOperandValue).doubleValue();
                if (this.myThrowExceptionOnOverflow && rVal == 0.0) {
                    throw new ConstantEvaluationOverflowException(expression2);
                }
                if (lOperandValue instanceof Double || rOperandValue instanceof Double) {
                    value2 = ((Number)lOperandValue).doubleValue() % ((Number)rOperandValue).doubleValue();
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Float || rOperandValue instanceof Float) {
                    value2 = Float.valueOf(((Number)lOperandValue).floatValue() % ((Number)rOperandValue).floatValue());
                    this.checkRealNumberOverflow(value2, lOperandValue, rOperandValue, expression2);
                } else if (lOperandValue instanceof Long || rOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    this.checkDivisionOverflow(l, r, Long.MIN_VALUE, expression2);
                    value2 = r == 0L ? null : Long.valueOf(l % r);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    this.checkDivisionOverflow(l, r, Integer.MIN_VALUE, expression2);
                    value2 = r == 0 ? null : Integer.valueOf(l % r);
                }
            }
        } else if (tokenType == JavaTokenType.LTLT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                if (lOperandValue instanceof Long) {
                    long l = ((Number)lOperandValue).longValue();
                    long r = ((Number)rOperandValue).longValue();
                    value2 = l << (int)r;
                    this.checkMultiplicationOverflow((Long)value2, l, (long)Math.pow(2.0, r & 0x3FL), expression2);
                } else {
                    int l = ((Number)lOperandValue).intValue();
                    int r = ((Number)rOperandValue).intValue();
                    value2 = l << r;
                    this.checkMultiplicationOverflow(((Integer)value2).intValue(), l, (long)Math.pow(2.0, r & 0x1F), expression2);
                }
            }
        } else if (tokenType == JavaTokenType.GTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.GTGTGT) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() >>> (int)((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() >>> ((Number)rOperandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.AND) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() & ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() & ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false && (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.OR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() | ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() | ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue != false || (Boolean)rOperandValue != false;
            }
        } else if (tokenType == JavaTokenType.XOR) {
            if (lOperandValue instanceof Character) {
                lOperandValue = (int)((Character)lOperandValue).charValue();
            }
            if (rOperandValue instanceof Character) {
                rOperandValue = (int)((Character)rOperandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(lOperandValue) && ConstantExpressionVisitor.isIntegral(rOperandValue)) {
                value2 = lOperandValue instanceof Long || rOperandValue instanceof Long ? (Number)(((Number)lOperandValue).longValue() ^ ((Number)rOperandValue).longValue()) : (Number)(((Number)lOperandValue).intValue() ^ ((Number)rOperandValue).intValue());
            } else if (lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
                value2 = (Boolean)lOperandValue ^ (Boolean)rOperandValue;
            }
        }
        return value2;
    }

    private static String computeValueToString(Object value2) {
        if (value2 instanceof PsiType) {
            if (value2 instanceof PsiArrayType) {
                return "class " + ClassUtil.getClassObjectPresentation((PsiType)value2);
            }
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)value2);
            String prefix = psiClass == null ? "" : (psiClass.isInterface() ? "interface " : "class ");
            return prefix + ((PsiType)value2).getCanonicalText();
        }
        return value2.toString();
    }

    @Nullable
    private static Boolean handleEqualityComparison(Object lOperandValue, Object rOperandValue, IElementType tokenType) {
        if (lOperandValue instanceof String && rOperandValue instanceof String || lOperandValue instanceof Boolean && rOperandValue instanceof Boolean) {
            return lOperandValue.equals(rOperandValue) == (tokenType == JavaTokenType.EQEQ);
        }
        return ConstantExpressionVisitor.compareNumbers(lOperandValue, rOperandValue, tokenType);
    }

    private static Boolean compareNumbers(Object o1, Object o2, IElementType op) {
        int result2;
        if (o1 instanceof Character) {
            o1 = (int)((Character)o1).charValue();
        }
        if (o2 instanceof Character) {
            o2 = (int)((Character)o2).charValue();
        }
        if (!(o1 instanceof Number) || !(o2 instanceof Number)) {
            return null;
        }
        Number n1 = (Number)o1;
        Number n2 = (Number)o2;
        if (n1 instanceof Double || n2 instanceof Double) {
            double v1 = n1.doubleValue();
            double v2 = n2.doubleValue();
            if (Double.isNaN(v1) || Double.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result2 = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else if (n1 instanceof Float || n2 instanceof Float) {
            float v1 = n1.floatValue();
            float v2 = n2.floatValue();
            if (Float.isNaN(v1) || Float.isNaN(v2)) {
                return op == JavaTokenType.NE;
            }
            result2 = v1 < v2 ? -1 : (v1 == v2 ? 0 : 1);
        } else {
            result2 = n1 instanceof Long || n2 instanceof Long ? Long.compare(n1.longValue(), n2.longValue()) : Integer.compare(n1.intValue(), n2.intValue());
        }
        if (op == JavaTokenType.EQEQ) {
            return result2 == 0;
        }
        if (op == JavaTokenType.LT) {
            return result2 < 0;
        }
        if (op == JavaTokenType.LE) {
            return result2 <= 0;
        }
        if (op == JavaTokenType.GT) {
            return result2 > 0;
        }
        if (op == JavaTokenType.GE) {
            return result2 >= 0;
        }
        if (op == JavaTokenType.NE) {
            return result2 != 0;
        }
        throw new IllegalArgumentException("Unexpected operator: " + op);
    }

    @Override
    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
        PsiExpression operand;
        Object operandValue;
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(4);
        }
        if ((operandValue = this.getStoredValue(operand = expression2.getOperand())) == null) {
            this.myResult = null;
            return;
        }
        IElementType tokenType = expression2.getOperationTokenType();
        Object value2 = null;
        if (tokenType == JavaTokenType.MINUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                if (operandValue instanceof Double) {
                    value2 = -((Number)operandValue).doubleValue();
                } else if (operandValue instanceof Float) {
                    value2 = Float.valueOf(-((Number)operandValue).floatValue());
                } else if (operandValue instanceof Long) {
                    value2 = -((Number)operandValue).longValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).longValue() == Long.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression2);
                    }
                } else {
                    value2 = -((Number)operandValue).intValue();
                    if (this.myThrowExceptionOnOverflow && !(operand instanceof PsiLiteralExpression) && ((Number)operandValue).intValue() == Integer.MIN_VALUE) {
                        throw new ConstantEvaluationOverflowException(expression2);
                    }
                }
            }
        } else if (tokenType == JavaTokenType.PLUS) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (operandValue instanceof Number) {
                value2 = operandValue;
            }
        } else if (tokenType == JavaTokenType.TILDE) {
            if (operandValue instanceof Character) {
                operandValue = (int)((Character)operandValue).charValue();
            }
            if (ConstantExpressionVisitor.isIntegral(operandValue)) {
                value2 = operandValue instanceof Long ? (Number)(((Number)operandValue).longValue() ^ 0xFFFFFFFFFFFFFFFFL) : (Number)(~((Number)operandValue).intValue());
            }
        } else if (tokenType == JavaTokenType.EXCL && operandValue instanceof Boolean) {
            value2 = (Boolean)operandValue == false;
        }
        this.myResult = value2;
    }

    @Override
    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression2) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(5);
        }
        this.myResult = this.getStoredValue(expression2.getExpression());
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(6);
        }
        this.myResult = this.myAuxEvaluator != null ? this.myAuxEvaluator.computeExpression(expression2, this) : null;
    }

    @Override
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression2) {
        PsiClass aClass;
        PsiType type2;
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(7);
        }
        if ((type2 = expression2.getOperand().getType()) instanceof PsiClassReferenceType && (aClass = ((PsiClassReferenceType)type2).resolve()) != null) {
            type2 = JavaPsiFacade.getElementFactory(expression2.getProject()).createType(aClass, ((PsiClassReferenceType)type2).getParameters());
        }
        this.myResult = type2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        PsiElement resolvedExpression;
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(8);
        }
        PsiExpression qualifierExpression = expression2.getQualifierExpression();
        while (qualifierExpression != null) {
            if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                this.myResult = null;
                return;
            }
            PsiReferenceExpression qualifier = (PsiReferenceExpression)qualifierExpression;
            PsiElement resolved = qualifier.resolve();
            if (resolved instanceof PsiPackage) break;
            if (!(resolved instanceof PsiClass)) {
                this.myResult = null;
                return;
            }
            qualifierExpression = ((PsiReferenceExpression)qualifierExpression).getQualifierExpression();
        }
        if ((resolvedExpression = expression2.resolve()) instanceof PsiEnumConstant) {
            String constant = ((PsiEnumConstant)resolvedExpression).getName();
            PsiReferenceExpression qualifier = (PsiReferenceExpression)expression2.getQualifier();
            if (qualifier == null) {
                return;
            }
            PsiElement element = qualifier.resolve();
            if (!(element instanceof PsiClass)) {
                return;
            }
            String name2 = ClassUtil.getJVMClassName((PsiClass)element);
            try {
                Class<?> aClass = Class.forName(name2);
                this.myResult = Enum.valueOf(aClass, constant);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return;
        }
        if (resolvedExpression instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolvedExpression;
            if (this.myVisitedVars != null && this.myVisitedVars.contains(variable)) {
                this.myResult = null;
                return;
            }
            Set<PsiVariable> oldVisitedVars = this.myVisitedVars;
            if (this.myVisitedVars == null) {
                this.myVisitedVars = new HashSet<PsiVariable>();
            }
            this.myVisitedVars.add(variable);
            try {
                Object object = this.myResult = variable instanceof PsiVariableEx ? ((PsiVariableEx)variable).computeConstantValue(this.myVisitedVars) : null;
                if (this.myResult == null && this.myAuxEvaluator != null) {
                    this.myResult = this.myAuxEvaluator.computeExpression(expression2, this);
                }
                return;
            }
            finally {
                this.myVisitedVars.remove(variable);
                this.myVisitedVars = oldVisitedVars;
            }
        }
        this.myResult = null;
    }

    private static boolean isIntegral(Object o) {
        return o instanceof Long || o instanceof Integer || o instanceof Short || o instanceof Byte || o instanceof Character;
    }

    private void checkDivisionOverflow(long l, long r, long minValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (r == -1L && l == minValue) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkMultiplicationOverflow(long result2, long l, long r, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (r == 0L || l == 0L) {
            return;
        }
        if (result2 / r != l || l < 0L ^ r < 0L != result2 < 0L) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkAdditionOverflow(boolean resultPositive, boolean lPositive, boolean rPositive, PsiElement expression2) {
        boolean overflow;
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        boolean bl = overflow = lPositive == rPositive && lPositive != resultPositive;
        if (overflow) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    private void checkRealNumberOverflow(Object result2, Object lOperandValue, Object rOperandValue, PsiElement expression2) {
        if (!this.myThrowExceptionOnOverflow) {
            return;
        }
        if (lOperandValue instanceof Float && ((Float)lOperandValue).isInfinite()) {
            return;
        }
        if (lOperandValue instanceof Double && ((Double)lOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Float && ((Float)rOperandValue).isInfinite()) {
            return;
        }
        if (rOperandValue instanceof Double && ((Double)rOperandValue).isInfinite()) {
            return;
        }
        if (result2 instanceof Float && ((Float)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
        if (result2 instanceof Double && ((Double)result2).isInfinite()) {
            throw new ConstantEvaluationOverflowException(expression2);
        }
    }

    @Override
    public Object computeExpression(@NotNull PsiExpression expression2, @NotNull PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression2 == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(9);
        }
        if (auxEvaluator == null) {
            ConstantExpressionVisitor.$$$reportNull$$$0(10);
        }
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, this.myVisitedVars, this.myThrowExceptionOnOverflow, auxEvaluator);
    }

    @Override
    @NotNull
    public ConcurrentMap<PsiElement, Object> getCacheMap(boolean overflow) {
        throw new AssertionError((Object)"should not be called");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "auxEvaluator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/ConstantExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLiteralExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitConditionalExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrefixExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitParenthesizedExpression";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodCallExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitClassObjectAccessExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "computeExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

