/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.com.intellij.openapi.util.ObjectTree;
import org.jetbrains.kotlin.com.intellij.openapi.util.objectTree.ThrowableInterner;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;

final class ObjectNode {
    private final Disposable myObject;
    @NotNull
    private NodeChildren myChildren;
    private Throwable myTrace;
    private static final Disposable ROOT_DISPOSABLE = Disposer.newDisposable("ROOT_DISPOSABLE");
    private static final NodeChildren EMPTY = new NodeChildren(){

        @Override
        public ObjectNode removeChildNode(@NotNull Disposable object) {
            if (object == null) {
                1.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            if (object == null) {
                1.$$$reportNull$$$0(1);
            }
            return null;
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            if (node == null) {
                1.$$$reportNull$$$0(2);
            }
            return new ListNodeChildren(node);
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
            if (deletedNodeConsumer == null) {
                1.$$$reportNull$$$0(3);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deletedNodeConsumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findChildNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addChildNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildren";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    private ObjectNode(@NotNull Disposable object, boolean parentIsRoot) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(0);
        }
        this.myChildren = EMPTY;
        this.myObject = object;
        this.myTrace = parentIsRoot && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private ObjectNode() {
        this.myChildren = EMPTY;
        this.myObject = ROOT_DISPOSABLE;
    }

    private boolean isRootNode() {
        return this.myObject == ROOT_DISPOSABLE;
    }

    @NotNull
    static ObjectNode createRootNode() {
        return new ObjectNode();
    }

    private void addChildNode(@NotNull ObjectNode childNode) {
        NodeChildren newChildren;
        NodeChildren children2;
        if (childNode == null) {
            ObjectNode.$$$reportNull$$$0(1);
        }
        if ((children2 = this.myChildren) != (newChildren = children2.addChildNode(childNode))) {
            this.myChildren = newChildren;
        }
    }

    void removeChildNode(@NotNull ObjectNode childNode) {
        if (childNode == null) {
            ObjectNode.$$$reportNull$$$0(2);
        }
        this.myChildren.removeChildNode(childNode.getObject());
    }

    @NotNull
    ObjectNode moveChildNodeToOtherParent(@NotNull Disposable child, @NotNull ObjectNode otherParentNode) {
        ObjectNode childNode;
        if (child == null) {
            ObjectNode.$$$reportNull$$$0(3);
        }
        if (otherParentNode == null) {
            ObjectNode.$$$reportNull$$$0(4);
        }
        if ((childNode = this.myChildren.removeChildNode(child)) == null) {
            childNode = new ObjectNode(child, this.isRootNode());
        }
        otherParentNode.addChildNode(childNode);
        assert (childNode.getObject() == child);
        ObjectNode objectNode = childNode;
        if (objectNode == null) {
            ObjectNode.$$$reportNull$$$0(5);
        }
        return objectNode;
    }

    void removeChildNodesRecursively(@NotNull List<? super Disposable> disposables, @NotNull ObjectTree tree, @Nullable Throwable trace2, @Nullable Predicate<? super Disposable> predicate) {
        if (disposables == null) {
            ObjectNode.$$$reportNull$$$0(6);
        }
        if (tree == null) {
            ObjectNode.$$$reportNull$$$0(7);
        }
        this.myChildren.removeChildren(predicate, childNode -> {
            boolean alreadyDisposed;
            childNode.removeChildNodesRecursively(disposables, tree, trace2, null);
            Disposable object = childNode.getObject();
            boolean bl = alreadyDisposed = tree.rememberDisposedTrace(object, trace2) != null;
            if (!alreadyDisposed) {
                disposables.add(object);
            }
        });
    }

    @NotNull
    Disposable getObject() {
        Disposable disposable = this.myObject;
        if (disposable == null) {
            ObjectNode.$$$reportNull$$$0(8);
        }
        return disposable;
    }

    @NonNls
    public String toString() {
        return this.isRootNode() ? "ROOT" : "Node: " + this.myObject;
    }

    ObjectNode findChildNode(@NotNull Disposable object) {
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(10);
        }
        return this.myChildren.findChildNode(object);
    }

    @NotNull
    ObjectNode findOrCreateChildNode(@NotNull Disposable object) {
        ObjectNode existing;
        if (object == null) {
            ObjectNode.$$$reportNull$$$0(11);
        }
        if ((existing = this.findChildNode(object)) != null) {
            ObjectNode objectNode = existing;
            if (objectNode == null) {
                ObjectNode.$$$reportNull$$$0(12);
            }
            return objectNode;
        }
        ObjectNode childNode = new ObjectNode(object, this.isRootNode());
        this.addChildNode(childNode);
        ObjectNode objectNode = childNode;
        if (objectNode == null) {
            ObjectNode.$$$reportNull$$$0(13);
        }
        return objectNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherParentNode";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposables";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "moveChildNodeToOtherParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateChildNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChildNode";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeChildNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveChildNodeToOtherParent";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeChildNodesRecursively";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertNoReferencesKept";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findChildNode";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateChildNode";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface NodeChildren {
        @Nullable
        public ObjectNode removeChildNode(@NotNull Disposable var1);

        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable var1);

        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode var1);

        public void removeChildren(@Nullable Predicate<? super Disposable> var1, @NotNull Consumer<? super ObjectNode> var2);
    }

    private static final class ListNodeChildren
    implements NodeChildren {
        @NotNull
        private final List<ObjectNode> myChildren;

        ListNodeChildren(@NotNull ObjectNode node) {
            if (node == null) {
                ListNodeChildren.$$$reportNull$$$0(0);
            }
            this.myChildren = new SmartList<ObjectNode>(node);
        }

        @Override
        public ObjectNode removeChildNode(@NotNull Disposable nodeToDelete) {
            if (nodeToDelete == null) {
                ListNodeChildren.$$$reportNull$$$0(1);
            }
            List<ObjectNode> children2 = this.myChildren;
            for (int i2 = children2.size() - 1; i2 >= 0; --i2) {
                ObjectNode node = children2.get(i2);
                if (node.getObject() != nodeToDelete) continue;
                return children2.remove(i2);
            }
            return null;
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            if (object == null) {
                ListNodeChildren.$$$reportNull$$$0(2);
            }
            for (ObjectNode node : this.myChildren) {
                if (node.getObject() != object) continue;
                return node;
            }
            return null;
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            if (node == null) {
                ListNodeChildren.$$$reportNull$$$0(3);
            }
            this.myChildren.add(node);
            NodeChildren nodeChildren = this.myChildren.size() > 500 ? new MapNodeChildren(this.myChildren) : this;
            if (nodeChildren == null) {
                ListNodeChildren.$$$reportNull$$$0(4);
            }
            return nodeChildren;
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
            if (deletedNodeConsumer == null) {
                ListNodeChildren.$$$reportNull$$$0(5);
            }
            for (int i2 = this.myChildren.size() - 1; i2 >= 0; --i2) {
                ObjectNode childNode = this.myChildren.get(i2);
                Disposable object = childNode.getObject();
                if (condition != null && !condition.test(object)) continue;
                this.myChildren.remove(i2);
                deletedNodeConsumer.accept(childNode);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeToDelete";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$ListNodeChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deletedNodeConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$ListNodeChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChildNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findChildNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addChildNode";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildren";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MapNodeChildren
    implements NodeChildren {
        private final Map<Disposable, ObjectNode> myChildren;

        MapNodeChildren(@NotNull List<ObjectNode> children2) {
            if (children2 == null) {
                MapNodeChildren.$$$reportNull$$$0(0);
            }
            Reference2ObjectLinkedOpenHashMap<Disposable, ObjectNode> map2 = new Reference2ObjectLinkedOpenHashMap<Disposable, ObjectNode>(children2.size());
            for (ObjectNode child : children2) {
                map2.put(child.getObject(), child);
            }
            this.myChildren = map2;
        }

        @Override
        @Nullable
        public ObjectNode removeChildNode(@NotNull Disposable object) {
            if (object == null) {
                MapNodeChildren.$$$reportNull$$$0(1);
            }
            return this.myChildren.remove(object);
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            if (object == null) {
                MapNodeChildren.$$$reportNull$$$0(2);
            }
            return this.myChildren.get(object);
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            if (node == null) {
                MapNodeChildren.$$$reportNull$$$0(3);
            }
            this.myChildren.put(node.getObject(), node);
            MapNodeChildren mapNodeChildren = this;
            if (mapNodeChildren == null) {
                MapNodeChildren.$$$reportNull$$$0(4);
            }
            return mapNodeChildren;
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
            if (deletedNodeConsumer == null) {
                MapNodeChildren.$$$reportNull$$$0(5);
            }
            Iterator<Map.Entry<Disposable, ObjectNode>> iterator2 = this.myChildren.entrySet().iterator();
            SmartList<ObjectNode> deletedValuesToProcess = new SmartList<ObjectNode>();
            while (iterator2.hasNext()) {
                Map.Entry<Disposable, ObjectNode> entry = iterator2.next();
                if (condition != null && !condition.test(entry.getKey())) continue;
                ObjectNode value2 = entry.getValue();
                iterator2.remove();
                deletedValuesToProcess.add(value2);
            }
            for (int i2 = deletedValuesToProcess.size() - 1; i2 >= 0; --i2) {
                deletedNodeConsumer.accept((ObjectNode)deletedValuesToProcess.get(i2));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$MapNodeChildren";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deletedNodeConsumer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/ObjectNode$MapNodeChildren";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChildNode";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllNodes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findChildNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addChildNode";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeChildren";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

