/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.diagnostic;

import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.diagnostic.Activity;
import org.jetbrains.kotlin.com.intellij.diagnostic.ActivityCategory;
import org.jetbrains.kotlin.com.intellij.diagnostic.StartUpMeasurer;

@ApiStatus.Internal
public final class ActivityImpl
implements Activity {
    private final String name;
    private String threadName;
    private long threadId;
    private final long start;
    private long end;
    private final ActivityImpl parent;
    @Nullable
    private final ActivityCategory category;
    @Nullable
    private final String pluginId;

    ActivityImpl(@Nullable String name2, long start, @Nullable ActivityImpl parent2, @Nullable String pluginId, @Nullable ActivityCategory category) {
        this.name = name2;
        this.start = start;
        this.parent = parent2;
        this.pluginId = pluginId;
        this.category = category;
        this.updateThreadName();
    }

    private void updateThreadName() {
        Thread thread2 = Thread.currentThread();
        this.threadId = thread2.getId();
        this.threadName = thread2.getName();
    }

    @ApiStatus.Internal
    public void setEnd(long end) {
        assert (this.end == 0L) : "not started or already ended";
        this.end = end;
    }

    @Override
    public void end() {
        this.end = System.nanoTime();
        StartUpMeasurer.addActivity(this);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActivityImpl(name=").append(this.name).append(", start=");
        ActivityImpl.nanoToString(this.start, builder);
        builder.append(", end=");
        ActivityImpl.nanoToString(this.end, builder);
        builder.append(", category=").append((Object)this.category).append(")");
        return builder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static void nanoToString(long start, @NotNull StringBuilder stringBuilder) {
        void builder;
        if (stringBuilder == null) {
            ActivityImpl.$$$reportNull$$$0(5);
        }
        builder.append(TimeUnit.NANOSECONDS.toMillis(start - StartUpMeasurer.getStartTime())).append("ms (").append(TimeUnit.NANOSECONDS.toMicros(start - StartUpMeasurer.getStartTime())).append("\u03bcs)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/diagnostic/ActivityImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startChild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "endAndStart";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "nanoToString";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

