/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableCollection;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableList;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMap;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapEntry;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapEntrySet;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapKeySet;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableMapValues;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Maps;
import org.jetbrains.kotlin.com.google.common.collect.RegularImmutableMap;

final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        HashMap<K, Object> duplicates = null;
        int dupCount = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            V value2;
            entryArray[i2] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i2]));
            K key = entryArray[i2].getKey();
            V oldValue = delegateMap.put(key, value2 = entryArray[i2].getValue());
            if (oldValue == null) continue;
            if (throwIfDuplicateKeys) {
                throw JdkBackedImmutableMap.conflictException("key", entryArray[i2], entryArray[i2].getKey() + "=" + oldValue);
            }
            if (duplicates == null) {
                duplicates = new HashMap<K, Object>();
            }
            duplicates.put(key, value2);
            ++dupCount;
        }
        if (duplicates != null) {
            Map.Entry[] newEntryArray = new Map.Entry[n - dupCount];
            int outI = 0;
            for (int inI = 0; inI < n; ++inI) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[inI]);
                K key = entry.getKey();
                if (duplicates.containsKey(key)) {
                    Object value3 = duplicates.get(key);
                    if (value3 == null) continue;
                    entry = new ImmutableMapEntry(key, value3);
                    duplicates.put(key, null);
                }
                newEntryArray[outI++] = entry;
            }
            entryArray = newEntryArray;
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries2) {
        this.delegateMap = delegateMap;
        this.entries = entries2;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public V get(Object key) {
        return this.delegateMap.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    Object writeReplace() {
        return super.writeReplace();
    }
}

