/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.when;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.when.SwitchCodegen;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;

public class StringSwitchCodegen
extends SwitchCodegen {
    private static final String HASH_CODE_METHOD_DESC = Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]);
    private static final String EQUALS_METHOD_DESC = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.getType(Object.class));
    private final Map<Integer, List<Entry>> hashCodesToEntries;
    private int tempVarIndex;

    public StringSwitchCodegen(@NotNull KtWhenExpression expression2, boolean isStatement, boolean isExhaustive, @NotNull ExpressionCodegen codegen2) {
        if (expression2 == null) {
            StringSwitchCodegen.$$$reportNull$$$0(0);
        }
        if (codegen2 == null) {
            StringSwitchCodegen.$$$reportNull$$$0(1);
        }
        super(expression2, isStatement, isExhaustive, codegen2, null);
        this.hashCodesToEntries = new HashMap<Integer, List<Entry>>();
    }

    @Override
    protected void processConstant(@NotNull ConstantValue<?> constant, @NotNull Label entryLabel, @NotNull KtWhenEntry entry) {
        List<Entry> hashCodesToEntry;
        if (constant == null) {
            StringSwitchCodegen.$$$reportNull$$$0(2);
        }
        if (entryLabel == null) {
            StringSwitchCodegen.$$$reportNull$$$0(3);
        }
        if (entry == null) {
            StringSwitchCodegen.$$$reportNull$$$0(4);
        }
        assert (constant instanceof StringValue) : "guaranteed by usage contract";
        int hashCode = constant.hashCode();
        if (!this.transitionsTable.containsKey(hashCode)) {
            this.transitionsTable.put(hashCode, new Label());
            hashCodesToEntry = new ArrayList<Entry>();
            this.hashCodesToEntries.put(hashCode, hashCodesToEntry);
        } else {
            hashCodesToEntry = this.hashCodesToEntries.get(hashCode);
        }
        hashCodesToEntry.add(new Entry((String)((StringValue)constant).getValue(), entryLabel, entry));
    }

    @Override
    public void generate() {
        super.generate();
    }

    @Override
    protected void generateSubjectValueToIndex() {
        this.generateNullCheckIfNeeded();
        this.tempVarIndex = this.codegen.myFrameMap.enterTemp(this.subjectType);
        this.v.store(this.tempVarIndex, this.subjectType);
        this.v.load(this.tempVarIndex, this.subjectType);
        this.v.invokevirtual(this.subjectType.getInternalName(), "hashCode", HASH_CODE_METHOD_DESC, false);
    }

    @Override
    protected void generateEntries() {
        for (int hashCode : this.hashCodesToEntries.keySet()) {
            this.v.visitLabel((Label)this.transitionsTable.get(hashCode));
            List<Entry> items = this.hashCodesToEntries.get(hashCode);
            Label nextLabel = null;
            for (int i2 = 0; i2 < items.size(); ++i2) {
                if (nextLabel != null) {
                    this.v.visitLabel(nextLabel);
                }
                Entry entry = items.get(i2);
                this.codegen.markLineNumber(entry.entry, false);
                this.v.load(this.tempVarIndex, this.subjectType);
                this.v.aconst(entry.value);
                this.v.invokevirtual(this.subjectType.getInternalName(), "equals", EQUALS_METHOD_DESC, false);
                nextLabel = i2 + 1 < items.size() ? new Label() : this.defaultLabel;
                this.v.ifeq(nextLabel);
                this.v.goTo(entry.label);
            }
        }
        super.generateEntries();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codegen";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryLabel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/when/StringSwitchCodegen";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstant";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Entry {
        private final String value;
        private final Label label;
        private final KtWhenEntry entry;

        private Entry(String value2, Label label2, KtWhenEntry entry) {
            this.value = value2;
            this.label = label2;
            this.entry = entry;
        }
    }
}

