/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.KtVirtualFileSourceFile;
import org.jetbrains.kotlin.cli.common.GroupedKtSources;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.CoreEnvironmentUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"kotlinFileExtensionWithDot", "", "javaFileExtensionWithDot", "collectSources", "Lorg/jetbrains/kotlin/cli/common/GroupedKtSources;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "projectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/VfsBasedProjectEnvironment;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "ktSourceFileComparator", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/KtSourceFile;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "cli"})
@SourceDebugExtension(value={"SMAP\nGroupedKtSources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupedKtSources.kt\norg/jetbrains/kotlin/cli/common/GroupedKtSourcesKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,94:1\n381#2,7:95\n*S KotlinDebug\n*F\n+ 1 GroupedKtSources.kt\norg/jetbrains/kotlin/cli/common/GroupedKtSourcesKt\n*L\n75#1:95,7\n*E\n"})
public final class GroupedKtSourcesKt {
    @NotNull
    private static final Comparator<KtSourceFile> ktSourceFileComparator = GroupedKtSourcesKt::ktSourceFileComparator$lambda$0;

    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull VfsBasedProjectEnvironment projectEnvironment, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkNotNullParameter(projectEnvironment, "projectEnvironment");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        return GroupedKtSourcesKt.collectSources(compilerConfiguration, projectEnvironment.getProject(), messageCollector);
    }

    @NotNull
    public static final GroupedKtSources collectSources(@NotNull CompilerConfiguration compilerConfiguration, @NotNull Project project, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkNotNullParameter(compilerConfiguration, "compilerConfiguration");
        Intrinsics.checkNotNullParameter(project, "project");
        Intrinsics.checkNotNullParameter(messageCollector, "messageCollector");
        TreeSet<KtSourceFile> platformSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        TreeSet<KtSourceFile> commonSources = new TreeSet<KtSourceFile>(ktSourceFileComparator);
        Map sourcesByModuleName = new LinkedHashMap();
        boolean skipScriptsInLtMode = compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_FIR) && compilerConfiguration.getBoolean(CommonConfigurationKeys.USE_LIGHT_TREE);
        Ref.BooleanRef skipScriptsInLtModeWarning = new Ref.BooleanRef();
        CoreEnvironmentUtilsKt.forAllFiles$default(CoreEnvironmentUtilsKt.getSourceRootsCheckingForDuplicates(compilerConfiguration, messageCollector), compilerConfiguration, project, null, (arg_0, arg_1, arg_2) -> GroupedKtSourcesKt.collectSources$lambda$2(skipScriptsInLtMode, commonSources, platformSources, sourcesByModuleName, skipScriptsInLtModeWarning, arg_0, arg_1, arg_2), 4, null);
        if (skipScriptsInLtModeWarning.element) {
            MessageCollector.report$default(messageCollector, CompilerMessageSeverity.STRONG_WARNING, "Scripts are not yet supported with K2 in LightTree mode, consider using K1 or disable LightTree mode with -Xuse-fir-lt=false", null, 4, null);
        }
        return new GroupedKtSources((Collection<? extends KtSourceFile>)platformSources, (Collection<? extends KtSourceFile>)commonSources, sourcesByModuleName);
    }

    private static final int ktSourceFileComparator$lambda$0(KtSourceFile o1, KtSourceFile o2) {
        String string2 = o1.getPath();
        if (string2 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path1 = string2;
        String string3 = o2.getPath();
        if (string3 == null) {
            throw new IllegalStateException("Expected a file with a well-defined path".toString());
        }
        String path2 = string3;
        return path1.compareTo(path2);
    }

    private static final Unit collectSources$lambda$2(boolean $skipScriptsInLtMode, TreeSet $commonSources, TreeSet $platformSources, Map $sourcesByModuleName, Ref.BooleanRef $skipScriptsInLtModeWarning, VirtualFile virtualFile, boolean isCommon, String moduleName) {
        Intrinsics.checkNotNullParameter(virtualFile, "virtualFile");
        KtVirtualFileSourceFile file2 = new KtVirtualFileSourceFile(virtualFile);
        if (!StringsKt.endsWith$default(file2.getPath(), ".java", false, 2, null)) {
            if (StringsKt.endsWith$default(file2.getPath(), ".kt", false, 2, null) || !$skipScriptsInLtMode) {
                boolean bl = isCommon ? $commonSources.add(file2) : $platformSources.add(file2);
                if (moduleName != null) {
                    Object object;
                    Map $this$getOrPut$iv = $sourcesByModuleName;
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(moduleName);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        Set answer$iv = new LinkedHashSet();
                        $this$getOrPut$iv.put(moduleName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).add(file2);
                }
            } else {
                $skipScriptsInLtModeWarning.element = true;
            }
        }
        return Unit.INSTANCE;
    }
}

