/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnBooleanExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnEnumExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnSealedExhaustivenessChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0011H\u0007J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#J \u0010$\u001a\u00020\u001c*\u0006\u0012\u0002\b\u00030%2\u0006\u0010\t\u001a\u00020&2\u0006\u0010\"\u001a\u00020#H\u0002J\u0016\u0010'\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenChecker;", "", "<init>", "()V", "exhaustivenessCheckers", "", "Lorg/jetbrains/kotlin/cfg/WhenExhaustivenessChecker;", "getClassIdForEnumSubject", "Lorg/jetbrains/kotlin/name/ClassId;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getClassIdForTypeIfEnum", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getClassDescriptorOfTypeIfEnum", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getClassDescriptorOfTypeIfSealed", "whenSubjectType", "whenSubjectTypeWithoutSmartCasts", "getEnumMissingCases", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "enumClassDescriptor", "getSealedMissingCases", "sealedClassDescriptor", "getMissingCases", "isWhenExhaustive", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "containsNullCase", "checkDuplicatedLabels", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isTrivial", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkDeprecatedWhenSyntax", "checkSealedWhenIsReserved", "sink", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "frontend"})
@SourceDebugExtension(value={"SMAP\nWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,485:1\n1#2:486\n774#3:487\n865#3,2:488\n1557#3:490\n1628#3,3:491\n*S KotlinDebug\n*F\n+ 1 WhenChecker.kt\norg/jetbrains/kotlin/cfg/WhenChecker\n*L\n342#1:487\n342#1:488,2\n344#1:490\n344#1:491,3\n*E\n"})
public final class WhenChecker {
    @NotNull
    public static final WhenChecker INSTANCE = new WhenChecker();
    @NotNull
    private static final List<WhenExhaustivenessChecker> exhaustivenessCheckers;

    private WhenChecker() {
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForEnumSubject(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return WhenChecker.getClassIdForTypeIfEnum(WhenChecker.whenSubjectType(expression2, context));
    }

    @JvmStatic
    @Nullable
    public static final ClassId getClassIdForTypeIfEnum(@Nullable KotlinType type2) {
        ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum(type2);
        return classDescriptor != null ? DescriptorUtilsKt.getClassId((ClassifierDescriptor)classDescriptor) : null;
    }

    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfEnum(@Nullable KotlinType type2) {
        if (type2 == null) {
            return null;
        }
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(type2);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getKind() != ClassKind.ENUM_CLASS) {
            return null;
        }
        return classDescriptor2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @Nullable
    public static final ClassDescriptor getClassDescriptorOfTypeIfSealed(@Nullable KotlinType type2) {
        Annotated annotated;
        KotlinType kotlinType = type2;
        Annotated annotated2 = kotlinType;
        if (kotlinType == null) return null;
        KotlinType it = annotated2;
        boolean bl = false;
        ClassDescriptor classDescriptor = TypeUtils.getClassDescriptor(it);
        annotated2 = classDescriptor;
        if (classDescriptor == null) return null;
        it = annotated = annotated2;
        boolean bl2 = false;
        if (!DescriptorUtils.isSealedClass((DeclarationDescriptor)((Object)it))) return null;
        Annotated annotated3 = annotated;
        return annotated3;
    }

    @JvmStatic
    @Nullable
    public static final KotlinType whenSubjectType(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Object object;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context.get(BindingContext.VARIABLE, subjectVariable);
            object = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else if (subjectExpression != null) {
            object = (ExplicitSmartCasts)context.get(BindingContext.SMARTCAST, subjectExpression);
            if (object == null || (object = object.getDefaultType()) == null) {
                object = context.getType(subjectExpression);
            }
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public final KotlinType whenSubjectTypeWithoutSmartCasts(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtProperty subjectVariable = expression2.getSubjectVariable();
        KtExpression subjectExpression = expression2.getSubjectExpression();
        if (subjectVariable != null) {
            VariableDescriptor variableDescriptor = (VariableDescriptor)context.get(BindingContext.VARIABLE, subjectVariable);
            kotlinType = variableDescriptor != null ? variableDescriptor.getType() : null;
        } else {
            KtExpression ktExpression = subjectExpression;
            kotlinType = ktExpression != null ? context.getType(ktExpression) : null;
        }
        return kotlinType;
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getEnumMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor enumClassDescriptor) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(enumClassDescriptor, "enumClassDescriptor");
        return WhenOnEnumExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, enumClassDescriptor, false);
    }

    @JvmStatic
    @NotNull
    public static final List<WhenMissingCase> getSealedMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context, @NotNull ClassDescriptor sealedClassDescriptor) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(sealedClassDescriptor, "sealedClassDescriptor");
        return WhenOnSealedExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, sealedClassDescriptor, false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        void $this$mapTo$iv$iv;
        WhenExhaustivenessChecker it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KotlinType kotlinType = WhenChecker.whenSubjectType(expression2, context);
        if (kotlinType == null) {
            return CollectionsKt.listOf(WhenMissingCase.Unknown.INSTANCE);
        }
        KotlinType type2 = kotlinType;
        boolean nullable = type2.isMarkedNullable();
        Iterable $this$filter$iv = exhaustivenessCheckers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (WhenExhaustivenessChecker)element$iv$iv;
            boolean bl = false;
            if (!it.isApplicable(type2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List checkers = (List)destination$iv$iv;
        if (checkers.isEmpty()) {
            return CollectionsKt.listOf(WhenMissingCase.Unknown.INSTANCE);
        }
        Iterable $this$map$iv = checkers;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WhenExhaustivenessChecker)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMissingCases(expression2, context, TypeUtils.getClassDescriptor(type2), nullable));
        }
        return CollectionsKt.flatten((List)destination$iv$iv);
    }

    @JvmStatic
    public static final boolean isWhenExhaustive(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace2, "trace");
        BindingContext bindingContext = trace2.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        if (INSTANCE.getMissingCases(expression2, bindingContext).isEmpty()) {
            trace2.record(BindingContext.EXHAUSTIVE_WHEN, expression2);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean containsNullCase(@NotNull KtWhenExpression expression2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        return WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression2, context, true).isEmpty();
    }

    public final void checkDuplicatedLabels(@NotNull KtWhenExpression expression2, @NotNull BindingTrace trace2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(trace2, "trace");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (expression2.getSubjectExpression() == null) {
            return;
        }
        HashSet<Pair<KotlinType, Boolean>> checkedTypes = new HashSet<Pair<KotlinType, Boolean>>();
        Map checkedConstants = new LinkedHashMap();
        Map notTrivialBranches = new LinkedHashMap();
        for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (KtWhenCondition condition : entry.getConditions()) {
                KotlinType type2;
                KtTypeReference typeReference;
                KtWhenCondition ktWhenCondition = condition;
                if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
                    boolean isTrivial;
                    CompileTimeConstant<?> constant;
                    KtExpression constantExpression;
                    if (((KtWhenConditionWithExpression)condition).getExpression() == null) continue;
                    BindingContext bindingContext = trace2.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                    if (ConstantExpressionEvaluator.Companion.getConstant(constantExpression, bindingContext) == null) continue;
                    Boolean bl = (Boolean)checkedConstants.get(constant);
                    if (Intrinsics.areEqual(bl, true)) {
                        WhenChecker.checkDuplicatedLabels$report(trace2, constantExpression);
                        continue;
                    }
                    if (Intrinsics.areEqual(bl, false)) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        if (isTrivial) {
                            Object v = notTrivialBranches.remove(constant);
                            Intrinsics.checkNotNull(v);
                            KtExpression reportOn = (KtExpression)v;
                            WhenChecker.checkDuplicatedLabels$report(trace2, reportOn);
                            checkedConstants.put(constant, true);
                            continue;
                        }
                        WhenChecker.checkDuplicatedLabels$report(trace2, constantExpression);
                        continue;
                    }
                    if (bl == null) {
                        isTrivial = this.isTrivial(constant, constantExpression, languageVersionSettings);
                        Boolean bl2 = isTrivial;
                        checkedConstants.put(constant, bl2);
                        if (isTrivial) continue;
                        notTrivialBranches.put(constant, constantExpression);
                        continue;
                    }
                    throw new NoWhenBranchMatchedException();
                }
                if (!(ktWhenCondition instanceof KtWhenConditionIsPattern) || ((KtWhenConditionIsPattern)condition).getTypeReference() == null || (KotlinType)trace2.get(BindingContext.TYPE, typeReference) == null) continue;
                Pair<KotlinType, Boolean> typeWithIsNegation = TuplesKt.to(type2, ((KtWhenConditionIsPattern)condition).isNegated());
                if (checkedTypes.contains(typeWithIsNegation)) {
                    trace2.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(typeReference));
                    continue;
                }
                checkedTypes.add(typeWithIsNegation);
            }
        }
    }

    private final boolean isTrivial(CompileTimeConstant<?> $this$isTrivial, KtExpression expression2, LanguageVersionSettings languageVersionSettings) {
        if ($this$isTrivial.getUsesVariableAsConstant()) {
            return false;
        }
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return !ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression2, $this$isTrivial);
        }
        return true;
    }

    public final void checkDeprecatedWhenSyntax(@NotNull BindingTrace trace2, @NotNull KtWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(trace2, "trace");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        if (expression2.getSubjectExpression() != null) {
            return;
        }
        block0: for (KtWhenEntry entry : expression2.getEntries()) {
            if (entry.isElse()) continue;
            for (PsiElement child = entry.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNode().getElementType() == KtTokens.COMMA) {
                    trace2.report(Errors.COMMA_IN_WHEN_CONDITION_WITHOUT_ARGUMENT.on(child));
                }
                if (child.getNode().getElementType() == KtTokens.ARROW) continue block0;
            }
        }
    }

    public final void checkSealedWhenIsReserved(@NotNull DiagnosticSink sink, @NotNull PsiElement element) {
        block0: {
            Intrinsics.checkNotNullParameter(sink, "sink");
            Intrinsics.checkNotNullParameter(element, "element");
            PsiElement psiElement = KtPsiUtil.getPreviousWord(element, "sealed");
            if (psiElement == null) break block0;
            PsiElement it = psiElement;
            boolean bl = false;
            sink.report(Errors.UNSUPPORTED_SEALED_WHEN.on(it));
        }
    }

    private static final void checkDuplicatedLabels$report(BindingTrace $trace, KtExpression reportOn) {
        $trace.report(Errors.DUPLICATE_LABEL_IN_WHEN.on(reportOn));
    }

    static {
        WhenExhaustivenessChecker[] whenExhaustivenessCheckerArray = new WhenExhaustivenessChecker[]{WhenOnBooleanExhaustivenessChecker.INSTANCE, WhenOnEnumExhaustivenessChecker.INSTANCE, WhenOnSealedExhaustivenessChecker.INSTANCE};
        exhaustivenessCheckers = CollectionsKt.listOf(whenExhaustivenessCheckerArray);
    }
}

