/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.build;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.BuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.JsMetadataVersion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/build/JsBuildMetaInfo;", "Lorg/jetbrains/kotlin/build/BuildMetaInfo;", "<init>", "()V", "checkIfPlatformSpecificCompilerArgumentWasChanged", "", "key", "", "currentValue", "previousValue", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "createPropertiesMapFromCompilerArguments", "", "args", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "argumentsListForSpecialCheck", "", "getArgumentsListForSpecialCheck", "()Ljava/util/List;", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nJsBuildMetaInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsBuildMetaInfo.kt\norg/jetbrains/kotlin/build/JsBuildMetaInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n1#2:42\n*E\n"})
public final class JsBuildMetaInfo
extends BuildMetaInfo {
    @Override
    @Nullable
    public Boolean checkIfPlatformSpecificCompilerArgumentWasChanged(@NotNull String key, @NotNull String currentValue, @NotNull String previousValue) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(currentValue, "currentValue");
        Intrinsics.checkNotNullParameter(previousValue, "previousValue");
        if (Intrinsics.areEqual(key, "METADATA_VERSION_STRING")) {
            int[] previousValueIntArray;
            int[] currentValueIntArray;
            if (!(currentValueIntArray != null ? (currentValueIntArray = BinaryVersion.Companion.parseVersionArray(currentValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray = new int[]{currentValueIntArray[0], currentValueIntArray[1], currentValueIntArray[2]};
            JsMetadataVersion currentVersion = new JsMetadataVersion(nArray);
            if (!(previousValueIntArray != null ? (previousValueIntArray = BinaryVersion.Companion.parseVersionArray(previousValue)).length == 3 : false)) {
                return null;
            }
            int[] nArray2 = new int[]{previousValueIntArray[0], previousValueIntArray[1], previousValueIntArray[2]};
            JsMetadataVersion previousVersion = new JsMetadataVersion(nArray2);
            return Intrinsics.areEqual(currentVersion, previousVersion);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> createPropertiesMapFromCompilerArguments(@NotNull CommonCompilerArguments args2) {
        JsMetadataVersion jsMetadataVersion;
        int[] metadataVersionArray;
        int[] nArray;
        Intrinsics.checkNotNullParameter(args2, "args");
        Map resultMap = new LinkedHashMap();
        String string2 = args2.getMetadataVersion();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            nArray = BinaryVersion.Companion.parseVersionArray(it);
        } else {
            nArray = null;
        }
        if (metadataVersionArray != null) {
            int[] p0 = metadataVersionArray = nArray;
            boolean bl = false;
            jsMetadataVersion = new JsMetadataVersion(p0);
        } else {
            jsMetadataVersion = JsMetadataVersion.INSTANCE;
        }
        JsMetadataVersion metadataVersion = jsMetadataVersion;
        String metadataVersionString = String.valueOf(metadataVersion.toInteger());
        resultMap.put("METADATA_VERSION_STRING", metadataVersionString);
        return MapsKt.plus(super.createPropertiesMapFromCompilerArguments(args2), resultMap);
    }

    @Override
    @NotNull
    public List<String> getArgumentsListForSpecialCheck() {
        String[] stringArray = new String[]{"sourceMap", "metaInfopartialLinkagewasmDebug"};
        return CollectionsKt.plus((Collection)super.getArgumentsListForSpecialCheck(), (Iterable)CollectionsKt.listOf(stringArray));
    }
}

