/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ConstantDataElement;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.InterfaceMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmTypeTransformer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u001f2\u0006\u0010 \u001a\u00020!J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0018\u0010#\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0012\u0004\u0012\u00020\u00140\u001fJ\u0016\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020'2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020!J\u0012\u00100\u001a\u00020'2\n\u00101\u001a\u0006\u0012\u0002\b\u000302J\u0016\u00103\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u0010-\u001a\u00020.J\u0016\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0016\u0010;\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00109\u001a\u00020:J\u0016\u0010<\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u00109\u001a\u00020:J\u0016\u0010=\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020?J\u0016\u0010A\u001a\u00020'2\u0006\u00104\u001a\u0002052\u0006\u0010B\u001a\u00020CJ\u000e\u0010G\u001a\u00020F2\u0006\u0010(\u001a\u00020)J\u000e\u0010J\u001a\u00020I2\u0006\u0010(\u001a\u00020)J\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020.0\r2\u0006\u00104\u001a\u000205J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u00107\u001a\u000208J\u0014\u0010M\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010(\u001a\u00020)J\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010(\u001a\u00020)J\u0014\u0010O\u001a\b\u0012\u0004\u0012\u00020?0\r2\u0006\u0010(\u001a\u00020)J\u0014\u0010P\u001a\b\u0012\u0004\u0012\u00020?0\r2\u0006\u0010(\u001a\u00020)J\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020?0\r2\u0006\u0010(\u001a\u00020)J\u0016\u0010R\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020?J\u000e\u0010S\u001a\u00020T2\u0006\u0010(\u001a\u00020)J\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010(\u001a\u00020)J\u0016\u0010V\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010W\u001a\u00020\u000eJ\u0014\u0010X\u001a\b\u0012\u0004\u0012\u00020C0\r2\u0006\u00104\u001a\u000205J\u0014\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010(\u001a\u00020)J\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010[\u001a\u00020\\J\u0016\u0010]\u001a\u00020'2\u0006\u0010^\u001a\u00020!2\u0006\u0010_\u001a\u00020!J\u000e\u0010`\u001a\u00020'2\u0006\u0010a\u001a\u00020!R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u001a\u0010D\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020F0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010H\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020I0EX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006b"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFragment", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;)V", "getBackendContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "typeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmTypeTransformer;", "scratchMemAddr", "Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "", "getScratchMemAddr", "()Lorg/jetbrains/kotlin/wasm/ir/WasmSymbol;", "stringPoolSize", "getStringPoolSize", "transformType", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "transformFieldType", "transformBoxedType", "transformValueParameterType", "irValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "transformResultType", "transformBlockResultType", "referenceStringLiteralAddressAndId", "Lkotlin/Pair;", "string", "", "referenceConstantArray", "resource", "", "", "generateTypeInfo", "", "irClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "typeInfo", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ConstantDataElement;", "registerInitFunction", "wasmFunction", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunction;", "priority", "addExport", "wasmExport", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "defineFunction", "irFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "defineGlobalField", "irField", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "wasmGlobal", "Lorg/jetbrains/kotlin/wasm/ir/WasmGlobal;", "defineGlobalVTable", "defineGlobalClassITable", "defineGcType", "wasmType", "Lorg/jetbrains/kotlin/wasm/ir/WasmTypeDeclaration;", "defineVTableGcType", "defineFunctionType", "wasmFunctionType", "Lorg/jetbrains/kotlin/wasm/ir/WasmFunctionType;", "classMetadataCache", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "getClassMetadata", "interfaceMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/InterfaceMetadata;", "getInterfaceMetadata", "referenceFunction", "referenceGlobalField", "referenceGlobalVTable", "referenceGlobalClassITable", "referenceGcType", "referenceVTableGcType", "referenceClassITableGcType", "defineClassITableGcType", "isAlreadyDefinedClassITableGcType", "", "referenceClassITableInterfaceSlot", "defineClassITableInterfaceSlot", "slot", "referenceFunctionType", "referenceTypeId", "getStructFieldRef", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addJsFun", "importName", "jsCode", "addJsModuleImport", "module", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nWasmModuleCodegenContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,190:1\n1#2:191\n381#3,7:192\n381#3,7:199\n*S KotlinDebug\n*F\n+ 1 WasmModuleCodegenContext.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext\n*L\n112#1:192,7\n125#1:199,7\n*E\n"})
public final class WasmModuleCodegenContext {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmCompiledModuleFragment wasmFragment;
    @NotNull
    private final WasmTypeTransformer typeTransformer;
    @NotNull
    private final Map<IrClassSymbol, ClassMetadata> classMetadataCache;
    @NotNull
    private final Map<IrClassSymbol, InterfaceMetadata> interfaceMetadataCache;

    public WasmModuleCodegenContext(@NotNull WasmBackendContext backendContext, @NotNull WasmCompiledModuleFragment wasmFragment) {
        Intrinsics.checkNotNullParameter(backendContext, "backendContext");
        Intrinsics.checkNotNullParameter(wasmFragment, "wasmFragment");
        this.backendContext = backendContext;
        this.wasmFragment = wasmFragment;
        this.typeTransformer = new WasmTypeTransformer(this, this.backendContext.getIrBuiltIns());
        this.classMetadataCache = new LinkedHashMap();
        this.interfaceMetadataCache = new LinkedHashMap();
    }

    @NotNull
    public final WasmBackendContext getBackendContext() {
        return this.backendContext;
    }

    @NotNull
    public final WasmSymbol<Integer> getScratchMemAddr() {
        return this.wasmFragment.getScratchMemAddr();
    }

    @NotNull
    public final WasmSymbol<Integer> getStringPoolSize() {
        return this.wasmFragment.getStringPoolSize();
    }

    @NotNull
    public final WasmType transformType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformType_u24lambda_u240 = this.typeTransformer;
        boolean bl = false;
        return $this$transformType_u24lambda_u240.toWasmValueType(irType);
    }

    @NotNull
    public final WasmType transformFieldType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformFieldType_u24lambda_u241 = this.typeTransformer;
        boolean bl = false;
        return $this$transformFieldType_u24lambda_u241.toWasmFieldType(irType);
    }

    @NotNull
    public final WasmType transformBoxedType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformBoxedType_u24lambda_u242 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBoxedType_u24lambda_u242.toBoxedInlineClassType(irType);
    }

    @NotNull
    public final WasmType transformValueParameterType(@NotNull IrValueParameter irValueParameter) {
        Intrinsics.checkNotNullParameter(irValueParameter, "irValueParameter");
        WasmTypeTransformer $this$transformValueParameterType_u24lambda_u243 = this.typeTransformer;
        boolean bl = false;
        return $this$transformValueParameterType_u24lambda_u243.getContext().backendContext.getInlineClassesUtils().shouldValueParameterBeBoxed(irValueParameter) ? $this$transformValueParameterType_u24lambda_u243.toBoxedInlineClassType(irValueParameter.getType()) : $this$transformValueParameterType_u24lambda_u243.toWasmValueType(irValueParameter.getType());
    }

    @Nullable
    public final WasmType transformResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformResultType_u24lambda_u244 = this.typeTransformer;
        boolean bl = false;
        return $this$transformResultType_u24lambda_u244.toWasmResultType(irType);
    }

    @Nullable
    public final WasmType transformBlockResultType(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter(irType, "irType");
        WasmTypeTransformer $this$transformBlockResultType_u24lambda_u245 = this.typeTransformer;
        boolean bl = false;
        return $this$transformBlockResultType_u24lambda_u245.toWasmBlockResultType(irType);
    }

    @NotNull
    public final Pair<WasmSymbol<Integer>, WasmSymbol<Integer>> referenceStringLiteralAddressAndId(@NotNull String string2) {
        Intrinsics.checkNotNullParameter(string2, "string");
        WasmSymbol<Integer> address2 = this.wasmFragment.getStringLiteralAddress().reference(string2);
        WasmSymbol<Integer> id = this.wasmFragment.getStringLiteralPoolId().reference(string2);
        return TuplesKt.to(address2, id);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceConstantArray(@NotNull Pair<? extends List<Long>, ? extends WasmType> resource) {
        Intrinsics.checkNotNullParameter(resource, "resource");
        return this.wasmFragment.getConstantArrayDataSegmentId().reference(resource);
    }

    public final void generateTypeInfo(@NotNull IrClassSymbol irClass, @NotNull ConstantDataElement typeInfo) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(typeInfo, "typeInfo");
        this.wasmFragment.getTypeInfo().define(irClass, typeInfo);
    }

    public final void registerInitFunction(@NotNull WasmFunction wasmFunction, @NotNull String priority) {
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        Intrinsics.checkNotNullParameter(priority, "priority");
        ((Collection)this.wasmFragment.getInitFunctions()).add(new WasmCompiledModuleFragment.FunWithPriority(wasmFunction, priority));
    }

    public final void addExport(@NotNull WasmExport<?> wasmExport) {
        Intrinsics.checkNotNullParameter(wasmExport, "wasmExport");
        ((Collection)this.wasmFragment.getExports()).add(wasmExport);
    }

    public final void defineFunction(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunction wasmFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(wasmFunction, "wasmFunction");
        this.wasmFragment.getFunctions().define(irFunction, wasmFunction);
    }

    public final void defineGlobalField(@NotNull IrFieldSymbol irField, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter(irField, "irField");
        Intrinsics.checkNotNullParameter(wasmGlobal, "wasmGlobal");
        this.wasmFragment.getGlobalFields().define(irField, wasmGlobal);
    }

    public final void defineGlobalVTable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(wasmGlobal, "wasmGlobal");
        this.wasmFragment.getGlobalVTables().define(irClass, wasmGlobal);
    }

    public final void defineGlobalClassITable(@NotNull IrClassSymbol irClass, @NotNull WasmGlobal wasmGlobal) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(wasmGlobal, "wasmGlobal");
        this.wasmFragment.getGlobalClassITables().define(irClass, wasmGlobal);
    }

    public final void defineGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(wasmType, "wasmType");
        this.wasmFragment.getGcTypes().define(irClass, wasmType);
    }

    public final void defineVTableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(wasmType, "wasmType");
        this.wasmFragment.getVTableGcTypes().define(irClass, wasmType);
    }

    public final void defineFunctionType(@NotNull IrFunctionSymbol irFunction, @NotNull WasmFunctionType wasmFunctionType) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        Intrinsics.checkNotNullParameter(wasmFunctionType, "wasmFunctionType");
        this.wasmFragment.getFunctionTypes().define(irFunction, wasmFunctionType);
    }

    @NotNull
    public final ClassMetadata getClassMetadata(@NotNull IrClassSymbol irClass) {
        ClassMetadata classMetadata;
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Map<IrClassSymbol, ClassMetadata> $this$getOrPut$iv = this.classMetadataCache;
        boolean $i$f$getOrPut = false;
        ClassMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            ClassMetadata classMetadata2;
            IrClass superClass;
            boolean bl = false;
            IrClass irClass2 = superClass = ClassInfoKt.getSuperClass((IrClass)irClass.getOwner(), this.backendContext.getIrBuiltIns());
            if (irClass2 != null) {
                IrClass it = irClass2;
                boolean bl2 = false;
                classMetadata2 = this.getClassMetadata(it.getSymbol());
            } else {
                classMetadata2 = null;
            }
            ClassMetadata superClassMetadata = classMetadata2;
            ClassMetadata answer$iv = new ClassMetadata((IrClass)irClass.getOwner(), superClassMetadata, this.backendContext.getIrBuiltIns(), this.backendContext.getPartialLinkageSupport().isEnabled());
            $this$getOrPut$iv.put(irClass, answer$iv);
            classMetadata = answer$iv;
        } else {
            classMetadata = value$iv;
        }
        return classMetadata;
    }

    @NotNull
    public final InterfaceMetadata getInterfaceMetadata(@NotNull IrClassSymbol irClass) {
        InterfaceMetadata interfaceMetadata;
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Map<IrClassSymbol, InterfaceMetadata> $this$getOrPut$iv = this.interfaceMetadataCache;
        boolean $i$f$getOrPut = false;
        InterfaceMetadata value$iv = $this$getOrPut$iv.get(irClass);
        if (value$iv == null) {
            boolean bl = false;
            InterfaceMetadata answer$iv = new InterfaceMetadata((IrClass)irClass.getOwner(), this.backendContext.getIrBuiltIns());
            $this$getOrPut$iv.put(irClass, answer$iv);
            interfaceMetadata = answer$iv;
        } else {
            interfaceMetadata = value$iv;
        }
        return interfaceMetadata;
    }

    @NotNull
    public final WasmSymbol<WasmFunction> referenceFunction(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        return this.wasmFragment.getFunctions().reference(irFunction);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalField(@NotNull IrFieldSymbol irField) {
        Intrinsics.checkNotNullParameter(irField, "irField");
        return this.wasmFragment.getGlobalFields().reference(irField);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalVTable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getGlobalVTables().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmGlobal> referenceGlobalClassITable(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getGlobalClassITables().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getGcTypes().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceVTableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getVTableGcTypes().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<WasmTypeDeclaration> referenceClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getClassITableGcType().reference(irClass);
    }

    public final void defineClassITableGcType(@NotNull IrClassSymbol irClass, @NotNull WasmTypeDeclaration wasmType) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        Intrinsics.checkNotNullParameter(wasmType, "wasmType");
        this.wasmFragment.getClassITableGcType().define(irClass, wasmType);
    }

    public final boolean isAlreadyDefinedClassITableGcType(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getClassITableGcType().getDefined().keySet().contains(irClass);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceClassITableInterfaceSlot(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        IrType type2 = IrTypesKt.getDefaultType(irClass);
        if (!(!IrTypePredicatesKt.isNothing(type2))) {
            boolean bl = false;
            String string2 = "Can't reference Nothing type";
            throw new IllegalArgumentException(string2.toString());
        }
        return this.wasmFragment.getClassITableInterfaceSlot().reference(irClass);
    }

    public final void defineClassITableInterfaceSlot(@NotNull IrClassSymbol irClass, int slot) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        this.wasmFragment.getClassITableInterfaceSlot().define(irClass, slot);
    }

    @NotNull
    public final WasmSymbol<WasmFunctionType> referenceFunctionType(@NotNull IrFunctionSymbol irFunction) {
        Intrinsics.checkNotNullParameter(irFunction, "irFunction");
        return this.wasmFragment.getFunctionTypes().reference(irFunction);
    }

    @NotNull
    public final WasmSymbol<Integer> referenceTypeId(@NotNull IrClassSymbol irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        return this.wasmFragment.getTypeIds().reference(irClass);
    }

    @NotNull
    public final WasmSymbol<Integer> getStructFieldRef(@NotNull IrField field) {
        Intrinsics.checkNotNullParameter(field, "field");
        IrClass klass = IrUtilsKt.getParentAsClass(field);
        ClassMetadata metadata = this.getClassMetadata(klass.getSymbol());
        int fieldId = metadata.getFields().indexOf(field) + 2;
        return new WasmSymbol<Integer>(fieldId);
    }

    public final void addJsFun(@NotNull String importName, @NotNull String jsCode) {
        Intrinsics.checkNotNullParameter(importName, "importName");
        Intrinsics.checkNotNullParameter(jsCode, "jsCode");
        ((Collection)this.wasmFragment.getJsFuns()).add(new WasmCompiledModuleFragment.JsCodeSnippet(importName, jsCode));
    }

    public final void addJsModuleImport(@NotNull String module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        ((Collection)this.wasmFragment.getJsModuleImports()).add(module2);
    }
}

