/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.backend.jvm.codegen.PromisedValueKt;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BooleanComparison;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.org.objectweb.asm.Label;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveToObjectComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "op", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "leftIsPrimitive", "", "left", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "right", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lcom/intellij/psi/tree/IElementType;ZLorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "checkTypeAndCompare", "onWrongType", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfFalse", "", "target", "jumpIfTrue", "discard", "backend.jvm.codegen"})
@SourceDebugExtension(value={"SMAP\nCompareTo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareTo.kt\norg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveToObjectComparison\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n1#2:236\n*E\n"})
public final class PrimitiveToObjectComparison
extends BooleanValue {
    @NotNull
    private final IrFunctionAccessExpression expression;
    @NotNull
    private final IElementType op;
    private final boolean leftIsPrimitive;
    @NotNull
    private final MaterialValue left;
    @NotNull
    private final MaterialValue right;

    public PrimitiveToObjectComparison(@NotNull IrFunctionAccessExpression expression2, @NotNull IElementType op, boolean leftIsPrimitive, @NotNull MaterialValue left, @NotNull MaterialValue right) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(op, "op");
        Intrinsics.checkNotNullParameter(left, "left");
        Intrinsics.checkNotNullParameter(right, "right");
        super(left.getCodegen());
        this.expression = expression2;
        this.op = op;
        this.leftIsPrimitive = leftIsPrimitive;
        this.left = left;
        this.right = right;
    }

    private final BooleanValue checkTypeAndCompare(Label onWrongType) {
        BooleanValue booleanValue;
        int n;
        Label compareLabel = new Label();
        if (this.leftIsPrimitive) {
            n = -1;
        } else {
            int n2;
            int it = n2 = this.getCodegen().getFrameMap().enterTemp(this.right.getType());
            boolean bl = false;
            this.getMv().store(it, this.right.getType());
            n = n2;
        }
        int tmp = n;
        this.getMv().dup();
        if (AsmUtil.isBoxedPrimitiveType(this.leftIsPrimitive ? this.right.getType() : this.left.getType())) {
            this.getMv().ifnonnull(compareLabel);
        } else {
            this.getMv().instanceOf(AsmUtil.boxType(this.leftIsPrimitive ? this.left.getType() : this.right.getType()));
            this.getMv().ifne(compareLabel);
        }
        if (this.leftIsPrimitive) {
            this.right.discard();
        }
        this.left.discard();
        this.getMv().goTo(onWrongType);
        this.getMv().mark(compareLabel);
        if (this.leftIsPrimitive) {
            booleanValue = new BooleanComparison(this.expression, this.op, this.left, PromisedValueKt.materializedAt$default(this.right, this.left.getType(), this.right.getIrType(), false, 4, null));
        } else {
            MaterialValue leftUnboxed = PromisedValueKt.materializedAt$default(this.left, this.right.getType(), this.left.getIrType(), false, 4, null);
            this.getMv().load(tmp, this.right.getType());
            this.getCodegen().getFrameMap().leaveTemp(this.right.getType());
            booleanValue = new BooleanComparison(this.expression, this.op, leftUnboxed, this.right);
        }
        return booleanValue;
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.markLineNumber(this.expression);
        BooleanValue comparison = this.checkTypeAndCompare(target);
        comparison.jumpIfFalse(target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Intrinsics.checkNotNullParameter(target, "target");
        this.markLineNumber(this.expression);
        Label wrongType = new Label();
        BooleanValue comparison = this.checkTypeAndCompare(wrongType);
        comparison.jumpIfTrue(target);
        this.getMv().mark(wrongType);
    }

    @Override
    public void discard() {
        this.markLineNumber(this.expression);
        this.right.discard();
        this.left.discard();
    }
}

