/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuilderContext;
import org.jetbrains.kotlin.analysis.decompiler.stub.ConstructorClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.FunctionClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.PropertyClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.TypeAliasClsStubBuildingKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u001a.\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001aB\u0010\r\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010\u001a4\u0010\u0014\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0010\u001a.\u0010\u0017\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e\u001a\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"COMPILED_DEFAULT_INITIALIZER", "", "createPackageDeclarationsStubs", "", "parentStub", "Lorg/jetbrains/kotlin/com/intellij/psi/stubs/StubElement;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "outerContext", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/ClsStubBuilderContext;", "protoContainer", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer$Package;", "packageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "createDeclarationsStubs", "Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "functionProtos", "", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function;", "propertyProtos", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property;", "createTypeAliasesStubs", "typeAliasesProtos", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeAlias;", "createConstructorStub", "constructorProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor;", "mustNotBeWrittenToStubs", "", "flags", "", "decompiler-to-stubs"})
public final class CallableClsStubBuilderKt {
    @NotNull
    public static final String COMPILED_DEFAULT_INITIALIZER = "COMPILED_CODE";

    public static final void createPackageDeclarationsStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer.Package protoContainer, @NotNull ProtoBuf.Package packageProto) {
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(packageProto, "packageProto");
        ProtoContainer protoContainer2 = protoContainer;
        List<ProtoBuf.Function> list = packageProto.getFunctionList();
        Intrinsics.checkNotNullExpressionValue(list, "getFunctionList(...)");
        List<ProtoBuf.Property> list2 = packageProto.getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list2, "getPropertyList(...)");
        CallableClsStubBuilderKt.createDeclarationsStubs(parentStub, outerContext, protoContainer2, list, list2);
        ProtoContainer protoContainer3 = protoContainer;
        List<ProtoBuf.TypeAlias> list3 = packageProto.getTypeAliasList();
        Intrinsics.checkNotNullExpressionValue(list3, "getTypeAliasList(...)");
        CallableClsStubBuilderKt.createTypeAliasesStubs(parentStub, outerContext, protoContainer3, list3);
    }

    public static final void createDeclarationsStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull List<ProtoBuf.Function> functionProtos, @NotNull List<ProtoBuf.Property> propertyProtos) {
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(functionProtos, "functionProtos");
        Intrinsics.checkNotNullParameter(propertyProtos, "propertyProtos");
        for (ProtoBuf.Property propertyProto : propertyProtos) {
            if (CallableClsStubBuilderKt.mustNotBeWrittenToStubs(propertyProto.getFlags())) continue;
            new PropertyClsStubBuilder(parentStub, outerContext, protoContainer, propertyProto).build();
        }
        for (ProtoBuf.Function functionProto : functionProtos) {
            if (CallableClsStubBuilderKt.mustNotBeWrittenToStubs(functionProto.getFlags())) continue;
            new FunctionClsStubBuilder(parentStub, outerContext, protoContainer, functionProto).build();
        }
    }

    public static final void createTypeAliasesStubs(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer, @NotNull List<ProtoBuf.TypeAlias> typeAliasesProtos) {
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        Intrinsics.checkNotNullParameter(typeAliasesProtos, "typeAliasesProtos");
        for (ProtoBuf.TypeAlias typeAliasProto : typeAliasesProtos) {
            TypeAliasClsStubBuildingKt.createTypeAliasStub(parentStub, typeAliasProto, protoContainer, outerContext);
        }
    }

    public static final void createConstructorStub(@NotNull StubElement<? extends PsiElement> parentStub, @NotNull ProtoBuf.Constructor constructorProto, @NotNull ClsStubBuilderContext outerContext, @NotNull ProtoContainer protoContainer) {
        Intrinsics.checkNotNullParameter(parentStub, "parentStub");
        Intrinsics.checkNotNullParameter(constructorProto, "constructorProto");
        Intrinsics.checkNotNullParameter(outerContext, "outerContext");
        Intrinsics.checkNotNullParameter(protoContainer, "protoContainer");
        new ConstructorClsStubBuilder(parentStub, outerContext, protoContainer, constructorProto).build();
    }

    private static final boolean mustNotBeWrittenToStubs(int flags) {
        return Flags.MEMBER_KIND.get(flags) == ProtoBuf.MemberKind.FAKE_OVERRIDE;
    }
}

