/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.html.dom;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.html.Entities;
import kotlinx.html.Tag;
import kotlinx.html.TagConsumer;
import kotlinx.html.Unsafe;
import kotlinx.html.dom.HTMLDOMBuilder;
import kotlinx.html.org.w3c.dom.events.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000m\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0002H\u0016J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0016J!\u0010$\u001a\u00020\u00172\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00170&\u00a2\u0006\u0002\b(H\u0016J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J,\u0010*\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\u00170&H\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010.\u001a\u00020\u0017*\u00020\u0002H\u0002R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0013j\b\u0012\u0004\u0012\u00020\u0002`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lkotlinx/html/dom/HTMLDOMBuilder;", "Lkotlinx/html/TagConsumer;", "Lorg/w3c/dom/Element;", "document", "Lorg/w3c/dom/Document;", "(Lorg/w3c/dom/Document;)V", "UnsafeImpl", "kotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1", "Lkotlinx/html/dom/HTMLDOMBuilder$UnsafeImpl$1;", "getDocument", "()Lorg/w3c/dom/Document;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "getDocumentBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "documentBuilder$delegate", "Lkotlin/Lazy;", "lastLeaved", "path", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "finalize", "onTagAttributeChange", "", "tag", "Lkotlinx/html/Tag;", "attribute", "", "value", "onTagComment", "content", "", "onTagContent", "onTagContentEntity", "entity", "Lkotlinx/html/Entities;", "onTagContentUnsafe", "block", "Lkotlin/Function1;", "Lkotlinx/html/Unsafe;", "Lkotlin/ExtensionFunctionType;", "onTagEnd", "onTagEvent", "event", "Lkotlinx/html/org/w3c/dom/events/Event;", "onTagStart", "setIdAttributeName", "kotlinx-html"})
public final class HTMLDOMBuilder
implements TagConsumer<Element> {
    @NotNull
    private final Document document;
    @NotNull
    private final ArrayList<Element> path;
    @Nullable
    private Element lastLeaved;
    @NotNull
    private final Lazy documentBuilder$delegate;
    @NotNull
    private final UnsafeImpl.1 UnsafeImpl;

    public HTMLDOMBuilder(@NotNull Document document) {
        Intrinsics.checkNotNullParameter(document, "document");
        this.document = document;
        this.path = new ArrayList();
        this.documentBuilder$delegate = LazyKt.lazy(documentBuilder.2.INSTANCE);
        this.UnsafeImpl = new Unsafe(this){
            final /* synthetic */ HTMLDOMBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public void unaryPlus(@NotNull String $this$unaryPlus) {
                Intrinsics.checkNotNullParameter($this$unaryPlus, "<this>");
                Element element = HTMLDOMBuilder.access$getDocumentBuilder(this.this$0).parse(new InputSource(new StringReader("<unsafeRoot>" + $this$unaryPlus + "</unsafeRoot>"))).getDocumentElement();
                Node importNode = this.this$0.getDocument().importNode(element, true);
                if (!Intrinsics.areEqual(importNode.getNodeName(), "unsafeRoot")) {
                    boolean bl = false;
                    String string2 = "the document factory hasn't created an unsafeRoot node";
                    throw new IllegalStateException(string2.toString());
                }
                Element last2 = (Element)CollectionsKt.last(HTMLDOMBuilder.access$getPath$p(this.this$0));
                while (importNode.hasChildNodes()) {
                    last2.appendChild(importNode.removeChild(importNode.getFirstChild()));
                }
            }

            public void unaryPlus(@NotNull Entities $this$unaryPlus) {
                Unsafe.DefaultImpls.unaryPlus(this, $this$unaryPlus);
            }

            public void raw(@NotNull String s) {
                Unsafe.DefaultImpls.raw((Unsafe)this, s);
            }

            public void raw(@NotNull Entities entity) {
                Unsafe.DefaultImpls.raw((Unsafe)this, entity);
            }

            public void raw(@NotNull Number n) {
                Unsafe.DefaultImpls.raw((Unsafe)this, n);
            }
        };
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    private final DocumentBuilder getDocumentBuilder() {
        Lazy lazy = this.documentBuilder$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-documentBuilder>(...)");
        return (DocumentBuilder)t;
    }

    @Override
    public void onTagStart(@NotNull Tag tag) {
        Element element;
        Intrinsics.checkNotNullParameter(tag, "tag");
        if (tag.getNamespace() != null) {
            String string2 = tag.getNamespace();
            Intrinsics.checkNotNull(string2);
            element = this.document.createElementNS(string2, tag.getTagName());
        } else {
            element = this.document.createElement(tag.getTagName());
        }
        Element element2 = element;
        Iterable $this$forEach$iv = tag.getAttributesEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            element2.setAttribute((String)it.getKey(), (String)it.getValue());
        }
        if (!((Collection)this.path).isEmpty()) {
            ((Element)CollectionsKt.last((List)this.path)).appendChild(element2);
        }
        this.path.add(element2);
    }

    @Override
    public void onTagAttributeChange(@NotNull Tag tag, @NotNull String attribute, @Nullable String value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(attribute, "attribute");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current tag");
        }
        Element node = (Element)CollectionsKt.last((List)this.path);
        boolean bl = false;
        if (value2 == null) {
            node.removeAttribute(attribute);
        } else {
            node.setAttribute(attribute, value2);
        }
    }

    @Override
    public void onTagEvent(@NotNull Tag tag, @NotNull String event, @NotNull Function1<? super Event, Unit> value2) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        Intrinsics.checkNotNullParameter(event, "event");
        Intrinsics.checkNotNullParameter(value2, "value");
        throw new UnsupportedOperationException("You can't assign lambda event handler on JVM");
    }

    @Override
    public void onTagEnd(@NotNull Tag tag) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(tag, "tag");
                if (this.path.isEmpty()) break block2;
                String string2 = ((Element)CollectionsKt.last((List)this.path)).getTagName();
                Intrinsics.checkNotNullExpressionValue(string2, "path.last().tagName");
                String string3 = string2.toLowerCase();
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase()");
                String string4 = tag.getTagName().toLowerCase();
                Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).toLowerCase()");
                if (Intrinsics.areEqual(string3, string4)) break block3;
            }
            throw new IllegalStateException("We haven't entered tag " + tag.getTagName() + " but trying to leave");
        }
        Element element = this.path.remove(CollectionsKt.getLastIndex((List)this.path));
        Intrinsics.checkNotNullExpressionValue(element, "path.removeAt(path.lastIndex)");
        Element element2 = element;
        this.setIdAttributeName(element2);
        this.lastLeaved = element2;
    }

    @Override
    public void onTagContent(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter(content, "content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createTextNode(((Object)content).toString()));
    }

    @Override
    public void onTagComment(@NotNull CharSequence content) {
        Intrinsics.checkNotNullParameter(content, "content");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createComment(((Object)content).toString()));
    }

    @Override
    public void onTagContentEntity(@NotNull Entities entity) {
        Intrinsics.checkNotNullParameter((Object)entity, "entity");
        if (this.path.isEmpty()) {
            throw new IllegalStateException("No current DOM node");
        }
        ((Element)CollectionsKt.last((List)this.path)).appendChild(this.document.createEntityReference(entity.name()));
    }

    @Override
    @NotNull
    public Element finalize() {
        Element element = this.lastLeaved;
        if (element == null) {
            throw new IllegalStateException("No tags were emitted");
        }
        return element;
    }

    @Override
    public void onTagContentUnsafe(@NotNull Function1<? super Unsafe, Unit> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        block.invoke(this.UnsafeImpl);
    }

    private final void setIdAttributeName(Element $this$setIdAttributeName) {
        if ($this$setIdAttributeName.hasAttribute("id")) {
            $this$setIdAttributeName.setIdAttribute("id", true);
        }
    }

    @Override
    public void onTagError(@NotNull Tag tag, @NotNull Throwable exception) {
        TagConsumer.DefaultImpls.onTagError(this, tag, exception);
    }

    public static final /* synthetic */ DocumentBuilder access$getDocumentBuilder(HTMLDOMBuilder $this) {
        return $this.getDocumentBuilder();
    }

    public static final /* synthetic */ ArrayList access$getPath$p(HTMLDOMBuilder $this) {
        return $this.path;
    }
}

