/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.types.AbstractTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.TypeCheckerState;
import kotlin.reflect.jvm.internal.impl.types.model.CapturedTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.SimpleTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeConstructorMarker;
import kotlin.reflect.jvm.internal.impl.types.model.TypeSystemContext;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nAbstractTypeChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/AbstractNullabilityChecker\n+ 2 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/TypeCheckerState\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,860:1\n132#2,16:861\n148#2,13:878\n132#2,16:891\n148#2,13:908\n1#3:877\n1#3:907\n*S KotlinDebug\n*F\n+ 1 AbstractTypeChecker.kt\norg/jetbrains/kotlin/types/AbstractNullabilityChecker\n*L\n804#1:861,16\n804#1:878,13\n818#1:891,16\n818#1:908,13\n804#1:877\n818#1:907\n*E\n"})
public final class AbstractNullabilityChecker {
    @NotNull
    public static final AbstractNullabilityChecker INSTANCE = new AbstractNullabilityChecker();

    private AbstractNullabilityChecker() {
    }

    public final boolean isPossibleSubtype(@NotNull TypeCheckerState state, @NotNull SimpleTypeMarker subType, @NotNull SimpleTypeMarker superType) {
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(subType, "subType");
        Intrinsics.checkNotNullParameter(superType, "superType");
        return this.runIsPossibleSubtype(state, subType, superType);
    }

    private final boolean runIsPossibleSubtype(TypeCheckerState state, SimpleTypeMarker subType, SimpleTypeMarker superType) {
        TypeSystemContext $this$runIsPossibleSubtype_u24lambda_u243 = state.getTypeSystemContext();
        boolean bl = false;
        if (AbstractTypeChecker.RUN_SLOW_ASSERTIONS) {
            boolean bl2;
            boolean bl3 = bl2 = $this$runIsPossibleSubtype_u24lambda_u243.isSingleClassifierType(subType) || $this$runIsPossibleSubtype_u24lambda_u243.isIntersection($this$runIsPossibleSubtype_u24lambda_u243.typeConstructor(subType)) || state.isAllowedTypeVariable(subType);
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32 = false;
                String $i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32 = "Not singleClassifierType and not intersection subType: " + subType;
                throw new AssertionError((Object)$i$a$-assert-AbstractNullabilityChecker$runIsPossibleSubtype$1$32);
            }
            boolean bl4 = bl2 = $this$runIsPossibleSubtype_u24lambda_u243.isSingleClassifierType(superType) || state.isAllowedTypeVariable(superType);
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string2 = "Not singleClassifierType superType: " + superType;
                throw new AssertionError((Object)string2);
            }
        }
        if ($this$runIsPossibleSubtype_u24lambda_u243.isMarkedNullable(superType)) {
            return true;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u243.isDefinitelyNotNullType(subType) || $this$runIsPossibleSubtype_u24lambda_u243.isNotNullTypeParameter(subType)) {
            return true;
        }
        if (subType instanceof CapturedTypeMarker && $this$runIsPossibleSubtype_u24lambda_u243.isProjectionNotNull((CapturedTypeMarker)subType)) {
            return true;
        }
        if (INSTANCE.hasNotNullSupertype(state, subType, TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE)) {
            return true;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u243.isDefinitelyNotNullType(superType)) {
            return false;
        }
        if (INSTANCE.hasNotNullSupertype(state, superType, TypeCheckerState.SupertypesPolicy.UpperIfFlexible.INSTANCE)) {
            return false;
        }
        if ($this$runIsPossibleSubtype_u24lambda_u243.isClassType(subType)) {
            return false;
        }
        return INSTANCE.hasPathByNotMarkedNullableNodes(state, subType, $this$runIsPossibleSubtype_u24lambda_u243.typeConstructor(superType));
    }

    public final boolean hasNotNullSupertype(@NotNull TypeCheckerState $this$hasNotNullSupertype, @NotNull SimpleTypeMarker type2, @NotNull TypeCheckerState.SupertypesPolicy supertypesPolicy) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter($this$hasNotNullSupertype, "<this>");
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(supertypesPolicy, "supertypesPolicy");
            TypeSystemContext $this$hasNotNullSupertype_u24lambda_u246 = $this$hasNotNullSupertype.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState this_$iv = $this$hasNotNullSupertype;
            boolean $i$f$anySupertype = false;
            SimpleTypeMarker it = type2;
            boolean bl3 = false;
            if ($this$hasNotNullSupertype_u24lambda_u246.isClassType(it) && !$this$hasNotNullSupertype_u24lambda_u246.isMarkedNullable(it) || $this$hasNotNullSupertype_u24lambda_u246.isDefinitelyNotNullType(it)) {
                bl = true;
            } else {
                this_$iv.initialize();
                ArrayDeque<SimpleTypeMarker> arrayDeque = this_$iv.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<SimpleTypeMarker> deque$iv = arrayDeque;
                Set<SimpleTypeMarker> set = this_$iv.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<SimpleTypeMarker> visitedSupertypes$iv = set;
                deque$iv.push(type2);
                while (!((Collection)deque$iv).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy policy$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        throw new IllegalStateException(("Too many supertypes for type: " + type2 + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null)).toString());
                    }
                    SimpleTypeMarker current$iv = deque$iv.pop();
                    Intrinsics.checkNotNull(current$iv);
                    if (!visitedSupertypes$iv.add(current$iv)) continue;
                    it = current$iv;
                    boolean bl4 = false;
                    TypeCheckerState.SupertypesPolicy supertypesPolicy2 = $this$hasNotNullSupertype_u24lambda_u246.isMarkedNullable(it) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : supertypesPolicy;
                    TypeCheckerState.SupertypesPolicy it$iv = supertypesPolicy2;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual(it$iv, TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? supertypesPolicy2 : null) == null) continue;
                    policy$iv = policy$iv;
                    TypeSystemContext $this$anySupertype_u24lambda_u243$iv = this_$iv.getTypeSystemContext();
                    boolean bl6 = false;
                    Collection<KotlinTypeMarker> supertypes$iv = $this$anySupertype_u24lambda_u243$iv.supertypes($this$anySupertype_u24lambda_u243$iv.typeConstructor(current$iv));
                    for (KotlinTypeMarker supertype$iv : supertypes$iv) {
                        SimpleTypeMarker newType$iv;
                        it = newType$iv = policy$iv.transformType(this_$iv, supertype$iv);
                        bl3 = false;
                        if ($this$hasNotNullSupertype_u24lambda_u246.isClassType(it) && !$this$hasNotNullSupertype_u24lambda_u246.isMarkedNullable(it) || $this$hasNotNullSupertype_u24lambda_u246.isDefinitelyNotNullType(it)) {
                            this_$iv.clear();
                            bl = true;
                            break block6;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                this_$iv.clear();
                bl = false;
            }
        }
        return bl;
    }

    public final boolean hasPathByNotMarkedNullableNodes(@NotNull TypeCheckerState state, @NotNull SimpleTypeMarker start, @NotNull TypeConstructorMarker end) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(state, "state");
            Intrinsics.checkNotNullParameter(start, "start");
            Intrinsics.checkNotNullParameter(end, "end");
            TypeSystemContext $this$hasPathByNotMarkedNullableNodes_u24lambda_u249 = state.getTypeSystemContext();
            boolean bl2 = false;
            TypeCheckerState this_$iv = state;
            boolean $i$f$anySupertype = false;
            SimpleTypeMarker it = start;
            boolean bl3 = false;
            if (INSTANCE.isApplicableAsEndNode(state, it, end)) {
                bl = true;
            } else {
                this_$iv.initialize();
                ArrayDeque<SimpleTypeMarker> arrayDeque = this_$iv.getSupertypesDeque();
                Intrinsics.checkNotNull(arrayDeque);
                ArrayDeque<SimpleTypeMarker> deque$iv = arrayDeque;
                Set<SimpleTypeMarker> set = this_$iv.getSupertypesSet();
                Intrinsics.checkNotNull(set);
                Set<SimpleTypeMarker> visitedSupertypes$iv = set;
                deque$iv.push(start);
                while (!((Collection)deque$iv).isEmpty()) {
                    TypeCheckerState.SupertypesPolicy policy$iv;
                    if (visitedSupertypes$iv.size() > 1000) {
                        throw new IllegalStateException(("Too many supertypes for type: " + start + ". Supertypes = " + CollectionsKt.joinToString$default(visitedSupertypes$iv, null, null, null, 0, null, null, 63, null)).toString());
                    }
                    SimpleTypeMarker current$iv = deque$iv.pop();
                    Intrinsics.checkNotNull(current$iv);
                    if (!visitedSupertypes$iv.add(current$iv)) continue;
                    it = current$iv;
                    boolean bl4 = false;
                    TypeCheckerState.SupertypesPolicy supertypesPolicy = $this$hasPathByNotMarkedNullableNodes_u24lambda_u249.isMarkedNullable(it) ? (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.None.INSTANCE : (TypeCheckerState.SupertypesPolicy)TypeCheckerState.SupertypesPolicy.LowerIfFlexible.INSTANCE;
                    TypeCheckerState.SupertypesPolicy it$iv = supertypesPolicy;
                    boolean bl5 = false;
                    if ((!Intrinsics.areEqual(it$iv, TypeCheckerState.SupertypesPolicy.None.INSTANCE) ? supertypesPolicy : null) == null) continue;
                    policy$iv = policy$iv;
                    TypeSystemContext $this$anySupertype_u24lambda_u243$iv = this_$iv.getTypeSystemContext();
                    boolean bl6 = false;
                    Collection<KotlinTypeMarker> supertypes$iv = $this$anySupertype_u24lambda_u243$iv.supertypes($this$anySupertype_u24lambda_u243$iv.typeConstructor(current$iv));
                    for (KotlinTypeMarker supertype$iv : supertypes$iv) {
                        SimpleTypeMarker newType$iv;
                        it = newType$iv = policy$iv.transformType(this_$iv, supertype$iv);
                        bl3 = false;
                        if (INSTANCE.isApplicableAsEndNode(state, it, end)) {
                            this_$iv.clear();
                            bl = true;
                            break block6;
                        }
                        deque$iv.add(newType$iv);
                    }
                }
                this_$iv.clear();
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isApplicableAsEndNode(TypeCheckerState state, SimpleTypeMarker type2, TypeConstructorMarker end) {
        TypeSystemContext $this$isApplicableAsEndNode_u24lambda_u2410 = state.getTypeSystemContext();
        boolean bl = false;
        if ($this$isApplicableAsEndNode_u24lambda_u2410.isNothing(type2)) {
            return true;
        }
        if ($this$isApplicableAsEndNode_u24lambda_u2410.isMarkedNullable(type2)) {
            return false;
        }
        if (state.isStubTypeEqualsToAnything() && $this$isApplicableAsEndNode_u24lambda_u2410.isStubType(type2)) {
            return true;
        }
        return $this$isApplicableAsEndNode_u24lambda_u2410.areEqualTypeConstructors($this$isApplicableAsEndNode_u24lambda_u2410.typeConstructor(type2), end);
    }
}

