/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.error.ErrorType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "resolveCallForExpression", "visitCallExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "isNullable", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "(Lorg/jetbrains/kotlin/psi/ValueArgument;)Ljava/lang/Boolean;", "Conversion", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUselessCallOnNotNull.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UselessCallOnNotNull.kt\nio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1734#2,3:134\n1#3:137\n*S KotlinDebug\n*F\n+ 1 UselessCallOnNotNull.kt\nio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull\n*L\n93#1:134,3\n*E\n"})
public final class UselessCallOnNotNull
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Map<FqName, Conversion> uselessFqNames;
    @NotNull
    private static final FqName listOfNotNull;

    public UselessCallOnNotNull(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UselessCallOnNotNull", Severity.Performance, "This call on a non-null reference may be reduced or removed. Some calls are intended to be called on nullable collection or text types (e.g. `String?`).When this call is used on a reference to a non-null type (e.g. `String`) it is redundant and will have no effect, so it can be removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UselessCallOnNotNull(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @Override
    public void visitQualifiedExpression(@NotNull KtQualifiedExpression expression2) {
        boolean notNullType;
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitQualifiedExpression(expression2);
        KtSafeQualifiedExpression safeExpression = expression2 instanceof KtSafeQualifiedExpression ? (KtSafeQualifiedExpression)expression2 : null;
        KotlinType kotlinType = CallUtilKt.getType(expression2.getReceiverExpression(), this.getBindingContext());
        boolean bl = kotlinType != null ? !KotlinTypeKt.isNullable(kotlinType) : (notNullType = false);
        if (notNullType || safeExpression != null) {
            this.resolveCallForExpression(expression2);
        }
    }

    private final void resolveCallForExpression(KtQualifiedExpression expression2) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
        FqName fqName = DescriptorUtilsKt.fqNameOrNull(callableDescriptor);
        if (fqName == null) {
            return;
        }
        FqName fqName2 = fqName;
        Conversion conversion = uselessFqNames.get(fqName2);
        if (conversion != null) {
            String string2 = fqName2.shortName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            String shortName = string2;
            String message = conversion.getReplacementName() == null ? "Remove redundant call to " + shortName : "Replace " + shortName + " with " + conversion.getReplacementName();
            this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitCallExpression(expression2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression2, this.getBindingContext());
        if (resolvedCall2 == null) {
            return;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
        FqName fqName = DescriptorUtilsKt.fqNameOrNull(callableDescriptor);
        if (Intrinsics.areEqual(fqName, listOfNotNull)) {
            boolean bl;
            block6: {
                List<ValueArgument> list = ((ResolvedValueArgument)((Map.Entry)CollectionsKt.single((Iterable)resolvedCall3.getValueArguments().entrySet())).getValue()).getArguments();
                Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                List<ValueArgument> varargs = list;
                Iterable $this$all$iv = varargs;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        ValueArgument it = (ValueArgument)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull(it);
                        if (Intrinsics.areEqual(this.isNullable(it), false)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            if (bl) {
                this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), "Replace listOfNotNull with listOf", null, null, 24, null));
            }
        }
    }

    private final Boolean isNullable(ValueArgument $this$isNullable) {
        Object type2;
        Object object;
        Object object2 = $this$isNullable.getArgumentExpression();
        if (object2 == null || (object2 = CallUtilKt.getType((KtExpression)object2, this.getBindingContext())) == null) {
            return null;
        }
        Object wrapperType = object2;
        Object object3 = $this$isNullable.getSpreadElement() != null ? CollectionsKt.first(((KotlinType)wrapperType).getArguments()).getType() : wrapperType;
        Intrinsics.checkNotNull(object3);
        Object it = object = (type2 = object3);
        boolean bl = false;
        object3 = !(it instanceof ErrorType) ? object : null;
        return object3 != null ? Boolean.valueOf(KotlinTypeKt.isNullable((KotlinType)object3)) : null;
    }

    public UselessCallOnNotNull() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(new FqName("kotlin.collections.orEmpty"), new Conversion(null, 1, null)), TuplesKt.to(new FqName("kotlin.sequences.orEmpty"), new Conversion(null, 1, null)), TuplesKt.to(new FqName("kotlin.text.orEmpty"), new Conversion(null, 1, null)), TuplesKt.to(new FqName("kotlin.text.isNullOrEmpty"), new Conversion("isEmpty")), TuplesKt.to(new FqName("kotlin.text.isNullOrBlank"), new Conversion("isBlank")), TuplesKt.to(new FqName("kotlin.collections.isNullOrEmpty"), new Conversion("isEmpty"))};
        uselessFqNames = MapsKt.mapOf(pairArray);
        listOfNotNull = new FqName("kotlin.collections.listOfNotNull");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Companion;", "", "<init>", "()V", "uselessFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "listOfNotNull", "detekt-rules-style"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\t\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UselessCallOnNotNull$Conversion;", "", "replacementName", "", "<init>", "(Ljava/lang/String;)V", "getReplacementName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "detekt-rules-style"})
    private static final class Conversion {
        @Nullable
        private final String replacementName;

        public Conversion(@Nullable String replacementName) {
            this.replacementName = replacementName;
        }

        public /* synthetic */ Conversion(String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string2 = null;
            }
            this(string2);
        }

        @Nullable
        public final String getReplacementName() {
            return this.replacementName;
        }

        @Nullable
        public final String component1() {
            return this.replacementName;
        }

        @NotNull
        public final Conversion copy(@Nullable String replacementName) {
            return new Conversion(replacementName);
        }

        public static /* synthetic */ Conversion copy$default(Conversion conversion, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = conversion.replacementName;
            }
            return conversion.copy(string2);
        }

        @NotNull
        public String toString() {
            return "Conversion(replacementName=" + this.replacementName + ')';
        }

        public int hashCode() {
            return this.replacementName == null ? 0 : this.replacementName.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Conversion)) {
                return false;
            }
            Conversion conversion = (Conversion)other;
            return Intrinsics.areEqual(this.replacementName, conversion.replacementName);
        }

        public Conversion() {
            this(null, 1, null);
        }
    }
}

