/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0017H\u0002J\f\u0010\u001b\u001a\u00020\u001a*\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnusedParameterVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "allowedNames", "Lkotlin/text/Regex;", "<init>", "(Lkotlin/text/Regex;)V", "unusedParameters", "", "Lorg/jetbrains/kotlin/psi/KtParameter;", "getUnusedReports", "", "Lio/gitlab/arturbosch/detekt/api/CodeSmell;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClassOrObject", "", "klassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "collectParameters", "isRelevant", "", "isAllowedToHaveUnusedParameters", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnusedParameter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnusedParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedParameterVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1557#2:139\n1628#2,3:140\n1863#2,2:143\n*S KotlinDebug\n*F\n+ 1 UnusedParameter.kt\nio/gitlab/arturbosch/detekt/rules/style/UnusedParameterVisitor\n*L\n75#1:139\n75#1:140,3\n105#1:143,2\n*E\n"})
final class UnusedParameterVisitor
extends DetektVisitor {
    @NotNull
    private final Regex allowedNames;
    @NotNull
    private final Set<KtParameter> unusedParameters;

    public UnusedParameterVisitor(@NotNull Regex allowedNames2) {
        Intrinsics.checkNotNullParameter(allowedNames2, "allowedNames");
        this.allowedNames = allowedNames2;
        this.unusedParameters = new LinkedHashSet();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CodeSmell> getUnusedReports(@NotNull Issue issue) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(issue, "issue");
        Iterable $this$map$iv = this.unusedParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtParameter ktParameter = (KtParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CodeSmell(issue, Entity.Companion.atName((KtNamedDeclaration)it), "Function parameter `" + it.getNameAsSafeName().getIdentifier() + "` is unused.", null, null, 24, null));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void visitClassOrObject(@NotNull KtClassOrObject klassOrObject) {
        Intrinsics.checkNotNullParameter(klassOrObject, "klassOrObject");
        if (KtModifierListKt.isExpect(klassOrObject)) {
            return;
        }
        super.visitClassOrObject(klassOrObject);
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (klass.isInterface()) {
            return;
        }
        if (KtModifierListKt.isExternal(klass)) {
            return;
        }
        super.visitClass(klass);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (!this.isRelevant(function2)) {
            return;
        }
        this.collectParameters(function2);
        super.visitNamedFunction(function2);
    }

    private final void collectParameters(KtNamedFunction function2) {
        Map parameters = new LinkedHashMap();
        Object object = function2.getValueParameterList();
        if (object != null && (object = ((KtParameterList)object).getParameters()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                KtParameter parameter = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(parameter.getNameAsSafeName().getIdentifier(), "getIdentifier(...)");
                if (this.allowedNames.matches(name2)) continue;
                parameters.put(name2, parameter);
            }
        }
        function2.accept(new DetektVisitor(parameters){
            final /* synthetic */ Map<String, KtParameter> $parameters;
            {
                this.$parameters = $parameters;
            }

            public void visitProperty(KtProperty property) {
                Intrinsics.checkNotNullParameter(property, "property");
                if (property.isLocal()) {
                    String string2 = property.getNameAsSafeName().getIdentifier();
                    Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
                    String name2 = string2;
                    this.$parameters.remove(name2);
                }
                super.visitProperty(property);
            }

            public void visitReferenceExpression(KtReferenceExpression expression2) {
                Intrinsics.checkNotNullParameter(expression2, "expression");
                if (!(expression2.getParent() instanceof KtValueArgumentName)) {
                    String string2 = expression2.getText();
                    Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
                    this.$parameters.remove(StringsKt.removeSurrounding(string2, (CharSequence)"`"));
                }
                super.visitReferenceExpression(expression2);
            }
        });
        this.unusedParameters.addAll(parameters.values());
    }

    private final boolean isRelevant(KtNamedFunction $this$isRelevant) {
        return !this.isAllowedToHaveUnusedParameters($this$isRelevant);
    }

    private final boolean isAllowedToHaveUnusedParameters(KtNamedFunction $this$isAllowedToHaveUnusedParameters) {
        return KtModifierListKt.isAbstract($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOpen($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOverride($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isOperator($this$isAllowedToHaveUnusedParameters) || MethodSignatureKt.isMainFunction($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isExternal($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isExpect($this$isAllowedToHaveUnusedParameters) || KtModifierListKt.isActual($this$isAllowedToHaveUnusedParameters) || KtPsiUtilKt.isProtected($this$isAllowedToHaveUnusedParameters);
    }
}

