/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.parsing.KotlinExpressionParsing;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "allowForUnclearPrecedence", "", "getAllowForUnclearPrecedence$annotations", "()V", "getAllowForUnclearPrecedence", "()Z", "allowForUnclearPrecedence$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitParenthesizedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "Companion", "detekt-rules-style"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryParentheses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,214:1\n1#2:215\n13409#3,2:216\n10072#3:218\n10494#3,2:219\n11165#3:221\n11500#3,2:222\n10494#3,5:224\n11502#3:229\n10496#3,3:230\n*S KotlinDebug\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses\n*L\n126#1:216,2\n128#1:218\n128#1:219,2\n129#1:221\n129#1:222,2\n130#1:224,5\n129#1:229\n128#1:230,3\n*E\n"})
public final class UnnecessaryParentheses
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowForUnclearPrecedence$delegate;
    @NotNull
    private static final Map<IElementType, Set<IElementType>> childToUnclearPrecedenceParentsMapping;

    public UnnecessaryParentheses(@NotNull Config config) {
        Intrinsics.checkNotNullParameter(config, "config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryParentheses", Severity.Style, "Unnecessary parentheses don't add any value to the code and should be removed.", Debt.Companion.getFIVE_MINS());
        this.allowForUnclearPrecedence$delegate = ConfigPropertyKt.config(false);
    }

    public /* synthetic */ UnnecessaryParentheses(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @Override
    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowForUnclearPrecedence() {
        return (Boolean)this.allowForUnclearPrecedence$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @Configuration(description="allow parentheses when not strictly required but precedence may be unclear, such as `(a && b) || c`")
    private static /* synthetic */ void getAllowForUnclearPrecedence$annotations() {
    }

    @Override
    public void visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        super.visitParenthesizedExpression(expression2);
        KtExpression ktExpression = expression2.getExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression inner = ktExpression;
        if (expression2.getParent() instanceof KtDelegatedSuperTypeEntry) {
            return;
        }
        if (!KtPsiUtil.areParenthesesUseless(expression2)) {
            return;
        }
        if (this.getAllowForUnclearPrecedence() && UnnecessaryParentheses.Companion.isBinaryOperationPrecedenceUnclearWithParent(inner)) {
            return;
        }
        if (this.getAllowForUnclearPrecedence() && UnnecessaryParentheses.Companion.isUnaryOperationPrecedenceUnclear(expression2)) {
            return;
        }
        if (this.getAllowForUnclearPrecedence() && UnnecessaryParentheses.Companion.isFloatWithOutIntegerPartAroundRange(expression2)) {
            return;
        }
        KtExpression ktExpression2 = KtPsiUtil.deparenthesize(expression2);
        String message = "Parentheses in " + expression2.getText() + " are unnecessary and can be replaced with: " + (ktExpression2 != null ? ktExpression2.getText() : null);
        this.report(new CodeSmell(this.getIssue(), Entity.Companion.from$default(Entity.Companion, expression2, 0, 2, null), message, null, null, 24, null));
    }

    public UnnecessaryParentheses() {
        this((Config)null, 1, (DefaultConstructorMarker)null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_6;
        Object[] it;
        Object parents2;
        Object[] objectArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(UnnecessaryParentheses.class, "allowForUnclearPrecedence", "getAllowForUnclearPrecedence()Z", 0))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new Pair[5];
        Object[] objectArray2 = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.EQUALITY, KotlinExpressionParsing.Precedence.COMPARISON, KotlinExpressionParsing.Precedence.IN_OR_IS};
        objectArray[0] = TuplesKt.to(KotlinExpressionParsing.Precedence.ELVIS, objectArray2);
        objectArray2 = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.ELVIS, KotlinExpressionParsing.Precedence.SIMPLE_NAME};
        objectArray[1] = TuplesKt.to(KotlinExpressionParsing.Precedence.SIMPLE_NAME, objectArray2);
        objectArray2 = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.ADDITIVE, KotlinExpressionParsing.Precedence.RANGE, KotlinExpressionParsing.Precedence.ELVIS};
        objectArray[2] = TuplesKt.to(KotlinExpressionParsing.Precedence.MULTIPLICATIVE, objectArray2);
        objectArray2 = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.RANGE, KotlinExpressionParsing.Precedence.ELVIS};
        objectArray[3] = TuplesKt.to(KotlinExpressionParsing.Precedence.ADDITIVE, objectArray2);
        objectArray2 = new KotlinExpressionParsing.Precedence[]{KotlinExpressionParsing.Precedence.DISJUNCTION};
        objectArray[4] = TuplesKt.to(KotlinExpressionParsing.Precedence.CONJUNCTION, objectArray2);
        for (KotlinExpressionParsing.Precedence precedence : objectArray2 = objectArray) {
            boolean bl = false;
            KotlinExpressionParsing.Precedence child = (KotlinExpressionParsing.Precedence)((Object)((Pair)((Object)precedence)).component1());
            parents2 = (KotlinExpressionParsing.Precedence[])((Pair)((Object)precedence)).component2();
            KotlinExpressionParsing.Precedence[] $this$forEach$iv = parents2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                Object[] element$iv;
                it = element$iv = $this$forEach$iv[j];
                boolean bl2 = false;
                if (child.compareTo((Enum)it) <= 0) continue;
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
        }
        Object[] $this$flatMap$iv = objectArray2;
        boolean $i$f$flatMap = false;
        Object[] objectArray3 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (KotlinExpressionParsing.Precedence element$iv$iv : objectArray3) {
            void $this$mapTo$iv$iv;
            parents2 = element$iv$iv;
            boolean bl = false;
            KotlinExpressionParsing.Precedence child = (KotlinExpressionParsing.Precedence)((Object)((Pair)parents2).component1());
            KotlinExpressionParsing.Precedence[] parents3 = (KotlinExpressionParsing.Precedence[])((Pair)parents2).component2();
            IElementType[] iElementTypeArray = child.getOperations().getTypes();
            Intrinsics.checkNotNullExpressionValue(iElementTypeArray, "getTypes(...)");
            Object[] $this$map$iv = iElementTypeArray;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void destination$iv;
                void $this$flatMapTo$iv;
                void childOp;
                IElementType iElementType = (IElementType)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                KotlinExpressionParsing.Precedence[] precedenceArray = parents3;
                Collection collection2 = new LinkedHashSet();
                void var25_37 = childOp;
                boolean $i$f$flatMapTo2 = false;
                int n = ((void)$this$flatMapTo$iv).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void parentOp = element$iv = $this$flatMapTo$iv[j];
                    boolean bl4 = false;
                    IElementType[] iElementTypeArray2 = parentOp.getOperations().getTypes();
                    Intrinsics.checkNotNullExpressionValue(iElementTypeArray2, "getTypes(...)");
                    Iterable list$iv = ArraysKt.toList((Object[])iElementTypeArray2);
                    CollectionsKt.addAll(destination$iv, list$iv);
                }
                collection.add(TuplesKt.to(var25_37, destination$iv));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        childToUnclearPrecedenceParentsMapping = MapsKt.toMap((List)var3_6);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\n*\u00020\fH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002J\f\u0010\u000f\u001a\u00020\u000e*\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u00020\u000e*\u00020\u0010H\u0002R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion;", "", "<init>", "()V", "childToUnclearPrecedenceParentsMapping", "", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "", "getChildToUnclearPrecedenceParentsMapping$annotations", "binaryOp", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "firstNonParenParent", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isBinaryOperationPrecedenceUnclearWithParent", "", "isUnaryOperationPrecedenceUnclear", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "isFloatWithOutIntegerPartAroundRange", "detekt-rules-style"})
    @SourceDebugExtension(value={"SMAP\nUnnecessaryParentheses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,214:1\n1#2:215\n183#3,2:216\n*S KotlinDebug\n*F\n+ 1 UnnecessaryParentheses.kt\nio/gitlab/arturbosch/detekt/rules/style/UnnecessaryParentheses$Companion\n*L\n155#1:216,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getChildToUnclearPrecedenceParentsMapping$annotations() {
        }

        private final IElementType binaryOp(PsiElement $this$binaryOp) {
            KtSimpleNameExpression ktSimpleNameExpression;
            PsiElement psiElement = $this$binaryOp;
            if (psiElement instanceof KtBinaryExpression) {
                KtOperationReferenceExpression ktOperationReferenceExpression;
                KtOperationReferenceExpression it = ktOperationReferenceExpression = ((KtBinaryExpression)$this$binaryOp).getOperationReference();
                boolean bl = false;
                ktSimpleNameExpression = !KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)$this$binaryOp).getOperationToken()) ? ktOperationReferenceExpression : null;
            } else {
                ktSimpleNameExpression = psiElement instanceof KtBinaryExpressionWithTypeRHS ? ((KtBinaryExpressionWithTypeRHS)$this$binaryOp).getOperationReference() : (psiElement instanceof KtIsExpression ? ((KtIsExpression)$this$binaryOp).getOperationReference() : null);
            }
            KtSimpleNameExpression ktSimpleNameExpression2 = ktSimpleNameExpression;
            return ktSimpleNameExpression2 != null ? ktSimpleNameExpression2.getReferencedNameElementType() : null;
        }

        private final PsiElement firstNonParenParent(KtExpression $this$firstNonParenParent) {
            PsiElement psiElement;
            block1: {
                Sequence<PsiElement> $this$firstOrNull$iv = SequencesKt.generateSequence($this$firstNonParenParent.getParent(), Companion::firstNonParenParent$lambda$1);
                boolean $i$f$firstOrNull = false;
                Iterator<PsiElement> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    PsiElement element$iv;
                    PsiElement it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (!(!(it instanceof KtParenthesizedExpression))) continue;
                    psiElement = element$iv;
                    break block1;
                }
                psiElement = null;
            }
            return psiElement;
        }

        private final boolean isBinaryOperationPrecedenceUnclearWithParent(KtExpression $this$isBinaryOperationPrecedenceUnclearWithParent) {
            IElementType iElementType = this.binaryOp($this$isBinaryOperationPrecedenceUnclearWithParent);
            if (iElementType == null) {
                return false;
            }
            IElementType innerOp = iElementType;
            Object object = this.firstNonParenParent($this$isBinaryOperationPrecedenceUnclearWithParent);
            if (object == null || (object = this.binaryOp((PsiElement)object)) == null) {
                return false;
            }
            Object outerOp = object;
            Set set = (Set)childToUnclearPrecedenceParentsMapping.get(innerOp);
            return set != null ? set.contains(outerOp) : false;
        }

        private final boolean isUnaryOperationPrecedenceUnclear(KtParenthesizedExpression $this$isUnaryOperationPrecedenceUnclear) {
            PsiElement parentExpression = $this$isUnaryOperationPrecedenceUnclear.getParent();
            if (!(parentExpression instanceof KtPrefixExpression)) {
                return false;
            }
            KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.PLUSPLUS, KtTokens.MINUSMINUS};
            if (CollectionsKt.contains((Iterable)CollectionsKt.listOf(ktSingleValueTokenArray), ((KtPrefixExpression)parentExpression).getOperationReference().getReferencedNameElementType())) {
                KtExpression ktExpression = $this$isUnaryOperationPrecedenceUnclear.getExpression();
                KtDotQualifiedExpression ktDotQualifiedExpression = ktExpression instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)ktExpression : null;
                if ((ktDotQualifiedExpression != null ? ktDotQualifiedExpression.getReceiverExpression() : null) instanceof KtConstantExpression) {
                    return false;
                }
            }
            ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.PLUS, KtTokens.MINUS, KtTokens.EXCL, KtTokens.PLUSPLUS, KtTokens.MINUSMINUS};
            return CollectionsKt.contains((Iterable)CollectionsKt.listOf(ktSingleValueTokenArray), ((KtPrefixExpression)parentExpression).getOperationReference().getReferencedNameElementType());
        }

        private final boolean isFloatWithOutIntegerPartAroundRange(KtParenthesizedExpression $this$isFloatWithOutIntegerPartAroundRange) {
            boolean bl;
            block7: {
                block6: {
                    PsiElement parentExpression = $this$isFloatWithOutIntegerPartAroundRange.getParent();
                    if (!(parentExpression instanceof KtBinaryExpression)) {
                        return false;
                    }
                    if (!Intrinsics.areEqual(((KtBinaryExpression)parentExpression).getOperationToken(), KtTokens.RANGE)) break block6;
                    KtExpression ktExpression = $this$isFloatWithOutIntegerPartAroundRange.getExpression();
                    KtConstantExpression ktConstantExpression = ktExpression instanceof KtConstantExpression ? (KtConstantExpression)ktExpression : null;
                    if (Intrinsics.areEqual(ktConstantExpression != null ? ktConstantExpression.getElementType() : null, KtNodeTypes.FLOAT_CONSTANT) && Intrinsics.areEqual(((KtBinaryExpression)parentExpression).getRight(), $this$isFloatWithOutIntegerPartAroundRange)) break block7;
                }
                return false;
            }
            KtExpression ktExpression = $this$isFloatWithOutIntegerPartAroundRange.getExpression();
            if (ktExpression != null) {
                KtExpression $this$isFloatWithOutIntegerPartAroundRange_u24lambda_u243 = ktExpression;
                boolean bl2 = false;
                String string2 = $this$isFloatWithOutIntegerPartAroundRange_u24lambda_u243.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
                bl = StringsKt.startsWith$default(string2, ".", false, 2, null);
            } else {
                bl = false;
            }
            return bl;
        }

        private static final PsiElement firstNonParenParent$lambda$1(PsiElement it) {
            Intrinsics.checkNotNullParameter(it, "it");
            KtParenthesizedExpression ktParenthesizedExpression = it instanceof KtParenthesizedExpression ? (KtParenthesizedExpression)it : null;
            return ktParenthesizedExpression != null ? ktParenthesizedExpression.getParent() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

